"use strict";
(() => {
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };

  // out/src/compiler/standard-library/elan-runtime-error.js
  var require_elan_runtime_error = __commonJS({
    "out/src/compiler/standard-library/elan-runtime-error.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ElanRuntimeError = void 0;
      var ElanRuntimeError = class extends Error {
        err;
        constructor(err) {
          super(err instanceof Error ? err.message : err);
          this.err = err;
        }
        useLine(token) {
          return !(token.startsWith("data") || token.startsWith("http") || token.startsWith("async") || token.startsWith("Array") || token.startsWith("System") || token.startsWith("onmessage"));
        }
        updateLine0(l0) {
          if (l0.startsWith("RangeError")) {
            return "Error: Stack Overflow";
          }
          return l0;
        }
        get elanStack() {
          const jsStack = this.err instanceof Error ? this.err.stack : this.stack;
          const elanStack = [];
          if (jsStack) {
            let lines = jsStack.split("\n").map((l) => l.trim());
            if (lines.length > 0) {
              elanStack.push(this.updateLine0(lines[0]));
              lines = lines.slice(1);
              for (const l of lines) {
                const line = l.split(" ");
                if (line.length > 1) {
                  let fn = line[1];
                  fn = fn === "runTests" ? "test" : fn;
                  fn = fn === "System.printLine" ? "print" : fn;
                  if (this.useLine(fn)) {
                    elanStack.push(`at ${fn}`);
                  }
                }
              }
            }
          }
          if (elanStack.length > 0) {
            return elanStack.join("\n");
          }
          return "";
        }
      };
      exports.ElanRuntimeError = ElanRuntimeError;
    }
  });

  // node_modules/reflect-metadata/Reflect.js
  var require_Reflect = __commonJS({
    "node_modules/reflect-metadata/Reflect.js"() {
      var Reflect2;
      (function(Reflect3) {
        (function(factory) {
          var root = typeof globalThis === "object" ? globalThis : typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : sloppyModeThis();
          var exporter = makeExporter(Reflect3);
          if (typeof root.Reflect !== "undefined") {
            exporter = makeExporter(root.Reflect, exporter);
          }
          factory(exporter, root);
          if (typeof root.Reflect === "undefined") {
            root.Reflect = Reflect3;
          }
          function makeExporter(target, previous) {
            return function(key, value) {
              Object.defineProperty(target, key, { configurable: true, writable: true, value });
              if (previous)
                previous(key, value);
            };
          }
          function functionThis() {
            try {
              return Function("return this;")();
            } catch (_) {
            }
          }
          function indirectEvalThis() {
            try {
              return (void 0, eval)("(function() { return this; })()");
            } catch (_) {
            }
          }
          function sloppyModeThis() {
            return functionThis() || indirectEvalThis();
          }
        })(function(exporter, root) {
          var hasOwn = Object.prototype.hasOwnProperty;
          var supportsSymbol = typeof Symbol === "function";
          var toPrimitiveSymbol = supportsSymbol && typeof Symbol.toPrimitive !== "undefined" ? Symbol.toPrimitive : "@@toPrimitive";
          var iteratorSymbol = supportsSymbol && typeof Symbol.iterator !== "undefined" ? Symbol.iterator : "@@iterator";
          var supportsCreate = typeof Object.create === "function";
          var supportsProto = { __proto__: [] } instanceof Array;
          var downLevel = !supportsCreate && !supportsProto;
          var HashMap = {
            // create an object in dictionary mode (a.k.a. "slow" mode in v8)
            create: supportsCreate ? function() {
              return MakeDictionary(/* @__PURE__ */ Object.create(null));
            } : supportsProto ? function() {
              return MakeDictionary({ __proto__: null });
            } : function() {
              return MakeDictionary({});
            },
            has: downLevel ? function(map, key) {
              return hasOwn.call(map, key);
            } : function(map, key) {
              return key in map;
            },
            get: downLevel ? function(map, key) {
              return hasOwn.call(map, key) ? map[key] : void 0;
            } : function(map, key) {
              return map[key];
            }
          };
          var functionPrototype = Object.getPrototypeOf(Function);
          var _Map = typeof Map === "function" && typeof Map.prototype.entries === "function" ? Map : CreateMapPolyfill();
          var _Set = typeof Set === "function" && typeof Set.prototype.entries === "function" ? Set : CreateSetPolyfill();
          var _WeakMap = typeof WeakMap === "function" ? WeakMap : CreateWeakMapPolyfill();
          var registrySymbol = supportsSymbol ? Symbol.for("@reflect-metadata:registry") : void 0;
          var metadataRegistry = GetOrCreateMetadataRegistry();
          var metadataProvider = CreateMetadataProvider(metadataRegistry);
          function decorate(decorators, target, propertyKey, attributes) {
            if (!IsUndefined(propertyKey)) {
              if (!IsArray(decorators))
                throw new TypeError();
              if (!IsObject(target))
                throw new TypeError();
              if (!IsObject(attributes) && !IsUndefined(attributes) && !IsNull(attributes))
                throw new TypeError();
              if (IsNull(attributes))
                attributes = void 0;
              propertyKey = ToPropertyKey(propertyKey);
              return DecorateProperty(decorators, target, propertyKey, attributes);
            } else {
              if (!IsArray(decorators))
                throw new TypeError();
              if (!IsConstructor(target))
                throw new TypeError();
              return DecorateConstructor(decorators, target);
            }
          }
          exporter("decorate", decorate);
          function metadata(metadataKey, metadataValue) {
            function decorator(target, propertyKey) {
              if (!IsObject(target))
                throw new TypeError();
              if (!IsUndefined(propertyKey) && !IsPropertyKey(propertyKey))
                throw new TypeError();
              OrdinaryDefineOwnMetadata(metadataKey, metadataValue, target, propertyKey);
            }
            return decorator;
          }
          exporter("metadata", metadata);
          function defineMetadata(metadataKey, metadataValue, target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryDefineOwnMetadata(metadataKey, metadataValue, target, propertyKey);
          }
          exporter("defineMetadata", defineMetadata);
          function hasMetadata(metadataKey, target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryHasMetadata(metadataKey, target, propertyKey);
          }
          exporter("hasMetadata", hasMetadata);
          function hasOwnMetadata(metadataKey, target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryHasOwnMetadata(metadataKey, target, propertyKey);
          }
          exporter("hasOwnMetadata", hasOwnMetadata);
          function getMetadata(metadataKey, target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryGetMetadata(metadataKey, target, propertyKey);
          }
          exporter("getMetadata", getMetadata);
          function getOwnMetadata(metadataKey, target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryGetOwnMetadata(metadataKey, target, propertyKey);
          }
          exporter("getOwnMetadata", getOwnMetadata);
          function getMetadataKeys(target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryMetadataKeys(target, propertyKey);
          }
          exporter("getMetadataKeys", getMetadataKeys);
          function getOwnMetadataKeys(target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            return OrdinaryOwnMetadataKeys(target, propertyKey);
          }
          exporter("getOwnMetadataKeys", getOwnMetadataKeys);
          function deleteMetadata(metadataKey, target, propertyKey) {
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            if (!IsObject(target))
              throw new TypeError();
            if (!IsUndefined(propertyKey))
              propertyKey = ToPropertyKey(propertyKey);
            var provider = GetMetadataProvider(
              target,
              propertyKey,
              /*Create*/
              false
            );
            if (IsUndefined(provider))
              return false;
            return provider.OrdinaryDeleteMetadata(metadataKey, target, propertyKey);
          }
          exporter("deleteMetadata", deleteMetadata);
          function DecorateConstructor(decorators, target) {
            for (var i = decorators.length - 1; i >= 0; --i) {
              var decorator = decorators[i];
              var decorated = decorator(target);
              if (!IsUndefined(decorated) && !IsNull(decorated)) {
                if (!IsConstructor(decorated))
                  throw new TypeError();
                target = decorated;
              }
            }
            return target;
          }
          function DecorateProperty(decorators, target, propertyKey, descriptor) {
            for (var i = decorators.length - 1; i >= 0; --i) {
              var decorator = decorators[i];
              var decorated = decorator(target, propertyKey, descriptor);
              if (!IsUndefined(decorated) && !IsNull(decorated)) {
                if (!IsObject(decorated))
                  throw new TypeError();
                descriptor = decorated;
              }
            }
            return descriptor;
          }
          function OrdinaryHasMetadata(MetadataKey, O, P) {
            var hasOwn2 = OrdinaryHasOwnMetadata(MetadataKey, O, P);
            if (hasOwn2)
              return true;
            var parent = OrdinaryGetPrototypeOf(O);
            if (!IsNull(parent))
              return OrdinaryHasMetadata(MetadataKey, parent, P);
            return false;
          }
          function OrdinaryHasOwnMetadata(MetadataKey, O, P) {
            var provider = GetMetadataProvider(
              O,
              P,
              /*Create*/
              false
            );
            if (IsUndefined(provider))
              return false;
            return ToBoolean(provider.OrdinaryHasOwnMetadata(MetadataKey, O, P));
          }
          function OrdinaryGetMetadata(MetadataKey, O, P) {
            var hasOwn2 = OrdinaryHasOwnMetadata(MetadataKey, O, P);
            if (hasOwn2)
              return OrdinaryGetOwnMetadata(MetadataKey, O, P);
            var parent = OrdinaryGetPrototypeOf(O);
            if (!IsNull(parent))
              return OrdinaryGetMetadata(MetadataKey, parent, P);
            return void 0;
          }
          function OrdinaryGetOwnMetadata(MetadataKey, O, P) {
            var provider = GetMetadataProvider(
              O,
              P,
              /*Create*/
              false
            );
            if (IsUndefined(provider))
              return;
            return provider.OrdinaryGetOwnMetadata(MetadataKey, O, P);
          }
          function OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P) {
            var provider = GetMetadataProvider(
              O,
              P,
              /*Create*/
              true
            );
            provider.OrdinaryDefineOwnMetadata(MetadataKey, MetadataValue, O, P);
          }
          function OrdinaryMetadataKeys(O, P) {
            var ownKeys = OrdinaryOwnMetadataKeys(O, P);
            var parent = OrdinaryGetPrototypeOf(O);
            if (parent === null)
              return ownKeys;
            var parentKeys = OrdinaryMetadataKeys(parent, P);
            if (parentKeys.length <= 0)
              return ownKeys;
            if (ownKeys.length <= 0)
              return parentKeys;
            var set = new _Set();
            var keys = [];
            for (var _i = 0, ownKeys_1 = ownKeys; _i < ownKeys_1.length; _i++) {
              var key = ownKeys_1[_i];
              var hasKey = set.has(key);
              if (!hasKey) {
                set.add(key);
                keys.push(key);
              }
            }
            for (var _a = 0, parentKeys_1 = parentKeys; _a < parentKeys_1.length; _a++) {
              var key = parentKeys_1[_a];
              var hasKey = set.has(key);
              if (!hasKey) {
                set.add(key);
                keys.push(key);
              }
            }
            return keys;
          }
          function OrdinaryOwnMetadataKeys(O, P) {
            var provider = GetMetadataProvider(
              O,
              P,
              /*create*/
              false
            );
            if (!provider) {
              return [];
            }
            return provider.OrdinaryOwnMetadataKeys(O, P);
          }
          function Type(x) {
            if (x === null)
              return 1;
            switch (typeof x) {
              case "undefined":
                return 0;
              case "boolean":
                return 2;
              case "string":
                return 3;
              case "symbol":
                return 4;
              case "number":
                return 5;
              case "object":
                return x === null ? 1 : 6;
              default:
                return 6;
            }
          }
          function IsUndefined(x) {
            return x === void 0;
          }
          function IsNull(x) {
            return x === null;
          }
          function IsSymbol(x) {
            return typeof x === "symbol";
          }
          function IsObject(x) {
            return typeof x === "object" ? x !== null : typeof x === "function";
          }
          function ToPrimitive(input, PreferredType) {
            switch (Type(input)) {
              case 0:
                return input;
              case 1:
                return input;
              case 2:
                return input;
              case 3:
                return input;
              case 4:
                return input;
              case 5:
                return input;
            }
            var hint = PreferredType === 3 ? "string" : PreferredType === 5 ? "number" : "default";
            var exoticToPrim = GetMethod(input, toPrimitiveSymbol);
            if (exoticToPrim !== void 0) {
              var result = exoticToPrim.call(input, hint);
              if (IsObject(result))
                throw new TypeError();
              return result;
            }
            return OrdinaryToPrimitive(input, hint === "default" ? "number" : hint);
          }
          function OrdinaryToPrimitive(O, hint) {
            if (hint === "string") {
              var toString_1 = O.toString;
              if (IsCallable(toString_1)) {
                var result = toString_1.call(O);
                if (!IsObject(result))
                  return result;
              }
              var valueOf = O.valueOf;
              if (IsCallable(valueOf)) {
                var result = valueOf.call(O);
                if (!IsObject(result))
                  return result;
              }
            } else {
              var valueOf = O.valueOf;
              if (IsCallable(valueOf)) {
                var result = valueOf.call(O);
                if (!IsObject(result))
                  return result;
              }
              var toString_2 = O.toString;
              if (IsCallable(toString_2)) {
                var result = toString_2.call(O);
                if (!IsObject(result))
                  return result;
              }
            }
            throw new TypeError();
          }
          function ToBoolean(argument) {
            return !!argument;
          }
          function ToString(argument) {
            return "" + argument;
          }
          function ToPropertyKey(argument) {
            var key = ToPrimitive(
              argument,
              3
              /* String */
            );
            if (IsSymbol(key))
              return key;
            return ToString(key);
          }
          function IsArray(argument) {
            return Array.isArray ? Array.isArray(argument) : argument instanceof Object ? argument instanceof Array : Object.prototype.toString.call(argument) === "[object Array]";
          }
          function IsCallable(argument) {
            return typeof argument === "function";
          }
          function IsConstructor(argument) {
            return typeof argument === "function";
          }
          function IsPropertyKey(argument) {
            switch (Type(argument)) {
              case 3:
                return true;
              case 4:
                return true;
              default:
                return false;
            }
          }
          function SameValueZero(x, y) {
            return x === y || x !== x && y !== y;
          }
          function GetMethod(V, P) {
            var func = V[P];
            if (func === void 0 || func === null)
              return void 0;
            if (!IsCallable(func))
              throw new TypeError();
            return func;
          }
          function GetIterator(obj) {
            var method = GetMethod(obj, iteratorSymbol);
            if (!IsCallable(method))
              throw new TypeError();
            var iterator = method.call(obj);
            if (!IsObject(iterator))
              throw new TypeError();
            return iterator;
          }
          function IteratorValue(iterResult) {
            return iterResult.value;
          }
          function IteratorStep(iterator) {
            var result = iterator.next();
            return result.done ? false : result;
          }
          function IteratorClose(iterator) {
            var f = iterator["return"];
            if (f)
              f.call(iterator);
          }
          function OrdinaryGetPrototypeOf(O) {
            var proto = Object.getPrototypeOf(O);
            if (typeof O !== "function" || O === functionPrototype)
              return proto;
            if (proto !== functionPrototype)
              return proto;
            var prototype = O.prototype;
            var prototypeProto = prototype && Object.getPrototypeOf(prototype);
            if (prototypeProto == null || prototypeProto === Object.prototype)
              return proto;
            var constructor = prototypeProto.constructor;
            if (typeof constructor !== "function")
              return proto;
            if (constructor === O)
              return proto;
            return constructor;
          }
          function CreateMetadataRegistry() {
            var fallback;
            if (!IsUndefined(registrySymbol) && typeof root.Reflect !== "undefined" && !(registrySymbol in root.Reflect) && typeof root.Reflect.defineMetadata === "function") {
              fallback = CreateFallbackProvider(root.Reflect);
            }
            var first;
            var second;
            var rest;
            var targetProviderMap = new _WeakMap();
            var registry = {
              registerProvider,
              getProvider,
              setProvider
            };
            return registry;
            function registerProvider(provider) {
              if (!Object.isExtensible(registry)) {
                throw new Error("Cannot add provider to a frozen registry.");
              }
              switch (true) {
                case fallback === provider:
                  break;
                case IsUndefined(first):
                  first = provider;
                  break;
                case first === provider:
                  break;
                case IsUndefined(second):
                  second = provider;
                  break;
                case second === provider:
                  break;
                default:
                  if (rest === void 0)
                    rest = new _Set();
                  rest.add(provider);
                  break;
              }
            }
            function getProviderNoCache(O, P) {
              if (!IsUndefined(first)) {
                if (first.isProviderFor(O, P))
                  return first;
                if (!IsUndefined(second)) {
                  if (second.isProviderFor(O, P))
                    return first;
                  if (!IsUndefined(rest)) {
                    var iterator = GetIterator(rest);
                    while (true) {
                      var next = IteratorStep(iterator);
                      if (!next) {
                        return void 0;
                      }
                      var provider = IteratorValue(next);
                      if (provider.isProviderFor(O, P)) {
                        IteratorClose(iterator);
                        return provider;
                      }
                    }
                  }
                }
              }
              if (!IsUndefined(fallback) && fallback.isProviderFor(O, P)) {
                return fallback;
              }
              return void 0;
            }
            function getProvider(O, P) {
              var providerMap = targetProviderMap.get(O);
              var provider;
              if (!IsUndefined(providerMap)) {
                provider = providerMap.get(P);
              }
              if (!IsUndefined(provider)) {
                return provider;
              }
              provider = getProviderNoCache(O, P);
              if (!IsUndefined(provider)) {
                if (IsUndefined(providerMap)) {
                  providerMap = new _Map();
                  targetProviderMap.set(O, providerMap);
                }
                providerMap.set(P, provider);
              }
              return provider;
            }
            function hasProvider(provider) {
              if (IsUndefined(provider))
                throw new TypeError();
              return first === provider || second === provider || !IsUndefined(rest) && rest.has(provider);
            }
            function setProvider(O, P, provider) {
              if (!hasProvider(provider)) {
                throw new Error("Metadata provider not registered.");
              }
              var existingProvider = getProvider(O, P);
              if (existingProvider !== provider) {
                if (!IsUndefined(existingProvider)) {
                  return false;
                }
                var providerMap = targetProviderMap.get(O);
                if (IsUndefined(providerMap)) {
                  providerMap = new _Map();
                  targetProviderMap.set(O, providerMap);
                }
                providerMap.set(P, provider);
              }
              return true;
            }
          }
          function GetOrCreateMetadataRegistry() {
            var metadataRegistry2;
            if (!IsUndefined(registrySymbol) && IsObject(root.Reflect) && Object.isExtensible(root.Reflect)) {
              metadataRegistry2 = root.Reflect[registrySymbol];
            }
            if (IsUndefined(metadataRegistry2)) {
              metadataRegistry2 = CreateMetadataRegistry();
            }
            if (!IsUndefined(registrySymbol) && IsObject(root.Reflect) && Object.isExtensible(root.Reflect)) {
              Object.defineProperty(root.Reflect, registrySymbol, {
                enumerable: false,
                configurable: false,
                writable: false,
                value: metadataRegistry2
              });
            }
            return metadataRegistry2;
          }
          function CreateMetadataProvider(registry) {
            var metadata2 = new _WeakMap();
            var provider = {
              isProviderFor: function(O, P) {
                var targetMetadata = metadata2.get(O);
                if (IsUndefined(targetMetadata))
                  return false;
                return targetMetadata.has(P);
              },
              OrdinaryDefineOwnMetadata: OrdinaryDefineOwnMetadata2,
              OrdinaryHasOwnMetadata: OrdinaryHasOwnMetadata2,
              OrdinaryGetOwnMetadata: OrdinaryGetOwnMetadata2,
              OrdinaryOwnMetadataKeys: OrdinaryOwnMetadataKeys2,
              OrdinaryDeleteMetadata
            };
            metadataRegistry.registerProvider(provider);
            return provider;
            function GetOrCreateMetadataMap(O, P, Create) {
              var targetMetadata = metadata2.get(O);
              var createdTargetMetadata = false;
              if (IsUndefined(targetMetadata)) {
                if (!Create)
                  return void 0;
                targetMetadata = new _Map();
                metadata2.set(O, targetMetadata);
                createdTargetMetadata = true;
              }
              var metadataMap = targetMetadata.get(P);
              if (IsUndefined(metadataMap)) {
                if (!Create)
                  return void 0;
                metadataMap = new _Map();
                targetMetadata.set(P, metadataMap);
                if (!registry.setProvider(O, P, provider)) {
                  targetMetadata.delete(P);
                  if (createdTargetMetadata) {
                    metadata2.delete(O);
                  }
                  throw new Error("Wrong provider for target.");
                }
              }
              return metadataMap;
            }
            function OrdinaryHasOwnMetadata2(MetadataKey, O, P) {
              var metadataMap = GetOrCreateMetadataMap(
                O,
                P,
                /*Create*/
                false
              );
              if (IsUndefined(metadataMap))
                return false;
              return ToBoolean(metadataMap.has(MetadataKey));
            }
            function OrdinaryGetOwnMetadata2(MetadataKey, O, P) {
              var metadataMap = GetOrCreateMetadataMap(
                O,
                P,
                /*Create*/
                false
              );
              if (IsUndefined(metadataMap))
                return void 0;
              return metadataMap.get(MetadataKey);
            }
            function OrdinaryDefineOwnMetadata2(MetadataKey, MetadataValue, O, P) {
              var metadataMap = GetOrCreateMetadataMap(
                O,
                P,
                /*Create*/
                true
              );
              metadataMap.set(MetadataKey, MetadataValue);
            }
            function OrdinaryOwnMetadataKeys2(O, P) {
              var keys = [];
              var metadataMap = GetOrCreateMetadataMap(
                O,
                P,
                /*Create*/
                false
              );
              if (IsUndefined(metadataMap))
                return keys;
              var keysObj = metadataMap.keys();
              var iterator = GetIterator(keysObj);
              var k = 0;
              while (true) {
                var next = IteratorStep(iterator);
                if (!next) {
                  keys.length = k;
                  return keys;
                }
                var nextValue = IteratorValue(next);
                try {
                  keys[k] = nextValue;
                } catch (e) {
                  try {
                    IteratorClose(iterator);
                  } finally {
                    throw e;
                  }
                }
                k++;
              }
            }
            function OrdinaryDeleteMetadata(MetadataKey, O, P) {
              var metadataMap = GetOrCreateMetadataMap(
                O,
                P,
                /*Create*/
                false
              );
              if (IsUndefined(metadataMap))
                return false;
              if (!metadataMap.delete(MetadataKey))
                return false;
              if (metadataMap.size === 0) {
                var targetMetadata = metadata2.get(O);
                if (!IsUndefined(targetMetadata)) {
                  targetMetadata.delete(P);
                  if (targetMetadata.size === 0) {
                    metadata2.delete(targetMetadata);
                  }
                }
              }
              return true;
            }
          }
          function CreateFallbackProvider(reflect) {
            var defineMetadata2 = reflect.defineMetadata, hasOwnMetadata2 = reflect.hasOwnMetadata, getOwnMetadata2 = reflect.getOwnMetadata, getOwnMetadataKeys2 = reflect.getOwnMetadataKeys, deleteMetadata2 = reflect.deleteMetadata;
            var metadataOwner = new _WeakMap();
            var provider = {
              isProviderFor: function(O, P) {
                var metadataPropertySet = metadataOwner.get(O);
                if (!IsUndefined(metadataPropertySet) && metadataPropertySet.has(P)) {
                  return true;
                }
                if (getOwnMetadataKeys2(O, P).length) {
                  if (IsUndefined(metadataPropertySet)) {
                    metadataPropertySet = new _Set();
                    metadataOwner.set(O, metadataPropertySet);
                  }
                  metadataPropertySet.add(P);
                  return true;
                }
                return false;
              },
              OrdinaryDefineOwnMetadata: defineMetadata2,
              OrdinaryHasOwnMetadata: hasOwnMetadata2,
              OrdinaryGetOwnMetadata: getOwnMetadata2,
              OrdinaryOwnMetadataKeys: getOwnMetadataKeys2,
              OrdinaryDeleteMetadata: deleteMetadata2
            };
            return provider;
          }
          function GetMetadataProvider(O, P, Create) {
            var registeredProvider = metadataRegistry.getProvider(O, P);
            if (!IsUndefined(registeredProvider)) {
              return registeredProvider;
            }
            if (Create) {
              if (metadataRegistry.setProvider(O, P, metadataProvider)) {
                return metadataProvider;
              }
              throw new Error("Illegal state.");
            }
            return void 0;
          }
          function CreateMapPolyfill() {
            var cacheSentinel = {};
            var arraySentinel = [];
            var MapIterator = (
              /** @class */
              (function() {
                function MapIterator2(keys, values, selector) {
                  this._index = 0;
                  this._keys = keys;
                  this._values = values;
                  this._selector = selector;
                }
                MapIterator2.prototype["@@iterator"] = function() {
                  return this;
                };
                MapIterator2.prototype[iteratorSymbol] = function() {
                  return this;
                };
                MapIterator2.prototype.next = function() {
                  var index = this._index;
                  if (index >= 0 && index < this._keys.length) {
                    var result = this._selector(this._keys[index], this._values[index]);
                    if (index + 1 >= this._keys.length) {
                      this._index = -1;
                      this._keys = arraySentinel;
                      this._values = arraySentinel;
                    } else {
                      this._index++;
                    }
                    return { value: result, done: false };
                  }
                  return { value: void 0, done: true };
                };
                MapIterator2.prototype.throw = function(error) {
                  if (this._index >= 0) {
                    this._index = -1;
                    this._keys = arraySentinel;
                    this._values = arraySentinel;
                  }
                  throw error;
                };
                MapIterator2.prototype.return = function(value) {
                  if (this._index >= 0) {
                    this._index = -1;
                    this._keys = arraySentinel;
                    this._values = arraySentinel;
                  }
                  return { value, done: true };
                };
                return MapIterator2;
              })()
            );
            var Map2 = (
              /** @class */
              (function() {
                function Map3() {
                  this._keys = [];
                  this._values = [];
                  this._cacheKey = cacheSentinel;
                  this._cacheIndex = -2;
                }
                Object.defineProperty(Map3.prototype, "size", {
                  get: function() {
                    return this._keys.length;
                  },
                  enumerable: true,
                  configurable: true
                });
                Map3.prototype.has = function(key) {
                  return this._find(
                    key,
                    /*insert*/
                    false
                  ) >= 0;
                };
                Map3.prototype.get = function(key) {
                  var index = this._find(
                    key,
                    /*insert*/
                    false
                  );
                  return index >= 0 ? this._values[index] : void 0;
                };
                Map3.prototype.set = function(key, value) {
                  var index = this._find(
                    key,
                    /*insert*/
                    true
                  );
                  this._values[index] = value;
                  return this;
                };
                Map3.prototype.delete = function(key) {
                  var index = this._find(
                    key,
                    /*insert*/
                    false
                  );
                  if (index >= 0) {
                    var size = this._keys.length;
                    for (var i = index + 1; i < size; i++) {
                      this._keys[i - 1] = this._keys[i];
                      this._values[i - 1] = this._values[i];
                    }
                    this._keys.length--;
                    this._values.length--;
                    if (SameValueZero(key, this._cacheKey)) {
                      this._cacheKey = cacheSentinel;
                      this._cacheIndex = -2;
                    }
                    return true;
                  }
                  return false;
                };
                Map3.prototype.clear = function() {
                  this._keys.length = 0;
                  this._values.length = 0;
                  this._cacheKey = cacheSentinel;
                  this._cacheIndex = -2;
                };
                Map3.prototype.keys = function() {
                  return new MapIterator(this._keys, this._values, getKey);
                };
                Map3.prototype.values = function() {
                  return new MapIterator(this._keys, this._values, getValue);
                };
                Map3.prototype.entries = function() {
                  return new MapIterator(this._keys, this._values, getEntry);
                };
                Map3.prototype["@@iterator"] = function() {
                  return this.entries();
                };
                Map3.prototype[iteratorSymbol] = function() {
                  return this.entries();
                };
                Map3.prototype._find = function(key, insert) {
                  if (!SameValueZero(this._cacheKey, key)) {
                    this._cacheIndex = -1;
                    for (var i = 0; i < this._keys.length; i++) {
                      if (SameValueZero(this._keys[i], key)) {
                        this._cacheIndex = i;
                        break;
                      }
                    }
                  }
                  if (this._cacheIndex < 0 && insert) {
                    this._cacheIndex = this._keys.length;
                    this._keys.push(key);
                    this._values.push(void 0);
                  }
                  return this._cacheIndex;
                };
                return Map3;
              })()
            );
            return Map2;
            function getKey(key, _) {
              return key;
            }
            function getValue(_, value) {
              return value;
            }
            function getEntry(key, value) {
              return [key, value];
            }
          }
          function CreateSetPolyfill() {
            var Set2 = (
              /** @class */
              (function() {
                function Set3() {
                  this._map = new _Map();
                }
                Object.defineProperty(Set3.prototype, "size", {
                  get: function() {
                    return this._map.size;
                  },
                  enumerable: true,
                  configurable: true
                });
                Set3.prototype.has = function(value) {
                  return this._map.has(value);
                };
                Set3.prototype.add = function(value) {
                  return this._map.set(value, value), this;
                };
                Set3.prototype.delete = function(value) {
                  return this._map.delete(value);
                };
                Set3.prototype.clear = function() {
                  this._map.clear();
                };
                Set3.prototype.keys = function() {
                  return this._map.keys();
                };
                Set3.prototype.values = function() {
                  return this._map.keys();
                };
                Set3.prototype.entries = function() {
                  return this._map.entries();
                };
                Set3.prototype["@@iterator"] = function() {
                  return this.keys();
                };
                Set3.prototype[iteratorSymbol] = function() {
                  return this.keys();
                };
                return Set3;
              })()
            );
            return Set2;
          }
          function CreateWeakMapPolyfill() {
            var UUID_SIZE = 16;
            var keys = HashMap.create();
            var rootKey = CreateUniqueKey();
            return (
              /** @class */
              (function() {
                function WeakMap2() {
                  this._key = CreateUniqueKey();
                }
                WeakMap2.prototype.has = function(target) {
                  var table = GetOrCreateWeakMapTable(
                    target,
                    /*create*/
                    false
                  );
                  return table !== void 0 ? HashMap.has(table, this._key) : false;
                };
                WeakMap2.prototype.get = function(target) {
                  var table = GetOrCreateWeakMapTable(
                    target,
                    /*create*/
                    false
                  );
                  return table !== void 0 ? HashMap.get(table, this._key) : void 0;
                };
                WeakMap2.prototype.set = function(target, value) {
                  var table = GetOrCreateWeakMapTable(
                    target,
                    /*create*/
                    true
                  );
                  table[this._key] = value;
                  return this;
                };
                WeakMap2.prototype.delete = function(target) {
                  var table = GetOrCreateWeakMapTable(
                    target,
                    /*create*/
                    false
                  );
                  return table !== void 0 ? delete table[this._key] : false;
                };
                WeakMap2.prototype.clear = function() {
                  this._key = CreateUniqueKey();
                };
                return WeakMap2;
              })()
            );
            function CreateUniqueKey() {
              var key;
              do
                key = "@@WeakMap@@" + CreateUUID();
              while (HashMap.has(keys, key));
              keys[key] = true;
              return key;
            }
            function GetOrCreateWeakMapTable(target, create) {
              if (!hasOwn.call(target, rootKey)) {
                if (!create)
                  return void 0;
                Object.defineProperty(target, rootKey, { value: HashMap.create() });
              }
              return target[rootKey];
            }
            function FillRandomBytes(buffer, size) {
              for (var i = 0; i < size; ++i)
                buffer[i] = Math.random() * 255 | 0;
              return buffer;
            }
            function GenRandomBytes(size) {
              if (typeof Uint8Array === "function") {
                var array = new Uint8Array(size);
                if (typeof crypto !== "undefined") {
                  crypto.getRandomValues(array);
                } else if (typeof msCrypto !== "undefined") {
                  msCrypto.getRandomValues(array);
                } else {
                  FillRandomBytes(array, size);
                }
                return array;
              }
              return FillRandomBytes(new Array(size), size);
            }
            function CreateUUID() {
              var data = GenRandomBytes(UUID_SIZE);
              data[6] = data[6] & 79 | 64;
              data[8] = data[8] & 191 | 128;
              var result = "";
              for (var offset = 0; offset < UUID_SIZE; ++offset) {
                var byte = data[offset];
                if (offset === 4 || offset === 6 || offset === 8)
                  result += "-";
                if (byte < 16)
                  result += "0";
                result += byte.toString(16).toLowerCase();
              }
              return result;
            }
          }
          function MakeDictionary(obj) {
            obj.__ = void 0;
            delete obj.__;
            return obj;
          }
        });
      })(Reflect2 || (Reflect2 = {}));
    }
  });

  // out/src/compiler/compiler-interfaces/elan-type-interfaces.js
  var require_elan_type_interfaces = __commonJS({
    "out/src/compiler/compiler-interfaces/elan-type-interfaces.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Deprecation = exports.elanMetadataKey = void 0;
      exports.isFunctionDescriptor = isFunctionDescriptor;
      exports.isProcedureDescriptor = isProcedureDescriptor;
      exports.isConstantDescriptor = isConstantDescriptor;
      exports.isClassDescriptor = isClassDescriptor;
      exports.elanMetadataKey = Symbol("elan-metadata");
      var Deprecation;
      (function(Deprecation2) {
        Deprecation2[Deprecation2["methodRenamed"] = 0] = "methodRenamed";
        Deprecation2[Deprecation2["methodRemoved"] = 1] = "methodRemoved";
        Deprecation2[Deprecation2["classRenamed"] = 2] = "classRenamed";
        Deprecation2[Deprecation2["classRemoved"] = 3] = "classRemoved";
        Deprecation2[Deprecation2["methodParametersChanged"] = 4] = "methodParametersChanged";
        Deprecation2[Deprecation2["classParametersChanged"] = 5] = "classParametersChanged";
        Deprecation2[Deprecation2["methodHidden"] = 6] = "methodHidden";
      })(Deprecation || (exports.Deprecation = Deprecation = {}));
      function isFunctionDescriptor(d) {
        return !!d && "isFunction" in d;
      }
      function isProcedureDescriptor(d) {
        return !!d && "isProcedure" in d;
      }
      function isConstantDescriptor(d) {
        return !!d && "isConstant" in d;
      }
      function isClassDescriptor(d) {
        return !!d && "isClass" in d;
      }
    }
  });

  // out/src/compiler/elan-compiler-error.js
  var require_elan_compiler_error = __commonJS({
    "out/src/compiler/elan-compiler-error.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ElanCompilerError = void 0;
      var ElanCompilerError = class extends Error {
        err;
        constructor(err) {
          super(err instanceof Error ? err.message : err);
          this.err = err;
        }
      };
      exports.ElanCompilerError = ElanCompilerError;
    }
  });

  // out/src/compiler/compiler-interfaces/type-options.js
  var require_type_options = __commonJS({
    "out/src/compiler/compiler-interfaces/type-options.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.immutableTypeOptions = exports.noTypeOptions = void 0;
      exports.getTypeOptions = getTypeOptions;
      exports.isDictionary = isDictionary;
      exports.isImmutableDictionary = isImmutableDictionary;
      exports.isAnyDictionary = isAnyDictionary;
      exports.isRecord = isRecord;
      exports.noTypeOptions = {
        isImmutable: false,
        isAbstract: false,
        isIndexable: false,
        isDoubleIndexable: false,
        isIterable: false
      };
      exports.immutableTypeOptions = {
        isImmutable: true,
        isAbstract: false,
        isIndexable: false,
        isDoubleIndexable: false,
        isIterable: false
      };
      function getTypeOptions() {
        return {
          isImmutable: false,
          isAbstract: false,
          isIndexable: false,
          isDoubleIndexable: false,
          isIterable: false
        };
      }
      function isDictionary(t) {
        return !t.isImmutable && t.isIndexable && !t.isIterable;
      }
      function isImmutableDictionary(t) {
        return t.isImmutable && t.isIndexable && !t.isIterable;
      }
      function isAnyDictionary(t) {
        return t.isIndexable && !t.isIterable;
      }
      function isRecord(t) {
        return t.isImmutable && !t.isIndexable && !t.isIterable;
      }
    }
  });

  // out/src/compiler/keywords.js
  var require_keywords = __commonJS({
    "out/src/compiler/keywords.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.returnsKeyword = exports.returnKeyword = exports.repeatKeyword = exports.refKeyword = exports.recordKeyword = exports.propertyKeyword = exports.procedureKeyword = exports.privateKeyword = exports.printKeyword = exports.outKeyword = exports.orKeyword = exports.ofKeyword = exports.notKeyword = exports.newKeyword = exports.modKeyword = exports.mainKeyword = exports.libraryKeyword = exports.letKeyword = exports.lambdaKeyword = exports.isntKeyword = exports.isKeyword = exports.interfaceKeyword = exports.inheritsKeyword = exports.inKeyword = exports.importKeyword = exports.imageKeyword = exports.ignoreKeyword = exports.ifKeyword = exports.globalKeyword = exports.functionKeyword = exports.fromKeyword = exports.forKeyword = exports.exceptionKeyword = exports.enumKeyword = exports.endKeyword = exports.emptyKeyword = exports.elseKeyword = exports.eachKeyword = exports.divKeyword = exports.copyKeyword = exports.constructorKeyword = exports.constantKeyword = exports.classKeyword = exports.catchKeyword = exports.callKeyword = exports.beKeyword = exports.assertKeyword = exports.asKeyword = exports.andKeyword = exports.abstractKeyword = void 0;
      exports.sourceAnnotations = exports.importedAnnotation = exports.ghostedAnnotation = exports.reservedWords = exports.allKeywords = exports.commentMarker = exports.abstractClassKeywords = exports.privateFunctionKeywords = exports.privateProcedureKeywords = exports.privatePropertyKeywords = exports.abstractFunctionKeywords = exports.abstractProcedureKeywords = exports.abstractPropertyKeywords = exports.withKeyword = exports.whileKeyword = exports.variableKeyword = exports.tupleKeyword = exports.tryKeyword = exports.toKeyword = exports.throwKeyword = exports.thisKeyword = exports.thenKeyword = exports.testKeyword = exports.stepKeyword = exports.setKeyword = void 0;
      exports.abstractKeyword = "abstract";
      exports.andKeyword = "and";
      exports.asKeyword = "as";
      exports.assertKeyword = "assert";
      exports.beKeyword = "be";
      exports.callKeyword = "call";
      exports.catchKeyword = "catch";
      exports.classKeyword = "class";
      exports.constantKeyword = "constant";
      exports.constructorKeyword = "constructor";
      exports.copyKeyword = "copy";
      exports.divKeyword = "div";
      exports.eachKeyword = "each";
      exports.elseKeyword = "else";
      exports.emptyKeyword = "empty";
      exports.endKeyword = "end";
      exports.enumKeyword = "enum";
      exports.exceptionKeyword = "exception";
      exports.forKeyword = "for";
      exports.fromKeyword = "from";
      exports.functionKeyword = "function";
      exports.globalKeyword = "global";
      exports.ifKeyword = "if";
      exports.ignoreKeyword = "ignore";
      exports.imageKeyword = "image";
      exports.importKeyword = "import";
      exports.inKeyword = "in";
      exports.inheritsKeyword = "inherits";
      exports.interfaceKeyword = "interface";
      exports.isKeyword = "is";
      exports.isntKeyword = "isnt";
      exports.lambdaKeyword = "lambda";
      exports.letKeyword = "let";
      exports.libraryKeyword = "library";
      exports.mainKeyword = "main";
      exports.modKeyword = "mod";
      exports.newKeyword = "new";
      exports.notKeyword = "not";
      exports.ofKeyword = "of";
      exports.orKeyword = "or";
      exports.outKeyword = "out";
      exports.printKeyword = "print";
      exports.privateKeyword = "private";
      exports.procedureKeyword = "procedure";
      exports.propertyKeyword = "property";
      exports.recordKeyword = "record";
      exports.refKeyword = "ref";
      exports.repeatKeyword = "repeat";
      exports.returnKeyword = "return";
      exports.returnsKeyword = "returns";
      exports.setKeyword = "set";
      exports.stepKeyword = "step";
      exports.testKeyword = "test";
      exports.thenKeyword = "then";
      exports.thisKeyword = "this";
      exports.throwKeyword = "throw";
      exports.toKeyword = "to";
      exports.tryKeyword = "try";
      exports.tupleKeyword = "tuple";
      exports.variableKeyword = "variable";
      exports.whileKeyword = "while";
      exports.withKeyword = "with";
      exports.abstractPropertyKeywords = exports.abstractKeyword + " " + exports.propertyKeyword;
      exports.abstractProcedureKeywords = exports.abstractKeyword + " " + exports.procedureKeyword;
      exports.abstractFunctionKeywords = exports.abstractKeyword + " " + exports.functionKeyword;
      exports.privatePropertyKeywords = exports.privateKeyword + " " + exports.propertyKeyword;
      exports.privateProcedureKeywords = exports.privateKeyword + " " + exports.procedureKeyword;
      exports.privateFunctionKeywords = exports.privateKeyword + " " + exports.functionKeyword;
      exports.abstractClassKeywords = exports.abstractKeyword + " " + exports.classKeyword;
      exports.commentMarker = "#";
      exports.allKeywords = [
        exports.abstractKeyword,
        exports.andKeyword,
        exports.asKeyword,
        exports.assertKeyword,
        exports.beKeyword,
        exports.callKeyword,
        exports.catchKeyword,
        exports.classKeyword,
        exports.constantKeyword,
        exports.constructorKeyword,
        exports.copyKeyword,
        exports.divKeyword,
        exports.eachKeyword,
        exports.elseKeyword,
        exports.emptyKeyword,
        exports.endKeyword,
        exports.enumKeyword,
        exports.exceptionKeyword,
        exports.forKeyword,
        exports.fromKeyword,
        exports.functionKeyword,
        exports.globalKeyword,
        exports.ifKeyword,
        exports.ignoreKeyword,
        exports.imageKeyword,
        exports.importKeyword,
        exports.inKeyword,
        exports.inheritsKeyword,
        exports.interfaceKeyword,
        exports.isKeyword,
        exports.isntKeyword,
        exports.lambdaKeyword,
        exports.letKeyword,
        exports.libraryKeyword,
        exports.mainKeyword,
        exports.modKeyword,
        exports.newKeyword,
        exports.notKeyword,
        exports.ofKeyword,
        exports.orKeyword,
        exports.outKeyword,
        exports.printKeyword,
        exports.privateKeyword,
        exports.procedureKeyword,
        exports.propertyKeyword,
        exports.recordKeyword,
        exports.refKeyword,
        exports.repeatKeyword,
        exports.returnKeyword,
        exports.returnsKeyword,
        exports.setKeyword,
        exports.stepKeyword,
        exports.testKeyword,
        exports.thenKeyword,
        exports.thisKeyword,
        exports.throwKeyword,
        exports.toKeyword,
        exports.tryKeyword,
        exports.tupleKeyword,
        exports.variableKeyword,
        exports.whileKeyword,
        exports.withKeyword
      ];
      exports.reservedWords = [
        "action",
        "arguments",
        "array",
        "async",
        "await",
        "boolean",
        "break",
        "by",
        "byte",
        "case",
        "catch",
        "char",
        "const",
        "continue",
        "curry",
        "debugger",
        "default",
        "delete",
        "dictionary",
        "do",
        "double",
        "eval",
        "export",
        "extends",
        "final",
        "finally",
        "float",
        "goto",
        "implements",
        "instanceof",
        "int",
        "into",
        "list",
        "long",
        "match",
        "mock",
        "namespace",
        "native",
        "null",
        "on",
        "optional",
        "otherwise",
        "package",
        "partial",
        "pattern",
        "protected",
        "public",
        "scenario",
        "short",
        "static",
        "stdlib",
        // Used for injected property
        "string",
        "super",
        "switch",
        "system",
        "synchronized",
        "throws",
        "transient",
        "typeof",
        "void",
        "volatile",
        "var",
        "when",
        "yield"
      ];
      exports.ghostedAnnotation = "ghosted";
      exports.importedAnnotation = "imported";
      exports.sourceAnnotations = [exports.ghostedAnnotation, exports.importedAnnotation];
    }
  });

  // out/src/compiler/symbols/elan-type-names.js
  var require_elan_type_names = __commonJS({
    "out/src/compiler/symbols/elan-type-names.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ImageName = exports.ClassName = exports.TupleName = exports.FuncName = exports.Array2DName = exports.DictionaryImmutableName = exports.DictionaryName = exports.ListImmutableName = exports.ListName = exports.RegExpName = exports.StringName = exports.FloatName = exports.IntName = exports.BooleanName = void 0;
      exports.BooleanName = "Boolean";
      exports.IntName = "Int";
      exports.FloatName = "Float";
      exports.StringName = "String";
      exports.RegExpName = "RegExp";
      exports.ListName = "List";
      exports.ListImmutableName = "ListImmutable";
      exports.DictionaryName = "Dictionary";
      exports.DictionaryImmutableName = "DictionaryImmutable";
      exports.Array2DName = "Array2D";
      exports.FuncName = "Func";
      exports.TupleName = "Tuple";
      exports.ClassName = "Class";
      exports.ImageName = "ImageVG";
    }
  });

  // out/src/compiler/symbols/boolean-type.js
  var require_boolean_type = __commonJS({
    "out/src/compiler/symbols/boolean-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BooleanType = void 0;
      var type_options_1 = require_type_options();
      var elan_type_names_1 = require_elan_type_names();
      var BooleanType = class _BooleanType {
        constructor() {
        }
        typeOptions = type_options_1.immutableTypeOptions;
        initialValue = "false";
        static Instance = new _BooleanType();
        name = elan_type_names_1.BooleanName;
        toString() {
          return this.name;
        }
        isAssignableFrom(otherType) {
          return otherType instanceof _BooleanType;
        }
      };
      exports.BooleanType = BooleanType;
    }
  });

  // out/src/compiler/symbols/int-type.js
  var require_int_type = __commonJS({
    "out/src/compiler/symbols/int-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IntType = void 0;
      var type_options_1 = require_type_options();
      var elan_type_names_1 = require_elan_type_names();
      var IntType = class _IntType {
        constructor() {
        }
        initialValue = "0";
        typeOptions = type_options_1.immutableTypeOptions;
        static Instance = new _IntType();
        name = elan_type_names_1.IntName;
        toString() {
          return this.name;
        }
        isAssignableFrom(otherType) {
          return otherType instanceof _IntType;
        }
      };
      exports.IntType = IntType;
    }
  });

  // out/src/compiler/symbols/float-type.js
  var require_float_type = __commonJS({
    "out/src/compiler/symbols/float-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FloatType = void 0;
      var type_options_1 = require_type_options();
      var elan_type_names_1 = require_elan_type_names();
      var int_type_1 = require_int_type();
      var FloatType = class _FloatType {
        constructor() {
        }
        initialValue = "0";
        typeOptions = type_options_1.immutableTypeOptions;
        static Instance = new _FloatType();
        name = elan_type_names_1.FloatName;
        toString() {
          return this.name;
        }
        isNumber(st) {
          return st instanceof int_type_1.IntType || st instanceof _FloatType;
        }
        isAssignableFrom(otherType) {
          return this.isNumber(otherType);
        }
      };
      exports.FloatType = FloatType;
    }
  });

  // out/src/compiler/symbols/function-type.js
  var require_function_type = __commonJS({
    "out/src/compiler/symbols/function-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FunctionType = void 0;
      var type_options_1 = require_type_options();
      var elan_type_names_1 = require_elan_type_names();
      var FunctionType = class _FunctionType {
        parameterNames;
        parameterTypes;
        returnType;
        isExtension;
        isPure;
        isAsync;
        deprecated;
        constructor(parameterNames, parameterTypes, returnType, isExtension, isPure, isAsync, deprecated) {
          this.parameterNames = parameterNames;
          this.parameterTypes = parameterTypes;
          this.returnType = returnType;
          this.isExtension = isExtension;
          this.isPure = isPure;
          this.isAsync = isAsync;
          this.deprecated = deprecated;
        }
        get initialValue() {
          return `system.emptyFunc(${this.returnType.initialValue})`;
        }
        // so can have mutable type parameters
        typeOptions = type_options_1.noTypeOptions;
        get name() {
          return `Func<of ${this.parameterTypes.map((p) => p.name).join(", ")} => ${this.returnType.name}>`;
        }
        toString() {
          return elan_type_names_1.FuncName;
        }
        isAssignableFrom(otherType) {
          if (otherType instanceof _FunctionType) {
            if (this.parameterTypes.length !== otherType.parameterTypes.length) {
              return false;
            }
            const rt = this.returnType.isAssignableFrom(otherType.returnType);
            return rt && this.parameterTypes.map((t, i) => t.isAssignableFrom(otherType.parameterTypes[i])).every((b) => b);
          }
          return false;
        }
      };
      exports.FunctionType = FunctionType;
    }
  });

  // out/src/compiler/symbols/generic-parameter-type.js
  var require_generic_parameter_type = __commonJS({
    "out/src/compiler/symbols/generic-parameter-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.GenericParameterType = void 0;
      var type_options_1 = require_type_options();
      var GenericParameterType = class _GenericParameterType {
        id;
        constraint;
        constructor(id, constraint) {
          this.id = id;
          this.constraint = constraint;
        }
        typeOptions = type_options_1.noTypeOptions;
        initialValue = "";
        get name() {
          return this.constraint ? `${this.constraint.name}` : `Generic Parameter ${this.id}`;
        }
        toString() {
          return this.name;
        }
        isAssignableFrom(otherType) {
          if (otherType instanceof _GenericParameterType) {
            return this.name === otherType.name;
          }
          return false;
        }
      };
      exports.GenericParameterType = GenericParameterType;
    }
  });

  // out/src/compiler/symbols/procedure-type.js
  var require_procedure_type = __commonJS({
    "out/src/compiler/symbols/procedure-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProcedureType = void 0;
      var type_options_1 = require_type_options();
      var ProcedureType = class {
        parameterNames;
        parameterTypes;
        isExtension;
        isAsync;
        deprecated;
        constructor(parameterNames, parameterTypes, isExtension, isAsync, deprecated) {
          this.parameterNames = parameterNames;
          this.parameterTypes = parameterTypes;
          this.isExtension = isExtension;
          this.isAsync = isAsync;
          this.deprecated = deprecated;
        }
        typeOptions = type_options_1.immutableTypeOptions;
        initialValue = "";
        get name() {
          return `Procedure (${this.parameterTypes.map((p) => p.name).join(", ")})`;
        }
        toString() {
          return `Procedure`;
        }
        isAssignableFrom(_otherType) {
          return true;
        }
      };
      exports.ProcedureType = ProcedureType;
    }
  });

  // out/src/compiler/symbols/string-type.js
  var require_string_type = __commonJS({
    "out/src/compiler/symbols/string-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StringType = void 0;
      var elan_type_names_1 = require_elan_type_names();
      var StringType = class _StringType {
        constructor() {
        }
        get ofTypes() {
          return [_StringType.Instance];
        }
        initialValue = '""';
        get typeOptions() {
          return {
            isImmutable: true,
            isAbstract: false,
            isIndexable: true,
            isDoubleIndexable: false,
            isIterable: true
          };
        }
        static Instance = new _StringType();
        name = elan_type_names_1.StringName;
        toString() {
          return this.name;
        }
        isAssignableFrom(otherType) {
          return otherType instanceof _StringType;
        }
      };
      exports.StringType = StringType;
    }
  });

  // out/src/compiler/symbols/tuple-type.js
  var require_tuple_type = __commonJS({
    "out/src/compiler/symbols/tuple-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TupleType = void 0;
      var type_options_1 = require_type_options();
      var TupleType = class _TupleType {
        ofTypes;
        constructor(ofTypes) {
          this.ofTypes = ofTypes;
        }
        typeOptions = type_options_1.immutableTypeOptions;
        get initialValue() {
          const init = this.ofTypes.map((t) => t.initialValue).join(", ");
          return `system.emptyTuple([${init}])`;
        }
        get name() {
          return `tuple(${this.ofTypes.map((t) => t.name).join(", ")})`;
        }
        toString() {
          return `tuple(${this.ofTypes.map((t) => t.name).join(", ")})`;
        }
        isAssignableFrom(otherType) {
          if (otherType instanceof _TupleType) {
            if (this.ofTypes.length !== otherType.ofTypes.length) {
              return false;
            }
            return this.ofTypes.map((t, i) => t.isAssignableFrom(otherType.ofTypes[i])).every((b) => b);
          }
          return false;
        }
      };
      exports.TupleType = TupleType;
    }
  });

  // out/src/compiler/symbols/unknown-type.js
  var require_unknown_type = __commonJS({
    "out/src/compiler/symbols/unknown-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.UnknownType = void 0;
      var type_options_1 = require_type_options();
      var UnknownType = class _UnknownType {
        constructor() {
        }
        initialValue = "";
        typeOptions = type_options_1.immutableTypeOptions;
        static Instance = new _UnknownType();
        name = "Unknown";
        toString() {
          return this.name;
        }
        isAssignableFrom(_otherType) {
          return true;
        }
      };
      exports.UnknownType = UnknownType;
    }
  });

  // out/src/compiler/compile-error.js
  var require_compile_error = __commonJS({
    "out/src/compiler/compile-error.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ImmutableCollectionCompileError = exports.NotGlobalFunctionRefCompileError = exports.FunctionRefCompileError = exports.DuplicateKeyCompileError = exports.RedefinedCompileError = exports.ReassignInFunctionCompileError = exports.ParameterNameCompileError = exports.NotUniqueNameCompileError = exports.MutateCompileError = exports.GenericParametersCompileError = exports.ParameterTypesCompileError = exports.ExtraParameterCompileError = exports.MissingParameterCompileError = exports.PropertyCompileError = exports.ExtensionCompileError = exports.OutParameterCompileError = exports.MustBeConcreteCompileError = exports.MustImplementCompileError = exports.PrivateMemberCompileError = exports.MustBeSingleAbstractCompileError = exports.MustNotBeCircularDependencyCompileError = exports.MustBeInterfaceCompileError = exports.MustBeAbstractCompileError = exports.InvalidSourceForEachCompileError = exports.NotNewableCompileError = exports.NotRangeableCompileError = exports.NotIndexableCompileError = exports.CannotCallAsAMethod = exports.CannotUseLikeAFunction = exports.IsDeprecated = exports.CannotUseSystemMethodInAFunction = exports.CannotCallAFunction = exports.UndefinedSymbolCompileError = exports.SyntaxCompileError = exports.TernaryCompileError = exports.TypesCompileError = exports.MemberTypeCompileError = exports.DeclaredAboveCompileError = exports.ThisCompileError = exports.TypeCompileError = exports.CompileError = exports.Severity = exports.DisplayPriority = void 0;
      var elan_type_interfaces_1 = require_elan_type_interfaces();
      var DisplayPriority;
      (function(DisplayPriority2) {
        DisplayPriority2[DisplayPriority2["first"] = 0] = "first";
        DisplayPriority2[DisplayPriority2["second"] = 1] = "second";
        DisplayPriority2[DisplayPriority2["third"] = 2] = "third";
        DisplayPriority2[DisplayPriority2["fourth"] = 3] = "fourth";
      })(DisplayPriority || (exports.DisplayPriority = DisplayPriority = {}));
      var Severity;
      (function(Severity2) {
        Severity2[Severity2["error"] = 0] = "error";
        Severity2[Severity2["warning"] = 1] = "warning";
      })(Severity || (exports.Severity = Severity = {}));
      var CompileError = class {
        priority;
        severity;
        message;
        locationId;
        link;
        constructor(priority, severity, message, locationId, link) {
          this.priority = priority;
          this.severity = severity;
          this.message = message;
          this.locationId = locationId;
          this.link = link;
        }
        toString() {
          return `${this.constructor.name}: ${this.message} Priority: ${DisplayPriority[this.priority]} Severity: ${Severity[this.severity]} at: ${this.locationId}`;
        }
        sameError(other) {
          return this.toString() === other.toString();
        }
      };
      exports.CompileError = CompileError;
      var TypeCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.fourth, Severity.error, `Expression must be ${type}.`, location, "LangRef.html#TypeCompileError");
        }
      };
      exports.TypeCompileError = TypeCompileError;
      var ThisCompileError = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.second, Severity.error, `Cannot use 'this' outside class context.`, location, "LangRef.html#ThisCompileError");
        }
      };
      exports.ThisCompileError = ThisCompileError;
      var DeclaredAboveCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.second, Severity.error, `Abstract Class '${type}' must be declared before it is used.`, location, "LangRef.html#DeclaredAboveCompileError");
        }
      };
      exports.DeclaredAboveCompileError = DeclaredAboveCompileError;
      var MemberTypeCompileError = class extends CompileError {
        constructor(name, type, location) {
          super(DisplayPriority.fourth, Severity.error, `Member '${name}' must be of type ${type}.`, location, "LangRef.html#MemberTypeCompileError");
        }
      };
      exports.MemberTypeCompileError = MemberTypeCompileError;
      var TypesCompileError = class extends CompileError {
        constructor(type1, type2, addInfo, location) {
          super(DisplayPriority.fourth, Severity.error, `Incompatible types. Expected: ${type2}${addInfo}, Provided: ${type1}.`, location, "LangRef.html#TypesCompileError");
        }
      };
      exports.TypesCompileError = TypesCompileError;
      var TernaryCompileError = class extends CompileError {
        constructor(type1, type2, location) {
          super(DisplayPriority.fourth, Severity.error, `Cannot determine common type between ${type1} and ${type2}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.TernaryCompileError = TernaryCompileError;
      var SyntaxCompileError = class extends CompileError {
        constructor(message, location, link = "") {
          const linkToUse = link === "" ? "LangRef.html#compile_error" : link;
          super(DisplayPriority.second, Severity.error, message, location, linkToUse);
        }
      };
      exports.SyntaxCompileError = SyntaxCompileError;
      var UndefinedSymbolCompileError = class extends CompileError {
        constructor(id, type, location) {
          const postfix = type ? ` for type '${type}'` : "";
          super(DisplayPriority.third, Severity.warning, `'${id}' is not defined${postfix}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.UndefinedSymbolCompileError = UndefinedSymbolCompileError;
      var CannotCallAFunction = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.second, Severity.error, `Cannot call a function as a procedure.`, location, "LangRef.html#compile_error");
        }
      };
      exports.CannotCallAFunction = CannotCallAFunction;
      var CannotUseSystemMethodInAFunction = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.second, Severity.error, `Cannot use a system method in a function.`, location, "LangRef.html#compile_error");
        }
      };
      exports.CannotUseSystemMethodInAFunction = CannotUseSystemMethodInAFunction;
      function reasonString(reason) {
        switch (reason) {
          case elan_type_interfaces_1.Deprecation.classRemoved:
            return "Class was removed";
          case elan_type_interfaces_1.Deprecation.classRenamed:
            return "Class was renamed";
          case elan_type_interfaces_1.Deprecation.methodRemoved:
            return "Method was removed";
          case elan_type_interfaces_1.Deprecation.methodRenamed:
            return "Method was renamed";
          case elan_type_interfaces_1.Deprecation.classParametersChanged:
            return "Parameters for class were changed";
          case elan_type_interfaces_1.Deprecation.methodParametersChanged:
            return "Parameters for method were changed";
          case elan_type_interfaces_1.Deprecation.methodHidden:
            return "Method was hidden";
        }
      }
      var IsDeprecated = class extends CompileError {
        constructor(reason, fromMajor, fromMinor, help, location) {
          super(DisplayPriority.first, Severity.error, `Code change required. ${reasonString(reason)} in v${fromMajor}.${fromMinor}.`, location, help);
        }
      };
      exports.IsDeprecated = IsDeprecated;
      var CannotUseLikeAFunction = class extends CompileError {
        constructor(id, location) {
          super(DisplayPriority.second, Severity.error, `Cannot call procedure '${id}' within an expression.`, location, "LangRef.html#compile_error");
        }
      };
      exports.CannotUseLikeAFunction = CannotUseLikeAFunction;
      var CannotCallAsAMethod = class extends CompileError {
        constructor(id, symbolType, location) {
          super(DisplayPriority.second, Severity.error, `Cannot invoke ${symbolType} '${id}' as a method.`, location, "LangRef.html#compile_error");
        }
      };
      exports.CannotCallAsAMethod = CannotCallAsAMethod;
      var NotIndexableCompileError = class extends CompileError {
        constructor(type, location, double) {
          const dbl = double ? "double " : "";
          super(DisplayPriority.second, Severity.error, `Cannot ${dbl}index ${type}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.NotIndexableCompileError = NotIndexableCompileError;
      var NotRangeableCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.second, Severity.error, `Cannot range ${type}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.NotRangeableCompileError = NotRangeableCompileError;
      var NotNewableCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.fourth, Severity.error, `Cannot new ${type}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.NotNewableCompileError = NotNewableCompileError;
      var InvalidSourceForEachCompileError = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.second, Severity.error, `Source for 'each' must be an Array, List, or String.`, location, "LangRef.html#compile_error");
        }
      };
      exports.InvalidSourceForEachCompileError = InvalidSourceForEachCompileError;
      var MustBeAbstractCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.second, Severity.error, `Superclass '${type}' must be inheritable class.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MustBeAbstractCompileError = MustBeAbstractCompileError;
      var MustBeInterfaceCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.second, Severity.error, `Superclass '${type}' must be an interface.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MustBeInterfaceCompileError = MustBeInterfaceCompileError;
      var MustNotBeCircularDependencyCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.second, Severity.error, `Class/interface '${type}' cannot inherit from itself.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MustNotBeCircularDependencyCompileError = MustNotBeCircularDependencyCompileError;
      var MustBeSingleAbstractCompileError = class extends CompileError {
        constructor(types, location) {
          super(DisplayPriority.second, Severity.error, `There must be only one abstract superclass, ${types.join(", ")} are abstract classes.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MustBeSingleAbstractCompileError = MustBeSingleAbstractCompileError;
      var PrivateMemberCompileError = class extends CompileError {
        constructor(id, location) {
          super(DisplayPriority.second, Severity.error, `Cannot reference private member '${id}'.`, location, "LangRef.html#compile_error");
        }
      };
      exports.PrivateMemberCompileError = PrivateMemberCompileError;
      var MustImplementCompileError = class extends CompileError {
        constructor(classType, superClassType, id, location) {
          super(DisplayPriority.second, Severity.error, `${classType} must implement ${superClassType}.${id}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MustImplementCompileError = MustImplementCompileError;
      var MustBeConcreteCompileError = class extends CompileError {
        constructor(type, location) {
          super(DisplayPriority.second, Severity.error, `${type} must be concrete to new.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MustBeConcreteCompileError = MustBeConcreteCompileError;
      var OutParameterCompileError = class extends CompileError {
        constructor(name, location) {
          super(DisplayPriority.fourth, Severity.error, `Cannot pass '${name}' as an out parameter.`, location, "LangRef.html#compile_error");
        }
      };
      exports.OutParameterCompileError = OutParameterCompileError;
      var ExtensionCompileError = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.second, Severity.error, `Cannot call extension method directly.`, location, "LangRef.html#compile_error");
        }
      };
      exports.ExtensionCompileError = ExtensionCompileError;
      var PropertyCompileError = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.second, Severity.error, `Cannot prefix function with 'property'.`, location, "LangRef.html#compile_error");
        }
      };
      exports.PropertyCompileError = PropertyCompileError;
      var MissingParameterCompileError = class extends CompileError {
        constructor(description, location) {
          super(DisplayPriority.third, Severity.warning, `Missing argument(s). Expected: ${description}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MissingParameterCompileError = MissingParameterCompileError;
      var ExtraParameterCompileError = class extends CompileError {
        constructor(description, location) {
          description = description ? description : "none";
          super(DisplayPriority.second, Severity.error, `Too many argument(s). Expected: ${description}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.ExtraParameterCompileError = ExtraParameterCompileError;
      var ParameterTypesCompileError = class extends CompileError {
        constructor(description, provided, location) {
          super(DisplayPriority.fourth, Severity.error, `Argument types. Expected: ${description}, Provided: ${provided}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.ParameterTypesCompileError = ParameterTypesCompileError;
      var GenericParametersCompileError = class extends CompileError {
        constructor(expected, actual, location) {
          const priority = actual < expected ? DisplayPriority.third : DisplayPriority.second;
          const severity = actual < expected ? Severity.warning : Severity.error;
          let msg = ``;
          if (expected === 0 && actual > 0) {
            msg = `<of Type> was not expected here.`;
          } else if (expected === 1 && actual === 0) {
            msg = `Expected: '<of Type>'.`;
          } else if (expected === 2 && actual < 2) {
            msg = `Expected: '<of Type, Type>'.`;
          } else {
            msg = `Number of Types specified in '<of ...>' is not correct. Expected: ${expected}, Provided: ${actual}.`;
          }
          super(priority, severity, `${msg}`, location, "LangRef.html#GenericParametersCompileError");
        }
      };
      exports.GenericParametersCompileError = GenericParametersCompileError;
      var MutateCompileError = class extends CompileError {
        constructor(name, purpose, location) {
          super(DisplayPriority.second, Severity.error, `May not re-assign the ${purpose} '${name}'.`, location, "LangRef.html#compile_error");
        }
      };
      exports.MutateCompileError = MutateCompileError;
      var NotUniqueNameCompileError = class extends CompileError {
        constructor(name, postFix, location) {
          super(DisplayPriority.second, Severity.error, `Name '${name}' not unique in scope${postFix}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.NotUniqueNameCompileError = NotUniqueNameCompileError;
      var ParameterNameCompileError = class extends CompileError {
        constructor(name, location) {
          super(DisplayPriority.second, Severity.error, `Parameter '${name}' may not have the same name as the method in which it is defined.`, location, "LangRef.html#compile_error");
        }
      };
      exports.ParameterNameCompileError = ParameterNameCompileError;
      var ReassignInFunctionCompileError = class extends CompileError {
        constructor(thing, location) {
          super(DisplayPriority.second, Severity.error, `May not set ${thing} in a function.`, location, "LangRef.html#compile_error");
        }
      };
      exports.ReassignInFunctionCompileError = ReassignInFunctionCompileError;
      var RedefinedCompileError = class extends CompileError {
        constructor(id, purpose, location) {
          super(DisplayPriority.second, Severity.error, `The identifier '${id}' is already used for a ${purpose} and cannot be re-defined here.`, location, "LangRef.html#compile_error");
        }
      };
      exports.RedefinedCompileError = RedefinedCompileError;
      var DuplicateKeyCompileError = class extends CompileError {
        constructor(location) {
          super(DisplayPriority.fourth, Severity.error, `Duplicate Dictionary key(s).`, location, "LangRef.html#compile_error");
        }
      };
      exports.DuplicateKeyCompileError = DuplicateKeyCompileError;
      var FunctionRefCompileError = class extends CompileError {
        constructor(id, isGlobal, location) {
          const postfix = isGlobal ? ` Or to create a reference to '${id}', precede it by 'ref'.` : "";
          super(DisplayPriority.second, Severity.error, `To evaluate function '${id}' add brackets.${postfix}`, location, "LangRef.html#compile_error");
        }
      };
      exports.FunctionRefCompileError = FunctionRefCompileError;
      var NotGlobalFunctionRefCompileError = class extends CompileError {
        constructor(id, location) {
          super(DisplayPriority.second, Severity.error, `Library or class function '${id}' cannot be preceded by 'ref'.`, location, "LangRef.html#NotGlobalFunctionRefCompileError");
        }
      };
      exports.NotGlobalFunctionRefCompileError = NotGlobalFunctionRefCompileError;
      var ImmutableCollectionCompileError = class extends CompileError {
        constructor(list, location) {
          super(DisplayPriority.second, Severity.error, `An ordinary ${list ? "List" : "Dictionary"} cannot be defined as a constant. Consider using { } instead of [ ] to define an immutable ${list ? "List" : "Dictionary"}.`, location, "LangRef.html#compile_error");
        }
      };
      exports.ImmutableCollectionCompileError = ImmutableCollectionCompileError;
    }
  });

  // out/src/compiler/symbols/deconstructed-list-type.js
  var require_deconstructed_list_type = __commonJS({
    "out/src/compiler/symbols/deconstructed-list-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedListType = void 0;
      var type_options_1 = require_type_options();
      var elan_type_names_1 = require_elan_type_names();
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_type_1 = require_unknown_type();
      var DeconstructedListType = class {
        headdId;
        tailId;
        headType;
        tailType;
        constructor(headdId, tailId, headType, tailType) {
          this.headdId = headdId;
          this.tailId = tailId;
          this.headType = headType;
          this.tailType = tailType;
          this.typeMap[headdId] = headType;
          this.typeMap[tailId] = tailType;
        }
        get ids() {
          return [this.headdId, this.tailId];
        }
        initialValue = "";
        symbolTypeFor(id) {
          return this.typeMap[id] ?? unknown_type_1.UnknownType.Instance;
        }
        typeOptions = type_options_1.immutableTypeOptions;
        typeMap = {};
        get name() {
          return this.tailId ? this.tailType.name : `${elan_type_names_1.ListImmutableName}<of ${this.headType}> or ${elan_type_names_1.ListName}<of ${this.headType}>`;
        }
        toString() {
          return `${this.headdId ? this.headType.name : "_"}:${this.tailId ? this.tailType.name : "_"}`;
        }
        isAssignableFrom(otherType) {
          if (this.tailId) {
            return this.tailType.isAssignableFrom(otherType);
          }
          if ((0, symbol_helpers_1.isGenericSymbolType)(otherType)) {
            return this.headType.isAssignableFrom(otherType.ofTypes[0]);
          }
          return false;
        }
      };
      exports.DeconstructedListType = DeconstructedListType;
    }
  });

  // out/src/compiler/symbols/deconstructed-tuple-type.js
  var require_deconstructed_tuple_type = __commonJS({
    "out/src/compiler/symbols/deconstructed-tuple-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedTupleType = void 0;
      var type_options_1 = require_type_options();
      var tuple_type_1 = require_tuple_type();
      var unknown_type_1 = require_unknown_type();
      var DeconstructedTupleType = class {
        ids;
        ofTypes;
        constructor(ids, ofTypes) {
          this.ids = ids;
          this.ofTypes = ofTypes;
          for (let i = 0; i < ids.length; i++) {
            this.typeMap[ids[i]] = ofTypes[i];
          }
        }
        initialValue = "";
        typeOptions = type_options_1.immutableTypeOptions;
        symbolTypeFor(id) {
          return this.typeMap[id] ?? unknown_type_1.UnknownType.Instance;
        }
        typeMap = {};
        nameOrDiscard(name, index) {
          return this.ids[index] ? name : "_";
        }
        get name() {
          return `${this.ofTypes.map((t, i) => this.nameOrDiscard(t.name, i)).join(", ")}`;
        }
        toString() {
          return this.name;
        }
        isAssignableFrom(otherType) {
          if (otherType instanceof tuple_type_1.TupleType) {
            if (this.ofTypes.length !== otherType.ofTypes.length) {
              return false;
            }
            return this.ofTypes.map((t, i) => t.isAssignableFrom(otherType.ofTypes[i])).every((b) => b);
          }
          return false;
        }
      };
      exports.DeconstructedTupleType = DeconstructedTupleType;
    }
  });

  // out/src/compiler/symbols/duplicate-symbol.js
  var require_duplicate_symbol = __commonJS({
    "out/src/compiler/symbols/duplicate-symbol.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DuplicateSymbol = void 0;
      var DuplicateSymbol = class {
        duplicates;
        constructor(duplicates) {
          this.duplicates = duplicates;
        }
        get symbolId() {
          return this.duplicates[0].symbolId;
        }
        symbolType() {
          return this.duplicates[0].symbolType();
        }
        get symbolScope() {
          return this.duplicates[0].symbolScope;
        }
        name = "Duplicate Symbol";
      };
      exports.DuplicateSymbol = DuplicateSymbol;
    }
  });

  // out/src/compiler/symbols/symbol-scope.js
  var require_symbol_scope = __commonJS({
    "out/src/compiler/symbols/symbol-scope.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SymbolScope = void 0;
      var SymbolScope;
      (function(SymbolScope2) {
        SymbolScope2[SymbolScope2["external"] = 0] = "external";
        SymbolScope2[SymbolScope2["system"] = 1] = "system";
        SymbolScope2[SymbolScope2["stdlib"] = 2] = "stdlib";
        SymbolScope2[SymbolScope2["program"] = 3] = "program";
        SymbolScope2[SymbolScope2["parameter"] = 4] = "parameter";
        SymbolScope2[SymbolScope2["outParameter"] = 5] = "outParameter";
        SymbolScope2[SymbolScope2["member"] = 6] = "member";
        SymbolScope2[SymbolScope2["local"] = 7] = "local";
        SymbolScope2[SymbolScope2["counter"] = 8] = "counter";
        SymbolScope2[SymbolScope2["unknown"] = 9] = "unknown";
      })(SymbolScope || (exports.SymbolScope = SymbolScope = {}));
    }
  });

  // out/src/compiler/symbols/unknown-symbol.js
  var require_unknown_symbol = __commonJS({
    "out/src/compiler/symbols/unknown-symbol.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.UnknownSymbol = void 0;
      var symbol_scope_1 = require_symbol_scope();
      var unknown_type_1 = require_unknown_type();
      var UnknownSymbol = class {
        constructor(id) {
          this.symbolId = id ?? "";
        }
        symbolId = "";
        symbolType = () => unknown_type_1.UnknownType.Instance;
        symbolScope = symbol_scope_1.SymbolScope.unknown;
        name = "Unknown Symbol";
      };
      exports.UnknownSymbol = UnknownSymbol;
    }
  });

  // out/src/compiler/debugging/breakpoint-event.js
  var require_breakpoint_event = __commonJS({
    "out/src/compiler/debugging/breakpoint-event.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BreakpointEvent = void 0;
      var BreakpointEvent;
      (function(BreakpointEvent2) {
        BreakpointEvent2[BreakpointEvent2["clear"] = 0] = "clear";
        BreakpointEvent2[BreakpointEvent2["activate"] = 1] = "activate";
        BreakpointEvent2[BreakpointEvent2["disable"] = 2] = "disable";
      })(BreakpointEvent || (exports.BreakpointEvent = BreakpointEvent = {}));
    }
  });

  // out/src/compiler/debugging/breakpoint-status.js
  var require_breakpoint_status = __commonJS({
    "out/src/compiler/debugging/breakpoint-status.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BreakpointStatus = void 0;
      var BreakpointStatus;
      (function(BreakpointStatus2) {
        BreakpointStatus2[BreakpointStatus2["none"] = 0] = "none";
        BreakpointStatus2[BreakpointStatus2["disabled"] = 1] = "disabled";
        BreakpointStatus2[BreakpointStatus2["active"] = 2] = "active";
        BreakpointStatus2[BreakpointStatus2["singlestep"] = 3] = "singlestep";
      })(BreakpointStatus || (exports.BreakpointStatus = BreakpointStatus = {}));
    }
  });

  // out/src/compiler/symbols/deconstructed-record-type.js
  var require_deconstructed_record_type = __commonJS({
    "out/src/compiler/symbols/deconstructed-record-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedRecordType = void 0;
      var type_options_1 = require_type_options();
      var unknown_type_1 = require_unknown_type();
      var DeconstructedRecordType = class {
        ids;
        record;
        constructor(ids, record) {
          this.ids = ids;
          this.record = record;
          for (const id of ids) {
            this.typeMap[id] = record.resolveOwnSymbol(id).symbolType();
          }
        }
        initialValue = "";
        typeOptions = type_options_1.immutableTypeOptions;
        symbolTypeFor(id) {
          return this.typeMap[id] ?? unknown_type_1.UnknownType.Instance;
        }
        typeMap = {};
        get name() {
          return `DeconstructedRecord<of ${this.record}>`;
        }
        toString() {
          return `( ${this.record})`;
        }
        isAssignableFrom(_otherType) {
          return false;
        }
      };
      exports.DeconstructedRecordType = DeconstructedRecordType;
    }
  });

  // out/src/compiler/symbols/enum-type.js
  var require_enum_type = __commonJS({
    "out/src/compiler/symbols/enum-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumType = void 0;
      var type_options_1 = require_type_options();
      var EnumType = class _EnumType {
        name;
        constructor(name) {
          this.name = name;
        }
        typeOptions = type_options_1.immutableTypeOptions;
        get initialValue() {
          return `${this.name}._default`;
        }
        toString() {
          return `Enum ${this.name}`;
        }
        isAssignableFrom(otherType) {
          if (otherType instanceof _EnumType) {
            return this.name === otherType.name;
          }
          return false;
        }
      };
      exports.EnumType = EnumType;
    }
  });

  // out/src/compiler/syntax-nodes/abstract-ast-node.js
  var require_abstract_ast_node = __commonJS({
    "out/src/compiler/syntax-nodes/abstract-ast-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractAstNode = void 0;
      var symbol_scope_1 = require_symbol_scope();
      var AbstractAstNode = class {
        compileErrors = [];
        get symbolScope() {
          return symbol_scope_1.SymbolScope.unknown;
        }
        indent() {
          return "";
        }
        singleIndent() {
          return "  ";
        }
      };
      exports.AbstractAstNode = AbstractAstNode;
    }
  });

  // out/src/compiler/syntax-nodes/breakpoint-asn.js
  var require_breakpoint_asn = __commonJS({
    "out/src/compiler/syntax-nodes/breakpoint-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BreakpointAsn = void 0;
      var compile_rules_1 = require_compile_rules();
      var breakpoint_event_1 = require_breakpoint_event();
      var breakpoint_status_1 = require_breakpoint_status();
      var class_type_1 = require_class_type();
      var deconstructed_list_type_1 = require_deconstructed_list_type();
      var deconstructed_record_type_1 = require_deconstructed_record_type();
      var deconstructed_tuple_type_1 = require_deconstructed_tuple_type();
      var enum_type_1 = require_enum_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var tuple_type_1 = require_tuple_type();
      var unknown_type_1 = require_unknown_type();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ast_helpers_1 = require_ast_helpers();
      var property_asn_1 = require_property_asn();
      var BreakpointAsn = class extends abstract_ast_node_1.AbstractAstNode {
        fieldId;
        scope;
        constructor(fieldId, scope) {
          super();
          this.fieldId = fieldId;
          this.scope = scope;
          (0, symbol_helpers_1.getGlobalScope)(scope).setScopeById(fieldId, this);
        }
        compile() {
          throw new Error("Method not implemented.");
        }
        breakpointStatus = breakpoint_status_1.BreakpointStatus.none;
        setBreakPoint = () => {
          this.breakpointStatus = breakpoint_status_1.BreakpointStatus.active;
        };
        clearBreakPoint = () => {
          this.breakpointStatus = breakpoint_status_1.BreakpointStatus.none;
        };
        toggleBreakPoint = () => {
          if (this.hasBreakpoint()) {
            this.clearBreakPoint();
          } else {
            this.setBreakPoint();
          }
        };
        clearAllBreakPoints = () => {
          (0, symbol_helpers_1.getGlobalScope)(this.scope).updateBreakpoints(breakpoint_event_1.BreakpointEvent.clear);
        };
        hasBreakpoint() {
          return this.breakpointStatus === breakpoint_status_1.BreakpointStatus.active || this.breakpointStatus === breakpoint_status_1.BreakpointStatus.disabled;
        }
        paused = false;
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
        compileScope;
        setCompileScope(s) {
          this.compileScope = s;
        }
        getParentScope() {
          return this.compileScope ?? this.scope;
        }
        getCurrentScope() {
          return this;
        }
        parentIndent() {
          return (0, ast_helpers_1.isAstNode)(this.scope) ? this.scope.indent() : "";
        }
        indent() {
          return this.parentIndent() + this.singleIndent();
        }
        isNotGlobalOrLib(s) {
          const scope = s.symbolScope;
          return !(scope === symbol_scope_1.SymbolScope.program || scope === symbol_scope_1.SymbolScope.stdlib);
        }
        bpIndent() {
          return this.indent() === "" ? "  " : this.indent();
        }
        getClassTypeMap(type, seenClasses) {
          seenClasses = seenClasses ?? [];
          if (type instanceof class_type_1.ClassType && (type.typeOptions.isIndexable || type.typeOptions.isDoubleIndexable)) {
            const ofTypes = type.ofTypes;
            const typeDict = { Type: type.name };
            if (ofTypes.length === 1) {
              typeDict["OfTypes"] = this.getClassTypeMap(ofTypes[0], [...seenClasses]);
            }
            if (ofTypes.length === 2) {
              typeDict["KeyType"] = this.getClassTypeMap(ofTypes[0], [...seenClasses]);
              typeDict["ValueType"] = this.getClassTypeMap(ofTypes[1], [...seenClasses]);
            }
            return typeDict;
          } else if (type instanceof class_type_1.ClassType && !type.typeOptions.isIndexable) {
            const childSymbols = type.childSymbols().filter((s) => s instanceof property_asn_1.PropertyAsn);
            const className = type.name;
            const typeDict = { Type: className };
            if (seenClasses.includes(className)) {
              return typeDict;
            }
            typeDict["Properties"] = {};
            seenClasses.push(className);
            for (const s of childSymbols) {
              typeDict["Properties"][(0, compile_rules_1.getId)(s.name)] = this.getClassTypeMap(s.symbolType(), [
                ...seenClasses
              ]);
            }
            return typeDict;
          } else if (type instanceof tuple_type_1.TupleType) {
            const ofTypes = type.ofTypes;
            const typeDict = { Type: type.name };
            typeDict["OfTypes"] = [];
            for (const s of ofTypes) {
              typeDict["OfTypes"].push(this.getClassTypeMap(s, [...seenClasses]));
            }
            return typeDict;
          } else if (type instanceof deconstructed_tuple_type_1.DeconstructedTupleType || type instanceof deconstructed_record_type_1.DeconstructedRecordType || type instanceof deconstructed_list_type_1.DeconstructedListType) {
            const typeDict = { Type: "Deconstructed" };
            typeDict["Ids"] = {};
            for (const id of type.ids) {
              typeDict["Ids"][id] = this.getClassTypeMap(type.symbolTypeFor(id), [...seenClasses]);
            }
            return typeDict;
          } else if (type instanceof enum_type_1.EnumType) {
            const typeDict = { Type: "Enum" };
            typeDict["OfTypes"] = { Type: type.name };
            return typeDict;
          } else {
            return { Type: type.name };
          }
        }
        resolveVariables(scopedSymbols) {
          const resolveId = [];
          const symbols = scopedSymbols().filter(this.isNotGlobalOrLib).sort(symbol_helpers_1.orderSymbol);
          const indent = this.bpIndent();
          for (const symbol of symbols) {
            const idPrefix = symbol.symbolScope === symbol_scope_1.SymbolScope.program ? "global." : symbol.symbolScope === symbol_scope_1.SymbolScope.member ? "property." : "";
            const scopePrefix = symbol.symbolScope === symbol_scope_1.SymbolScope.stdlib ? "_stdlib." : symbol.symbolScope === symbol_scope_1.SymbolScope.program ? "global." : symbol.symbolScope === symbol_scope_1.SymbolScope.member ? "this." : "";
            const scopePostfix = symbol.symbolScope === symbol_scope_1.SymbolScope.outParameter ? "[0]" : "";
            const id = `${idPrefix}${symbol.symbolId}`;
            const value = `${scopePrefix}${symbol.symbolId}${scopePostfix}`;
            const type = symbol.symbolType();
            const typeMap = JSON.stringify(this.getClassTypeMap(type));
            resolveId.push(`${indent}_scopedIds${this.fieldId}.push(await system.debugSymbol("${id}", ${value}, '${typeMap}'));`);
          }
          return `${resolveId.join("\r\n")}`;
        }
        breakPoint(scopedSymbols) {
          if (this.breakpointStatus === breakpoint_status_1.BreakpointStatus.active || this.breakpointStatus === breakpoint_status_1.BreakpointStatus.singlestep) {
            let resolve = this.resolveVariables(scopedSymbols);
            const type = this.breakpointStatus === breakpoint_status_1.BreakpointStatus.singlestep ? "true" : "false";
            const indent = this.bpIndent();
            if (this.breakpointStatus === breakpoint_status_1.BreakpointStatus.singlestep) {
              resolve = `${indent}if (__pause) {
    ${resolve}
    ${indent}}`;
            }
            resolve = `${indent}const _scopedIds${this.fieldId} = [];
    ${resolve}`;
            return `${resolve}\r
${indent}__pause = await system.breakPoint(_scopedIds${this.fieldId}, "${this.fieldId}", ${type}, __pause);\r
`;
          }
          return "";
        }
        resolveSymbol(id, _initialScope) {
          return this.getParentScope().resolveSymbol(id, this);
        }
        symbolMatches(id, all, _initialScope) {
          return this.getParentScope().symbolMatches(id, all, this);
        }
        debugSymbols() {
          return () => (0, symbol_helpers_1.allScopedSymbols)(this.getParentScope(), this);
        }
        getNextState(currentState, event) {
          switch (currentState) {
            case breakpoint_status_1.BreakpointStatus.none:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.singlestep;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.none;
              }
            case breakpoint_status_1.BreakpointStatus.disabled:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.active;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.disabled;
              }
            case breakpoint_status_1.BreakpointStatus.active:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.active;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.disabled;
              }
            case breakpoint_status_1.BreakpointStatus.singlestep:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.singlestep;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.none;
              }
          }
        }
        updateBreakpoints(event) {
          this.breakpointStatus = this.getNextState(this.breakpointStatus, event);
        }
      };
      exports.BreakpointAsn = BreakpointAsn;
    }
  });

  // out/src/compiler/syntax-nodes/empty-asn.js
  var require_empty_asn = __commonJS({
    "out/src/compiler/syntax-nodes/empty-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EmptyAsn = void 0;
      var symbol_scope_1 = require_symbol_scope();
      var unknown_type_1 = require_unknown_type();
      var EmptyAsn = class _EmptyAsn {
        fieldId;
        constructor(fieldId) {
          this.fieldId = fieldId;
        }
        indent() {
          return "";
        }
        items = [];
        id = "";
        symbolScope = symbol_scope_1.SymbolScope.unknown;
        compileErrors = [];
        compile() {
          return ``;
        }
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
        get value() {
          return _EmptyAsn.Instance;
        }
        toString() {
          return "";
        }
        static Instance = new _EmptyAsn("");
      };
      exports.EmptyAsn = EmptyAsn;
    }
  });

  // out/src/compiler/syntax-nodes/class-members/property-asn.js
  var require_property_asn = __commonJS({
    "out/src/compiler/syntax-nodes/class-members/property-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.PropertyAsn = void 0;
      var class_type_1 = require_class_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var compile_rules_1 = require_compile_rules();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var PropertyAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        isProperty = true;
        isMember = true;
        isAbstract = false;
        private = false;
        name = empty_asn_1.EmptyAsn.Instance;
        type = empty_asn_1.EmptyAsn.Instance;
        getClass() {
          return this.getParentScope();
        }
        isGlobalClass(st) {
          return st instanceof class_type_1.ClassType && !st.typeOptions.isIndexable;
        }
        compile() {
          this.compileErrors = [];
          const pName = this.name.compile();
          const st = this.type.symbolType();
          (0, compile_rules_1.mustBeUniqueNameInScope)(pName, (0, symbol_helpers_1.getClassScope)(this), this.compileErrors, this.fieldId);
          (0, compile_rules_1.mustBeKnownSymbolType)(st, (0, compile_rules_1.getId)(this.type), this.compileErrors, this.fieldId);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          if (this.isGlobalClass(st)) {
            return `${this.indent()}_${pName};\r
${this.indent()}get ${pName}() {\r
${this.indent()}${this.indent()}return this._${pName} ??= ${this.type.compile()};\r
${this.indent()}}\r
${this.indent()}set ${pName}(${pName}) {\r
${this.indent()}${this.indent()}this._${pName} = ${pName};\r
${this.indent()}}\r
`;
          }
          return `${this.indent()}${pName} = ${this.type.compile()};\r
`;
        }
        get symbolId() {
          return (0, compile_rules_1.getId)(this.name);
        }
        symbolType() {
          return this.type.symbolType();
        }
        get symbolScope() {
          return symbol_scope_1.SymbolScope.member;
        }
        initCode() {
          const tst = this.symbolType();
          if (!this.isGlobalClass(tst)) {
            return `["${(0, compile_rules_1.getId)(this.name)}", ${tst.initialValue}]`;
          }
          return "";
        }
      };
      exports.PropertyAsn = PropertyAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/definition-adapter.js
  var require_definition_adapter = __commonJS({
    "out/src/compiler/syntax-nodes/statements/definition-adapter.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DefinitionAdapter = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var DefinitionAdapter = class {
        adapted;
        constructor(adapted, index) {
          this.adapted = adapted;
          const ids = (0, symbol_helpers_1.getDeconstructionIds)(adapted.symbolId);
          this.symbolId = ids[index];
          this.symbolScope = adapted.symbolScope;
        }
        isLet() {
          return (0, symbol_helpers_1.isLet)(this.adapted);
        }
        isVariable() {
          return (0, symbol_helpers_1.isVariable)(this.adapted);
        }
        symbolId;
        symbolType() {
          return this.adapted.symbolType();
        }
        symbolScope;
      };
      exports.DefinitionAdapter = DefinitionAdapter;
    }
  });

  // out/src/compiler/syntax-nodes/statements/abstract-definition-asn.js
  var require_abstract_definition_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/abstract-definition-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractDefinitionAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var compile_rules_1 = require_compile_rules();
      var ast_helpers_1 = require_ast_helpers();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var definition_adapter_1 = require_definition_adapter();
      var AbstractDefinitionAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        name = empty_asn_1.EmptyAsn.Instance;
        expr = empty_asn_1.EmptyAsn.Instance;
        getScope() {
          return this.compileScope ?? this.scope;
        }
        ids() {
          return (0, ast_helpers_1.getIds)(this.name);
        }
        compile() {
          this.compileErrors = [];
          const ids = this.ids();
          if (ids.length > 1) {
            (0, compile_rules_1.mustBeDeconstructableType)(this.symbolType(), this.compileErrors, this.fieldId);
          }
          for (const i of ids) {
            (0, compile_rules_1.mustNotBeKeyword)(i, this.compileErrors, this.fieldId);
            const symbol = this.getScope().resolveSymbol(i, this);
            (0, compile_rules_1.mustNotBeRedefined)(symbol, i, this.compileErrors, this.fieldId);
          }
          const lhs = this.name;
          const rhs = this.expr;
          (0, compile_rules_1.mustBeCompatibleDefinitionNode)(lhs, rhs, this.getScope(), this.compileErrors, this.fieldId);
          const lhsCode = (0, ast_helpers_1.wrapDeconstructionLhs)(lhs, rhs, false);
          const rhsCode = (0, ast_helpers_1.wrapDeconstructionRhs)(lhs, rhs, false);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${this.breakPoint(this.debugSymbols())}${this.indent()}${this.getJsKeyword()} ${lhsCode} = ${rhsCode};`;
        }
        get symbolId() {
          return (0, compile_rules_1.getId)(this.name);
        }
        symbolType() {
          const ids = this.ids();
          const st = this.expr.symbolType();
          return (0, symbol_helpers_1.mapSymbolType)(ids, st);
        }
        get symbolScope() {
          return symbol_scope_1.SymbolScope.local;
        }
        resolveSymbol(id, initialScope) {
          if (id === this.symbolId) {
            return this;
          }
          return super.resolveSymbol(id, initialScope);
        }
        symbolMatches(id, all, initialScope) {
          const matches = super.symbolMatches(id, all, initialScope);
          const ids = (0, symbol_helpers_1.getDeconstructionIds)(this.symbolId);
          const definitions = ids.length > 1 ? ids.map((_, i) => new definition_adapter_1.DefinitionAdapter(this, i)) : [this];
          const localMatches = (0, symbol_helpers_1.symbolMatches)(id, all, definitions);
          return localMatches.concat(matches);
        }
      };
      exports.AbstractDefinitionAsn = AbstractDefinitionAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/let-asn.js
  var require_let_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/let-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LetAsn = void 0;
      var abstract_definition_asn_1 = require_abstract_definition_asn();
      var LetAsn = class extends abstract_definition_asn_1.AbstractDefinitionAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        getJsKeyword() {
          return "const";
        }
        isLet() {
          return true;
        }
        isVariable() {
          return false;
        }
      };
      exports.LetAsn = LetAsn;
    }
  });

  // out/src/compiler/syntax-nodes/this-asn.js
  var require_this_asn = __commonJS({
    "out/src/compiler/syntax-nodes/this-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ThisAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var compile_rules_1 = require_compile_rules();
      var keywords_1 = require_keywords();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ThisAsn = class extends abstract_ast_node_1.AbstractAstNode {
        originalKeyword;
        fieldId;
        scope;
        constructor(originalKeyword, fieldId, scope) {
          super();
          this.originalKeyword = originalKeyword;
          this.fieldId = fieldId;
          this.scope = scope;
        }
        compile() {
          this.compileErrors = [];
          if (!(0, symbol_helpers_1.isInsideClass)(this.scope)) {
            (0, compile_rules_1.mustBeInsideClass)(this.compileErrors, this.fieldId);
          }
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return keywords_1.thisKeyword;
        }
        symbolType() {
          return this.scope.resolveSymbol(keywords_1.thisKeyword, this.scope)?.symbolType();
        }
        toString() {
          return this.originalKeyword;
        }
      };
      exports.ThisAsn = ThisAsn;
    }
  });

  // out/src/compiler/syntax-nodes/fixed-id-asn.js
  var require_fixed_id_asn = __commonJS({
    "out/src/compiler/syntax-nodes/fixed-id-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FixedIdAsn = void 0;
      var unknown_type_1 = require_unknown_type();
      var keywords_1 = require_keywords();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var FixedIdAsn = class extends abstract_ast_node_1.AbstractAstNode {
        id;
        fieldId;
        constructor(id, fieldId) {
          super();
          this.id = id;
          this.fieldId = fieldId;
        }
        compile() {
          this.compileErrors = [];
          return this.id === keywords_1.libraryKeyword ? "_stdlib" : this.id === keywords_1.globalKeyword ? "global" : this.id;
        }
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
        toString() {
          return this.id;
        }
      };
      exports.FixedIdAsn = FixedIdAsn;
    }
  });

  // out/src/compiler/compile-rules.js
  var require_compile_rules = __commonJS({
    "out/src/compiler/compile-rules.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.mustBeOfSymbolType = mustBeOfSymbolType;
      exports.mustBeMemberOfSymbolType = mustBeMemberOfSymbolType;
      exports.mustBeOfType = mustBeOfType;
      exports.mustBeBooleanCondition = mustBeBooleanCondition;
      exports.mustNotHaveConditionalAfterUnconditionalElse = mustNotHaveConditionalAfterUnconditionalElse;
      exports.mustBeKnownSymbol = mustBeKnownSymbol;
      exports.mustBeKnownExtension = mustBeKnownExtension;
      exports.mustBeKnownSymbolType = mustBeKnownSymbolType;
      exports.mustNotBeKeyword = mustNotBeKeyword;
      exports.mustBeProcedure = mustBeProcedure;
      exports.mustBeCallable = mustBeCallable;
      exports.mustBeDeconstructableType = mustBeDeconstructableType;
      exports.mustBePureFunctionSymbol = mustBePureFunctionSymbol;
      exports.checkForDeprecation = checkForDeprecation;
      exports.mustNotBeNegativeIndex = mustNotBeNegativeIndex;
      exports.mustBeIndexableType = mustBeIndexableType;
      exports.mustBeDoubleIndexableType = mustBeDoubleIndexableType;
      exports.mustBeRangeableType = mustBeRangeableType;
      exports.mustBeInheritableClassOrInterface = mustBeInheritableClassOrInterface;
      exports.mustBeInterfaceClass = mustBeInterfaceClass;
      exports.mustNotBeCircularDependency = mustNotBeCircularDependency;
      exports.mustBeSingleAbstractSuperClass = mustBeSingleAbstractSuperClass;
      exports.mustBePublicMember = mustBePublicMember;
      exports.mustBePropertyAndPublic = mustBePropertyAndPublic;
      exports.mustImplementSuperClasses = mustImplementSuperClasses;
      exports.mustBeConcreteClass = mustBeConcreteClass;
      exports.mustBeClass = mustBeClass;
      exports.mustBeInsideClass = mustBeInsideClass;
      exports.mustBeDeclaredAbove = mustBeDeclaredAbove;
      exports.mustCallExtensionViaQualifier = mustCallExtensionViaQualifier;
      exports.mustNotCallNonExtensionViaQualifier = mustNotCallNonExtensionViaQualifier;
      exports.mustbeValidQualifier = mustbeValidQualifier;
      exports.mustCallMemberViaQualifier = mustCallMemberViaQualifier;
      exports.mustMatchParameters = mustMatchParameters;
      exports.mustMatchGenericParameters = mustMatchGenericParameters;
      exports.mustBeCoercibleType = mustBeCoercibleType;
      exports.mustBeKnownOperation = mustBeKnownOperation;
      exports.mustBeNumberType = mustBeNumberType;
      exports.mustBeNumberTypes = mustBeNumberTypes;
      exports.mustBeBooleanType = mustBeBooleanType;
      exports.mustBeBooleanTypes = mustBeBooleanTypes;
      exports.mustBeIntegerType = mustBeIntegerType;
      exports.mustBeImmutableType = mustBeImmutableType;
      exports.mustBeImmutableGenericType = mustBeImmutableGenericType;
      exports.mustBeValidKeyType = mustBeValidKeyType;
      exports.mustBeCompatibleType = mustBeCompatibleType;
      exports.mustBeAssignableType = mustBeAssignableType;
      exports.mustBeImmutableCollection = mustBeImmutableCollection;
      exports.mustBeCompatibleDefinitionNode = mustBeCompatibleDefinitionNode;
      exports.mustBeCompatibleNode = mustBeCompatibleNode;
      exports.getId = getId;
      exports.getQualifierId = getQualifierId;
      exports.mustNotBePropertyOnFunctionMethod = mustNotBePropertyOnFunctionMethod;
      exports.mustBePropertyPrefixedOnMember = mustBePropertyPrefixedOnMember;
      exports.mustNotBeParameter = mustNotBeParameter;
      exports.mustNotBeCounter = mustNotBeCounter;
      exports.mustNotBeConstant = mustNotBeConstant;
      exports.cannotPassAsOutParameter = cannotPassAsOutParameter;
      exports.mustNotBeSameAsMethodName = mustNotBeSameAsMethodName;
      exports.mustBeUniqueNameInScope = mustBeUniqueNameInScope;
      exports.mustBeUniqueValueInScope = mustBeUniqueValueInScope;
      exports.mustNotBeLet = mustNotBeLet;
      exports.mustNotBeRedefined = mustNotBeRedefined;
      exports.mustNotBeOutParameter = mustNotBeOutParameter;
      exports.mustNotHaveDuplicateMain = mustNotHaveDuplicateMain;
      exports.mustBeIterable = mustBeIterable;
      exports.mustHaveUniqueKeys = mustHaveUniqueKeys;
      exports.mustBeNewable = mustBeNewable;
      exports.mustBeFunctionRefIfFunction = mustBeFunctionRefIfFunction;
      exports.mustBeGlobalFunctionIfRef = mustBeGlobalFunctionIfRef;
      exports.mustNotBeTwoUnaryExpressions = mustNotBeTwoUnaryExpressions;
      exports.compilerAssert = compilerAssert;
      var type_options_1 = require_type_options();
      var elan_compiler_error_1 = require_elan_compiler_error();
      var keywords_1 = require_keywords();
      var compile_error_1 = require_compile_error();
      var elan_type_interfaces_1 = require_elan_type_interfaces();
      var boolean_type_1 = require_boolean_type();
      var class_type_1 = require_class_type();
      var deconstructed_list_type_1 = require_deconstructed_list_type();
      var deconstructed_tuple_type_1 = require_deconstructed_tuple_type();
      var duplicate_symbol_1 = require_duplicate_symbol();
      var float_type_1 = require_float_type();
      var function_type_1 = require_function_type();
      var int_type_1 = require_int_type();
      var procedure_type_1 = require_procedure_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var tuple_type_1 = require_tuple_type();
      var unknown_symbol_1 = require_unknown_symbol();
      var unknown_type_1 = require_unknown_type();
      var ast_helpers_1 = require_ast_helpers();
      var property_asn_1 = require_property_asn();
      var let_asn_1 = require_let_asn();
      var this_asn_1 = require_this_asn();
      var fixed_id_asn_1 = require_fixed_id_asn();
      function mustBeOfSymbolType(exprType, ofType, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(exprType) && exprType.name !== ofType.name) {
          compileErrors.push(new compile_error_1.TypeCompileError(ofType.name, location));
        }
      }
      function mustBeMemberOfSymbolType(name, exprType, ofType, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(exprType) && exprType.name !== ofType.name) {
          compileErrors.push(new compile_error_1.MemberTypeCompileError(name, ofType.name, location));
        }
      }
      function mustBeOfType(expr, ofType, compileErrors, location) {
        mustBeOfSymbolType(expr.symbolType(), ofType, compileErrors, location);
      }
      function mustBeBooleanCondition(expr, compileErrors, location) {
        const st = expr.symbolType();
        if ((0, symbol_helpers_1.isKnownType)(st) && st !== boolean_type_1.BooleanType.Instance) {
          compileErrors.push(new compile_error_1.SyntaxCompileError("Condition of 'if' expression does not evaluate to a Boolean.", location));
        }
      }
      function mustNotHaveConditionalAfterUnconditionalElse(elses, compileErrors, location) {
        const unconditionals = elses.filter((s) => !s.hasIf).length;
        if (unconditionals > 1 || unconditionals === 1 && elses[elses.length - 1].hasIf) {
          compileErrors.push(new compile_error_1.SyntaxCompileError(`Cannot have any clause after unconditional 'else'.`, location));
        }
      }
      function mustBeKnownSymbol(symbol, scope, onSymbol, onType, compileErrors, location) {
        if (symbol instanceof unknown_symbol_1.UnknownSymbol && onType instanceof unknown_type_1.UnknownType) {
          const type = (0, symbol_helpers_1.isClass)(scope) ? scope.symbolId : "";
          const id = onSymbol || symbol.symbolId;
          compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(id, type, location));
        } else if (symbol instanceof unknown_symbol_1.UnknownSymbol) {
          const type = (0, symbol_helpers_1.isClass)(scope) ? scope.symbolId : onType.name;
          compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(symbol.symbolId, type, location));
        }
      }
      function mustBeKnownExtension(id, type, compileErrors, location) {
        compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(id, type, location));
      }
      function mustBeKnownSymbolType(symbolType, originalName, compileErrors, location) {
        if (symbolType instanceof unknown_type_1.UnknownType) {
          compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(originalName, "", location));
        }
      }
      function mustNotBeKeyword(id, compileErrors, location) {
        if (keywords_1.allKeywords.includes(id)) {
          compileErrors.push(new compile_error_1.SyntaxCompileError(`'${id}' is a keyword, and may not be used as an identifier.`, location));
        }
        if (keywords_1.reservedWords.includes(id)) {
          compileErrors.push(new compile_error_1.SyntaxCompileError(`'${id}' is a reserved word, and may not be used as an identifier.`, location));
        }
      }
      function mustBeProcedure(symbolId, symbolType, symbolScope, compileErrors, location) {
        if (symbolType instanceof function_type_1.FunctionType) {
          compileErrors.push(new compile_error_1.CannotCallAFunction(location));
        } else if ((0, symbol_helpers_1.isKnownType)(symbolType) && !(symbolType instanceof procedure_type_1.ProcedureType)) {
          compileErrors.push(new compile_error_1.CannotCallAsAMethod(symbolId, (0, symbol_helpers_1.symbolScopeToFriendlyName)(symbolScope), location));
        }
      }
      function mustBeCallable(symbolId, symbolType, symbolScope, compileErrors, location) {
        if (symbolType instanceof procedure_type_1.ProcedureType) {
          compileErrors.push(new compile_error_1.CannotUseLikeAFunction(symbolId, location));
        } else if ((0, symbol_helpers_1.isKnownType)(symbolType)) {
          compileErrors.push(new compile_error_1.CannotCallAsAMethod(symbolId, (0, symbol_helpers_1.symbolScopeToFriendlyName)(symbolScope), location));
        }
      }
      function mustBeDeconstructableType(symbolType, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(symbolType) && !(0, symbol_helpers_1.isDeconstructedType)(symbolType)) {
          compileErrors.push(new compile_error_1.TypeCompileError("able to be deconstructed", location));
        }
      }
      function mustBePureFunctionSymbol(symbolType, scope, compileErrors, location) {
        if ((0, ast_helpers_1.inFunctionScope)(scope)) {
          if ((0, symbol_helpers_1.isKnownType)(symbolType) && !symbolType.isPure) {
            compileErrors.push(new compile_error_1.CannotUseSystemMethodInAFunction(location));
          }
        }
      }
      function checkForDeprecation(symbolType, scope, compileErrors, location) {
        if (symbolType.deprecated) {
          const reason = symbolType.deprecated.reason;
          if (reason === elan_type_interfaces_1.Deprecation.methodHidden) {
            return;
          }
          if ((reason === elan_type_interfaces_1.Deprecation.classParametersChanged || reason === elan_type_interfaces_1.Deprecation.methodParametersChanged) && compileErrors.length === 0) {
            return;
          }
          const file = (0, symbol_helpers_1.getGlobalScope)(scope);
          const version = file.getVersion();
          const fromMajor = symbolType.deprecated.fromMajor;
          const fromMinor = symbolType.deprecated.fromMinor;
          if (fromMajor < version.major || fromMajor === version.major && fromMinor <= version.minor) {
            compileErrors.push(new compile_error_1.IsDeprecated(reason, fromMajor, fromMinor, symbolType.deprecated.message, location));
          }
        }
      }
      function mustNotBeNegativeIndex(compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError("Index cannot be negative.", location));
      }
      function mustBeIndexableType(symbolId, symbolType, read, compileErrors, location) {
        if (symbolType instanceof unknown_type_1.UnknownType) {
          compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(symbolId, "", location));
        } else if (!(read && (0, symbol_helpers_1.isIndexableType)(symbolType))) {
          compileErrors.push(new compile_error_1.NotIndexableCompileError(symbolType.name, location, false));
        }
      }
      function mustBeDoubleIndexableType(symbolId, symbolType, read, compileErrors, location) {
        if (symbolType instanceof unknown_type_1.UnknownType) {
          compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(symbolId, "", location));
        } else if (!(read && (0, symbol_helpers_1.isDoubleIndexableType)(symbolType))) {
          compileErrors.push(new compile_error_1.NotIndexableCompileError(symbolType.name, location, true));
        }
      }
      function mustBeRangeableType(symbolType, read, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(symbolType) && !(read && (0, symbol_helpers_1.isIterableType)(symbolType))) {
          compileErrors.push(new compile_error_1.NotRangeableCompileError(symbolType.name, location));
        }
      }
      function mustBeInheritableClassOrInterface(symbolType, name, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(symbolType) && (!(symbolType instanceof class_type_1.ClassType) || symbolType.subType === class_type_1.ClassSubType.concrete || symbolType.isNotInheritable)) {
          compileErrors.push(new compile_error_1.MustBeAbstractCompileError(name, location));
        }
      }
      function mustBeInterfaceClass(symbolType, name, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(symbolType) && (!(symbolType instanceof class_type_1.ClassType) || symbolType.subType !== class_type_1.ClassSubType.interface || symbolType.isNotInheritable)) {
          compileErrors.push(new compile_error_1.MustBeInterfaceCompileError(name, location));
        }
      }
      function mustNotBeCircularDependency(name, compileErrors, location) {
        compileErrors.push(new compile_error_1.MustNotBeCircularDependencyCompileError(name, location));
      }
      function mustBeSingleAbstractSuperClass(typeAndName, compileErrors, location) {
        const names = [];
        for (const [st, name] of typeAndName) {
          if (st instanceof class_type_1.ClassType) {
            if (st.subType === class_type_1.ClassSubType.abstract) {
              names.push(name);
            }
          }
        }
        if (names.length > 1) {
          compileErrors.push(new compile_error_1.MustBeSingleAbstractCompileError(names, location));
        }
      }
      function mustBePublicMember(member, compileErrors, location) {
        if ((0, symbol_helpers_1.isMember)(member) && member.private) {
          compileErrors.push(new compile_error_1.PrivateMemberCompileError(member.symbolId, location));
        }
      }
      function mustBePropertyAndPublic(symbol, compileErrors, location) {
        if (symbol instanceof property_asn_1.PropertyAsn && symbol.private === true) {
          compileErrors.push(new compile_error_1.PrivateMemberCompileError(getId(symbol.name), location));
        }
        if (symbol.symbolScope !== symbol_scope_1.SymbolScope.member) {
          compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(symbol.symbolId, "", location));
        }
      }
      function mustImplementSuperClasses(classType, superClassTypes, compileErrors, location) {
        for (const superClassType of superClassTypes) {
          const superSymbols = superClassType.childSymbols();
          for (const superSymbol of superSymbols.filter((ss) => (0, symbol_helpers_1.isMember)(ss) && ss.isAbstract)) {
            const subSymbol = classType.resolveSymbol(superSymbol.symbolId, classType);
            if (subSymbol instanceof unknown_symbol_1.UnknownSymbol || (0, symbol_helpers_1.isMember)(subSymbol) && subSymbol.isAbstract || (0, symbol_helpers_1.isMember)(subSymbol) && subSymbol.private) {
              compileErrors.push(new compile_error_1.MustImplementCompileError(classType.name, superClassType.name, superSymbol.symbolId, location));
            } else {
              mustBeMemberOfSymbolType(superSymbol.symbolId, subSymbol.symbolType(), superSymbol.symbolType(), compileErrors, location);
            }
          }
        }
      }
      function mustBeConcreteClass(classType, compileErrors, location) {
        if (classType.subType !== class_type_1.ClassSubType.concrete) {
          compileErrors.push(new compile_error_1.MustBeConcreteCompileError(classType.name, location));
        }
      }
      function mustBeClass(symbol, compileErrors, location) {
        if (!(0, symbol_helpers_1.isClass)(symbol)) {
          const st = symbol.symbolType();
          if ((0, symbol_helpers_1.isKnownType)(st)) {
            compileErrors.push(new compile_error_1.TypeCompileError("Class", location));
          }
        }
      }
      function mustBeInsideClass(compileErrors, location) {
        compileErrors.push(new compile_error_1.ThisCompileError(location));
      }
      function mustBeDeclaredAbove(name, compileErrors, location) {
        compileErrors.push(new compile_error_1.DeclaredAboveCompileError(name, location));
      }
      function mustCallExtensionViaQualifier(ft, qualifier, compileErrors, location) {
        if (ft.isExtension && (0, ast_helpers_1.isEmptyNode)(qualifier)) {
          compileErrors.push(new compile_error_1.ExtensionCompileError(location));
        }
      }
      function qualifierIsFixedIdOrEmpty(qualifier) {
        if ((0, ast_helpers_1.isEmptyNode)(qualifier)) {
          return true;
        }
        return (0, ast_helpers_1.isAstQualifierNode)(qualifier) ? qualifier.value instanceof fixed_id_asn_1.FixedIdAsn : qualifier instanceof fixed_id_asn_1.FixedIdAsn;
      }
      function mustNotCallNonExtensionViaQualifier(ft, name, qualifier, scope, compileErrors, location) {
        if (ft.isExtension || (0, symbol_helpers_1.isClass)(scope) || qualifierIsFixedIdOrEmpty(qualifier)) {
          return;
        }
        compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(name, qualifier.symbolType().name, location));
      }
      function mustbeValidQualifier(qualifier, compileErrors, location) {
        if (qualifier instanceof this_asn_1.ThisAsn) {
          compileErrors.push(new compile_error_1.PropertyCompileError(location));
        }
      }
      function mustCallMemberViaQualifier(id, ft, scope, compileErrors, location) {
        if (!ft.isExtension && (0, symbol_helpers_1.isClass)(scope)) {
          const t = scope.resolveOwnSymbol(id);
          if (t instanceof unknown_symbol_1.UnknownSymbol) {
            compileErrors.push(new compile_error_1.UndefinedSymbolCompileError(id, scope.symbolId, location));
          }
        }
      }
      function mustMatchParameters(id, parms, ofType, description, isExtension, compileErrors, location) {
        const extensionOfType = isExtension ? ofType[0] : void 0;
        const extensionParm = isExtension ? parms[0] : void 0;
        ofType = isExtension ? ofType.slice(1) : ofType;
        parms = isExtension ? parms.slice(1) : parms;
        const expected = ofType.length;
        const actual = parms.length;
        if (expected > actual) {
          compileErrors.push(new compile_error_1.MissingParameterCompileError(description, location));
        }
        if (actual > expected) {
          compileErrors.push(new compile_error_1.ExtraParameterCompileError(description, location));
        }
        if (extensionParm && extensionOfType) {
          const parmType = extensionParm.symbolType();
          if (!extensionOfType.isAssignableFrom(parmType)) {
            mustBeKnownExtension(id, parmType.name, compileErrors, location);
            return;
          }
        }
        const maxLen = parms.length > ofType.length ? parms.length : ofType.length;
        const tempErrors = [];
        const parmTypes = parms.map((p) => p.symbolType());
        for (let i = 0; i < maxLen; i++) {
          const p = parmTypes[i];
          const t = ofType[i];
          if (p && t) {
            mustBeAssignableType(t, p, tempErrors, location);
          }
        }
        if (tempErrors.length > 0) {
          const provided = parmTypes.map((pt) => pt.name).join(", ");
          compileErrors.push(new compile_error_1.ParameterTypesCompileError(description, provided, location));
        }
      }
      function mustMatchGenericParameters(parms, expected, compileErrors, location) {
        if (parms.length !== expected) {
          compileErrors.push(new compile_error_1.GenericParametersCompileError(expected, parms.length, location));
        }
      }
      function FailNotAssignable(lhs, rhs, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(lhs) && (0, symbol_helpers_1.isKnownType)(rhs)) {
          const addInfo = (0, symbol_helpers_1.isListImmutableType)(lhs) && (0, symbol_helpers_1.isListType)(rhs) ? " try converting with '.asListImmutable()'" : "";
          compileErrors.push(new compile_error_1.TypesCompileError(rhs.name, lhs.name, addInfo, location));
        }
      }
      function FailNoCommonType(lhs, rhs, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(lhs) && (0, symbol_helpers_1.isKnownType)(rhs)) {
          compileErrors.push(new compile_error_1.TernaryCompileError(rhs.name, lhs.name, location));
        }
      }
      function FailNotNumber(lhs, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(lhs)) {
          compileErrors.push(new compile_error_1.TypesCompileError(lhs.name, "Float or Int", "", location));
        }
      }
      function FailCannotCompareProcFunc(compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError("Cannot do equality operations on Procedures or Functions.", location, "LangRef.html#CannotCompareProcFunc"));
      }
      function mustBeCoercibleType(lhs, rhs, compileErrors, location) {
        if ((0, symbol_helpers_1.isNumber)(lhs) && (0, symbol_helpers_1.isNumber)(rhs)) {
          return;
        }
        if (lhs instanceof procedure_type_1.ProcedureType || lhs instanceof function_type_1.FunctionType || rhs instanceof procedure_type_1.ProcedureType || rhs instanceof function_type_1.FunctionType) {
          FailCannotCompareProcFunc(compileErrors, location);
        }
        mustBeAssignableType(lhs, rhs, compileErrors, location);
      }
      function mustBeKnownOperation(op, compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError(`UNEXPECTED COMPILE ERROR:  '${op}'  Please email a screenshot to rpawson@nakedobjects.org - then edit your code until this error disappears.`, location));
      }
      function mustBeNumberType(st, compileErrors, location) {
        if (!(0, symbol_helpers_1.isNumber)(st)) {
          FailNotNumber(st, compileErrors, location);
        }
      }
      function mustBeNumberTypes(lhs, rhs, compileErrors, location) {
        mustBeNumberType(lhs, compileErrors, location);
        mustBeNumberType(rhs, compileErrors, location);
      }
      function mustBeBooleanType(st, compileErrors, location) {
        mustBeAssignableType(boolean_type_1.BooleanType.Instance, st, compileErrors, location);
      }
      function mustBeBooleanTypes(lhs, rhs, compileErrors, location) {
        mustBeBooleanType(lhs, compileErrors, location);
        mustBeBooleanType(rhs, compileErrors, location);
      }
      function mustBeIntegerType(lhs, rhs, compileErrors, location) {
        mustBeAssignableType(int_type_1.IntType.Instance, lhs, compileErrors, location);
        mustBeAssignableType(int_type_1.IntType.Instance, rhs, compileErrors, location);
      }
      function mustBeImmutableType(name, type, compileErrors, location) {
        if (!type.typeOptions.isImmutable) {
          compileErrors.push(new compile_error_1.SyntaxCompileError(`Property ${name} is not of an immutable type.`, location));
        }
      }
      function mustBeImmutableGenericType(type, ofType, compileErrors, location) {
        if (!ofType.typeOptions.isImmutable) {
          compileErrors.push(new compile_error_1.SyntaxCompileError(`${type} cannot be of mutable type '${ofType.name}'.`, location));
        }
      }
      function mustBeValidKeyType(type, ofType, compileErrors, location) {
        if (!ofType.typeOptions.isImmutable || ofType instanceof class_type_1.ClassType && (ofType.typeOptions.isIndexable || ofType.typeOptions.isIterable)) {
          compileErrors.push(new compile_error_1.SyntaxCompileError(`${type} cannot have key of type '${ofType.name}'.`, location));
        }
      }
      function mustBeCompatibleType(lhs, rhs, compileErrors, location) {
        if (lhs.name === rhs.name || (lhs instanceof int_type_1.IntType || lhs instanceof float_type_1.FloatType) && (rhs instanceof float_type_1.FloatType || rhs instanceof int_type_1.IntType)) {
          return;
        }
        if (lhs instanceof class_type_1.ClassType && rhs instanceof class_type_1.ClassType && (lhs.isAssignableFrom(rhs) || rhs.isAssignableFrom(lhs))) {
          return;
        }
        FailNoCommonType(lhs, rhs, compileErrors, location);
      }
      function mustBeAssignableType(lhs, rhs, compileErrors, location) {
        if (!lhs.isAssignableFrom(rhs)) {
          FailNotAssignable(lhs, rhs, compileErrors, location);
        }
      }
      function mustBeImmutableCollection(list, compileErrors, location) {
        compileErrors.push(new compile_error_1.ImmutableCollectionCompileError(list, location));
      }
      function mustBeCompatibleRecordDeconstruction(ids, lst, rst, scope, compileErrors, location) {
        const classDef = scope.resolveSymbol(rst.name, scope);
        if ((0, symbol_helpers_1.isClass)(classDef)) {
          const childSymbols = classDef.getChildren().filter((s) => (0, symbol_helpers_1.isProperty)(s));
          for (let i = 0; i < ids.length; i++) {
            const id = ids[i];
            const childSymbol = childSymbols.find((s) => s.symbolId === id);
            if (childSymbol) {
              const llst = lst.ofTypes[i];
              const rrst = childSymbol.symbolType();
              mustBeAssignableType(llst, rrst, compileErrors, location);
            } else {
              const msg = id ? `No such property '${id}' on record '${rst.name}.` : "Cannot discard in record deconstruction.";
              compileErrors.push(new compile_error_1.SyntaxCompileError(msg, location));
            }
          }
        }
      }
      function mustBeCompatibleDeconstruction(ids, lst, rst, scope, compileErrors, location) {
        if (lst instanceof deconstructed_tuple_type_1.DeconstructedTupleType) {
          if (rst instanceof class_type_1.ClassType) {
            if ((0, type_options_1.isRecord)(rst.typeOptions)) {
              mustBeCompatibleRecordDeconstruction(ids, lst, rst, scope, compileErrors, location);
            } else {
              compileErrors.push(new compile_error_1.SyntaxCompileError(`Cannot deconstruct ${rst.name} as tuple.`, location));
            }
            return true;
          }
          if (rst instanceof tuple_type_1.TupleType && lst.ofTypes.length !== rst.ofTypes.length) {
            compileErrors.push(new compile_error_1.SyntaxCompileError(`Wrong number of deconstructed variables.`, location));
            return true;
          }
        }
        if (lst instanceof deconstructed_list_type_1.DeconstructedListType) {
          if (rst instanceof tuple_type_1.TupleType) {
            compileErrors.push(new compile_error_1.SyntaxCompileError(`Cannot deconstruct ${rst.name} as list.`, location));
            return true;
          }
        }
        return false;
      }
      function mustBeCompatibleDefinitionNode(lhs, rhs, scope, compileErrors, location) {
        const ids = (0, ast_helpers_1.getIds)(lhs);
        const lst = lhs.symbolType();
        const rst = rhs.symbolType();
        mustBeCompatibleDeconstruction(ids, lst, rst, scope, compileErrors, location);
      }
      function mustBeCompatibleNode(lhs, rhs, scope, compileErrors, location) {
        const ids = (0, ast_helpers_1.getIds)(lhs);
        const lst = lhs.symbolType();
        const rst = rhs.symbolType();
        if (!mustBeCompatibleDeconstruction(ids, lst, rst, scope, compileErrors, location)) {
          mustBeAssignableType(lst, rst, compileErrors, location);
        }
      }
      function getId(astNode) {
        if ((0, ast_helpers_1.isAstIdNode)(astNode)) {
          return astNode.id;
        }
        return "unknown";
      }
      function getQualifierId(astNode) {
        if ((0, ast_helpers_1.isAstQualifierNode)(astNode)) {
          return getId(astNode.value);
        }
        return getId(astNode);
      }
      function mustNotBePropertyOnFunctionMethod(assignable, scope, compileErrors, location) {
        if ((0, ast_helpers_1.isInsideFunction)(scope)) {
          const s = assignable.symbolScope;
          if (s === symbol_scope_1.SymbolScope.member) {
            compileErrors.push(new compile_error_1.ReassignInFunctionCompileError(`property: ${getId(assignable)}`, location));
          }
        }
      }
      function mustBePropertyPrefixedOnMember(compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError(`referencing a property requires a prefix.`, location));
      }
      function isIndexed(assignable) {
        if ((0, ast_helpers_1.isAstIndexableNode)(assignable)) {
          const rst = assignable.rootSymbolType();
          const st = assignable.symbolType();
          return rst.name !== st.name;
        }
        return false;
      }
      function mustNotBeParameter(assignable, parent, compileErrors, location) {
        const s = assignable.symbolScope;
        if (s === symbol_scope_1.SymbolScope.parameter) {
          if ((0, ast_helpers_1.isInsideFunctionOrConstructor)(parent)) {
            compileErrors.push(new compile_error_1.MutateCompileError(getId(assignable), "parameter", location));
          } else {
            if (!isIndexed(assignable)) {
              compileErrors.push(new compile_error_1.MutateCompileError(getId(assignable), "parameter", location));
            }
          }
        }
      }
      function mustNotBeCounter(assignable, compileErrors, location) {
        const s = assignable.symbolScope;
        if (s === symbol_scope_1.SymbolScope.counter) {
          compileErrors.push(new compile_error_1.MutateCompileError(getId(assignable), "loop counter", location));
        }
      }
      function mustNotBeConstant(assignable, compileErrors, location) {
        const s = assignable.symbolScope;
        if (s === symbol_scope_1.SymbolScope.program || s === symbol_scope_1.SymbolScope.stdlib) {
          compileErrors.push(new compile_error_1.MutateCompileError(getId(assignable), "constant", location));
        }
      }
      function cannotPassAsOutParameter(parameter, compileErrors, location) {
        if (typeof parameter === "string") {
          compileErrors.push(new compile_error_1.OutParameterCompileError(parameter, location));
        } else {
          if ((0, symbol_helpers_1.isKnownType)(parameter.symbolType())) {
            compileErrors.push(new compile_error_1.OutParameterCompileError(parameter.toString(), location));
          }
        }
      }
      function mustNotBeSameAsMethodName(name, scope, compileErrors, location) {
        if ((0, symbol_helpers_1.isSymbol)(scope)) {
          const methodName = scope.symbolId;
          if (name === methodName) {
            compileErrors.push(new compile_error_1.ParameterNameCompileError(name, location));
          }
        }
      }
      function mustBeUniqueNameInScope(name, scope, compileErrors, location) {
        const symbol = scope.resolveSymbol(name, scope);
        if (symbol instanceof duplicate_symbol_1.DuplicateSymbol) {
          let postFix = "";
          if (symbol.duplicates.length === symbol.duplicates.filter((s) => (0, symbol_helpers_1.isMember)(s) && s.isAbstract).length) {
            postFix = ". Suggestion: factor out the common member(s) into a higher level interface";
          }
          compileErrors.push(new compile_error_1.NotUniqueNameCompileError(name, postFix, location));
        }
      }
      function mustBeUniqueValueInScope(name, compileErrors, location) {
        compileErrors.push(new compile_error_1.NotUniqueNameCompileError(name, "", location));
      }
      function mustNotBeLet(symbol, id, compileErrors, location) {
        if (symbol instanceof let_asn_1.LetAsn) {
          compileErrors.push(new compile_error_1.MutateCompileError((0, symbol_helpers_1.displayName)(symbol, id), mapToPurpose(symbol), location));
        }
      }
      function mapToPurpose(symbol) {
        if (symbol.symbolScope === symbol_scope_1.SymbolScope.parameter) {
          return "parameter";
        }
        if ((0, symbol_helpers_1.isConstant)(symbol)) {
          return "constant";
        }
        if ((0, symbol_helpers_1.isFunction)(symbol)) {
          return "function";
        }
        if ((0, symbol_helpers_1.isProcedure)(symbol)) {
          return "procedure";
        }
        if ((0, symbol_helpers_1.isLet)(symbol)) {
          return "'let'";
        }
        return "variable";
      }
      function mustNotBeRedefined(variable, id, compileErrors, location) {
        if (variable instanceof unknown_symbol_1.UnknownSymbol || variable.symbolScope === symbol_scope_1.SymbolScope.member || variable.symbolScope === symbol_scope_1.SymbolScope.program || variable.symbolScope === symbol_scope_1.SymbolScope.stdlib) {
          return;
        }
        compileErrors.push(new compile_error_1.RedefinedCompileError((0, symbol_helpers_1.displayName)(variable, id), mapToPurpose(variable), location));
      }
      function mustNotBeOutParameter(compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError("'out' parameters are only supported on procedures.", location));
      }
      function mustNotHaveDuplicateMain(compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError("There can only be one 'main' in a program.", location));
      }
      function mustBeIterable(symbolType, compileErrors, location) {
        if ((0, symbol_helpers_1.isKnownType)(symbolType) && !(0, symbol_helpers_1.isIterableType)(symbolType)) {
          compileErrors.push(new compile_error_1.InvalidSourceForEachCompileError(location));
        }
      }
      function mustHaveUniqueKeys(keys, compileErrors, location) {
        const set = new Set(keys);
        if (set.size !== keys.length) {
          compileErrors.push(new compile_error_1.DuplicateKeyCompileError(location));
        }
      }
      function mustBeNewable(type, compileErrors, location) {
        compileErrors.push(new compile_error_1.NotNewableCompileError(type, location));
      }
      function mustBeFunctionRefIfFunction(symbol, id, compileErrors, location) {
        if (symbol.symbolType() instanceof function_type_1.FunctionType) {
          compileErrors.push(new compile_error_1.FunctionRefCompileError((0, symbol_helpers_1.displayName)(symbol, id), !(symbol.symbolScope === symbol_scope_1.SymbolScope.stdlib || symbol.symbolScope === symbol_scope_1.SymbolScope.member), location));
        }
      }
      function mustBeGlobalFunctionIfRef(symbol, id, compileErrors, location) {
        if (symbol.symbolType() instanceof function_type_1.FunctionType && (symbol.symbolScope === symbol_scope_1.SymbolScope.stdlib || symbol.symbolScope === symbol_scope_1.SymbolScope.member)) {
          compileErrors.push(new compile_error_1.NotGlobalFunctionRefCompileError((0, symbol_helpers_1.displayName)(symbol, id), location));
        }
      }
      function mustNotBeTwoUnaryExpressions(compileErrors, location) {
        compileErrors.push(new compile_error_1.SyntaxCompileError("Unsupported operation.", location));
      }
      var compilerAssertions = true;
      function compilerAssert(condition, message) {
        if (compilerAssertions && !condition) {
          throw new elan_compiler_error_1.ElanCompilerError(message);
        }
      }
    }
  });

  // out/src/compiler/syntax-nodes/statements/assert-asn.js
  var require_assert_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/assert-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssertAsn = void 0;
      var unknown_type_1 = require_unknown_type();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var AssertAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        expected = empty_asn_1.EmptyAsn.Instance;
        actual = empty_asn_1.EmptyAsn.Instance;
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
        compile() {
          this.compileErrors = [];
          const test = this.scope;
          const ignored = test.ignored;
          const emptyString = `""`;
          const emptyTuple = `[${emptyString}, ${emptyString}]`;
          let expected = emptyTuple;
          let actual = emptyTuple;
          const expectedValue = this.expected.compile();
          const actualValue = this.actual.compile();
          if (!ignored) {
            const expectedSt = this.expected.symbolType().name;
            const actualSt = this.actual.symbolType().name;
            const actualFunc = `async () => ${actualValue}`;
            expected = `[${expectedValue}, "${expectedSt}"]`;
            actual = `[${actualFunc}, "${actualSt}"]`;
          }
          return `${this.indent()}_outcomes.push(await system.assert(${actual}, ${expected}, "${this.fieldId}", _stdlib, ${ignored}));`;
        }
      };
      exports.AssertAsn = AssertAsn;
    }
  });

  // out/src/compiler/syntax-nodes/compound-asn.js
  var require_compound_asn = __commonJS({
    "out/src/compiler/syntax-nodes/compound-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CompoundAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var ast_helpers_1 = require_ast_helpers();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var assert_asn_1 = require_assert_asn();
      var CompoundAsn = class _CompoundAsn extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        children = [];
        paused = false;
        getFirstChild() {
          return this.children[0];
        }
        getCurrentScope() {
          return this;
        }
        getChildRange(first, last) {
          const fst = this.children.indexOf(first);
          const lst = (0, ast_helpers_1.isAstNode)(last) ? this.children.indexOf(last) : -1;
          return fst < lst ? this.children.slice(fst, lst + 1) : this.children.slice(lst, fst + 1);
        }
        resolveSymbol(id, initialScope) {
          const fst = this.getFirstChild();
          let range = this.getChildRange(fst, initialScope);
          if (range.length > 1) {
            range = range.slice(0, range.length - 1);
            for (const f of range) {
              if ((0, symbol_helpers_1.isSymbol)(f) && id) {
                const sids = (0, symbol_helpers_1.getIdsFromString)(f.symbolId);
                if (sids.includes(id)) {
                  return f;
                }
              }
            }
          }
          return this.getParentScope().resolveSymbol(id, this.getCurrentScope());
        }
        isNotGlobalOrLib(s) {
          const scope = s.symbolScope;
          return !(scope === symbol_scope_1.SymbolScope.program || scope === symbol_scope_1.SymbolScope.stdlib);
        }
        bpIndent() {
          return this.indent() === "" ? "  " : this.indent();
        }
        compileChildren() {
          return (0, ast_helpers_1.compileNodes)(this.children);
        }
        getAsserts() {
          const children = this.children;
          let asserts = this.children.filter((c) => c instanceof assert_asn_1.AssertAsn);
          for (const f of children.filter((c) => c instanceof _CompoundAsn)) {
            asserts = asserts.concat(f.getAsserts());
          }
          return asserts;
        }
        updateBreakpoints(event) {
          super.updateBreakpoints(event);
          for (const child of this.children.filter((f) => f instanceof breakpoint_asn_1.BreakpointAsn)) {
            child.updateBreakpoints(event);
          }
        }
        symbolMatches(id, all, initialScope) {
          const matches = this.getParentScope().symbolMatches(id, all, this.getCurrentScope());
          let localMatches = [];
          const fst = this.getFirstChild();
          let range = this.getChildRange(fst, initialScope);
          if (range.length > 1) {
            range = range.slice(0, range.length - 1);
            const symbols = (0, symbol_helpers_1.handleDeconstruction)(range.filter((r) => (0, symbol_helpers_1.isSymbol)(r)));
            localMatches = (0, symbol_helpers_1.symbolMatches)(id, all, symbols);
          }
          return localMatches.concat(matches);
        }
      };
      exports.CompoundAsn = CompoundAsn;
    }
  });

  // out/src/compiler/syntax-nodes/fields/param-list-asn.js
  var require_param_list_asn = __commonJS({
    "out/src/compiler/syntax-nodes/fields/param-list-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ParamListAsn = void 0;
      var duplicate_symbol_1 = require_duplicate_symbol();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var compile_rules_1 = require_compile_rules();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ast_helpers_1 = require_ast_helpers();
      var empty_asn_1 = require_empty_asn();
      var ParamListAsn = class extends abstract_ast_node_1.AbstractAstNode {
        fieldId;
        scope;
        constructor(fieldId, scope) {
          super();
          this.fieldId = fieldId;
          this.scope = scope;
        }
        symbolType() {
          throw new Error("Method not implemented.");
        }
        parms = empty_asn_1.EmptyAsn.Instance;
        getParentScope() {
          return this.scope;
        }
        getParamsAsSymbols() {
          const ast = this.parms;
          if ((0, ast_helpers_1.isAstCollectionNode)(ast)) {
            return ast.items.filter((n) => (0, ast_helpers_1.isAstIdNode)(n)).map((n) => ({
              symbolId: n.id,
              symbolType: () => n.symbolType(),
              symbolScope: n.symbolScope
            }));
          }
          return [];
        }
        symbolMatches(id, all, _initialScope) {
          const symbols = this.getParamsAsSymbols();
          return (0, symbol_helpers_1.symbolMatches)(id, all, symbols);
        }
        symbolNamesAndTypes() {
          const symbols = this.getParamsAsSymbols();
          const names = symbols.map((s) => s.symbolId);
          const types = symbols.map((s) => s.symbolType());
          return [names, types];
        }
        resolveSymbol(id, _initialScope) {
          const allSymbols = this.getParamsAsSymbols();
          const matches = allSymbols.filter((n) => n.symbolId === id);
          if (matches.length === 1) {
            return matches[0];
          }
          if (matches.length > 1) {
            return new duplicate_symbol_1.DuplicateSymbol(matches);
          }
          return new unknown_symbol_1.UnknownSymbol(id);
        }
        mustNotBeRedefined(id) {
          const symbol = this.getParentScope().getParentScope().resolveSymbol(id, this);
          (0, compile_rules_1.mustNotBeRedefined)(symbol, id, this.compileErrors, this.fieldId);
        }
        mustNotBeOutOnFunctionOrConstructor(id) {
          const parentScope = this.getParentScope();
          if ((0, symbol_helpers_1.isFunction)(parentScope) || (0, ast_helpers_1.isConstructor)(parentScope)) {
            const symbol = parentScope.resolveSymbol(id, this);
            if (symbol.symbolScope === symbol_scope_1.SymbolScope.outParameter) {
              (0, compile_rules_1.mustNotBeOutParameter)(this.compileErrors, this.fieldId);
            }
          }
        }
        getIdNodes(parms) {
          if ((0, ast_helpers_1.isAstCollectionNode)(parms)) {
            return parms.items.filter((n) => (0, ast_helpers_1.isAstIdNode)(n));
          }
          return [];
        }
        compile() {
          this.compileErrors = [];
          const parms = this.parms;
          const idNodes = this.getIdNodes(parms);
          for (const idNode of idNodes) {
            this.mustNotBeOutOnFunctionOrConstructor(idNode.id);
            (0, compile_rules_1.mustNotBeSameAsMethodName)(idNode.id, this.scope, this.compileErrors, this.fieldId);
            if (idNodes.length > 1) {
              (0, compile_rules_1.mustBeUniqueNameInScope)(idNode.id, this, this.compileErrors, this.fieldId);
            }
            this.mustNotBeRedefined(idNode.id);
            (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          }
          return parms.compile();
        }
      };
      exports.ParamListAsn = ParamListAsn;
    }
  });

  // out/src/compiler/syntax-nodes/class-members/constructor-asn.js
  var require_constructor_asn = __commonJS({
    "out/src/compiler/syntax-nodes/class-members/constructor-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ConstructorAsn = void 0;
      var procedure_type_1 = require_procedure_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var keywords_1 = require_keywords();
      var compound_asn_1 = require_compound_asn();
      var empty_asn_1 = require_empty_asn();
      var param_list_asn_1 = require_param_list_asn();
      var ConstructorAsn = class extends compound_asn_1.CompoundAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        isMember = true;
        isAbstract = false;
        private = false;
        params = empty_asn_1.EmptyAsn.Instance;
        getClass() {
          return this.getParentScope();
        }
        compile() {
          this.compileErrors = [];
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${this.indent()}async _initialise(${this.params.compile()}) {\r
${this.breakPoint(this.debugSymbols())}${this.compileChildren()}\r
${this.indent()}${this.indent()}return this;\r
${this.indent()}}\r
`;
        }
        resolveSymbol(id, initialScope) {
          const s = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.resolveSymbol(id, this) : new unknown_symbol_1.UnknownSymbol(id);
          return s instanceof unknown_symbol_1.UnknownSymbol ? super.resolveSymbol(id, initialScope) : s;
        }
        symbolMatches(id, all, initialScope) {
          const matches = super.symbolMatches(id, all, initialScope);
          const localMatches = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.symbolMatches(id, all, initialScope) : [];
          return localMatches.concat(matches);
        }
        get symbolId() {
          return `__${keywords_1.constructorKeyword}`;
        }
        symbolType() {
          const [pn, pt] = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.symbolNamesAndTypes() : [[], []];
          return new procedure_type_1.ProcedureType(pn, pt, false, false);
        }
        get symbolScope() {
          return symbol_scope_1.SymbolScope.member;
        }
      };
      exports.ConstructorAsn = ConstructorAsn;
    }
  });

  // out/src/compiler/syntax-nodes/deconstructed-list-asn.js
  var require_deconstructed_list_asn = __commonJS({
    "out/src/compiler/syntax-nodes/deconstructed-list-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedListAsn = void 0;
      var deconstructed_list_type_1 = require_deconstructed_list_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var compile_rules_1 = require_compile_rules();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var DeconstructedListAsn = class extends abstract_ast_node_1.AbstractAstNode {
        head;
        tail;
        fieldId;
        scope;
        constructor(head, tail, fieldId, scope) {
          super();
          this.head = head;
          this.tail = tail;
          this.fieldId = fieldId;
          this.scope = scope;
        }
        get id() {
          return `${this.head.compile()},${this.tail.compile()}`;
        }
        compile() {
          this.compileErrors = [];
          const st = this.symbolType();
          if ((0, symbol_helpers_1.isGenericSymbolType)(st.tailType)) {
            (0, compile_rules_1.mustBeAssignableType)(st.headType, st.tailType.ofTypes[0], this.compileErrors, this.fieldId);
          }
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${this.head.compile()}, ${this.tail.compile()}`;
        }
        symbolType() {
          const headSt = this.head.symbolType();
          const tailSt = this.tail.symbolType();
          return new deconstructed_list_type_1.DeconstructedListType(this.head.compile(), this.tail.compile(), headSt, tailSt);
        }
        toString() {
          return `${this.head}:${this.tail}`;
        }
      };
      exports.DeconstructedListAsn = DeconstructedListAsn;
    }
  });

  // out/src/compiler/syntax-nodes/deconstructed-tuple-asn.js
  var require_deconstructed_tuple_asn = __commonJS({
    "out/src/compiler/syntax-nodes/deconstructed-tuple-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedTupleAsn = void 0;
      var deconstructed_tuple_type_1 = require_deconstructed_tuple_type();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var DeconstructedTupleAsn = class extends abstract_ast_node_1.AbstractAstNode {
        items;
        fieldId;
        constructor(items, fieldId) {
          super();
          this.items = items;
          this.fieldId = fieldId;
        }
        get id() {
          const ids = this.items.map((i) => i.id).join(",");
          return `${ids}`;
        }
        compile() {
          this.compileErrors = [];
          return this.items.map((p) => p.compile()).join(", ");
        }
        symbolType() {
          return new deconstructed_tuple_type_1.DeconstructedTupleType(this.items.map((i) => i.id), this.items.map((i) => i.symbolType()));
        }
        toString() {
          const it = this.items.map((p) => p.toString()).join(", ");
          return `${it}`;
        }
      };
      exports.DeconstructedTupleAsn = DeconstructedTupleAsn;
    }
  });

  // out/src/compiler/symbols/enum-value-type.js
  var require_enum_value_type = __commonJS({
    "out/src/compiler/symbols/enum-value-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumValueType = void 0;
      var type_options_1 = require_type_options();
      var EnumValueType = class {
        owner;
        name;
        constructor(owner, name) {
          this.owner = owner;
          this.name = name;
        }
        typeOptions = type_options_1.immutableTypeOptions;
        initialValue = "";
        toString() {
          return `${this.owner}.${this.name}`;
        }
        isAssignableFrom(_otherType) {
          return false;
        }
      };
      exports.EnumValueType = EnumValueType;
    }
  });

  // out/src/compiler/syntax-nodes/fields/enum-values-asn.js
  var require_enum_values_asn = __commonJS({
    "out/src/compiler/syntax-nodes/fields/enum-values-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumValuesAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_type_1 = require_unknown_type();
      var compile_rules_1 = require_compile_rules();
      var enum_value_type_1 = require_enum_value_type();
      var symbol_scope_1 = require_symbol_scope();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ast_helpers_1 = require_ast_helpers();
      var empty_asn_1 = require_empty_asn();
      var EnumValuesAsn = class extends abstract_ast_node_1.AbstractAstNode {
        fieldId;
        scope;
        constructor(fieldId, scope) {
          super();
          this.fieldId = fieldId;
          this.scope = scope;
        }
        values = empty_asn_1.EmptyAsn.Instance;
        get names() {
          if ((0, ast_helpers_1.isAstCollectionNode)(this.values)) {
            const items = this.values.items;
            return items.map((i) => (0, compile_rules_1.getId)(i));
          }
          return [];
        }
        getSymbols(typeName) {
          return this.names.map((n) => ({
            symbolId: n,
            symbolType: () => new enum_value_type_1.EnumValueType(typeName, n),
            symbolScope: symbol_scope_1.SymbolScope.program
          }));
        }
        compile() {
          this.compileErrors = [];
          const ast = this.values;
          if ((0, ast_helpers_1.isAstCollectionNode)(ast)) {
            const items = ast.items;
            if (items.length > 0) {
              const ids = items.map((i) => i.compile());
              for (const id of ids) {
                (0, compile_rules_1.mustNotBeKeyword)(id, this.compileErrors, this.fieldId);
                if (ids.indexOf(id) !== ids.lastIndexOf(id)) {
                  (0, compile_rules_1.mustBeUniqueValueInScope)(id, this.compileErrors, this.fieldId);
                }
              }
              const def = `_default : "${ids[0]}", `;
              const itStr = ids.map((n) => `${n} : "${n}"`).join(", ");
              (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
              return `${def}${itStr}`;
            }
            return `_default : ""`;
          }
          return "";
        }
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
      };
      exports.EnumValuesAsn = EnumValuesAsn;
    }
  });

  // out/src/compiler/compiler-interfaces/root-ast-node.js
  var require_root_ast_node = __commonJS({
    "out/src/compiler/compiler-interfaces/root-ast-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CompileMode = void 0;
      var CompileMode;
      (function(CompileMode2) {
        CompileMode2[CompileMode2["inprocess"] = 0] = "inprocess";
        CompileMode2[CompileMode2["worker"] = 1] = "worker";
        CompileMode2[CompileMode2["debugWorker"] = 2] = "debugWorker";
        CompileMode2[CompileMode2["testWorker"] = 3] = "testWorker";
        CompileMode2[CompileMode2["standaloneWorker"] = 4] = "standaloneWorker";
      })(CompileMode || (exports.CompileMode = CompileMode = {}));
    }
  });

  // out/src/compiler/symbols/regexp-type.js
  var require_regexp_type = __commonJS({
    "out/src/compiler/symbols/regexp-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.RegExpType = void 0;
      var type_options_1 = require_type_options();
      var elan_type_names_1 = require_elan_type_names();
      var RegExpType = class _RegExpType {
        constructor() {
        }
        initialValue = "system.emptyRegExp()";
        typeOptions = type_options_1.immutableTypeOptions;
        static Instance = new _RegExpType();
        name = elan_type_names_1.RegExpName;
        toString() {
          return this.name;
        }
        isAssignableFrom(otherType) {
          return otherType instanceof _RegExpType;
        }
      };
      exports.RegExpType = RegExpType;
    }
  });

  // out/src/compiler/symbols/elan-symbols.js
  var require_elan_symbols = __commonJS({
    "out/src/compiler/symbols/elan-symbols.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.elanSymbols = void 0;
      var boolean_type_1 = require_boolean_type();
      var elan_type_names_1 = require_elan_type_names();
      var float_type_1 = require_float_type();
      var function_type_1 = require_function_type();
      var generic_parameter_type_1 = require_generic_parameter_type();
      var int_type_1 = require_int_type();
      var regexp_type_1 = require_regexp_type();
      var string_type_1 = require_string_type();
      var symbol_scope_1 = require_symbol_scope();
      var tuple_type_1 = require_tuple_type();
      var intSymbol = {
        symbolId: int_type_1.IntType.Instance.name,
        symbolType: function() {
          return int_type_1.IntType.Instance;
        },
        symbolScope: symbol_scope_1.SymbolScope.program
      };
      var floatSymbol = {
        symbolId: float_type_1.FloatType.Instance.name,
        symbolType: function() {
          return float_type_1.FloatType.Instance;
        },
        symbolScope: symbol_scope_1.SymbolScope.program
      };
      var stringSymbol = {
        symbolId: string_type_1.StringType.Instance.name,
        symbolType: function() {
          return string_type_1.StringType.Instance;
        },
        symbolScope: symbol_scope_1.SymbolScope.program
      };
      var booleanSymbol = {
        symbolId: boolean_type_1.BooleanType.Instance.name,
        symbolType: function() {
          return boolean_type_1.BooleanType.Instance;
        },
        symbolScope: symbol_scope_1.SymbolScope.program
      };
      var regExpSymbol = {
        symbolId: regexp_type_1.RegExpType.Instance.name,
        symbolType: function() {
          return regexp_type_1.RegExpType.Instance;
        },
        symbolScope: symbol_scope_1.SymbolScope.program
      };
      var tupleSymbol = {
        symbolId: elan_type_names_1.TupleName,
        symbolType: function() {
          return new tuple_type_1.TupleType([new generic_parameter_type_1.GenericParameterType("T1"), new generic_parameter_type_1.GenericParameterType("T2")]);
        },
        symbolScope: symbol_scope_1.SymbolScope.program,
        isClass: true,
        isAbstract: true,
        isNotInheritable: true,
        ofTypes: [new generic_parameter_type_1.GenericParameterType("T1"), new generic_parameter_type_1.GenericParameterType("T2")]
      };
      var funcSymbol = {
        symbolId: elan_type_names_1.FuncName,
        symbolType: function() {
          return new function_type_1.FunctionType(["T"], [new generic_parameter_type_1.GenericParameterType("T")], new generic_parameter_type_1.GenericParameterType("T1"), false, true, false);
        },
        symbolScope: symbol_scope_1.SymbolScope.program,
        isClass: true,
        isAbstract: true,
        isNotInheritable: true,
        ofTypes: [new generic_parameter_type_1.GenericParameterType("T")]
      };
      exports.elanSymbols = [
        intSymbol,
        floatSymbol,
        stringSymbol,
        booleanSymbol,
        regExpSymbol,
        tupleSymbol,
        funcSymbol
      ];
    }
  });

  // out/src/compiler/symbols/null-scope.js
  var require_null_scope = __commonJS({
    "out/src/compiler/symbols/null-scope.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.NullScope = void 0;
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var unknown_type_1 = require_unknown_type();
      var NullScope = class _NullScope {
        resolveSymbol(_id, _scope) {
          return new unknown_symbol_1.UnknownSymbol();
        }
        resolveOwnSymbol(_id) {
          return new unknown_symbol_1.UnknownSymbol();
        }
        getParentScope() {
          return _NullScope.Instance;
        }
        symbolMatches(_id, _all, _initialScope) {
          return [];
        }
        getChildren() {
          return [];
        }
        symbolId = "";
        symbolType = () => unknown_type_1.UnknownType.Instance;
        symbolScope = symbol_scope_1.SymbolScope.unknown;
        static Instance = new _NullScope();
      };
      exports.NullScope = NullScope;
    }
  });

  // out/src/compiler/syntax-nodes/globals/constant-asn.js
  var require_constant_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/constant-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ConstantAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var compile_rules_1 = require_compile_rules();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var ConstantAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        isConstant = true;
        name = empty_asn_1.EmptyAsn.Instance;
        value = empty_asn_1.EmptyAsn.Instance;
        get symbolId() {
          return (0, compile_rules_1.getId)(this.name);
        }
        symbolType() {
          return this.value.symbolType();
        }
        get symbolScope() {
          return symbol_scope_1.SymbolScope.program;
        }
        compile() {
          this.compileErrors = [];
          const name = this.name.compile();
          (0, compile_rules_1.mustBeUniqueNameInScope)(name, (0, symbol_helpers_1.getGlobalScope)(this.scope), this.compileErrors, this.fieldId);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${name} = ${this.value.compile()};\r
`;
        }
      };
      exports.ConstantAsn = ConstantAsn;
    }
  });

  // out/src/compiler/syntax-nodes/globals/enum-asn.js
  var require_enum_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/enum-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumAsn = void 0;
      var enum_type_1 = require_enum_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var compile_rules_1 = require_compile_rules();
      var ast_helpers_1 = require_ast_helpers();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var EnumAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        get symbolId() {
          return (0, compile_rules_1.getId)(this.name);
        }
        symbolType() {
          return new enum_type_1.EnumType(this.symbolId);
        }
        name = empty_asn_1.EmptyAsn.Instance;
        values = empty_asn_1.EmptyAsn.Instance;
        compile() {
          this.compileErrors = [];
          const name = this.name.compile();
          (0, compile_rules_1.mustBeUniqueNameInScope)(name, (0, symbol_helpers_1.getGlobalScope)(this.scope), this.compileErrors, this.fieldId);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `const ${name} = {\r
${this.singleIndent()}${this.values.compile()}\r
};\r
`;
        }
        enumValueSymbols() {
          return (0, ast_helpers_1.isEnumValuesAsn)(this.values) ? this.values.getSymbols((0, compile_rules_1.getId)(this.name)) : [];
        }
        resolveSymbol(id, _initialScope) {
          for (const n of this.enumValueSymbols()) {
            if (n.symbolId === id) {
              return n;
            }
          }
          return this.getParentScope().resolveSymbol(id, this);
        }
        symbolMatches(id, all, _initialScope) {
          const otherMatches = this.getParentScope().symbolMatches(id, all, this);
          const symbols = this.enumValueSymbols();
          const matches = (0, symbol_helpers_1.symbolMatches)(id, all, symbols);
          return matches.concat(otherMatches);
        }
      };
      exports.EnumAsn = EnumAsn;
    }
  });

  // out/src/compiler/syntax-nodes/globals/main-asn.js
  var require_main_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/main-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MainAsn = void 0;
      var duplicate_symbol_1 = require_duplicate_symbol();
      var symbol_helpers_1 = require_symbol_helpers();
      var compile_rules_1 = require_compile_rules();
      var compound_asn_1 = require_compound_asn();
      var MainAsn = class extends compound_asn_1.CompoundAsn {
        fieldId;
        constructor(fieldId, scope) {
          super(fieldId, scope);
          this.fieldId = fieldId;
        }
        indent() {
          return "";
        }
        get symbolId() {
          return "__main";
        }
        debugSymbols() {
          return () => (0, symbol_helpers_1.allScopedSymbols)(this.getParentScope(), this);
        }
        compile() {
          this.compileErrors = [];
          const existingMain = this.resolveSymbol("__main", this);
          if (existingMain instanceof duplicate_symbol_1.DuplicateSymbol) {
            (0, compile_rules_1.mustNotHaveDuplicateMain)(this.compileErrors, this.fieldId);
          }
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `async function main() {\r
${this.breakPoint(this.debugSymbols())}${this.compileChildren()}\r
}\r
`;
        }
      };
      exports.MainAsn = MainAsn;
    }
  });

  // out/src/compiler/syntax-nodes/globals/test-asn.js
  var require_test_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/test-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TestAsn = void 0;
      var ast_helpers_1 = require_ast_helpers();
      var compound_asn_1 = require_compound_asn();
      var TestAsn = class extends compound_asn_1.CompoundAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        symbolType() {
          throw new Error("Method not implemented.");
        }
        indent() {
          return "";
        }
        ignored = false;
        compileTestBody() {
          const body = this.compileChildren();
          if (!this.ignored || this.compileErrors.length > 0) {
            return body;
          }
          return (0, ast_helpers_1.compileNodes)(this.getAsserts());
        }
        compile() {
          this.compileErrors = [];
          return `_tests.push(["${this.fieldId}", async (_outcomes) => {\r
${this.compileTestBody()}\r
}]);\r
`;
        }
      };
      exports.TestAsn = TestAsn;
    }
  });

  // out/src/compiler/syntax-nodes/file-asn.js
  var require_file_asn = __commonJS({
    "out/src/compiler/syntax-nodes/file-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FileAsn = void 0;
      var root_ast_node_1 = require_root_ast_node();
      var duplicate_symbol_1 = require_duplicate_symbol();
      var elan_symbols_1 = require_elan_symbols();
      var null_scope_1 = require_null_scope();
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_type_1 = require_unknown_type();
      var breakpoint_event_1 = require_breakpoint_event();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ast_helpers_1 = require_ast_helpers();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var constant_asn_1 = require_constant_asn();
      var enum_asn_1 = require_enum_asn();
      var main_asn_1 = require_main_asn();
      var test_asn_1 = require_test_asn();
      var FileAsn = class extends abstract_ast_node_1.AbstractAstNode {
        scope;
        version;
        constructor(scope, version) {
          super();
          this.scope = scope;
          this.version = version;
        }
        isRoot = true;
        _nextId = 0;
        mode = root_ast_node_1.CompileMode.inprocess;
        base;
        compileErrorMap = /* @__PURE__ */ new Map();
        scopeMap = /* @__PURE__ */ new Map();
        getScopeById(id) {
          if (this.scopeMap.has(id)) {
            return this.scopeMap.get(id);
          }
          return null_scope_1.NullScope.Instance;
        }
        setScopeById(id, scope) {
          this.scopeMap.set(id, scope);
        }
        setCompileOptions(mode, base) {
          this.mode = mode;
          this.base = base;
        }
        getAllCompileErrors() {
          let all = [];
          for (const e of this.compileErrorMap.values()) {
            all = all.concat(e);
          }
          return all;
        }
        getNextId() {
          return this._nextId++;
        }
        getCompileErrorsFor(fieldId) {
          if (this.compileErrorMap.has(fieldId)) {
            return this.compileErrorMap.get(fieldId);
          }
          return [];
        }
        get libraryScope() {
          return this.scope;
        }
        getVersion() {
          return this.version;
        }
        addCompileError(error) {
          if (this.compileErrorMap.has(error.locationId)) {
            this.compileErrorMap.get(error.locationId)?.push(error);
          } else {
            this.compileErrorMap.set(error.locationId, [error]);
          }
        }
        addCompileErrors(errors) {
          for (const error of errors) {
            this.addCompileError(error);
          }
        }
        getParentScope() {
          return this.scope;
        }
        symbolMatches(id, all) {
          const languageMatches = (0, symbol_helpers_1.symbolMatches)(id, all, elan_symbols_1.elanSymbols);
          const libMatches = this.scope.symbolMatches(id, all, this);
          const globalSymbols = this.children.filter((c) => (0, symbol_helpers_1.isSymbol)(c));
          const matches = (0, symbol_helpers_1.symbolMatches)(id, all, globalSymbols);
          return languageMatches.concat(matches).concat(libMatches);
        }
        fieldId = "";
        children = [];
        hasTests = false;
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
        compileGlobals() {
          let result = "";
          const ss = [];
          for (const child of this.children.filter((g) => g instanceof enum_asn_1.EnumAsn)) {
            ss.push(child.compile());
          }
          const constants = this.children.filter((g) => g instanceof constant_asn_1.ConstantAsn);
          if (constants.length > 0) {
            ss.push("const global = new class {");
            for (const constant of constants) {
              ss.push(`  ${constant.compile()}`);
            }
            ss.push("};");
          } else {
            ss.push("const global = new class {};");
          }
          for (const child of this.children.filter((g) => !(g instanceof enum_asn_1.EnumAsn || g instanceof constant_asn_1.ConstantAsn))) {
            ss.push(child.compile());
          }
          if (!this.children.some((g) => g instanceof main_asn_1.MainAsn)) {
            const emptyMain = new main_asn_1.MainAsn(this.fieldId, this);
            ss.push(emptyMain.compile());
          }
          result = ss.join("\r\n");
          this.hasTests = this.children.some((g) => g instanceof test_asn_1.TestAsn);
          return result;
        }
        updateBreakpoints(event) {
          for (const child of this.children.filter((f) => f instanceof breakpoint_asn_1.BreakpointAsn)) {
            child.updateBreakpoints(event);
          }
        }
        compileAsTestWorker(base) {
          this.updateBreakpoints(breakpoint_event_1.BreakpointEvent.disable);
          const onmsg = `onmessage = async (e) => {
    if (e.data.type === "start") {
      try {
        const [main, tests] = await program();
        const outcomes = await system.runTests(tests);
        postMessage({type : "test", value : outcomes});
      }
      catch (e) {
        postMessage({type : "status", status : "error", error : e});
      }
    }
  };`;
          const stdlib = `import { StdLib, StubInputOutput } from "${base}/elan-api.js"; let system; let _stdlib; let _tests = []; async function program() { _stdlib = new StdLib(new StubInputOutput()); system = _stdlib.system; system.stdlib = _stdlib  `;
          return `${stdlib}
${this.compileGlobals()}return [main, _tests];}
${onmsg}`;
        }
        compileAsWorker(base, debugMode, standalone) {
          this.updateBreakpoints(debugMode ? breakpoint_event_1.BreakpointEvent.activate : breakpoint_event_1.BreakpointEvent.disable);
          const onmsg = `addEventListener("message", async (e) => {
  if (e.data.type === "start") {
    try {
      const [main, tests] = await program();
      await main();
      postMessage({type : "status", status : "finished"});
    }
    catch (e) {
      postMessage({type : "status", status : "error", error : e});
    }
  }
  if (e.data.type === "pause") {
    __pause = true;
  }
  });`;
          const imp = standalone ? "" : `import { StdLib, StubInputOutput } from "${base}/elan-api.js"; `;
          const stdlib = `${imp}let system; let _stdlib; let _tests = []; let __pause = false; async function program() { _stdlib = new StdLib(new StubInputOutput()); system = _stdlib.system; system.stdlib = _stdlib  `;
          return `${stdlib}
${this.compileGlobals()}return [main, _tests];}
${onmsg}`;
        }
        compile() {
          if (this.mode === root_ast_node_1.CompileMode.inprocess) {
            const stdlib = `let system; let _stdlib; let _tests = []; export function _inject(l,s) { system = l; _stdlib = s; }; export async function program() {`;
            return `${stdlib}
${this.compileGlobals()}return [main, _tests];}`;
          }
          if (this.mode === root_ast_node_1.CompileMode.worker) {
            return this.compileAsWorker(this.base, false, false);
          }
          if (this.mode === root_ast_node_1.CompileMode.debugWorker) {
            return this.compileAsWorker(this.base, true, false);
          }
          if (this.mode === root_ast_node_1.CompileMode.standaloneWorker) {
            return this.compileAsWorker(this.base, false, true);
          }
          if (this.mode === root_ast_node_1.CompileMode.testWorker) {
            return this.compileAsTestWorker(this.base);
          }
          return "";
        }
        resolveSymbol(id, initialScope) {
          let globalSymbols = [];
          if (initialScope instanceof constant_asn_1.ConstantAsn) {
            const constChildren = this.children.filter((c) => c instanceof constant_asn_1.ConstantAsn);
            const otherChildren = this.children.filter((c) => !(c instanceof constant_asn_1.ConstantAsn));
            const range = (0, ast_helpers_1.getChildRange)(constChildren, initialScope);
            const all = range.concat(otherChildren).filter((c) => (0, symbol_helpers_1.isSymbol)(c));
            globalSymbols = all.concat(elan_symbols_1.elanSymbols);
          } else {
            globalSymbols = this.children.filter((c) => (0, symbol_helpers_1.isSymbol)(c)).concat(elan_symbols_1.elanSymbols);
          }
          const matches = globalSymbols.filter((s) => s.symbolId === id);
          if (matches.length === 1) {
            return matches[0];
          }
          if (matches.length > 1) {
            return new duplicate_symbol_1.DuplicateSymbol(matches);
          }
          return this.scope.resolveSymbol(id, this);
        }
      };
      exports.FileAsn = FileAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/return-asn.js
  var require_return_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/return-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ReturnAsn = void 0;
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var ReturnAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        expr = empty_asn_1.EmptyAsn.Instance;
        compile() {
          this.compileErrors = [];
          return `${this.indent()}${this.breakPoint(this.debugSymbols())}return ${this.expr.compile()};`;
        }
      };
      exports.ReturnAsn = ReturnAsn;
    }
  });

  // out/src/compiler/syntax-nodes/globals/function-asn.js
  var require_function_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/function-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FunctionAsn = void 0;
      var function_type_1 = require_function_type();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var compile_rules_1 = require_compile_rules();
      var compound_asn_1 = require_compound_asn();
      var empty_asn_1 = require_empty_asn();
      var param_list_asn_1 = require_param_list_asn();
      var return_asn_1 = require_return_asn();
      var FunctionAsn = class extends compound_asn_1.CompoundAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        name = empty_asn_1.EmptyAsn.Instance;
        params = empty_asn_1.EmptyAsn.Instance;
        returnType = empty_asn_1.EmptyAsn.Instance;
        get symbolId() {
          return (0, compile_rules_1.getId)(this.name);
        }
        symbolType() {
          const [pn, pt] = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.symbolNamesAndTypes() : [[], []];
          const rt = this.returnType.symbolType();
          return new function_type_1.FunctionType(pn, pt, rt, false, true, true);
        }
        get symbolScope() {
          return symbol_scope_1.SymbolScope.program;
        }
        getReturnAsn() {
          return this.children.filter((s) => s instanceof return_asn_1.ReturnAsn)[0];
        }
        resolveSymbol(id, initialScope) {
          if ((0, compile_rules_1.getId)(this.name) === id) {
            return this;
          }
          const s = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.resolveSymbol(id, this) : new unknown_symbol_1.UnknownSymbol(id);
          return s instanceof unknown_symbol_1.UnknownSymbol ? super.resolveSymbol(id, initialScope) : s;
        }
        compile() {
          return `${this.name.compile()}(${this.params.compile()}) {\r
${this.breakPoint(this.debugSymbols())}${this.compileChildren()}\r`;
        }
        symbolMatches(id, all, initialScope) {
          const matches = super.symbolMatches(id, all, initialScope);
          const localMatches = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.symbolMatches(id, all, initialScope) : [];
          return localMatches.concat(matches);
        }
      };
      exports.FunctionAsn = FunctionAsn;
    }
  });

  // out/src/compiler/syntax-nodes/operation-symbol.js
  var require_operation_symbol = __commonJS({
    "out/src/compiler/syntax-nodes/operation-symbol.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.OperationSymbol = void 0;
      var OperationSymbol;
      (function(OperationSymbol2) {
        OperationSymbol2[OperationSymbol2["Add"] = 0] = "Add";
        OperationSymbol2[OperationSymbol2["Minus"] = 1] = "Minus";
        OperationSymbol2[OperationSymbol2["Not"] = 2] = "Not";
        OperationSymbol2[OperationSymbol2["Multiply"] = 3] = "Multiply";
        OperationSymbol2[OperationSymbol2["And"] = 4] = "And";
        OperationSymbol2[OperationSymbol2["Equals"] = 5] = "Equals";
        OperationSymbol2[OperationSymbol2["LT"] = 6] = "LT";
        OperationSymbol2[OperationSymbol2["GT"] = 7] = "GT";
        OperationSymbol2[OperationSymbol2["GTE"] = 8] = "GTE";
        OperationSymbol2[OperationSymbol2["LTE"] = 9] = "LTE";
        OperationSymbol2[OperationSymbol2["Div"] = 10] = "Div";
        OperationSymbol2[OperationSymbol2["Mod"] = 11] = "Mod";
        OperationSymbol2[OperationSymbol2["Divide"] = 12] = "Divide";
        OperationSymbol2[OperationSymbol2["NotEquals"] = 13] = "NotEquals";
        OperationSymbol2[OperationSymbol2["Pow"] = 14] = "Pow";
        OperationSymbol2[OperationSymbol2["Or"] = 15] = "Or";
        OperationSymbol2[OperationSymbol2["Unknown"] = 16] = "Unknown";
      })(OperationSymbol || (exports.OperationSymbol = OperationSymbol = {}));
    }
  });

  // out/src/compiler/syntax-nodes/unary-expr-asn.js
  var require_unary_expr_asn = __commonJS({
    "out/src/compiler/syntax-nodes/unary-expr-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.UnaryExprAsn = void 0;
      var boolean_type_1 = require_boolean_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var compile_rules_1 = require_compile_rules();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ast_helpers_1 = require_ast_helpers();
      var operation_symbol_1 = require_operation_symbol();
      var UnaryExprAsn = class _UnaryExprAsn extends abstract_ast_node_1.AbstractAstNode {
        op;
        operand;
        fieldId;
        scope;
        constructor(op, operand, fieldId, scope) {
          super();
          this.op = op;
          this.operand = operand;
          this.fieldId = fieldId;
          this.scope = scope;
        }
        compileErrors = [];
        isNegativeOperation() {
          return (0, ast_helpers_1.mapOperation)(this.op) === operation_symbol_1.OperationSymbol.Minus;
        }
        opToJs(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Not:
              return "!";
            case operation_symbol_1.OperationSymbol.Minus:
              return "-";
            default:
              return " ";
          }
        }
        compile() {
          this.compileErrors = [];
          if (this.operand instanceof _UnaryExprAsn) {
            (0, compile_rules_1.mustNotBeTwoUnaryExpressions)(this.compileErrors, this.fieldId);
          }
          const opSymbol = (0, ast_helpers_1.mapOperation)(this.op);
          if (opSymbol === operation_symbol_1.OperationSymbol.Unknown) {
            (0, compile_rules_1.mustBeKnownOperation)(this.op, this.compileErrors, this.fieldId);
          }
          const code = `${this.opToJs(opSymbol)}${this.operand.compile()}`;
          const opSt = this.operand.symbolType();
          if (opSymbol === operation_symbol_1.OperationSymbol.Minus) {
            (0, compile_rules_1.mustBeNumberType)(opSt, this.compileErrors, this.fieldId);
            (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
            return `(${code})`;
          }
          (0, compile_rules_1.mustBeBooleanType)(opSt, this.compileErrors, this.fieldId);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return code;
        }
        symbolType() {
          const opSymbol = (0, ast_helpers_1.mapOperation)(this.op);
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Not:
              return boolean_type_1.BooleanType.Instance;
            default:
              return this.operand.symbolType();
          }
        }
        toString() {
          return `${this.op} ${this.operand}`;
        }
      };
      exports.UnaryExprAsn = UnaryExprAsn;
    }
  });

  // out/src/compiler/syntax-nodes/index-double-asn.js
  var require_index_double_asn = __commonJS({
    "out/src/compiler/syntax-nodes/index-double-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IndexDoubleAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_type_1 = require_unknown_type();
      var compile_rules_1 = require_compile_rules();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var unary_expr_asn_1 = require_unary_expr_asn();
      var IndexDoubleAsn = class extends abstract_ast_node_1.AbstractAstNode {
        index1;
        index2;
        fieldId;
        scope;
        constructor(index1, index2, fieldId, scope) {
          super();
          this.index1 = index1;
          this.index2 = index2;
          this.fieldId = fieldId;
          this.scope = scope;
        }
        checkForNegativeIndex(index) {
          if (index instanceof unary_expr_asn_1.UnaryExprAsn) {
            if (index.isNegativeOperation()) {
              (0, compile_rules_1.mustNotBeNegativeIndex)(this.compileErrors, this.fieldId);
            }
          }
        }
        compile() {
          this.compileErrors = [];
          this.checkForNegativeIndex(this.index1);
          this.checkForNegativeIndex(this.index2);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${this.index1.compile()}, ${this.index2.compile()}`;
        }
        symbolType() {
          return unknown_type_1.UnknownType.Instance;
        }
        toString() {
          return `${this.index1}..${this.index2}`;
        }
      };
      exports.IndexDoubleAsn = IndexDoubleAsn;
    }
  });

  // out/src/compiler/syntax-nodes/qualifier-asn.js
  var require_qualifier_asn = __commonJS({
    "out/src/compiler/syntax-nodes/qualifier-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.QualifierAsn = void 0;
      var abstract_ast_node_1 = require_abstract_ast_node();
      var QualifierAsn = class extends abstract_ast_node_1.AbstractAstNode {
        value;
        fieldId;
        scope;
        constructor(value, fieldId, scope) {
          super();
          this.value = value;
          this.fieldId = fieldId;
          this.scope = scope;
        }
        compileErrors = [];
        compile() {
          const s = this.compileAsParameter();
          return s === "" ? "" : `${s}.`;
        }
        compileAsParameter() {
          this.compileErrors = [];
          return this.value.compile();
        }
        symbolType() {
          return this.value.symbolType();
        }
        toString() {
          return `${this.value}.`;
        }
      };
      exports.QualifierAsn = QualifierAsn;
    }
  });

  // out/src/compiler/syntax-nodes/ast-helpers.js
  var require_ast_helpers = __commonJS({
    "out/src/compiler/syntax-nodes/ast-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.isAstNode = isAstNode;
      exports.isAstQualifiedNode = isAstQualifiedNode;
      exports.isAstQualifierNode = isAstQualifierNode;
      exports.isAstIndexableNode = isAstIndexableNode;
      exports.isAstCollectionNode = isAstCollectionNode;
      exports.isAstIdNode = isAstIdNode;
      exports.isRootNode = isRootNode;
      exports.isAstTypeNode = isAstTypeNode;
      exports.isConstructor = isConstructor;
      exports.isEmptyNode = isEmptyNode;
      exports.isFunctionScope = isFunctionScope;
      exports.isFileScope = isFileScope;
      exports.isEnumValuesAsn = isEnumValuesAsn;
      exports.inFunctionScope = inFunctionScope;
      exports.flatten = flatten;
      exports.containsGenericType = containsGenericType;
      exports.generateType = generateType;
      exports.minOf = minOf;
      exports.match = match;
      exports.matchGenericTypes = matchGenericTypes;
      exports.matchParametersAndTypes = matchParametersAndTypes;
      exports.mapOperation = mapOperation;
      exports.wrapDeconstructionRhs = wrapDeconstructionRhs;
      exports.wrapDeconstructionLhs = wrapDeconstructionLhs;
      exports.getIds = getIds;
      exports.getIndexAndOfType = getIndexAndOfType;
      exports.wrapSimpleSubscript = wrapSimpleSubscript;
      exports.compileSimpleSubscript = compileSimpleSubscript;
      exports.compileNodes = compileNodes;
      exports.isInsideFunction = isInsideFunction;
      exports.isInsideFunctionOrConstructor = isInsideFunctionOrConstructor;
      exports.isInsideConstant = isInsideConstant;
      exports.getChildRange = getChildRange;
      exports.childSymbolMatches = childSymbolMatches;
      exports.getChildSymbol = getChildSymbol;
      var type_options_1 = require_type_options();
      var class_type_1 = require_class_type();
      var function_type_1 = require_function_type();
      var generic_parameter_type_1 = require_generic_parameter_type();
      var int_type_1 = require_int_type();
      var procedure_type_1 = require_procedure_type();
      var string_type_1 = require_string_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var tuple_type_1 = require_tuple_type();
      var unknown_type_1 = require_unknown_type();
      var compile_rules_1 = require_compile_rules();
      var constructor_asn_1 = require_constructor_asn();
      var deconstructed_list_asn_1 = require_deconstructed_list_asn();
      var deconstructed_tuple_asn_1 = require_deconstructed_tuple_asn();
      var empty_asn_1 = require_empty_asn();
      var enum_values_asn_1 = require_enum_values_asn();
      var file_asn_1 = require_file_asn();
      var constant_asn_1 = require_constant_asn();
      var function_asn_1 = require_function_asn();
      var index_double_asn_1 = require_index_double_asn();
      var operation_symbol_1 = require_operation_symbol();
      var qualifier_asn_1 = require_qualifier_asn();
      function isAstNode(n) {
        return !!n && "compile" in n && "fieldId" in n && "indent" in n;
      }
      function isAstQualifiedNode(n) {
        return !!n && "qualifier" in n;
      }
      function isAstQualifierNode(n) {
        return n instanceof qualifier_asn_1.QualifierAsn;
      }
      function isAstIndexableNode(n) {
        return !!n && "rootSymbolType" in n;
      }
      function isAstCollectionNode(n) {
        return !!n && "items" in n;
      }
      function isAstIdNode(n) {
        return !!n && "id" in n;
      }
      function isRootNode(n) {
        return !!n && "isRoot" in n;
      }
      function isAstTypeNode(n) {
        return !!n && "compileToEmptyObjectCode" in n;
      }
      function isConstructor(n) {
        return n instanceof constructor_asn_1.ConstructorAsn;
      }
      function isEmptyNode(n) {
        return n instanceof empty_asn_1.EmptyAsn;
      }
      function isFunctionScope(scope) {
        return scope instanceof function_asn_1.FunctionAsn;
      }
      function isFileScope(scope) {
        return scope instanceof file_asn_1.FileAsn;
      }
      function isEnumValuesAsn(n) {
        return n instanceof enum_values_asn_1.EnumValuesAsn;
      }
      function inFunctionScope(start) {
        if (isFunctionScope(start)) {
          return true;
        }
        if (isFileScope(start)) {
          return false;
        }
        return inFunctionScope(start.getParentScope());
      }
      var TypeHolder = class {
        symbolType;
        ofTypes;
        constructor(symbolType, ofTypes) {
          this.symbolType = symbolType;
          this.ofTypes = ofTypes;
        }
        isAssignableFrom(otherType) {
          return this.symbolType.isAssignableFrom(otherType);
        }
        typeOptions = type_options_1.noTypeOptions;
        name = "TypeHolder";
        initialValue = "";
        toString() {
          return this.name;
        }
      };
      function flatten(p) {
        if (p instanceof class_type_1.ClassType && p.typeOptions.isIndexable && p.ofTypes.length === 1) {
          return new TypeHolder(p, [flatten(p.ofTypes[0])]);
        }
        if (p instanceof class_type_1.ClassType && p.typeOptions.isIndexable && p.ofTypes.length === 2) {
          return new TypeHolder(p, [flatten(p.ofTypes[0]), flatten(p.ofTypes[1])]);
        }
        if (p instanceof tuple_type_1.TupleType) {
          let flattened = [];
          for (const t of p.ofTypes) {
            flattened = flattened.concat(flatten(t));
          }
          return new TypeHolder(p, flattened);
        }
        if (p instanceof function_type_1.FunctionType) {
          let flattened = [];
          for (const t of p.parameterTypes) {
            flattened = flattened.concat(flatten(t));
          }
          flattened = flattened.concat(flatten(p.returnType));
          return new TypeHolder(p, flattened);
        }
        if (p instanceof string_type_1.StringType) {
          return new TypeHolder(p, [p]);
        }
        return p;
      }
      function containsGenericType(type) {
        if (type instanceof generic_parameter_type_1.GenericParameterType) {
          return true;
        }
        if (type instanceof tuple_type_1.TupleType) {
          return type.ofTypes.some((t) => containsGenericType(t));
        }
        if (type instanceof class_type_1.ClassType) {
          if ((0, symbol_helpers_1.isClass)(type.scope)) {
            return type.scope.ofTypes.some((t) => containsGenericType(t));
          }
        }
        if (type instanceof function_type_1.FunctionType) {
          if (containsGenericType(type.returnType)) {
            return true;
          }
          return type.parameterTypes.some((t) => containsGenericType(t));
        }
        if (type instanceof procedure_type_1.ProcedureType) {
          return type.parameterTypes.some((t) => containsGenericType(t));
        }
        return false;
      }
      function generateType(type, matches, depth = 0) {
        depth++;
        if (depth > 20) {
          return type;
        }
        if ((0, symbol_helpers_1.isReifyableSymbolType)(type)) {
          return type.reify(type.ofTypes.map((t) => generateType(t, matches, depth)));
        }
        if (type instanceof generic_parameter_type_1.GenericParameterType) {
          let match2 = matches.get(type.id);
          if (match2 instanceof TypeHolder) {
            match2 = generateType(match2.symbolType, matches, depth);
          }
          match2 = match2 ?? type;
          if (match2 instanceof generic_parameter_type_1.GenericParameterType) {
            let newConstraint = void 0;
            if (match2.constraint) {
              newConstraint = generateType(match2.constraint, matches, depth);
            }
            if (newConstraint) {
              match2 = new generic_parameter_type_1.GenericParameterType(match2.id, newConstraint);
            }
          }
          return match2;
        }
        if (type instanceof tuple_type_1.TupleType) {
          return new tuple_type_1.TupleType(type.ofTypes.map((t) => generateType(t, matches, depth)));
        }
        if (type instanceof function_type_1.FunctionType) {
          return new function_type_1.FunctionType(type.parameterNames, type.parameterTypes.map((t) => generateType(t, matches, depth)), generateType(type.returnType, matches), type.isExtension, type.isPure, type.isAsync, type.deprecated);
        }
        if (type instanceof procedure_type_1.ProcedureType) {
          return new procedure_type_1.ProcedureType(type.parameterNames, type.parameterTypes.map((t) => generateType(t, matches, depth)), type.isExtension, type.isAsync);
        }
        return type;
      }
      function minOf(a1, a2) {
        return a1.length < a2.length ? a1.length : a2.length;
      }
      function match(flattened, pTypes, matches) {
        const minLength = minOf(flattened, pTypes);
        for (let i = 0; i < minLength; i++) {
          const t = flattened[i];
          const st = pTypes[i];
          if (t instanceof generic_parameter_type_1.GenericParameterType) {
            if (!matches.has(t.id)) {
              if (!t.constraint || t.constraint.isAssignableFrom(st)) {
                matches.set(t.id, st);
              }
            }
          }
          if (t instanceof TypeHolder && st instanceof TypeHolder) {
            match(t.ofTypes, st.ofTypes, matches);
          }
        }
      }
      function matchGenericTypes(type, parameters) {
        const matches = /* @__PURE__ */ new Map();
        const flattened = type.parameterTypes.map((n) => flatten(n));
        const pTypes = parameters.map((p) => flatten(p.symbolType()));
        match(flattened, pTypes, matches);
        return matches;
      }
      function matchParametersAndTypes(id, methodSymbolType, parameters, compileErrors, location) {
        let parameterTypes = methodSymbolType.parameterTypes;
        if (parameterTypes.some((pt) => containsGenericType(pt))) {
          const matches = matchGenericTypes(methodSymbolType, parameters);
          parameterTypes = parameterTypes.map((pt) => generateType(pt, matches));
        }
        (0, compile_rules_1.mustMatchParameters)(id, parameters, parameterTypes, (0, symbol_helpers_1.parameterNamesWithTypes)(methodSymbolType, parameterTypes).join(", "), methodSymbolType.isExtension, compileErrors, location);
      }
      var opMap = /* @__PURE__ */ new Map([
        [operation_symbol_1.OperationSymbol.Add, "+"],
        [operation_symbol_1.OperationSymbol.Minus, "-"],
        [operation_symbol_1.OperationSymbol.Not, "not"],
        [operation_symbol_1.OperationSymbol.Multiply, "*"],
        [operation_symbol_1.OperationSymbol.And, "and"],
        [operation_symbol_1.OperationSymbol.Equals, "is"],
        [operation_symbol_1.OperationSymbol.LT, "<"],
        [operation_symbol_1.OperationSymbol.GT, ">"],
        [operation_symbol_1.OperationSymbol.GTE, ">="],
        [operation_symbol_1.OperationSymbol.LTE, "<="],
        [operation_symbol_1.OperationSymbol.Div, "div"],
        [operation_symbol_1.OperationSymbol.Mod, "mod"],
        [operation_symbol_1.OperationSymbol.Divide, "/"],
        [operation_symbol_1.OperationSymbol.NotEquals, "isnt"],
        [operation_symbol_1.OperationSymbol.Pow, "^"],
        [operation_symbol_1.OperationSymbol.Or, "or"]
      ]);
      function mapOperation(op) {
        op = op.trim();
        for (const e of opMap.entries()) {
          if (e[1] === op) {
            return e[0];
          }
        }
        return operation_symbol_1.OperationSymbol.Unknown;
      }
      function wrapDeconstructionRhs(lhs, rhs, isAssignment) {
        const code = rhs.compile();
        const closeBracket = isAssignment ? ")" : "";
        if (lhs instanceof deconstructed_list_asn_1.DeconstructedListAsn) {
          return `system.deconstructList(${code})`;
        }
        if (lhs instanceof deconstructed_tuple_asn_1.DeconstructedTupleAsn && rhs.symbolType() instanceof class_type_1.ClassType) {
          return `${code}${closeBracket}`;
        }
        return code;
      }
      function wrapDeconstructionLhs(lhs, rhs, isAssignment) {
        const code = lhs.compile();
        const openBracket = isAssignment ? "(" : "";
        if (lhs instanceof deconstructed_list_asn_1.DeconstructedListAsn) {
          return `[${code}]`;
        }
        if (lhs instanceof deconstructed_tuple_asn_1.DeconstructedTupleAsn && rhs.symbolType() instanceof class_type_1.ClassType) {
          return `${openBracket}{${code}}`;
        }
        if (lhs instanceof deconstructed_tuple_asn_1.DeconstructedTupleAsn) {
          return `[${code}]`;
        }
        return code;
      }
      function getIds(ast) {
        if (isAstIdNode(ast)) {
          const id = ast.id;
          return id.includes(",") ? id.split(",") : [id];
        }
        return [];
      }
      function getIndexAndOfType(rootType) {
        if ((0, symbol_helpers_1.isClassType)(rootType) && (0, symbol_helpers_1.isClass)(rootType.scope)) {
          if (rootType.scope.ofTypes.length === 1) {
            return [int_type_1.IntType.Instance, rootType.scope.ofTypes[0]];
          }
          if (rootType.scope.ofTypes.length === 2) {
            return [rootType.scope.ofTypes[0], rootType.scope.ofTypes[1]];
          }
        }
        if ((0, symbol_helpers_1.isGenericSymbolType)(rootType)) {
          return [int_type_1.IntType.Instance, rootType.ofTypes[0]];
        }
        return [unknown_type_1.UnknownType.Instance, unknown_type_1.UnknownType.Instance];
      }
      function wrapSimpleSubscript(code) {
        return `system.safeIndex(${code})`;
      }
      function compileSimpleSubscript(id, rootType, index, prefix, code, postfix, compileErrors, fieldId) {
        const [indexType] = getIndexAndOfType(rootType);
        if (index.index instanceof index_double_asn_1.IndexDoubleAsn) {
          (0, compile_rules_1.mustBeDoubleIndexableType)(id, rootType, true, compileErrors, fieldId);
          (0, compile_rules_1.mustBeAssignableType)(indexType, index.index.index1.symbolType(), compileErrors, fieldId);
          (0, compile_rules_1.mustBeAssignableType)(indexType, index.index.index2.symbolType(), compileErrors, fieldId);
        } else {
          (0, compile_rules_1.mustBeIndexableType)(id, rootType, true, compileErrors, fieldId);
          (0, compile_rules_1.mustBeAssignableType)(indexType, index.index.symbolType(), compileErrors, fieldId);
        }
        return wrapSimpleSubscript(`${prefix}${code}, ${postfix}`);
      }
      function compileNodes(nodes) {
        let result = "";
        if (nodes.length > 0) {
          const ss = [];
          for (const node of nodes) {
            ss.push(node.compile());
          }
          result = ss.join("\r\n");
        }
        return result;
      }
      function isInsideFunction(scope) {
        if (scope instanceof function_asn_1.FunctionAsn) {
          return true;
        }
        if (scope instanceof file_asn_1.FileAsn) {
          return false;
        }
        return isInsideFunction(scope.getParentScope());
      }
      function isInsideFunctionOrConstructor(scope) {
        if (scope instanceof function_asn_1.FunctionAsn) {
          return true;
        }
        if (scope instanceof constructor_asn_1.ConstructorAsn) {
          return true;
        }
        if (scope instanceof file_asn_1.FileAsn) {
          return false;
        }
        return isInsideFunctionOrConstructor(scope.getParentScope());
      }
      function isInsideConstant(scope) {
        if (scope instanceof constant_asn_1.ConstantAsn) {
          return true;
        }
        if (scope instanceof file_asn_1.FileAsn) {
          return false;
        }
        return isInsideConstant(scope.getParentScope());
      }
      function getChildRange(compileChildren, initialScope) {
        const fst = compileChildren[0];
        const fi = compileChildren.indexOf(fst);
        const li = isAstNode(initialScope) ? compileChildren.indexOf(initialScope) : -1;
        return fi < li ? compileChildren.slice(fi, li + 1) : compileChildren.slice(li, fi + 1);
      }
      function childSymbolMatches(compileChildren, id, all, matches, initialScope) {
        let localMatches = [];
        if (compileChildren.length > 0) {
          let range = getChildRange(compileChildren, initialScope);
          if (range.length > 1) {
            range = range.slice(0, range.length - 1);
            const symbols = (0, symbol_helpers_1.handleDeconstruction)(range.filter((r) => (0, symbol_helpers_1.isSymbol)(r)));
            localMatches = localMatches.concat((0, symbol_helpers_1.symbolMatches)(id, all, symbols));
          }
        }
        return localMatches.concat(matches);
      }
      function getChildSymbol(compileChildren, id, initialScope) {
        if (compileChildren.length > 0) {
          let range = getChildRange(compileChildren, initialScope);
          if (range.length > 1) {
            range = range.slice(0, range.length - 1);
            for (const f of range) {
              if ((0, symbol_helpers_1.isSymbol)(f) && id) {
                const sids = (0, symbol_helpers_1.getIdsFromString)(f.symbolId);
                if (sids.includes(id)) {
                  return f;
                }
              }
            }
          }
        }
        return void 0;
      }
    }
  });

  // out/src/compiler/syntax-nodes/globals/tuple-asn.js
  var require_tuple_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/tuple-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TupleAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var TupleAsn = class {
        type;
        scope;
        constructor(type, scope) {
          this.type = type;
          this.scope = scope;
        }
        parseId(id) {
          if (id.startsWith("item") && id.length >= 5) {
            const index = id.slice(4);
            const i = parseInt(index);
            if (!isNaN(i) && i < this.type.ofTypes.length) {
              return [true, i];
            }
          }
          return [false, 0];
        }
        typeToSymbol(id, t) {
          return {
            symbolId: id,
            symbolType: () => t,
            symbolScope: symbol_scope_1.SymbolScope.member,
            isProperty: true
          };
        }
        resolveOwnSymbol(id) {
          const [ok, index] = this.parseId(id);
          if (ok) {
            return this.typeToSymbol(id, this.type.ofTypes[index]);
          }
          return new unknown_symbol_1.UnknownSymbol(id);
        }
        resolveSymbol(id, _scope) {
          const symbol = this.resolveOwnSymbol(id);
          if (symbol instanceof unknown_symbol_1.UnknownSymbol) {
            return this.getParentScope().resolveSymbol(id, this);
          }
          return symbol;
        }
        getParentScope() {
          return this.scope;
        }
        symbolMatches(id, all, _initialScope) {
          const symbols = this.type.ofTypes.map((t, i) => this.typeToSymbol(`item${i}`, t));
          const matches = (0, symbol_helpers_1.symbolMatches)(id, all, symbols);
          return matches;
        }
      };
      exports.TupleAsn = TupleAsn;
    }
  });

  // out/src/compiler/syntax-nodes/globals/procedure-asn.js
  var require_procedure_asn = __commonJS({
    "out/src/compiler/syntax-nodes/globals/procedure-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProcedureAsn = void 0;
      var procedure_type_1 = require_procedure_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_symbol_1 = require_unknown_symbol();
      var compile_rules_1 = require_compile_rules();
      var compound_asn_1 = require_compound_asn();
      var empty_asn_1 = require_empty_asn();
      var param_list_asn_1 = require_param_list_asn();
      var ProcedureAsn = class extends compound_asn_1.CompoundAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        name = empty_asn_1.EmptyAsn.Instance;
        params = empty_asn_1.EmptyAsn.Instance;
        isProcedure = true;
        get symbolId() {
          return (0, compile_rules_1.getId)(this.name);
        }
        symbolType() {
          const [pn, pt] = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.symbolNamesAndTypes() : [[], []];
          return new procedure_type_1.ProcedureType(pn, pt, false, true);
        }
        resolveSymbol(id, initialScope) {
          if ((0, compile_rules_1.getId)(this.name) === id) {
            return this;
          }
          const s = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.resolveSymbol(id, this) : new unknown_symbol_1.UnknownSymbol(id);
          return s instanceof unknown_symbol_1.UnknownSymbol ? super.resolveSymbol(id, initialScope) : s;
        }
        compile() {
          const name = this.name.compile();
          (0, compile_rules_1.mustBeUniqueNameInScope)(name, (0, symbol_helpers_1.getGlobalScope)(this), this.compileErrors, this.fieldId);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${name}(${this.params.compile()}) {\r
${this.breakPoint(this.debugSymbols())}${this.compileChildren()}\r`;
        }
        symbolMatches(id, all, initialScope) {
          const matches = super.symbolMatches(id, all, initialScope);
          const localMatches = this.params instanceof param_list_asn_1.ParamListAsn ? this.params.symbolMatches(id, all, initialScope) : [];
          return localMatches.concat(matches);
        }
      };
      exports.ProcedureAsn = ProcedureAsn;
    }
  });

  // out/src/compiler/syntax-nodes/lambda-asn.js
  var require_lambda_asn = __commonJS({
    "out/src/compiler/syntax-nodes/lambda-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LambdaAsn = void 0;
      var function_type_1 = require_function_type();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var LambdaAsn = class extends abstract_ast_node_1.AbstractAstNode {
        signature;
        body;
        fieldId;
        constructor(signature, body, fieldId) {
          super();
          this.signature = signature;
          this.body = body;
          this.fieldId = fieldId;
        }
        compile() {
          this.compileErrors = [];
          return `async (${this.signature.compile()}) => ${this.body.compile()}`;
        }
        symbolType() {
          const [pn, pt] = this.signature.parameterNamesAndTypes();
          return new function_type_1.FunctionType(pn, pt, this.body.symbolType(), false, true, true);
        }
        toString() {
          return `lambda ${this.signature} => ${this.body}`;
        }
      };
      exports.LambdaAsn = LambdaAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/variable-asn.js
  var require_variable_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/variable-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.VariableAsn = void 0;
      var abstract_definition_asn_1 = require_abstract_definition_asn();
      var VariableAsn = class extends abstract_definition_asn_1.AbstractDefinitionAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        getJsKeyword() {
          return "let";
        }
        isLet() {
          return false;
        }
        isVariable() {
          return true;
        }
      };
      exports.VariableAsn = VariableAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/call-asn.js
  var require_call_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/call-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CallAsn = void 0;
      var procedure_type_1 = require_procedure_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var compile_rules_1 = require_compile_rules();
      var unknown_symbol_1 = require_unknown_symbol();
      var ast_helpers_1 = require_ast_helpers();
      var breakpoint_asn_1 = require_breakpoint_asn();
      var empty_asn_1 = require_empty_asn();
      var param_list_asn_1 = require_param_list_asn();
      var procedure_asn_1 = require_procedure_asn();
      var lambda_asn_1 = require_lambda_asn();
      var qualifier_asn_1 = require_qualifier_asn();
      var let_asn_1 = require_let_asn();
      var variable_asn_1 = require_variable_asn();
      var CallAsn = class extends breakpoint_asn_1.BreakpointAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        proc = empty_asn_1.EmptyAsn.Instance;
        args = empty_asn_1.EmptyAsn.Instance;
        wrapParameters(procSymbol, callParameters) {
          const postFix = (0, symbol_helpers_1.getGlobalScope)(this.scope).getNextId();
          const wrappedInParameters = [];
          const wrappedOutParameters = [];
          const passedParameters = [];
          const parameterDefScopes = procSymbol instanceof procedure_asn_1.ProcedureAsn ? procSymbol.params instanceof param_list_asn_1.ParamListAsn ? procSymbol.params.symbolMatches("", true, this).map((s) => s.symbolScope) : [] : [];
          for (let i = 0; i < callParameters.length; i++) {
            const p = callParameters[i];
            let pName = p.compile();
            const parameterDefScope = i < parameterDefScopes.length ? parameterDefScopes[i] : symbol_scope_1.SymbolScope.parameter;
            if (parameterDefScope === symbol_scope_1.SymbolScope.outParameter) {
              if ((0, ast_helpers_1.isAstIdNode)(p)) {
                const callParamSymbol = this.getParentScope().resolveSymbol(p.id, this);
                if (callParamSymbol instanceof variable_asn_1.VariableAsn || callParamSymbol.symbolScope === symbol_scope_1.SymbolScope.parameter || callParamSymbol.symbolScope === symbol_scope_1.SymbolScope.outParameter) {
                  const tpName = `_${p.id}${postFix}`;
                  wrappedInParameters.push(`let ${tpName} = [${pName}]`);
                  wrappedOutParameters.push(`${pName} = ${tpName}[0]`);
                  pName = tpName;
                } else {
                  const msg = callParamSymbol instanceof let_asn_1.LetAsn ? `let ${p.id}` : p;
                  (0, compile_rules_1.cannotPassAsOutParameter)(msg, this.compileErrors, this.fieldId);
                }
              } else {
                (0, compile_rules_1.cannotPassAsOutParameter)(p, this.compileErrors, this.fieldId);
              }
            }
            passedParameters.push(pName);
          }
          return [wrappedInParameters, wrappedOutParameters, passedParameters];
        }
        compile() {
          this.compileErrors = [];
          const astNode = this.proc;
          const id = (0, ast_helpers_1.isAstIdNode)(astNode) ? astNode.id : "";
          const [updatedQualifier, currentScope] = (0, symbol_helpers_1.updateScopeAndQualifier)(astNode, this);
          let qualifier = updatedQualifier;
          const procSymbol = currentScope.resolveSymbol(id, this);
          (0, compile_rules_1.mustBeKnownSymbol)(procSymbol, currentScope, (0, compile_rules_1.getQualifierId)(qualifier), qualifier.symbolType(), this.compileErrors, this.fieldId);
          (0, compile_rules_1.mustBeProcedure)((0, symbol_helpers_1.displayName)(procSymbol, id), procSymbol.symbolType(), procSymbol.symbolScope, this.compileErrors, this.fieldId);
          if (!(0, symbol_helpers_1.isMemberOnFieldsClass)(procSymbol, this)) {
            (0, compile_rules_1.mustBePublicMember)(procSymbol, this.compileErrors, this.fieldId);
          }
          const procSymbolType = procSymbol.symbolType();
          const parameterList = this.args;
          if ((0, ast_helpers_1.isAstCollectionNode)(parameterList)) {
            let callParameters = parameterList.items;
            let isAsync = false;
            if (procSymbolType instanceof procedure_type_1.ProcedureType) {
              (0, compile_rules_1.mustCallExtensionViaQualifier)(procSymbolType, qualifier, this.compileErrors, this.fieldId);
              (0, compile_rules_1.mustNotCallNonExtensionViaQualifier)(procSymbolType, procSymbol.symbolId, qualifier, currentScope, this.compileErrors, this.fieldId);
              (0, compile_rules_1.mustCallMemberViaQualifier)(id, procSymbolType, currentScope, this.compileErrors, this.fieldId);
              if (procSymbolType.isExtension && qualifier instanceof qualifier_asn_1.QualifierAsn) {
                callParameters = [qualifier.value].concat(callParameters);
                qualifier = empty_asn_1.EmptyAsn.Instance;
              }
              (0, ast_helpers_1.matchParametersAndTypes)(id, procSymbolType, callParameters, this.compileErrors, this.fieldId);
              (0, compile_rules_1.checkForDeprecation)(procSymbolType, currentScope, this.compileErrors, this.fieldId);
              isAsync = procSymbolType.isAsync;
            }
            const [wrappedInParameters, wrappedOutParameters, passedParameters] = this.wrapParameters(procSymbol, callParameters);
            const parms = passedParameters.join(", ");
            const prefix = !(0, ast_helpers_1.isEmptyNode)(qualifier) ? `${qualifier.compile()}` : (0, symbol_helpers_1.scopePrefix)(procSymbol, this.compileErrors, this, this.fieldId);
            const async = isAsync ? "await " : "";
            let wrappedInParms = "";
            let wrappedOutParms = "";
            if (wrappedInParameters.length > 0) {
              wrappedInParms = `${this.indent()}${wrappedInParameters.join("; ")};
`;
            }
            if (wrappedOutParameters.length > 0) {
              wrappedOutParms = `
${this.indent()}${wrappedOutParameters.join("; ")};`;
            }
            (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
            return `${wrappedInParms}${this.indent()}${this.breakPoint(this.debugSymbols())}${async}${prefix}${id}(${parms});${wrappedOutParms}`;
          }
          return "";
        }
        resolveSymbol(id, initialScope) {
          if ((0, ast_helpers_1.isAstCollectionNode)(this.args)) {
            const items = this.args.items;
            const last = items.length > 0 ? items[items.length - 1] : new unknown_symbol_1.UnknownSymbol();
            if (last instanceof lambda_asn_1.LambdaAsn) {
              const ss = last.signature.resolveSymbol(id, initialScope);
              if (!(ss instanceof unknown_symbol_1.UnknownSymbol)) {
                return ss;
              }
            }
          }
          return super.resolveSymbol(id, this);
        }
        symbolMatches(id, all, initialScope) {
          const matches = super.symbolMatches(id, all, this);
          let localMatches = [];
          if ((0, ast_helpers_1.isAstCollectionNode)(this.args)) {
            const items = this.args.items;
            const last = items.length > 0 ? items[items.length - 1] : new unknown_symbol_1.UnknownSymbol();
            if (last instanceof lambda_asn_1.LambdaAsn) {
              localMatches = last.signature.symbolMatches(id, all, initialScope);
            }
          }
          return localMatches.concat(matches);
        }
      };
      exports.CallAsn = CallAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/each-asn.js
  var require_each_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/each-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EachAsn = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_type_1 = require_unknown_type();
      var compile_rules_1 = require_compile_rules();
      var compound_asn_1 = require_compound_asn();
      var empty_asn_1 = require_empty_asn();
      var EachAsn = class extends compound_asn_1.CompoundAsn {
        constructor(fieldId, scope) {
          super(fieldId, scope);
        }
        variable = empty_asn_1.EmptyAsn.Instance;
        iter = empty_asn_1.EmptyAsn.Instance;
        compile() {
          this.compileErrors = [];
          const id = this.variable.compile();
          const symbol = this.scope.resolveSymbol(id, this);
          (0, compile_rules_1.mustNotBeRedefined)(symbol, id, this.compileErrors, this.fieldId);
          const iterType = this.iter.symbolType();
          (0, compile_rules_1.mustBeIterable)(iterType, this.compileErrors, this.fieldId);
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${this.indent()}const _iter${this.fieldId} = [...${this.iter.compile()}];\r
${this.indent()}${this.breakPoint(this.debugSymbols())}for (const ${this.variable.compile()} of _iter${this.fieldId}) {\r
${this.compileChildren()}\r
${this.indent()}}`;
        }
        resolveSymbol(id, initialScope) {
          const v = (0, compile_rules_1.getId)(this.variable);
          if (id === v) {
            const iterSt = this.iter.symbolType();
            const st = (0, symbol_helpers_1.isGenericSymbolType)(iterSt) ? iterSt.ofTypes[0] : unknown_type_1.UnknownType.Instance;
            return {
              symbolId: id,
              symbolType: () => st,
              symbolScope: symbol_scope_1.SymbolScope.counter
            };
          }
          return super.resolveSymbol(id, initialScope);
        }
        symbolMatches(id, all, _initialScope) {
          const matches = super.symbolMatches(id, all, this);
          const v = (0, compile_rules_1.getId)(this.variable);
          const counter = {
            symbolId: v,
            symbolType: () => {
              const iterSt = this.iter.symbolType();
              return (0, symbol_helpers_1.isGenericSymbolType)(iterSt) ? iterSt.ofTypes[0] : unknown_type_1.UnknownType.Instance;
            },
            symbolScope: symbol_scope_1.SymbolScope.counter
          };
          return matches.concat((0, symbol_helpers_1.symbolMatches)(id, all, [counter]));
        }
      };
      exports.EachAsn = EachAsn;
    }
  });

  // out/src/compiler/syntax-nodes/statements/for-asn.js
  var require_for_asn = __commonJS({
    "out/src/compiler/syntax-nodes/statements/for-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ForAsn = void 0;
      var int_type_1 = require_int_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var compile_rules_1 = require_compile_rules();
      var compound_asn_1 = require_compound_asn();
      var empty_asn_1 = require_empty_asn();
      var unary_expr_asn_1 = require_unary_expr_asn();
      var ForAsn = class extends compound_asn_1.CompoundAsn {
        constructor(fieldID, scope) {
          super(fieldID, scope);
        }
        variable = empty_asn_1.EmptyAsn.Instance;
        from = empty_asn_1.EmptyAsn.Instance;
        to = empty_asn_1.EmptyAsn.Instance;
        step = empty_asn_1.EmptyAsn.Instance;
        compile() {
          this.compileErrors = [];
          const v = this.variable.compile();
          const f = this.from.compile();
          const t = this.to.compile();
          let s = this.step.compile();
          const id = this.getParentScope().resolveSymbol(v, this);
          let declare = "";
          if (id instanceof unknown_symbol_1.UnknownSymbol) {
            declare = "let ";
          } else {
            (0, compile_rules_1.mustBeOfSymbolType)(id.symbolType(), int_type_1.IntType.Instance, this.compileErrors, this.fieldId);
          }
          (0, compile_rules_1.mustBeOfSymbolType)(this.from.symbolType(), int_type_1.IntType.Instance, this.compileErrors, this.fieldId);
          (0, compile_rules_1.mustBeOfSymbolType)(this.to.symbolType(), int_type_1.IntType.Instance, this.compileErrors, this.fieldId);
          (0, compile_rules_1.mustBeOfSymbolType)(this.step.symbolType(), int_type_1.IntType.Instance, this.compileErrors, this.fieldId);
          let compare = "<=";
          let incDec = "+";
          if (this.step instanceof unary_expr_asn_1.UnaryExprAsn && this.step.isNegativeOperation()) {
            compare = ">=";
            incDec = "-";
            s = this.step.operand.compile();
          }
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          return `${this.indent()}const _to${this.fieldId} = ${t};\r
${this.indent()}${this.breakPoint(this.debugSymbols())}for (${declare}${v} = ${f}; ${v} ${compare} _to${this.fieldId}; ${v} = ${v} ${incDec} ${s}) {\r
${this.compileChildren()}\r
${this.indent()}}`;
        }
        resolveSymbol(id, initialScope) {
          const v = (0, compile_rules_1.getId)(this.variable);
          if (id === v) {
            const st = this.from.symbolType();
            return {
              symbolId: id,
              symbolType: () => st,
              symbolScope: symbol_scope_1.SymbolScope.counter
            };
          }
          return super.resolveSymbol(id, initialScope);
        }
        symbolMatches(id, all, initialScope) {
          const matches = super.symbolMatches(id, all, initialScope);
          const v = (0, compile_rules_1.getId)(this.variable);
          const counter = {
            symbolId: v,
            symbolType: () => int_type_1.IntType.Instance,
            symbolScope: symbol_scope_1.SymbolScope.counter
          };
          return matches.concat((0, symbol_helpers_1.symbolMatches)(id, all, [counter]));
        }
      };
      exports.ForAsn = ForAsn;
    }
  });

  // out/src/compiler/symbols/symbol-helpers.js
  var require_symbol_helpers = __commonJS({
    "out/src/compiler/symbols/symbol-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.isClass = isClass;
      exports.isGenericClass = isGenericClass;
      exports.isScope = isScope;
      exports.isDeconstructedType = isDeconstructedType;
      exports.isSymbol = isSymbol;
      exports.isGenericSymbolType = isGenericSymbolType;
      exports.isReifyableSymbolType = isReifyableSymbolType;
      exports.isDefinition = isDefinition;
      exports.isConstant = isConstant;
      exports.isProperty = isProperty;
      exports.isMember = isMember;
      exports.isEnum = isEnum;
      exports.isCall = isCall;
      exports.isListImmutableType = isListImmutableType;
      exports.isListType = isListType;
      exports.isClassType = isClassType;
      exports.isNumber = isNumber;
      exports.isFunctionType = isFunctionType;
      exports.isInsideClass = isInsideClass;
      exports.isPublicMember = isPublicMember;
      exports.isEnumValue = isEnumValue;
      exports.isOutParameter = isOutParameter;
      exports.isParameter = isParameter;
      exports.isVariable = isVariable;
      exports.isLet = isLet;
      exports.isIndexableType = isIndexableType;
      exports.isDoubleIndexableType = isDoubleIndexableType;
      exports.isIterableType = isIterableType;
      exports.isKnownType = isKnownType;
      exports.isDefinitionScope = isDefinitionScope;
      exports.isValueType = isValueType;
      exports.isProcedure = isProcedure;
      exports.isFunction = isFunction;
      exports.isPureFunction = isPureFunction;
      exports.isSystemFunction = isSystemFunction;
      exports.isTypeName = isTypeName;
      exports.isAbstractClass = isAbstractClass;
      exports.isNotInheritableClass = isNotInheritableClass;
      exports.isConcreteTypeName = isConcreteTypeName;
      exports.isAbstractTypeName = isAbstractTypeName;
      exports.isNotInheritableTypeName = isNotInheritableTypeName;
      exports.isId = isId;
      exports.isPossibleExtensionForType = isPossibleExtensionForType;
      exports.isMemberOnFieldsClass = isMemberOnFieldsClass;
      exports.scopePrefix = scopePrefix;
      exports.updateScopeAndQualifier = updateScopeAndQualifier;
      exports.updateScopeInChain = updateScopeInChain;
      exports.getGlobalScope = getGlobalScope;
      exports.getClassScope = getClassScope;
      exports.matchType = matchType;
      exports.firstCharIsUpper = firstCharIsUpper;
      exports.matchingSymbolsWithQualifier = matchingSymbolsWithQualifier;
      exports.orderSymbol = orderSymbol;
      exports.updateScope = updateScope;
      exports.getDeconstructionIds = getDeconstructionIds;
      exports.symbolMatches = symbolMatches;
      exports.symbolScopeToFriendlyName = symbolScopeToFriendlyName;
      exports.parameterNamesWithTypes = parameterNamesWithTypes;
      exports.parameterNames = parameterNames;
      exports.allScopedSymbols = allScopedSymbols;
      exports.getIdsFromString = getIdsFromString;
      exports.handleDeconstruction = handleDeconstruction;
      exports.mostPreciseSymbol = mostPreciseSymbol;
      exports.allPropertiesInScope = allPropertiesInScope;
      exports.mapSymbolType = mapSymbolType;
      exports.displayName = displayName;
      var type_options_1 = require_type_options();
      var elan_compiler_error_1 = require_elan_compiler_error();
      var keywords_1 = require_keywords();
      var ast_helpers_1 = require_ast_helpers();
      var empty_asn_1 = require_empty_asn();
      var enum_asn_1 = require_enum_asn();
      var tuple_asn_1 = require_tuple_asn();
      var abstract_definition_asn_1 = require_abstract_definition_asn();
      var call_asn_1 = require_call_asn();
      var definition_adapter_1 = require_definition_adapter();
      var each_asn_1 = require_each_asn();
      var for_asn_1 = require_for_asn();
      var boolean_type_1 = require_boolean_type();
      var class_type_1 = require_class_type();
      var deconstructed_list_type_1 = require_deconstructed_list_type();
      var deconstructed_record_type_1 = require_deconstructed_record_type();
      var deconstructed_tuple_type_1 = require_deconstructed_tuple_type();
      var elan_type_names_1 = require_elan_type_names();
      var enum_type_1 = require_enum_type();
      var enum_value_type_1 = require_enum_value_type();
      var float_type_1 = require_float_type();
      var function_type_1 = require_function_type();
      var generic_parameter_type_1 = require_generic_parameter_type();
      var int_type_1 = require_int_type();
      var null_scope_1 = require_null_scope();
      var procedure_type_1 = require_procedure_type();
      var regexp_type_1 = require_regexp_type();
      var string_type_1 = require_string_type();
      var symbol_scope_1 = require_symbol_scope();
      var tuple_type_1 = require_tuple_type();
      var unknown_symbol_1 = require_unknown_symbol();
      var unknown_type_1 = require_unknown_type();
      function isClass(s) {
        return !!s && "isClass" in s;
      }
      function isGenericClass(s) {
        return isClass(s) && s.ofTypes?.length > 0;
      }
      function isScope(s) {
        return !!s && "resolveSymbol" in s && "getParentScope" in s;
      }
      function isDeconstructedType(s) {
        return !!s && "symbolTypeFor" in s;
      }
      function isSymbol(s) {
        return !!s && "symbolId" in s && "symbolType" in s;
      }
      function isGenericSymbolType(s) {
        return !!s && "ofTypes" in s;
      }
      function isReifyableSymbolType(s) {
        return !!s && "reify" in s;
      }
      function isDefinition(s) {
        return !!s && "isLet" in s && "isVariable" in s;
      }
      function isConstant(s) {
        return !!s && "isConstant" in s;
      }
      function isProperty(s) {
        return !!s && "isProperty" in s;
      }
      function isMember(s) {
        return !!s && "isMember" in s;
      }
      function isEnum(s) {
        return s instanceof enum_asn_1.EnumAsn;
      }
      function isCall(s) {
        return s instanceof call_asn_1.CallAsn;
      }
      function isListImmutableType(s) {
        return s instanceof class_type_1.ClassType && s.className === elan_type_names_1.ListImmutableName;
      }
      function isListType(s) {
        return s instanceof class_type_1.ClassType && s.className === elan_type_names_1.ListName;
      }
      function isClassType(s) {
        return s instanceof class_type_1.ClassType;
      }
      function isNumber(s) {
        return s instanceof int_type_1.IntType || s instanceof float_type_1.FloatType;
      }
      function isFunctionType(s) {
        return s instanceof function_type_1.FunctionType;
      }
      function isInsideClass(scope) {
        return getClassScope(scope) !== null_scope_1.NullScope.Instance;
      }
      function isPublicMember(s) {
        return isMember(s) && !s.private;
      }
      function isEnumValue(s) {
        return s?.symbolType() instanceof enum_value_type_1.EnumValueType;
      }
      function isOutParameter(s) {
        return s?.symbolScope === symbol_scope_1.SymbolScope.outParameter;
      }
      function isParameter(s) {
        return s?.symbolScope === symbol_scope_1.SymbolScope.parameter;
      }
      function isVariable(s) {
        return isDefinition(s) && s.isVariable();
      }
      function isLet(s) {
        return isDefinition(s) && s.isLet();
      }
      function isIndexableType(s) {
        return !!s?.typeOptions.isIndexable;
      }
      function isDoubleIndexableType(s) {
        return !!s?.typeOptions.isDoubleIndexable;
      }
      function isIterableType(s) {
        return !!s?.typeOptions.isIterable;
      }
      function isKnownType(s) {
        return !(s instanceof unknown_type_1.UnknownType);
      }
      function isDefinitionScope(s) {
        return s instanceof abstract_definition_asn_1.AbstractDefinitionAsn || s instanceof each_asn_1.EachAsn || s instanceof for_asn_1.ForAsn;
      }
      function isValueType(type) {
        return type instanceof int_type_1.IntType || type instanceof float_type_1.FloatType || type instanceof boolean_type_1.BooleanType || type instanceof string_type_1.StringType || type instanceof enum_type_1.EnumType || type instanceof regexp_type_1.RegExpType;
      }
      function isProcedure(s) {
        return s.symbolType() instanceof procedure_type_1.ProcedureType;
      }
      function isFunction(s) {
        return isSymbol(s) && s.symbolType() instanceof function_type_1.FunctionType;
      }
      function isPureFunction(s) {
        if (isFunction(s)) {
          const ft = s.symbolType();
          return ft instanceof function_type_1.FunctionType && ft.isPure;
        }
        return false;
      }
      function isSystemFunction(s) {
        if (isFunction(s)) {
          const ft = s.symbolType();
          return ft instanceof function_type_1.FunctionType && !ft.isPure;
        }
        return false;
      }
      function isTypeName(s) {
        return firstCharIsUpper(s?.symbolId ?? "");
      }
      function isAbstractClass(s) {
        return isClass(s) && s.isAbstract;
      }
      function isNotInheritableClass(s) {
        return isClass(s) && s.isNotInheritable;
      }
      function isConcreteTypeName(s) {
        return isTypeName(s) && !isAbstractClass(s);
      }
      function isAbstractTypeName(s) {
        return isTypeName(s) && isAbstractClass(s) && !isNotInheritableClass(s);
      }
      function isNotInheritableTypeName(s) {
        return isTypeName(s) && isAbstractClass(s) && isNotInheritableClass(s);
      }
      function isId(f) {
        return isConstant(f) || isLet(f) || isVariable(f) || isParameter(f) || isOutParameter(f) || isProperty(f) || isEnumValue(f);
      }
      function isNotFuncOrProcOrType(s) {
        const st = s.symbolType();
        return !(st instanceof function_type_1.FunctionType || st instanceof procedure_type_1.ProcedureType || firstCharIsUpper(s.symbolId));
      }
      function isPossibleExtensionForType(actualType, procType) {
        if (procType.parameterTypes.length > 0) {
          const firstParmType = procType.parameterTypes[0];
          return matchType(actualType, firstParmType);
        }
        return false;
      }
      function isMemberOnFieldsClass(s, scope) {
        const currentClass = getClassScope(scope);
        const matchingMember = currentClass.resolveSymbol(s.symbolId, scope);
        return isMember(s) && isMember(matchingMember) && s.getClass() === matchingMember.getClass();
      }
      function scopePrefix(symbol, _compileErors, scope, _location) {
        if (symbol.symbolScope === symbol_scope_1.SymbolScope.stdlib) {
          return `_stdlib.`;
        }
        if (isConstant(symbol) && symbol.symbolScope === symbol_scope_1.SymbolScope.program) {
          return isConstant(scope) ? "this." : "global.";
        }
        if (symbol.symbolScope === symbol_scope_1.SymbolScope.member) {
          return `this.`;
        }
        if (isFunction(symbol) && symbol.symbolScope === symbol_scope_1.SymbolScope.program) {
          return "global.";
        }
        return "";
      }
      function internalUpdateScopeAndQualifier(qualifierScope, currentScope, value, qualifier) {
        if (qualifierScope instanceof class_type_1.ClassType) {
          const classSymbol = currentScope.resolveSymbol(qualifierScope.className, currentScope);
          currentScope = isScope(classSymbol) ? classSymbol : currentScope;
          if (isClass(currentScope)) {
            if (isClass(qualifierScope.scope)) {
              currentScope = currentScope.updateOfTypes(qualifierScope.scope.ofTypes);
            }
          }
        } else if (qualifierScope instanceof tuple_type_1.TupleType) {
          currentScope = new tuple_asn_1.TupleAsn(qualifierScope, currentScope);
        } else if ((0, ast_helpers_1.isAstIdNode)(value) && value.id === keywords_1.libraryKeyword) {
          currentScope = getGlobalScope(currentScope).libraryScope;
          qualifier = empty_asn_1.EmptyAsn.Instance;
        } else if ((0, ast_helpers_1.isAstIdNode)(value) && value.id === keywords_1.globalKeyword) {
          currentScope = getGlobalScope(currentScope);
        } else if (!(0, ast_helpers_1.isEmptyNode)(qualifier)) {
          currentScope = getGlobalScope(currentScope).libraryScope;
        } else {
          currentScope = currentScope.getParentScope();
        }
        return [qualifier, currentScope];
      }
      function updateScopeAndQualifier(rootNode, currentScope) {
        const qualifier = (0, ast_helpers_1.isAstQualifiedNode)(rootNode) ? rootNode.qualifier : empty_asn_1.EmptyAsn.Instance;
        const qualifierScope = qualifier.symbolType();
        const value = qualifier.value;
        return internalUpdateScopeAndQualifier(qualifierScope, currentScope, value, qualifier);
      }
      function updateScopeInChain(qualifier, currentScope) {
        const qualifierScope = qualifier?.symbolType();
        const [, newScope] = internalUpdateScopeAndQualifier(qualifierScope, currentScope, qualifier, qualifier);
        return newScope;
      }
      function getGlobalScope(start) {
        if (start instanceof null_scope_1.NullScope) {
          throw new elan_compiler_error_1.ElanCompilerError("Global scope not found");
        }
        if ((0, ast_helpers_1.isRootNode)(start)) {
          return start;
        }
        return getGlobalScope(start.getParentScope());
      }
      function getClassScope(start) {
        if (start instanceof null_scope_1.NullScope) {
          return start;
        }
        if (isClass(start)) {
          return start;
        }
        return getClassScope(start.getParentScope());
      }
      function matchType(actualType, paramType) {
        if (paramType.name === actualType.name) {
          return true;
        }
        if (paramType instanceof generic_parameter_type_1.GenericParameterType) {
          return true;
        }
        if (paramType instanceof class_type_1.ClassType) {
          return paramType.isAssignableFrom(actualType);
        }
        return false;
      }
      function firstCharIsUpper(s) {
        const firstChar = s[0] ?? "";
        return firstChar.toUpperCase() === firstChar;
      }
      function matchingSymbolsWithQualifier(propId, qualId, scope) {
        const qual = scope.resolveSymbol(qualId, scope);
        if (qual instanceof unknown_symbol_1.UnknownSymbol) {
          return [];
        }
        let qualSt = qual.symbolType();
        if (isFunctionType(qualSt)) {
          qualSt = qualSt.returnType;
        }
        let qualifiedSymbols = [];
        if (qualSt instanceof class_type_1.ClassType) {
          const cls = getGlobalScope(scope).resolveSymbol(qualSt.className, scope);
          if (isClass(cls)) {
            qualifiedSymbols = cls.symbolMatches(propId, !propId, null_scope_1.NullScope.Instance).filter((s) => isPublicMember(s));
          }
        }
        if (qualSt instanceof enum_type_1.EnumType) {
          const en = getGlobalScope(scope).resolveSymbol(qualSt.name, scope);
          if (isEnum(en)) {
            qualifiedSymbols = en.symbolMatches(propId, !propId, null_scope_1.NullScope.Instance);
          }
        }
        if (qualSt instanceof tuple_type_1.TupleType) {
          qualifiedSymbols = new tuple_asn_1.TupleAsn(qualSt, scope).symbolMatches(propId, !propId, null_scope_1.NullScope.Instance);
        }
        const allExtensions = getGlobalScope(scope).libraryScope.symbolMatches(propId, !propId, null_scope_1.NullScope.Instance).filter((s) => {
          const st = s.symbolType();
          return (st instanceof procedure_type_1.ProcedureType || st instanceof function_type_1.FunctionType) && st.isExtension && isPossibleExtensionForType(qualSt, st);
        });
        return qualifiedSymbols.concat(allExtensions);
      }
      function orderSymbol(s1, s2) {
        return s1.symbolId.localeCompare(s2.symbolId);
      }
      function updateScope(qualifier, originalScope) {
        let currentScope = originalScope;
        const classScope = qualifier.symbolType();
        if (classScope instanceof class_type_1.ClassType) {
          const classSymbol = originalScope.resolveSymbol(classScope.className, originalScope);
          currentScope = isScope(classSymbol) ? classSymbol : originalScope;
        } else {
          currentScope = originalScope.getParentScope();
        }
        return currentScope;
      }
      function getDeconstructionIds(sid) {
        if (sid.includes(",")) {
          return sid.split(",").map((s) => s.trim());
        }
        if (sid.includes(":")) {
          return sid.split(":").map((s) => s.trim());
        }
        return [sid];
      }
      function fixCase(id, s) {
        let sid = s.symbolId;
        if (!hasAnyUpperCase(id)) {
          id = id.toUpperCase();
          sid = sid.toUpperCase();
        }
        return [id, sid];
      }
      function matchStart(i, s) {
        const [id, sid] = fixCase(i, s);
        return sid.startsWith(id);
      }
      function hasAnyUpperCase(id) {
        return Array.from(id).filter((c) => c.toUpperCase() === c).length > 0;
      }
      function matchIncludes(i, s) {
        const [id, sid] = fixCase(i, s);
        return sid.includes(id);
      }
      function symbolMatches(id, all, symbols) {
        if (all) {
          return symbols;
        }
        const sw = symbols.filter((s) => matchStart(id, s));
        let inc = [];
        const limit = 1;
        if (id.length >= limit) {
          inc = symbols.filter((s) => !sw.includes(s)).filter((s) => matchIncludes(id, s));
        }
        return sw.concat(inc);
      }
      function symbolScopeToFriendlyName(ss) {
        switch (ss) {
          case symbol_scope_1.SymbolScope.member:
            return "property";
          case symbol_scope_1.SymbolScope.parameter:
          case symbol_scope_1.SymbolScope.outParameter:
            return "parameter";
          default:
            return "identifier";
        }
      }
      function parameterNamesWithTypes(st, actualTypes) {
        if (st instanceof procedure_type_1.ProcedureType || st instanceof function_type_1.FunctionType) {
          const parameterNames2 = st.isExtension ? st.parameterNames.slice(1) : st.parameterNames;
          let parameterTypes = actualTypes ? actualTypes : st.parameterTypes;
          parameterTypes = st.isExtension ? parameterTypes.slice(1) : parameterTypes;
          const descriptions = parameterNames2.map((n, i) => `${n} (${parameterTypes[i].name})`);
          return descriptions;
        }
        return [];
      }
      function parameterNames(st) {
        if (st instanceof procedure_type_1.ProcedureType || st instanceof function_type_1.FunctionType) {
          const parameterNames2 = st.isExtension ? st.parameterNames.slice(1) : st.parameterNames;
          const descriptions = parameterNames2.map((n) => `${n}`);
          return descriptions;
        }
        return [];
      }
      function allScopedSymbols(scope, initialScope) {
        return scope.symbolMatches("", true, initialScope).filter((s) => isNotFuncOrProcOrType(s));
      }
      function getIdsFromString(sid) {
        if (sid.includes(",")) {
          return sid.split(",").map((s) => s.trim());
        }
        if (sid.includes(":")) {
          return sid.split(":").map((s) => s.trim());
        }
        return [sid];
      }
      function handleDeconstruction(ss) {
        const newSymbols = [];
        for (const s of ss) {
          const ids = getDeconstructionIds(s.symbolId);
          if (ids.length === 1) {
            newSymbols.push(s);
          } else {
            for (let i = 0; i < ids.length; i++) {
              newSymbols.push(new definition_adapter_1.DefinitionAdapter(s, i));
            }
          }
        }
        return newSymbols;
      }
      function mostPreciseSymbol(lhs, rhs) {
        if (lhs instanceof float_type_1.FloatType || rhs instanceof float_type_1.FloatType) {
          return float_type_1.FloatType.Instance;
        }
        return lhs;
      }
      function allPropertiesInScope(scope) {
        const all = scope.symbolMatches("", true, scope);
        return all.filter((s) => isProperty(s));
      }
      function mapSymbolType(ids, st) {
        if (ids.length > 1 && st instanceof tuple_type_1.TupleType) {
          return new deconstructed_tuple_type_1.DeconstructedTupleType(ids, st.ofTypes);
        }
        if (ids.length > 1 && st instanceof class_type_1.ClassType && (0, type_options_1.isRecord)(st.typeOptions)) {
          return new deconstructed_record_type_1.DeconstructedRecordType(ids, st.scope);
        }
        if (ids.length === 2 && st instanceof class_type_1.ClassType && st.typeOptions.isIterable) {
          return new deconstructed_list_type_1.DeconstructedListType(ids[0], ids[1], st.ofTypes[0], st);
        }
        return st;
      }
      function displayName(symbol, id) {
        const type = symbol.symbolType();
        if (isDeconstructedType(type)) {
          return id;
        }
        return symbol.symbolId;
      }
    }
  });

  // out/src/compiler/symbols/class-type.js
  var require_class_type = __commonJS({
    "out/src/compiler/symbols/class-type.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ClassType = exports.ClassSubType = void 0;
      var float_type_1 = require_float_type();
      var int_type_1 = require_int_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var ClassSubType;
      (function(ClassSubType2) {
        ClassSubType2[ClassSubType2["concrete"] = 0] = "concrete";
        ClassSubType2[ClassSubType2["abstract"] = 1] = "abstract";
        ClassSubType2[ClassSubType2["interface"] = 2] = "interface";
      })(ClassSubType || (exports.ClassSubType = ClassSubType = {}));
      var ClassType = class _ClassType {
        className;
        subType;
        isNotInheritable;
        typeOptions;
        inheritsFrom;
        scope;
        constructor(className, subType, isNotInheritable, typeOptions, inheritsFrom, scope) {
          this.className = className;
          this.subType = subType;
          this.isNotInheritable = isNotInheritable;
          this.typeOptions = typeOptions;
          this.inheritsFrom = inheritsFrom;
          this.scope = scope;
        }
        get ofTypes() {
          return (0, symbol_helpers_1.isClass)(this.scope) ? this.scope.ofTypes : [];
        }
        get deprecated() {
          return (0, symbol_helpers_1.isClass)(this.scope) ? this.scope.deprecated : void 0;
        }
        reify(gts) {
          if ((0, symbol_helpers_1.isClass)(this.scope)) {
            const cls = this.scope.updateOfTypes(gts);
            return new _ClassType(this.className, this.subType, this.isNotInheritable, this.typeOptions, this.inheritsFrom, cls);
          }
          return this;
        }
        updateFrom(other) {
          this.className = other.className;
          this.isNotInheritable = other.isNotInheritable;
          this.typeOptions = other.typeOptions;
          this.inheritsFrom = other.inheritsFrom;
          this.scope = other.scope;
          return this;
        }
        symbolMatches(id, all) {
          const symbols = this.scope.getChildren().filter((f) => (0, symbol_helpers_1.isSymbol)(f));
          return (0, symbol_helpers_1.symbolMatches)(id, all, symbols);
        }
        typeMatch(t1, t2) {
          if (t1 instanceof float_type_1.FloatType && t2 instanceof int_type_1.IntType) {
            return true;
          }
          return t1.name === t2.name;
        }
        isAssignableFrom(otherType) {
          if (otherType instanceof _ClassType) {
            if (otherType.className === this.className) {
              if (this.ofTypes.length === otherType.ofTypes.length) {
                return this.ofTypes.length === 0 ? true : this.ofTypes.every((t, i) => this.typeMatch(t, otherType.ofTypes[i]));
              }
              return false;
            }
            return otherType.inheritsFrom.some((c) => this.isAssignableFrom(c));
          }
          return false;
        }
        getParentScope() {
          return this.scope;
        }
        childSymbols() {
          return this.scope.getChildren().filter((c) => (0, symbol_helpers_1.isSymbol)(c));
        }
        resolveSymbol(id, scope) {
          return this.scope.resolveSymbol(id, scope);
        }
        get name() {
          if (this.ofTypes.length === 1) {
            return `${this.className.trim()}<of ${this.ofTypes[0].name}>`;
          }
          if (this.ofTypes.length === 2) {
            return `${this.className.trim()}<of ${this.ofTypes[0].name}, ${this.ofTypes[1].name}>`;
          }
          return `${this.className.trim()}`;
        }
        toString() {
          return `${this.className.trim()}`;
        }
        get initialValue() {
          const isStdLib = this.scope.symbolScope === symbol_scope_1.SymbolScope.stdlib;
          const prefix = isStdLib ? "system.initialise(_stdlib." : "";
          const postfix = isStdLib ? ")" : "";
          return `${prefix}${this.className}.emptyInstance()${postfix}`;
        }
      };
      exports.ClassType = ClassType;
    }
  });

  // out/src/compiler/symbols/stdlib-class.js
  var require_stdlib_class = __commonJS({
    "out/src/compiler/symbols/stdlib-class.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StdLibClass = void 0;
      var keywords_1 = require_keywords();
      var ast_helpers_1 = require_ast_helpers();
      var class_type_1 = require_class_type();
      var duplicate_symbol_1 = require_duplicate_symbol();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var StdLibClass = class _StdLibClass {
        name;
        isNotInheritable;
        typeOptions;
        children;
        ofTypes;
        inheritTypes;
        scope;
        deprecated;
        constructor(name, isNotInheritable, typeOptions, children, ofTypes, inheritTypes, scope, deprecated) {
          this.name = name;
          this.isNotInheritable = isNotInheritable;
          this.typeOptions = typeOptions;
          this.children = children;
          this.ofTypes = ofTypes;
          this.inheritTypes = inheritTypes;
          this.scope = scope;
          this.deprecated = deprecated;
          this.symbolId = this.name;
        }
        get isAbstract() {
          return this.typeOptions.isAbstract;
        }
        updateOfTypes(ofTypes) {
          const newOfTypes = [...this.ofTypes];
          const lessOf = newOfTypes.length > ofTypes.length ? ofTypes.length : newOfTypes.length;
          for (let i = 0; i < lessOf; i++) {
            newOfTypes[i] = ofTypes[i];
          }
          return new _StdLibClass(this.name, this.isNotInheritable, this.typeOptions, this.children, newOfTypes, this.inheritTypes, this.scope, this.deprecated);
        }
        getDirectSuperClassesTypeAndName() {
          if (this.inheritTypes.length > 0) {
            const typeAndName = this.inheritTypes.filter((c) => c instanceof class_type_1.ClassType).map((c) => [c, c.className]);
            return typeAndName;
          }
          return [];
        }
        isClass = true;
        symbolId;
        symbolType() {
          return new class_type_1.ClassType(this.name, this.typeOptions.isAbstract ? class_type_1.ClassSubType.abstract : class_type_1.ClassSubType.concrete, this.isNotInheritable, this.typeOptions, this.inheritTypes, this);
        }
        symbolScope = symbol_scope_1.SymbolScope.stdlib;
        getChildren() {
          return this.children;
        }
        resolveOwnSymbol(id) {
          if (id === keywords_1.thisKeyword) {
            return this;
          }
          const matches = this.getChildren().filter((f) => (0, symbol_helpers_1.isSymbol)(f) && f.symbolId === id);
          if (matches.length === 1) {
            return matches[0];
          }
          if (matches.length > 1) {
            return new duplicate_symbol_1.DuplicateSymbol(matches);
          }
          const types = this.inheritTypes.filter((t) => t instanceof class_type_1.ClassType);
          for (const ct of types) {
            const s = ct.scope.resolveOwnSymbol(id);
            if ((0, symbol_helpers_1.isMember)(s)) {
              matches.push(s);
            }
          }
          if (matches.length === 1) {
            return matches[0];
          }
          if (matches.length > 1) {
            return new duplicate_symbol_1.DuplicateSymbol(matches);
          }
          return new unknown_symbol_1.UnknownSymbol(id);
        }
        resolveSymbol(id, _scope) {
          const symbol = this.resolveOwnSymbol(id);
          if (symbol instanceof unknown_symbol_1.UnknownSymbol) {
            return this.getParentScope().resolveSymbol(id, this);
          }
          if (!(0, symbol_helpers_1.isProperty)(symbol)) {
            const st = symbol.symbolType();
            const matches = /* @__PURE__ */ new Map();
            this.ofTypes.forEach((t, i) => matches.set(`T${i + 1}`, t));
            const st1 = (0, ast_helpers_1.generateType)(st, matches);
            let reifiedSymbol;
            if ((0, symbol_helpers_1.isMember)(symbol)) {
              reifiedSymbol = {
                symbolId: symbol.symbolId,
                symbolType: () => st1,
                symbolScope: symbol.symbolScope,
                isMember: symbol.isMember,
                private: symbol.private,
                isAbstract: symbol.isAbstract,
                getClass: symbol.getClass
              };
            } else {
              reifiedSymbol = {
                symbolId: symbol.symbolId,
                symbolType: () => st1,
                symbolScope: symbol.symbolScope
              };
            }
            return reifiedSymbol;
          }
          return symbol;
        }
        getParentScope() {
          return this.scope;
        }
        symbolMatches(id, all, _initialScope) {
          let otherMatches = this.getParentScope().symbolMatches(id, all, this);
          for (const inherited of this.inheritTypes) {
            if (inherited instanceof class_type_1.ClassType) {
              const m = inherited.symbolMatches(id, all);
              otherMatches = otherMatches.concat(m);
            }
          }
          const symbols = this.getChildren().filter((f) => (0, symbol_helpers_1.isSymbol)(f));
          const matches = (0, symbol_helpers_1.symbolMatches)(id, all, symbols);
          return matches.concat(otherMatches);
        }
      };
      exports.StdLibClass = StdLibClass;
    }
  });

  // out/src/compiler/elan-type-annotations.js
  var require_elan_type_annotations = __commonJS({
    "out/src/compiler/elan-type-annotations.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MemberType = exports.ClassOption = exports.ProcedureOptions = exports.FunctionOptions = exports.ElanT2 = exports.ElanT1 = exports.ElanRegExp = exports.ElanBoolean = exports.ElanString = exports.ElanFloat = exports.ElanInt = exports.TypescriptTypeDescriptor = exports.ElanClassNameTypeDescriptor = exports.ElanClassTypeDescriptor = exports.ElanTupleTypeDescriptor = exports.ElanFuncTypeDescriptor = exports.ElanGenericTypeDescriptor = exports.ElanValueTypeDescriptor = exports.ElanSignatureDescriptor = exports.ElanFunctionDescriptor = exports.ElanClassDescriptor = exports.ElanProcedureDescriptor = exports.nameToTypeMap = void 0;
      exports.stdlibClassUniqueId = stdlibClassUniqueId;
      exports.elanFunction = elanFunction;
      exports.elanProcedure = elanProcedure;
      exports.elanMethod = elanMethod;
      exports.elanClass = elanClass;
      exports.elanConstant = elanConstant;
      exports.elanProperty = elanProperty;
      exports.elanClassExport = elanClassExport;
      exports.elanType = elanType;
      exports.elanDeprecated = elanDeprecated;
      exports.ElanT1Constrained = ElanT1Constrained;
      exports.ElanT2Constrained = ElanT2Constrained;
      exports.ElanClass = ElanClass;
      exports.ElanClassName = ElanClassName;
      exports.ElanTuple = ElanTuple;
      exports.ElanFunc = ElanFunc;
      exports.elanIntType = elanIntType;
      exports.elanFloatType = elanFloatType;
      exports.elanStringType = elanStringType;
      exports.elanBooleanType = elanBooleanType;
      exports.elanRegexType = elanRegexType;
      exports.elanGenericParamT1Type = elanGenericParamT1Type;
      exports.elanGenericParamT2Type = elanGenericParamT2Type;
      exports.elanTupleType = elanTupleType;
      exports.elanFuncType = elanFuncType;
      exports.elanClassType = elanClassType;
      exports.getSymbol = getSymbol;
      exports.getConstantSymbol = getConstantSymbol;
      var elan_type_interfaces_1 = require_elan_type_interfaces();
      var type_options_1 = require_type_options();
      var elan_compiler_error_1 = require_elan_compiler_error();
      var keywords_1 = require_keywords();
      var boolean_type_1 = require_boolean_type();
      var class_type_1 = require_class_type();
      var elan_type_names_1 = require_elan_type_names();
      var float_type_1 = require_float_type();
      var function_type_1 = require_function_type();
      var generic_parameter_type_1 = require_generic_parameter_type();
      var int_type_1 = require_int_type();
      var procedure_type_1 = require_procedure_type();
      var regexp_type_1 = require_regexp_type();
      var stdlib_class_1 = require_stdlib_class();
      var string_type_1 = require_string_type();
      var symbol_scope_1 = require_symbol_scope();
      var tuple_type_1 = require_tuple_type();
      var unknown_type_1 = require_unknown_type();
      exports.nameToTypeMap = /* @__PURE__ */ new Map();
      var StdLibClassCache = /* @__PURE__ */ new Map();
      function stdlibClassUniqueId(name, ofTypes) {
        const fullName = [name];
        for (const st of ofTypes ?? []) {
          fullName.push(st.name);
        }
        return fullName.join("_");
      }
      var ElanProcedureDescriptor = class {
        isExtension;
        isAsync;
        constructor(isExtension = false, isAsync = false) {
          this.isExtension = isExtension;
          this.isAsync = isAsync;
        }
        isProcedure = true;
        isPure = false;
        parameterTypes = [];
        parameterNames = [];
        deprecated;
        mapType(scope) {
          const parameterTypes = this.parameterTypes;
          return new procedure_type_1.ProcedureType(this.parameterNames, parameterTypes.map((t) => t.mapType(scope)), this.isExtension, this.isAsync, this.deprecated);
        }
      };
      exports.ElanProcedureDescriptor = ElanProcedureDescriptor;
      var ElanClassDescriptor = class {
        typeOptions;
        ofTypes;
        parameterNames;
        parameterTypes;
        inherits;
        alias;
        constructor(typeOptions = type_options_1.noTypeOptions, ofTypes = [], parameterNames = [], parameterTypes = [], inherits = [], alias) {
          this.typeOptions = typeOptions;
          this.ofTypes = ofTypes;
          this.parameterNames = parameterNames;
          this.parameterTypes = parameterTypes;
          this.inherits = inherits;
          this.alias = alias;
        }
        deprecated;
        mapType(scope) {
          const parameterTypes = this.parameterTypes;
          return new procedure_type_1.ProcedureType(this.parameterNames, parameterTypes.map((t) => t.mapType(scope)), false, false);
        }
      };
      exports.ElanClassDescriptor = ElanClassDescriptor;
      var ElanFunctionDescriptor = class {
        isExtension;
        isPure;
        isAsync;
        returnType;
        constructor(isExtension = false, isPure = true, isAsync = false, returnType) {
          this.isExtension = isExtension;
          this.isPure = isPure;
          this.isAsync = isAsync;
          this.returnType = returnType;
        }
        isFunction = true;
        parameterTypes = [];
        parameterNames = [];
        deprecated;
        mapType(scope) {
          const retType = this.returnType;
          const parameterTypes = this.parameterTypes;
          return new function_type_1.FunctionType(this.parameterNames, parameterTypes.map((t) => t.mapType(scope)), retType.mapType(scope), this.isExtension, this.isPure, this.isAsync, this.deprecated);
        }
      };
      exports.ElanFunctionDescriptor = ElanFunctionDescriptor;
      var ElanSignatureDescriptor = class {
        isPure = false;
        isExtension = false;
        isAsync = false;
        parameterNames = [];
        parameterTypes = [];
        returnType;
      };
      exports.ElanSignatureDescriptor = ElanSignatureDescriptor;
      var ElanValueTypeDescriptor = class {
        name;
        ofType;
        valueType;
        constructor(name, ofType, valueType) {
          this.name = name;
          this.ofType = ofType;
          this.valueType = valueType;
        }
        isConstant = true;
        mapType(_scope) {
          switch (this.name) {
            case elan_type_names_1.FloatName:
              return float_type_1.FloatType.Instance;
            case elan_type_names_1.StringName:
              return string_type_1.StringType.Instance;
            case elan_type_names_1.IntName:
              return int_type_1.IntType.Instance;
            case elan_type_names_1.BooleanName:
              return boolean_type_1.BooleanType.Instance;
            case elan_type_names_1.RegExpName:
              return regexp_type_1.RegExpType.Instance;
          }
          throw new Error("NotImplemented: " + this.name);
        }
      };
      exports.ElanValueTypeDescriptor = ElanValueTypeDescriptor;
      var ElanGenericTypeDescriptor = class {
        name;
        constraint;
        constructor(name, constraint) {
          this.name = name;
          this.constraint = constraint;
        }
        isConstant = true;
        mapType(scope) {
          return new generic_parameter_type_1.GenericParameterType(this.name, this.constraint?.mapType(scope));
        }
      };
      exports.ElanGenericTypeDescriptor = ElanGenericTypeDescriptor;
      var ElanFuncTypeDescriptor = class {
        parameters;
        returnType;
        constructor(parameters, returnType) {
          this.parameters = parameters;
          this.returnType = returnType;
        }
        isConstant = true;
        name = elan_type_names_1.FuncName;
        mapType(scope) {
          return new function_type_1.FunctionType(this.parameters.map((t) => t.name), this.parameters.map((p) => p.mapType(scope)), this.returnType.mapType(scope), false, true, false, void 0);
        }
      };
      exports.ElanFuncTypeDescriptor = ElanFuncTypeDescriptor;
      var ElanTupleTypeDescriptor = class {
        parameters;
        constructor(parameters) {
          this.parameters = parameters;
        }
        name = elan_type_names_1.TupleName;
        isConstant = true;
        mapType(scope) {
          return new tuple_type_1.TupleType(this.parameters.map((p) => p.mapType(scope)));
        }
      };
      exports.ElanTupleTypeDescriptor = ElanTupleTypeDescriptor;
      var tempMap = /* @__PURE__ */ new Map();
      function removeUnderscore(name) {
        return name.startsWith("_") ? name.slice(1) : name;
      }
      var ElanClassTypeDescriptor = class {
        cls;
        ofTypes;
        constructor(cls, ofTypes) {
          this.cls = cls;
          this.ofTypes = ofTypes;
        }
        isClass = true;
        name = elan_type_names_1.ClassName;
        deprecated;
        classId(className, classMetadata) {
          const ofTypeNames = (this.ofTypes ?? classMetadata.ofTypes).map((td) => td.name).join("_");
          return `${className}_${ofTypeNames}`;
        }
        getNewClassTypeDef(classMetadata, className, scope) {
          const names = Object.getOwnPropertyNames(this.cls.prototype).concat(Object.getOwnPropertyNames(this.cls.emptyInstance()));
          const children = [];
          for (let i = 0; i < names.length; i++) {
            const name = names[i];
            const metadata = Reflect.getMetadata(elan_type_interfaces_1.elanMetadataKey, this.cls.prototype, name);
            if (name === "constructor") {
              children.push([
                `__${keywords_1.constructorKeyword}`,
                classMetadata.mapType(scope),
                MemberType.procedure
              ]);
            }
            if ((0, elan_type_interfaces_1.isFunctionDescriptor)(metadata)) {
              children.push([name, metadata.mapType(scope), MemberType.function]);
            }
            if ((0, elan_type_interfaces_1.isProcedureDescriptor)(metadata)) {
              children.push([name, metadata.mapType(scope), MemberType.procedure]);
            }
            if ((0, elan_type_interfaces_1.isConstantDescriptor)(metadata)) {
              children.push([name, metadata.mapType(scope), MemberType.property]);
            }
          }
          const classTypeDef = new stdlib_class_1.StdLibClass(className, classMetadata.typeOptions.isAbstract, classMetadata.typeOptions, [], [], [], scope, this.deprecated);
          for (const c of children) {
            classTypeDef.children.push(getSymbol(c[0], c[1], symbol_scope_1.SymbolScope.member, c[2], classTypeDef));
          }
          const actualOfTypes = this.ofTypes ?? classMetadata.ofTypes;
          for (const ot of actualOfTypes) {
            classTypeDef.ofTypes.push(ot.mapType(scope));
          }
          for (const inherits of classMetadata.inherits) {
            classTypeDef.inheritTypes.push(inherits.mapType(scope));
          }
          StdLibClassCache.set(stdlibClassUniqueId(className, this.ofTypes), classTypeDef);
          return classTypeDef;
        }
        mapType(scope) {
          const classMetadata = Reflect.getMetadata(elan_type_interfaces_1.elanMetadataKey, this.cls) ?? new ElanClassDescriptor();
          const className = classMetadata.alias ?? removeUnderscore(this.cls.name);
          const classId = this.classId(className, classMetadata);
          if (tempMap.has(classId)) {
            return tempMap.get(classId);
          }
          tempMap.set(classId, new class_type_1.ClassType(className, class_type_1.ClassSubType.concrete, false, type_options_1.noTypeOptions, [], void 0));
          const classTypeDef = StdLibClassCache.get(stdlibClassUniqueId(className, this.ofTypes)) ?? this.getNewClassTypeDef(classMetadata, className, scope);
          const classType = tempMap.get(classId);
          tempMap.delete(classId);
          return classType.updateFrom(classTypeDef.symbolType());
        }
      };
      exports.ElanClassTypeDescriptor = ElanClassTypeDescriptor;
      var ElanClassNameTypeDescriptor = class {
        className;
        ofTypes;
        constructor(className, ofTypes) {
          this.className = className;
          this.ofTypes = ofTypes;
        }
        isClass = true;
        name = elan_type_names_1.ClassName;
        mapType(scope) {
          const cls = exports.nameToTypeMap.get(this.className);
          if (cls) {
            const td = new ElanClassTypeDescriptor(cls, this.ofTypes);
            return td.mapType(scope);
          }
          return unknown_type_1.UnknownType.Instance;
        }
      };
      exports.ElanClassNameTypeDescriptor = ElanClassNameTypeDescriptor;
      var TypescriptTypeDescriptor = class {
        name;
        constructor(name) {
          this.name = name;
        }
        isConstant = true;
        mapType(_scope) {
          switch (this.name) {
            case "Number":
              return float_type_1.FloatType.Instance;
            case "String":
              return string_type_1.StringType.Instance;
            case "Boolean":
              return boolean_type_1.BooleanType.Instance;
            case "RegExp":
              return regexp_type_1.RegExpType.Instance;
            case "Function":
              throw new elan_compiler_error_1.ElanCompilerError("Typescript 'Function' must be mapped into Elan types");
            case "Array":
              throw new elan_compiler_error_1.ElanCompilerError("Typescript 'Array' must be mapped into Elan types");
          }
          throw new elan_compiler_error_1.ElanCompilerError("Missing type annotation in stdlib class");
        }
      };
      exports.TypescriptTypeDescriptor = TypescriptTypeDescriptor;
      function mapTypescriptType(t) {
        return new TypescriptTypeDescriptor(t.name);
      }
      function elanFunction(parameterNames, options, retType) {
        const flags = mapFunctionOptions(options ?? FunctionOptions.pure, retType);
        return elanMethod(parameterNames, new ElanFunctionDescriptor(...flags));
      }
      function elanProcedure(parameterNames, options) {
        const flags = mapProcedureOptions(options ?? ProcedureOptions.default);
        return elanMethod(parameterNames, new ElanProcedureDescriptor(...flags));
      }
      function elanMethod(parameterNames, elanDesc) {
        return function(target, propertyKey, _descriptor) {
          const paramTypesMetadata = Reflect.getMetadata("design:paramtypes", target, propertyKey);
          const retTypeMetadata = Reflect.getMetadata("design:returntype", target, propertyKey);
          if (Array.isArray(paramTypesMetadata)) {
            elanDesc.parameterTypes = paramTypesMetadata.map((t) => mapTypescriptType(t));
          }
          if ((0, elan_type_interfaces_1.isFunctionDescriptor)(elanDesc) && !elanDesc.returnType && retTypeMetadata && retTypeMetadata.name) {
            elanDesc.returnType = new TypescriptTypeDescriptor(retTypeMetadata.name);
          }
          const metaData = Reflect.getOwnMetadata(elan_type_interfaces_1.elanMetadataKey, target, propertyKey) ?? new ElanSignatureDescriptor();
          for (let i = 0; i < elanDesc.parameterTypes.length; i++) {
            const updatedParam = metaData.parameterTypes[i];
            if (updatedParam) {
              elanDesc.parameterTypes[i] = updatedParam;
            }
          }
          for (let i = 0; i < elanDesc.parameterTypes.length; i++) {
            if (i < parameterNames.length) {
              elanDesc.parameterNames[i] = parameterNames[i];
            } else {
              elanDesc.parameterNames[i] = `parameter${i}`;
            }
          }
          Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, elanDesc, target, propertyKey);
        };
      }
      function elanClass(option, ofTypes, names, params, inherits, alias) {
        const typeOptions = mapClassOption(option ?? ClassOption.concrete);
        const classDesc = new ElanClassDescriptor(typeOptions, ofTypes ?? [], names ?? [], params ?? [], inherits ?? [], alias);
        return function(target) {
          Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, classDesc, target);
        };
      }
      function elanConstant(elanDesc) {
        return function(target, propertyKey) {
          const typeMetadata = Reflect.getMetadata("design:type", target, propertyKey);
          if (!elanDesc && typeMetadata && typeMetadata.name) {
            elanDesc = new TypescriptTypeDescriptor(typeMetadata.name);
          }
          Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, elanDesc, target, propertyKey);
        };
      }
      function elanProperty(elanDesc) {
        return function(target, propertyKey) {
          const typeMetadata = Reflect.getMetadata("design:type", target, propertyKey);
          if (!elanDesc && typeMetadata && typeMetadata.name) {
            elanDesc = new TypescriptTypeDescriptor(typeMetadata.name);
          }
          Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, elanDesc, target, propertyKey);
        };
      }
      function elanClassExport(cls) {
        exports.nameToTypeMap.set(cls.name, cls);
        let elanDesc = ElanClass(cls);
        return function(target, propertyKey) {
          const typeMetadata = Reflect.getMetadata("design:type", target, propertyKey);
          if (!elanDesc && typeMetadata && typeMetadata.name) {
            elanDesc = new TypescriptTypeDescriptor(typeMetadata.name);
          }
          Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, elanDesc, target, propertyKey);
        };
      }
      function elanType(eType) {
        return function(target, propertyKey, parameterIndex) {
          const metaData = Reflect.getOwnMetadata(elan_type_interfaces_1.elanMetadataKey, target, propertyKey) ?? new ElanSignatureDescriptor();
          metaData.parameterTypes[parameterIndex] = eType;
          Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, metaData, target, propertyKey);
        };
      }
      function getDeprecated(reason, fromMajor, fromMinor, message) {
        return {
          reason,
          fromMajor,
          fromMinor,
          message
        };
      }
      function elanDeprecated(reason, fromMajor, fromMinor, message) {
        return function(target, propertyKey, propertyDescriptor) {
          if (propertyDescriptor) {
            const metaData = Reflect.getOwnMetadata(elan_type_interfaces_1.elanMetadataKey, target, propertyKey) ?? new ElanSignatureDescriptor();
            metaData.deprecated = getDeprecated(reason, fromMajor, fromMinor, message);
            Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, metaData, target, propertyKey);
          } else {
            const typeMetadata = Reflect.getMetadata(elan_type_interfaces_1.elanMetadataKey, target, propertyKey);
            if (typeMetadata) {
              typeMetadata.deprecated = getDeprecated(reason, fromMajor, fromMinor, message);
              Reflect.defineMetadata(elan_type_interfaces_1.elanMetadataKey, typeMetadata, target, propertyKey);
            }
          }
        };
      }
      exports.ElanInt = new ElanValueTypeDescriptor(elan_type_names_1.IntName);
      exports.ElanFloat = new ElanValueTypeDescriptor(elan_type_names_1.FloatName);
      exports.ElanString = new ElanValueTypeDescriptor(elan_type_names_1.StringName);
      exports.ElanBoolean = new ElanValueTypeDescriptor(elan_type_names_1.BooleanName);
      exports.ElanRegExp = new ElanValueTypeDescriptor(elan_type_names_1.RegExpName);
      exports.ElanT1 = new ElanGenericTypeDescriptor("T1");
      exports.ElanT2 = new ElanGenericTypeDescriptor("T2");
      function ElanT1Constrained(constraint) {
        return new ElanGenericTypeDescriptor("T1", constraint);
      }
      function ElanT2Constrained(constraint) {
        return new ElanGenericTypeDescriptor("T2", constraint);
      }
      function ElanClass(cls, ofTypes) {
        return new ElanClassTypeDescriptor(cls, ofTypes);
      }
      function ElanClassName(className, _ofTypes) {
        return new ElanClassNameTypeDescriptor(className);
      }
      function ElanTuple(ofTypes) {
        return new ElanTupleTypeDescriptor(ofTypes);
      }
      function ElanFunc(parameters, returnType) {
        return new ElanFuncTypeDescriptor(parameters, returnType);
      }
      function elanIntType() {
        return elanType(exports.ElanInt);
      }
      function elanFloatType() {
        return elanType(exports.ElanFloat);
      }
      function elanStringType() {
        return elanType(exports.ElanString);
      }
      function elanBooleanType() {
        return elanType(exports.ElanBoolean);
      }
      function elanRegexType() {
        return elanType(exports.ElanRegExp);
      }
      function elanGenericParamT1Type(constraint) {
        return elanType(constraint ? ElanT1Constrained(constraint) : exports.ElanT1);
      }
      function elanGenericParamT2Type(constraint) {
        return elanType(constraint ? ElanT2Constrained(constraint) : exports.ElanT2);
      }
      function elanTupleType(ofTypes) {
        return elanType(ElanTuple(ofTypes));
      }
      function elanFuncType(parameters, returnType) {
        return elanType(ElanFunc(parameters, returnType));
      }
      function elanClassType(cls, ofTypes) {
        return elanType(ElanClass(cls, ofTypes));
      }
      var FunctionOptions;
      (function(FunctionOptions2) {
        FunctionOptions2[FunctionOptions2["pure"] = 0] = "pure";
        FunctionOptions2[FunctionOptions2["pureExtension"] = 1] = "pureExtension";
        FunctionOptions2[FunctionOptions2["pureAsync"] = 2] = "pureAsync";
        FunctionOptions2[FunctionOptions2["pureAsyncExtension"] = 3] = "pureAsyncExtension";
        FunctionOptions2[FunctionOptions2["impure"] = 4] = "impure";
        FunctionOptions2[FunctionOptions2["impureExtension"] = 5] = "impureExtension";
        FunctionOptions2[FunctionOptions2["impureAsync"] = 6] = "impureAsync";
        FunctionOptions2[FunctionOptions2["impureAsyncExtension"] = 7] = "impureAsyncExtension";
      })(FunctionOptions || (exports.FunctionOptions = FunctionOptions = {}));
      var ProcedureOptions;
      (function(ProcedureOptions2) {
        ProcedureOptions2[ProcedureOptions2["default"] = 0] = "default";
        ProcedureOptions2[ProcedureOptions2["extension"] = 1] = "extension";
        ProcedureOptions2[ProcedureOptions2["async"] = 2] = "async";
        ProcedureOptions2[ProcedureOptions2["asyncExtension"] = 3] = "asyncExtension";
      })(ProcedureOptions || (exports.ProcedureOptions = ProcedureOptions = {}));
      var ClassOption;
      (function(ClassOption2) {
        ClassOption2[ClassOption2["concrete"] = 0] = "concrete";
        ClassOption2[ClassOption2["abstract"] = 1] = "abstract";
        ClassOption2[ClassOption2["record"] = 2] = "record";
        ClassOption2[ClassOption2["list"] = 3] = "list";
        ClassOption2[ClassOption2["array"] = 4] = "array";
        ClassOption2[ClassOption2["array2D"] = 5] = "array2D";
        ClassOption2[ClassOption2["listImmutable"] = 6] = "listImmutable";
        ClassOption2[ClassOption2["dictionary"] = 7] = "dictionary";
        ClassOption2[ClassOption2["dictionaryImmutable"] = 8] = "dictionaryImmutable";
      })(ClassOption || (exports.ClassOption = ClassOption = {}));
      function mapFunctionOptions(options, retType) {
        switch (options) {
          case FunctionOptions.pure:
            return [false, true, false, retType];
          case FunctionOptions.pureExtension:
            return [true, true, false, retType];
          case FunctionOptions.pureAsync:
            return [false, true, true, retType];
          case FunctionOptions.pureAsyncExtension:
            return [true, true, true, retType];
          case FunctionOptions.impure:
            return [false, false, false, retType];
          case FunctionOptions.impureExtension:
            return [true, false, false, retType];
          case FunctionOptions.impureAsync:
            return [false, false, true, retType];
          case FunctionOptions.impureAsyncExtension:
            return [true, false, true, retType];
        }
      }
      function mapProcedureOptions(options) {
        switch (options) {
          case ProcedureOptions.default:
            return [false, false];
          case ProcedureOptions.extension:
            return [true, false];
          case ProcedureOptions.async:
            return [false, true];
          case ProcedureOptions.asyncExtension:
            return [true, true];
        }
      }
      function mapClassOption(options) {
        const opt = (0, type_options_1.getTypeOptions)();
        switch (options) {
          case ClassOption.concrete:
            return opt;
          case ClassOption.abstract:
            opt.isAbstract = true;
            return opt;
          case ClassOption.record:
            opt.isImmutable = true;
            return opt;
          case ClassOption.list:
            opt.isIndexable = opt.isIterable = true;
            return opt;
          case ClassOption.array:
            opt.isIndexable = opt.isIterable = true;
            return opt;
          case ClassOption.array2D:
            opt.isDoubleIndexable = true;
            return opt;
          case ClassOption.listImmutable:
            opt.isImmutable = opt.isIndexable = opt.isIterable = true;
            return opt;
          case ClassOption.dictionary:
            opt.isIndexable = true;
            return opt;
          case ClassOption.dictionaryImmutable:
            opt.isImmutable = opt.isIndexable = true;
            return opt;
        }
      }
      var MemberType;
      (function(MemberType2) {
        MemberType2[MemberType2["property"] = 0] = "property";
        MemberType2[MemberType2["function"] = 1] = "function";
        MemberType2[MemberType2["procedure"] = 2] = "procedure";
      })(MemberType || (exports.MemberType = MemberType = {}));
      function getSymbol(id, st, ss, mt, cls) {
        if (st instanceof class_type_1.ClassType) {
          return st.scope;
        }
        let symbol;
        if (ss === symbol_scope_1.SymbolScope.member) {
          symbol = {
            symbolId: id,
            symbolType: () => st,
            symbolScope: ss,
            isMember: true,
            private: false,
            isAbstract: false,
            getClass: () => cls
          };
        } else {
          symbol = {
            symbolId: id,
            symbolType: () => st,
            symbolScope: ss
          };
        }
        if (mt === MemberType.property) {
          symbol["isProperty"] = true;
        }
        return symbol;
      }
      function getConstantSymbol(id, st, ss) {
        const symbol = {
          symbolId: id,
          symbolType: () => st,
          symbolScope: ss,
          isConstant: true
        };
        return symbol;
      }
    }
  });

  // out/src/compiler/assert-outcome.js
  var require_assert_outcome = __commonJS({
    "out/src/compiler/assert-outcome.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssertOutcome = void 0;
      var AssertOutcome = class {
        status;
        actual;
        expected;
        htmlId;
        error;
        constructor(status, actual, expected, htmlId, error) {
          this.status = status;
          this.actual = actual;
          this.expected = expected;
          this.htmlId = htmlId;
          this.error = error;
        }
      };
      exports.AssertOutcome = AssertOutcome;
    }
  });

  // out/src/compiler/standard-library/data-structure-helpers.js
  var require_data_structure_helpers = __commonJS({
    "out/src/compiler/standard-library/data-structure-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.withAppendHelper = withAppendHelper;
      exports.withAppendListHelper = withAppendListHelper;
      exports.withPutHelper = withPutHelper;
      exports.withInsertHelper = withInsertHelper;
      exports.withRemoveAtHelper = withRemoveAtHelper;
      exports.withRemoveFirstHelper = withRemoveFirstHelper;
      exports.withRemoveAllHelper = withRemoveAllHelper;
      exports.filterHelper = filterHelper;
      exports.mapHelper = mapHelper;
      exports.reduceHelper = reduceHelper;
      exports.maxByHelper = maxByHelper;
      exports.minByHelper = minByHelper;
      exports.sortByHelper = sortByHelper;
      var elan_runtime_error_1 = require_elan_runtime_error();
      function checkIndex(contents, index) {
        const size = contents.length;
        if (index >= size || index < 0) {
          throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index: ${index} size: ${size}`);
        }
      }
      function withAppendHelper(contents, value) {
        const newList = [...contents];
        newList.push(value);
        return newList;
      }
      function withAppendListHelper(contents, listB) {
        const newList = [...contents];
        newList.push(...listB);
        return newList;
      }
      function withPutHelper(contents, index, value) {
        checkIndex(contents, index);
        const newList = [...contents];
        newList[index] = value;
        return newList;
      }
      function withInsertHelper(contents, index, value) {
        return contents.toSpliced(index, 0, value);
      }
      function withRemoveAtHelper(contents, index) {
        checkIndex(contents, index);
        return contents.toSpliced(index, 1);
      }
      function withRemoveFirstHelper(contents, value, system) {
        let newList = [...contents];
        const index = system.elanIndexOf(newList, value);
        if (index > -1) {
          newList = newList.toSpliced(index, 1);
        }
        return newList;
      }
      function withRemoveAllHelper(contents, value, system) {
        let newList = [...contents];
        let index = system.elanIndexOf(newList, value);
        while (index > -1) {
          newList = newList.toSpliced(index, 1);
          index = system.elanIndexOf(newList, value);
        }
        return newList;
      }
      async function filterHelper(contents, predicate) {
        const list = [...contents];
        const asyncFilter = async (list2, predicate2) => {
          const results = await Promise.all(list2.map(predicate2));
          return list2.filter((_v, index) => results[index]);
        };
        return await asyncFilter(list, predicate);
      }
      async function mapHelper(contents, predicate) {
        const list = [...contents];
        return await Promise.all(list.map(predicate));
      }
      async function reduceHelper(contents, initValue, predicate) {
        const list = [...contents];
        let acc = initValue;
        for (const i of list) {
          acc = await predicate(acc, i);
        }
        return acc;
      }
      async function maxByHelper(contents, predicate, system) {
        const mm = await mapHelper(contents, predicate);
        const max = Math.max(...mm);
        const i = system.elanIndexOf(mm, max);
        return contents[i];
      }
      async function minByHelper(contents, predicate, system) {
        const mm = await mapHelper(contents, predicate);
        const min = Math.min(...mm);
        const i = system.elanIndexOf(mm, min);
        return contents[i];
      }
      async function sortByHelper(contents, predicate, system) {
        const clone = [...contents];
        return await system.quickSort(clone, predicate);
      }
    }
  });

  // out/src/compiler/standard-library/list.js
  var require_list = __commonJS({
    "out/src/compiler/standard-library/list.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var List_1;
      var _a;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.List = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var data_structure_helpers_1 = require_data_structure_helpers();
      var List = List_1 = class List {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new List_1();
        }
        async _initialise() {
          return this;
        }
        constructor(arr) {
          this.contents = arr ? [...arr] : [];
        }
        contents;
        system;
        [Symbol.iterator]() {
          let index = 0;
          return {
            next: () => {
              if (index < this.contents.length) {
                return { value: this.contents[index++], done: false };
              } else {
                return { done: true };
              }
            }
          };
        }
        read(index) {
          return this.contents[index];
        }
        put(index, value) {
          this.system.safeListSet(this.contents, index, value);
        }
        insert(index, value) {
          this.contents.splice(index, 0, value);
        }
        removeAt(index) {
          this.contents.splice(index, 1);
        }
        removeFirst(value) {
          const index = this.system.elanIndexOf(this.contents, value);
          if (index > -1) {
            this.contents.splice(index, 1);
          }
        }
        removeAll(value) {
          let index = this.system.elanIndexOf(this.contents, value);
          while (index > -1) {
            this.contents.splice(index, 1);
            index = this.system.elanIndexOf(this.contents, value);
          }
        }
        append(value) {
          this.contents.push(value);
        }
        appendList(listB) {
          this.contents.push(...listB.contents);
        }
        prepend(value) {
          this.contents.unshift(value);
        }
        prependList(listB) {
          this.contents.unshift(...listB.contents);
        }
        length() {
          return this.contents.length;
        }
        indexOf(item) {
          return this.system.elanIndexOf(this.contents, item);
        }
        contains(item) {
          return this.indexOf(item) !== -1;
        }
        newList(newContents) {
          return this.system.initialise(new List_1(newContents));
        }
        async filter(predicate) {
          return this.newList(await (0, data_structure_helpers_1.filterHelper)(this.contents, predicate));
        }
        async map(predicate) {
          return this.newList(await (0, data_structure_helpers_1.mapHelper)(this.contents, predicate));
        }
        async reduce(initValue, predicate) {
          return (0, data_structure_helpers_1.reduceHelper)(this.contents, initValue, predicate);
        }
        async maxBy(predicate) {
          return (0, data_structure_helpers_1.maxByHelper)(this.contents, predicate, this.system);
        }
        async minBy(predicate) {
          return (0, data_structure_helpers_1.minByHelper)(this.contents, predicate, this.system);
        }
        async sortBy(predicate) {
          return this.newList(await (0, data_structure_helpers_1.sortByHelper)(this.contents, predicate, this.system));
        }
        head() {
          return this.safeIndex(0);
        }
        tail() {
          const [_, ...tl] = this.contents;
          return this.system.initialise(new List_1(tl));
        }
        async asString() {
          const items = [];
          for (const i of this.contents) {
            const s = await this.system.asString(i);
            items.push(s);
          }
          return `[${items.join(", ")}]`;
        }
        safeIndex(index) {
          const r = this.contents[index];
          if (r === void 0) {
            this.system.throwRangeError(this.contents, index);
          }
          return r;
        }
        safeSlice(index1, index2) {
          if (index1 && index1 < 0) {
            this.system.throwRangeError(this.contents, index1);
          }
          if (index2 && index2 < 0) {
            this.system.throwRangeError(this.contents, index2);
          }
          const r = this.contents.slice(index1, index2);
          return this.system.initialise(new List_1(r));
        }
        deconstructList() {
          const [hd, ...tl] = this.contents;
          return [hd, this.system.initialise(new List_1(tl))];
        }
        equals(other) {
          if (other instanceof List_1) {
            if (this.contents.length === other.contents.length) {
              return this.contents.every((c, i) => this.system.equals(c, other.contents[i]));
            }
          }
          return false;
        }
        withAppend(value) {
          return this.newList((0, data_structure_helpers_1.withAppendHelper)(this.contents, value));
        }
        withAppendList(toAppend) {
          return this.newList((0, data_structure_helpers_1.withAppendListHelper)(this.contents, toAppend.contents));
        }
        withPrepend(value) {
          return this.withInsert(0, value);
        }
        withPrependList(toPrepend) {
          return toPrepend.withAppendList(this);
        }
        withPut(index, value) {
          return this.newList((0, data_structure_helpers_1.withPutHelper)(this.contents, index, value));
        }
        withInsert(index, value) {
          return this.newList((0, data_structure_helpers_1.withInsertHelper)(this.contents, index, value));
        }
        withRemoveAt(index) {
          return this.newList((0, data_structure_helpers_1.withRemoveAtHelper)(this.contents, index));
        }
        withRemoveFirst(value) {
          return this.newList((0, data_structure_helpers_1.withRemoveFirstHelper)(this.contents, value, this.system));
        }
        withRemoveAll(value) {
          return this.newList((0, data_structure_helpers_1.withRemoveAllHelper)(this.contents, value, this.system));
        }
        async join(separator) {
          const asStrings = await (0, data_structure_helpers_1.mapHelper)(this.contents, async (i) => await this.system.asString(i));
          return asStrings.join(separator);
        }
        asListImmutable() {
          return this.system.listAsListImmutable(this);
        }
        asSet() {
          return this.system.listAsSet(this);
        }
        asArray() {
          return this.system.listAsArray(this);
        }
      };
      exports.List = List;
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["index", "value"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "put", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["index", "value"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "insert", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["index"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "removeAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["value"]),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "removeFirst", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["value"]),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "removeAll", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["value"]),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "append", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["other"]),
        __param(0, (0, elan_type_annotations_1.elanClassType)(List, [(0, elan_type_annotations_1.ElanT2Constrained)(elan_type_annotations_1.ElanT1)])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [List]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "appendList", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["other"]),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "prepend", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["other"]),
        __param(0, (0, elan_type_annotations_1.elanClassType)(List)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [List]),
        __metadata("design:returntype", void 0)
      ], List.prototype, "prependList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], List.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Number)
      ], List.prototype, "indexOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Boolean)
      ], List.prototype, "contains", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanBoolean)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "filter", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, (0, elan_type_annotations_1.ElanClass)(List, [elan_type_annotations_1.ElanT2])),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanT2)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "map", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["initialValue", "lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanT2),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT2Type)()),
        __param(1, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT2, elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanT2)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [typeof (_a = typeof T2 !== "undefined" && T2) === "function" ? _a : Object, Function]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "reduce", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanT1),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanFloat)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "maxBy", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanT1),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanFloat)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "minBy", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1, elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanInt)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "sortBy", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanT1),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Object)
      ], List.prototype, "head", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", List)
      ], List.prototype, "tail", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", List)
      ], List.prototype, "withAppend", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["toAppend"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(List)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [List]),
        __metadata("design:returntype", List)
      ], List.prototype, "withAppendList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", List)
      ], List.prototype, "withPrepend", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["toPrepend"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(List)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [List]),
        __metadata("design:returntype", List)
      ], List.prototype, "withPrependList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", List)
      ], List.prototype, "withPut", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", List)
      ], List.prototype, "withInsert", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", List)
      ], List.prototype, "withRemoveAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", List)
      ], List.prototype, "withRemoveFirst", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(List)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", List)
      ], List.prototype, "withRemoveAll", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["separator"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], List.prototype, "join", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("ListImmutable")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], List.prototype, "asListImmutable", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("ElanSet")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], List.prototype, "asSet", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("ElanArray")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], List.prototype, "asArray", null);
      exports.List = List = List_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.list, [elan_type_annotations_1.ElanT1], [], [], []),
        __metadata("design:paramtypes", [Array])
      ], List);
    }
  });

  // out/src/compiler/standard-library/dictionary.js
  var require_dictionary = __commonJS({
    "out/src/compiler/standard-library/dictionary.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var Dictionary_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Dictionary = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var list_1 = require_list();
      var Dictionary = Dictionary_1 = class Dictionary {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new Dictionary_1();
        }
        async _initialise() {
          return this;
        }
        constructor(dict) {
          this.contents = dict ? new Map(dict) : /* @__PURE__ */ new Map();
        }
        contents;
        system;
        findRealKey(key) {
          for (const rk of this.contents.keys()) {
            if (this.system.equals(key, rk)) {
              return rk;
            }
          }
          return key;
        }
        removeAt(key) {
          const rk = this.findRealKey(key);
          this.contents.delete(rk);
        }
        put(key, value) {
          const rk = this.findRealKey(key);
          this.contents.set(rk, value);
        }
        keys() {
          const lst = [...this.contents.keys()];
          return this.system.initialise(new list_1.List(lst));
        }
        values() {
          const lst = [...this.contents.values()];
          return this.system.initialise(new list_1.List(lst));
        }
        hasKey(key) {
          const rk = this.findRealKey(key);
          return this.contents.has(rk);
        }
        async asString() {
          const items = [];
          for (const k of this.contents.keys()) {
            const kStr = await this.system.asString(k);
            const vStr = await this.system.asString(this.contents.get(k));
            items.push(`${kStr}:${vStr}`);
          }
          return `[${items.join(", ")}]`;
        }
        async asCloneableObject() {
          const dict = {};
          for (const k of this.contents.keys()) {
            const kStr = await this.system.asString(k);
            const v = await this.system?.asCloneableObject(this.contents.get(k));
            dict[kStr] = v;
          }
          return dict;
        }
        safeIndex(key) {
          const rk = this.findRealKey(key);
          if (!this.contents.has(rk)) {
            this.system.throwKeyError(key);
          }
          return this.contents.get(rk);
        }
        equals(other) {
          if (other instanceof Dictionary_1) {
            if (this.contents.size === other.contents.size) {
              return this.contents.keys().every((k) => this.system.equals(this.contents.get(k), other.contents.get(k)));
            }
          }
          return false;
        }
        withRemoveAt(key) {
          const rk = this.findRealKey(key);
          const newDict = new Map(this.contents);
          newDict.delete(rk);
          return this.system.initialise(new Dictionary_1([...newDict.entries()]));
        }
        withPut(key, value) {
          const rk = this.findRealKey(key);
          const newDict = new Map(this.contents);
          newDict.set(rk, value);
          return this.system.initialise(new Dictionary_1([...newDict.entries()]));
        }
        asDictionaryImmutable() {
          return this.system.dictionaryAsDictionaryImmutable(this);
        }
      };
      exports.Dictionary = Dictionary;
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["key"]),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], Dictionary.prototype, "removeAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["key", "value"]),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT2Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object]),
        __metadata("design:returntype", void 0)
      ], Dictionary.prototype, "put", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_1.List, [elan_type_annotations_1.ElanT1])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", list_1.List)
      ], Dictionary.prototype, "keys", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_1.List, [elan_type_annotations_1.ElanT2])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", list_1.List)
      ], Dictionary.prototype, "values", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["key"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanBoolean),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Boolean)
      ], Dictionary.prototype, "hasKey", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["key"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(Dictionary)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], Dictionary.prototype, "withRemoveAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["key", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(Dictionary)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT2Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object]),
        __metadata("design:returntype", void 0)
      ], Dictionary.prototype, "withPut", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("DictionaryImmutable")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Dictionary.prototype, "asDictionaryImmutable", null);
      exports.Dictionary = Dictionary = Dictionary_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.dictionary, [elan_type_annotations_1.ElanT1, elan_type_annotations_1.ElanT2]),
        __metadata("design:paramtypes", [Array])
      ], Dictionary);
    }
  });

  // out/src/compiler/standard-library/list-immutable.js
  var require_list_immutable = __commonJS({
    "out/src/compiler/standard-library/list-immutable.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var ListImmutable_1;
      var _a;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ListImmutable = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var data_structure_helpers_1 = require_data_structure_helpers();
      var ListImmutable = ListImmutable_1 = class ListImmutable {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new ListImmutable_1();
        }
        async _initialise() {
          return this;
        }
        constructor(arr) {
          this.contents = arr ? [...arr] : [];
        }
        contents;
        system;
        [Symbol.iterator]() {
          let index = 0;
          return {
            next: () => {
              if (index < this.contents.length) {
                return { value: this.contents[index++], done: false };
              } else {
                return { done: true };
              }
            }
          };
        }
        newList(newContents) {
          return this.system.initialise(new ListImmutable_1(newContents));
        }
        withAppend(value) {
          return this.newList((0, data_structure_helpers_1.withAppendHelper)(this.contents, value));
        }
        withAppendList(toAppend) {
          return this.newList((0, data_structure_helpers_1.withAppendListHelper)(this.contents, toAppend.contents));
        }
        withPrepend(value) {
          return this.withInsert(0, value);
        }
        withPrependList(toPrepend) {
          return toPrepend.withAppendList(this);
        }
        withPut(index, value) {
          return this.newList((0, data_structure_helpers_1.withPutHelper)(this.contents, index, value));
        }
        withInsert(index, value) {
          return this.newList((0, data_structure_helpers_1.withInsertHelper)(this.contents, index, value));
        }
        withRemoveAt(index) {
          return this.newList((0, data_structure_helpers_1.withRemoveAtHelper)(this.contents, index));
        }
        withRemoveFirst(value) {
          return this.newList((0, data_structure_helpers_1.withRemoveFirstHelper)(this.contents, value, this.system));
        }
        withRemoveAll(value) {
          return this.newList((0, data_structure_helpers_1.withRemoveAllHelper)(this.contents, value, this.system));
        }
        length() {
          return this.contents.length;
        }
        indexOf(item) {
          return this.system.elanIndexOf(this.contents, item);
        }
        contains(item) {
          return this.indexOf(item) !== -1;
        }
        async filter(predicate) {
          return this.newList(await (0, data_structure_helpers_1.filterHelper)(this.contents, predicate));
        }
        async map(predicate) {
          return this.newList(await (0, data_structure_helpers_1.mapHelper)(this.contents, predicate));
        }
        async reduce(initValue, predicate) {
          return (0, data_structure_helpers_1.reduceHelper)(this.contents, initValue, predicate);
        }
        async maxBy(predicate) {
          return (0, data_structure_helpers_1.maxByHelper)(this.contents, predicate, this.system);
        }
        async minBy(predicate) {
          return (0, data_structure_helpers_1.minByHelper)(this.contents, predicate, this.system);
        }
        async sortBy(predicate) {
          const arr = await (0, data_structure_helpers_1.sortByHelper)(this.contents, predicate, this.system);
          return this.newList(arr);
        }
        head() {
          return this.safeIndex(0);
        }
        tail() {
          const [_, ...tl] = this.contents;
          return this.system.initialise(new ListImmutable_1(tl));
        }
        async asString() {
          const items = [];
          for (const i of this.contents) {
            const s = await this.system.asString(i);
            items.push(s);
          }
          return `{${items.join(", ")}}`;
        }
        safeIndex(index) {
          const r = this.contents[index];
          if (r === void 0) {
            this.system.throwRangeError(this.contents, index);
          }
          return r;
        }
        safeSlice(index1, index2) {
          if (index1 && index1 < 0) {
            this.system.throwRangeError(this.contents, index1);
          }
          if (index2 && index2 < 0) {
            this.system.throwRangeError(this.contents, index2);
          }
          const r = this.contents.slice(index1, index2);
          return this.system.initialise(new ListImmutable_1(r));
        }
        deconstructList() {
          const [hd, ...tl] = this.contents;
          return [hd, this.system.initialise(new ListImmutable_1(tl))];
        }
        equals(other) {
          if (other instanceof ListImmutable_1) {
            if (this.contents.length === other.contents.length) {
              return this.contents.every((c, i) => this.system.equals(c, other.contents[i]));
            }
          }
          return false;
        }
        async join(separator) {
          const asStrings = await (0, data_structure_helpers_1.mapHelper)(this.contents, async (i) => await this.system.asString(i));
          return asStrings.join(separator);
        }
        asList() {
          return this.system.listImmutableAsList(this);
        }
        asSet() {
          return this.system.listImmutableAsSet(this);
        }
        asArray() {
          return this.system.listImmutableAsArray(this);
        }
      };
      exports.ListImmutable = ListImmutable;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withAppend", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["toAppend"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ListImmutable)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ListImmutable]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withAppendList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withPrepend", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["toPrepend"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ListImmutable)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ListImmutable]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withPrependList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withPut", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withInsert", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withRemoveAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withRemoveFirst", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "withRemoveAll", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ListImmutable.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Number)
      ], ListImmutable.prototype, "indexOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Boolean)
      ], ListImmutable.prototype, "contains", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanBoolean)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "filter", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, (0, elan_type_annotations_1.ElanClass)(ListImmutable, [elan_type_annotations_1.ElanT2])),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanT2)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "map", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["initialValue", "lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanT2),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT2Type)()),
        __param(1, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT2, elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanT2)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [typeof (_a = typeof T2 !== "undefined" && T2) === "function" ? _a : Object, Function]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "reduce", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanT1),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanFloat)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "maxBy", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanT1),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanFloat)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "minBy", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["lambdaOrFunctionRef"], elan_type_annotations_1.FunctionOptions.pureAsync, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __param(0, (0, elan_type_annotations_1.elanFuncType)([elan_type_annotations_1.ElanT1, elan_type_annotations_1.ElanT1], elan_type_annotations_1.ElanInt)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "sortBy", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanT1),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Object)
      ], ListImmutable.prototype, "head", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ListImmutable)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", ListImmutable)
      ], ListImmutable.prototype, "tail", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["separator"], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], ListImmutable.prototype, "join", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("List")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ListImmutable.prototype, "asList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("ElanSet")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ListImmutable.prototype, "asSet", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("ElanArray")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ListImmutable.prototype, "asArray", null);
      exports.ListImmutable = ListImmutable = ListImmutable_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.listImmutable, [elan_type_annotations_1.ElanT1], [], [], []),
        __metadata("design:paramtypes", [Array])
      ], ListImmutable);
    }
  });

  // out/src/compiler/standard-library/dictionary-immutable.js
  var require_dictionary_immutable = __commonJS({
    "out/src/compiler/standard-library/dictionary-immutable.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var DictionaryImmutable_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DictionaryImmutable = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var list_immutable_1 = require_list_immutable();
      var DictionaryImmutable = DictionaryImmutable_1 = class DictionaryImmutable {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new DictionaryImmutable_1();
        }
        async _initialise() {
          return this;
        }
        constructor(dict) {
          this.contents = dict ? new Map(dict) : /* @__PURE__ */ new Map();
        }
        contents;
        system;
        findRealKey(key) {
          for (const rk of this.contents.keys()) {
            if (this.system.equals(key, rk)) {
              return rk;
            }
          }
          return key;
        }
        withRemoveAt(key) {
          const rk = this.findRealKey(key);
          const newDict = new Map(this.contents);
          newDict.delete(rk);
          return this.system.initialise(new DictionaryImmutable_1([...newDict.entries()]));
        }
        withPut(key, value) {
          const rk = this.findRealKey(key);
          const newDict = new Map(this.contents);
          newDict.set(rk, value);
          return this.system.initialise(new DictionaryImmutable_1([...newDict.entries()]));
        }
        keys() {
          const lst = [...this.contents.keys()];
          return this.system.initialise(new list_immutable_1.ListImmutable(lst));
        }
        values() {
          const lst = [...this.contents.values()];
          return this.system.initialise(new list_immutable_1.ListImmutable(lst));
        }
        hasKey(key) {
          const rk = this.findRealKey(key);
          return this.contents.has(rk);
        }
        asDictionary() {
          return this.system.dictionaryImmutableAsDictionary(this);
        }
        async asString() {
          const items = [];
          for (const k of this.contents.keys()) {
            const kStr = await this.system.asString(k);
            const vStr = await this.system.asString(this.contents.get(k));
            items.push(`${kStr}:${vStr}`);
          }
          return `{${items.join(", ")}}`;
        }
        async asCloneableObject() {
          const dict = {};
          for (const k of this.contents.keys()) {
            const kStr = await this.system.asString(k);
            const v = await this.system?.asCloneableObject(this.contents.get(k));
            dict[kStr] = v;
          }
          return dict;
        }
        safeIndex(key) {
          const rk = this.findRealKey(key);
          if (!this.contents.has(rk)) {
            this.system.throwKeyError(key);
          }
          return this.contents.get(rk);
        }
        equals(other) {
          if (other instanceof DictionaryImmutable_1) {
            if (this.contents.size === other.contents.size) {
              return this.contents.keys().every((k) => this.system.equals(this.contents.get(k), other.contents.get(k)));
            }
          }
          return false;
        }
      };
      exports.DictionaryImmutable = DictionaryImmutable;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["key"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(DictionaryImmutable)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], DictionaryImmutable.prototype, "withRemoveAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["key", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(DictionaryImmutable)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT2Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object]),
        __metadata("design:returntype", void 0)
      ], DictionaryImmutable.prototype, "withPut", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_immutable_1.ListImmutable, [elan_type_annotations_1.ElanT1])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", list_immutable_1.ListImmutable)
      ], DictionaryImmutable.prototype, "keys", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_immutable_1.ListImmutable, [elan_type_annotations_1.ElanT2])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", list_immutable_1.ListImmutable)
      ], DictionaryImmutable.prototype, "values", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["key"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanBoolean),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Boolean)
      ], DictionaryImmutable.prototype, "hasKey", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("Dictionary")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], DictionaryImmutable.prototype, "asDictionary", null);
      exports.DictionaryImmutable = DictionaryImmutable = DictionaryImmutable_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.dictionaryImmutable, [elan_type_annotations_1.ElanT1, elan_type_annotations_1.ElanT2]),
        __metadata("design:paramtypes", [Array])
      ], DictionaryImmutable);
    }
  });

  // out/src/compiler/standard-library/elan-array.js
  var require_elan_array = __commonJS({
    "out/src/compiler/standard-library/elan-array.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var ElanArray_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ElanArray = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var data_structure_helpers_1 = require_data_structure_helpers();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var ElanArray = ElanArray_1 = class ElanArray {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new ElanArray_1();
        }
        async _initialise(size, value) {
          if (size <= 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Size of Array must be non zero, positive value`);
          }
          if (!(typeof value === "boolean" || typeof value === "string" || typeof value === "number")) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Array must be of Type: Int, Float, String, or Boolean, with matching initial value`);
          }
          const toInit = [];
          toInit.length = size;
          for (let i = 0; i < size; i++) {
            toInit[i] = value;
          }
          this.contents = toInit;
          return this;
        }
        constructor(arr) {
          this.contents = arr ? [...arr] : [];
        }
        contents;
        system;
        [Symbol.iterator]() {
          let index = 0;
          return {
            next: () => {
              if (index < this.contents.length) {
                return { value: this.contents[index++], done: false };
              } else {
                return { done: true };
              }
            }
          };
        }
        newArray(newContents) {
          return this.system.initialise(new ElanArray_1(newContents));
        }
        put(index, value) {
          this.system.safeListSet(this.contents, index, value);
        }
        withPut(index, value) {
          return this.newArray((0, data_structure_helpers_1.withPutHelper)(this.contents, index, value));
        }
        length() {
          return this.contents.length;
        }
        indexOf(item) {
          return this.system.elanIndexOf(this.contents, item);
        }
        contains(item) {
          return this.indexOf(item) !== -1;
        }
        async asString() {
          const items = [];
          for (const i of this.contents) {
            const s = await this.system.asString(i);
            items.push(s);
          }
          return `[${items.join(", ")}]`;
        }
        safeIndex(index) {
          const r = this.contents[index];
          if (r === void 0) {
            this.system.throwRangeError(this.contents, index);
          }
          return r;
        }
        safeSlice(index1, index2) {
          if (index1 && index1 < 0) {
            this.system.throwRangeError(this.contents, index1);
          }
          if (index2 && index2 < 0) {
            this.system.throwRangeError(this.contents, index2);
          }
          const r = this.contents.slice(index1, index2);
          return this.system.initialise(new ElanArray_1(r));
        }
        equals(other) {
          if (other instanceof ElanArray_1) {
            if (this.contents.length === other.contents.length) {
              return this.contents.every((c, i) => this.system.equals(c, other.contents[i]));
            }
          }
          return false;
        }
        asSet() {
          return this.system.arrayAsSet(this);
        }
        asList() {
          return this.system.arrayAsList(this);
        }
      };
      exports.ElanArray = ElanArray;
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["index", "value"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", void 0)
      ], ElanArray.prototype, "put", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["index", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanArray)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Object]),
        __metadata("design:returntype", ElanArray)
      ], ElanArray.prototype, "withPut", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ElanArray.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Number)
      ], ElanArray.prototype, "indexOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Boolean)
      ], ElanArray.prototype, "contains", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("ElanSet")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ElanArray.prototype, "asSet", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClassName)("List")),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ElanArray.prototype, "asList", null);
      exports.ElanArray = ElanArray = ElanArray_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.array, [elan_type_annotations_1.ElanT1], ["size", "initialValue"], [elan_type_annotations_1.ElanInt, elan_type_annotations_1.ElanT1], [], "Array"),
        __metadata("design:paramtypes", [Array])
      ], ElanArray);
    }
  });

  // out/src/compiler/standard-library/elan-set.js
  var require_elan_set = __commonJS({
    "out/src/compiler/standard-library/elan-set.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var ElanSet_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ElanSet = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var list_1 = require_list();
      var list_immutable_1 = require_list_immutable();
      var ElanSet = ElanSet_1 = class ElanSet {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new ElanSet_1();
        }
        async _initialise() {
          return this;
        }
        _system;
        set system(value) {
          this._system = value;
        }
        get system() {
          return this._system;
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        stdlib;
        // injected
        constructor(arr) {
          this.contents = arr ? new Set(arr) : /* @__PURE__ */ new Set();
        }
        contents;
        copyOfThis() {
          const copy = this.system.initialise(new ElanSet_1());
          copy.contents = new Set(this.contents);
          return copy;
        }
        length() {
          return this.contents.size;
        }
        contains(item) {
          return this.contents.has(item);
        }
        add(item) {
          const copy = this.copyOfThis();
          copy.contents.add(item);
          return copy;
        }
        addFromList(list) {
          const copy = this.copyOfThis();
          for (const item of list) {
            copy.contents.add(item);
          }
          return copy;
        }
        remove(item) {
          const copy = this.copyOfThis();
          copy.contents.delete(item);
          return copy;
        }
        union(other) {
          const copy = this.copyOfThis();
          copy.contents = this.contents.union(other.contents);
          return copy;
        }
        difference(other) {
          const copy = this.copyOfThis();
          copy.contents = this.contents.difference(other.contents);
          return copy;
        }
        intersection(other) {
          const copy = this.copyOfThis();
          copy.contents = this.contents.intersection(other.contents);
          return copy;
        }
        isDisjointFrom(other) {
          return this.contents.isDisjointFrom(other.contents);
        }
        isSubsetOf(other) {
          return this.contents.isSubsetOf(other.contents);
        }
        isSupersetOf(other) {
          return this.contents.isSupersetOf(other.contents);
        }
        asList() {
          return this.system.initialise(new list_1.List(Array.from(this.contents)));
        }
        async asString() {
          const listImm = this.system.initialise(new list_immutable_1.ListImmutable(Array.from(this.contents)));
          return await this.stdlib.asString(listImm);
        }
      };
      exports.ElanSet = ElanSet;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ElanSet.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanBoolean),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], ElanSet.prototype, "contains", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanSet)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", ElanSet)
      ], ElanSet.prototype, "add", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanSet)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", ElanSet)
      ], ElanSet.prototype, "addFromList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure, (0, elan_type_annotations_1.ElanClass)(ElanSet)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", ElanSet)
      ], ElanSet.prototype, "remove", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanSet)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ElanSet)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ElanSet]),
        __metadata("design:returntype", ElanSet)
      ], ElanSet.prototype, "union", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanSet)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ElanSet)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ElanSet]),
        __metadata("design:returntype", ElanSet)
      ], ElanSet.prototype, "difference", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanSet)),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ElanSet)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ElanSet]),
        __metadata("design:returntype", ElanSet)
      ], ElanSet.prototype, "intersection", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ElanSet)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ElanSet]),
        __metadata("design:returntype", Boolean)
      ], ElanSet.prototype, "isDisjointFrom", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanBoolean),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ElanSet)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ElanSet]),
        __metadata("design:returntype", Boolean)
      ], ElanSet.prototype, "isSubsetOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanBoolean),
        __param(0, (0, elan_type_annotations_1.elanClassType)(ElanSet)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [ElanSet]),
        __metadata("design:returntype", Boolean)
      ], ElanSet.prototype, "isSupersetOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_1.List)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", list_1.List)
      ], ElanSet.prototype, "asList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureAsync, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], ElanSet.prototype, "asString", null);
      exports.ElanSet = ElanSet = ElanSet_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.record, [elan_type_annotations_1.ElanT1], [], [], [], "Set"),
        __metadata("design:paramtypes", [Array])
      ], ElanSet);
    }
  });

  // out/src/compiler/test-status.js
  var require_test_status = __commonJS({
    "out/src/compiler/test-status.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TestStatus = void 0;
      var TestStatus;
      (function(TestStatus2) {
        TestStatus2[TestStatus2["error"] = 0] = "error";
        TestStatus2[TestStatus2["fail"] = 1] = "fail";
        TestStatus2[TestStatus2["ignored"] = 2] = "ignored";
        TestStatus2[TestStatus2["running"] = 3] = "running";
        TestStatus2[TestStatus2["pass"] = 4] = "pass";
        TestStatus2[TestStatus2["default"] = 5] = "default";
      })(TestStatus || (exports.TestStatus = TestStatus = {}));
    }
  });

  // out/src/compiler/system.js
  var require_system = __commonJS({
    "out/src/compiler/system.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.System = void 0;
      var assert_outcome_1 = require_assert_outcome();
      var dictionary_1 = require_dictionary();
      var dictionary_immutable_1 = require_dictionary_immutable();
      var elan_array_1 = require_elan_array();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var elan_set_1 = require_elan_set();
      var list_1 = require_list();
      var list_immutable_1 = require_list_immutable();
      var test_status_1 = require_test_status();
      var System = class {
        elanInputOutput;
        constructor(elanInputOutput) {
          this.elanInputOutput = elanInputOutput;
        }
        _stdlib;
        set stdlib(stdlib) {
          this._stdlib = stdlib;
        }
        // constant immutables
        emptyImmutableListSingleton = this.initialise(new list_immutable_1.ListImmutable([]));
        emptyDictionaryImmutableSingleton = this.dictionaryImmutable([]);
        emptyRegExpSingleton = /(?:)/;
        emptyRegExp() {
          return this.emptyRegExpSingleton;
        }
        emptyTuple(toInit) {
          const t = [...toInit];
          return this.tuple(t);
        }
        emptyFunc(rt) {
          return () => rt;
        }
        tuple(t) {
          return t;
        }
        listImmutable(t) {
          return this.initialise(new list_immutable_1.ListImmutable(t));
        }
        dictionary(t) {
          return this.initialise(new dictionary_1.Dictionary(t));
        }
        dictionaryImmutable(t) {
          return this.initialise(new dictionary_immutable_1.DictionaryImmutable(t));
        }
        list(t) {
          return this.initialise(new list_1.List(t));
        }
        initialise(toInit) {
          if ("system" in toInit) {
            toInit.system = this;
          }
          if ("stdlib" in toInit) {
            toInit.stdlib = this._stdlib;
          }
          return toInit;
        }
        emptyClass(type, properties) {
          const t = Object.create(type.prototype);
          for (const p of properties) {
            t[p[0]] = p[1];
          }
          return t;
        }
        safeIndex(indexable, index1, index2) {
          if (typeof indexable !== "string" && "safeIndex" in indexable) {
            return indexable.safeIndex(index1, index2);
          }
          if (indexable === void 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index`);
          }
          const r = indexable[index1];
          if (r === void 0) {
            this.throwRangeError(indexable, index1);
          }
          return r;
        }
        safeSlice(indexable, index1, index2) {
          if (indexable === void 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index`);
          }
          if (typeof indexable !== "string" && "safeSlice" in indexable) {
            return indexable.safeSlice(index1, index2);
          }
          if (typeof indexable !== "string") {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index`);
          }
          if (index1 && index1 < 0) {
            this.throwRangeError(indexable, index1);
          }
          if (index2 && index2 < 0) {
            this.throwRangeError(indexable, index2);
          }
          return indexable.slice(index1, index2);
        }
        throwRangeError(toIndex, index) {
          const size = toIndex.length;
          if (size !== void 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index: ${index} size: ${size}`);
          }
          throw new elan_runtime_error_1.ElanRuntimeError(`No such key: ${index}`);
        }
        throwKeyError(index) {
          throw new elan_runtime_error_1.ElanRuntimeError(`No such key: ${index}`);
        }
        safeListSet(toIndex, index, value) {
          const size = toIndex.length;
          if (index >= size) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index: ${index} size: ${size}`);
          }
          toIndex[index] = value;
        }
        safeArray2DSet(toIndex, col, row, value) {
          const size = toIndex.length;
          if (col >= size) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range index: ${col} size: ${size}`);
          }
          this.safeListSet(toIndex[col], row, value);
        }
        async printLine(s) {
          const ss = await this._stdlib.asString(s);
          await this.elanInputOutput.printLine(ss);
        }
        async input() {
          return await this.elanInputOutput.readLine();
        }
        equals(i1, i2) {
          const t = typeof i1;
          if (t === "boolean" || t === "string" || t === "number") {
            return i1 === i2;
          }
          return this.objectEquals(i1, i2);
        }
        objectEquals(o1, o2) {
          if (o1 === o2) {
            return true;
          }
          if (o1?.constructor?.name !== o2?.constructor?.name) {
            return false;
          }
          if (o1?.constructor?.name === o2?.constructor?.name && o2?.constructor?.name === "Function") {
            return false;
          }
          if ("equals" in o1) {
            return o1.equals(o2);
          }
          const o1items = Object.getOwnPropertyNames(o1);
          const o2items = Object.getOwnPropertyNames(o2);
          if (o1items.length !== o2items.length) {
            return false;
          }
          if (o1items.join() !== o2items.join()) {
            return false;
          }
          for (const i of o1items.filter((i2) => !i2.startsWith("_"))) {
            if (!this.equals(o1[i], o2[i])) {
              return false;
            }
          }
          if (o1 instanceof Set) {
            return o1.size === o2.size && o1.isSubsetOf(o2);
          }
          return true;
        }
        async assert(actual, expected, htmlId, stdlib, ignored) {
          if (ignored) {
            return new assert_outcome_1.AssertOutcome(test_status_1.TestStatus.ignored, "", "", htmlId);
          }
          try {
            const actualValue = await actual[0]();
            return await this.doAssert(actualValue, expected[0], actual[1], expected[1], htmlId, stdlib);
          } catch (err) {
            return await this.doAssert(err.message, expected[0], "String", "String", htmlId, stdlib);
          }
        }
        async doAssert(actual, expected, actualSt, expectedSt, htmlId, stdlib) {
          let testStatus = test_status_1.TestStatus.pass;
          const expectedValue = `${await stdlib.asString(expected)}`;
          let actualValue = `${await stdlib.asString(actual)}`;
          if (!this.equals(actual, expected)) {
            testStatus = test_status_1.TestStatus.fail;
            if (actualSt !== expectedSt) {
              actualValue = `${actualSt} expected: ${expectedSt}`;
            }
          }
          return new assert_outcome_1.AssertOutcome(testStatus, actualValue, expectedValue, htmlId);
        }
        deconstructList(list) {
          return list.deconstructList();
        }
        unhandledExpression(v) {
          const s = this._stdlib.asString(v);
          throw new elan_runtime_error_1.ElanRuntimeError(`'${s}' not covered in switch statement`);
        }
        async runTests(tests) {
          const allOutcomes = [];
          for (const t of tests) {
            const outcomes = [];
            const testId = t[0];
            try {
              await t[1](outcomes);
            } catch (e) {
              const msg = e.message || "Test threw error";
              outcomes.push(new assert_outcome_1.AssertOutcome(test_status_1.TestStatus.error, msg, "", "", e));
            }
            allOutcomes.push([testId, outcomes]);
          }
          tests.length = 0;
          return allOutcomes;
        }
        ignoredProperty(s) {
          return s === "system" || s === "stdlib" || s.startsWith("_");
        }
        async asCloneableObject(v) {
          if (typeof v === "boolean" || typeof v === "string" || typeof v === "number") {
            return v;
          }
          if (v instanceof RegExp) {
            return `/${v.source}/`;
          }
          if ("asCloneableObject" in v) {
            return await v.asCloneableObject();
          }
          if (typeof v[Symbol.iterator] === "function") {
            const arr = [];
            for (const o of v) {
              arr.push(await this.asCloneableObject(o));
            }
            return arr;
          }
          const getters = [];
          const proto = Object.getPrototypeOf(v);
          const descriptors = Object.getOwnPropertyDescriptors(proto);
          const dKeys = Object.keys(descriptors);
          for (const d of dKeys) {
            const dd = descriptors[d];
            const isGet = dd.get;
            if (isGet) {
              getters.push(d);
            }
          }
          const clone = {};
          const keys = Object.keys(v).filter((k) => !this.ignoredProperty(k));
          const keySet = new Set(keys.concat(getters));
          for (const k of keySet) {
            clone[k] = await this.asCloneableObject(v[k]);
          }
          return clone;
        }
        async debugSymbol(id, symbol, typeMap) {
          const asCloneable = await this.asCloneableObject(symbol);
          try {
            return {
              name: id,
              value: asCloneable,
              typeMap
            };
          } catch (_e) {
            return "error resolving";
          }
        }
        elanIndexOf(list, elem) {
          for (let i = 0; i < list.length; i++) {
            const item = list[i];
            if (this.equals(item, elem)) {
              return i;
            }
          }
          return -1;
        }
        elan2DIndexOf(list, elem) {
          for (let i = 0; i < list.length; i++) {
            const subArr = list[i];
            for (let j = 0; j < subArr.length; j++) {
              const item = subArr[j];
              if (this.equals(item, elem)) {
                return [i, j];
              }
            }
          }
          return [-1, -1];
        }
        async asString(a) {
          return await this._stdlib.asString(a);
        }
        async breakPoint(allScopedSymbols, id, singlestep, pause) {
          if (singlestep && !pause) {
            return false;
          }
          return await this.elanInputOutput.breakPoint(allScopedSymbols, id, singlestep);
        }
        async getPivot(x, y, z, compare) {
          if (await compare(x, y) < 0) {
            if (await compare(y, z) < 0) {
              return y;
            } else if (await compare(z, x) < 0) {
              return x;
            } else {
              return z;
            }
          } else if (await compare(y, z) > 0) {
            return y;
          } else if (await compare(z, x) > 0) {
            return x;
          } else {
            return z;
          }
        }
        // from github https://gist.github.com/kimamula/fa34190db624239111bbe0deba72a6ab
        async quickSort(arr, compare, left = 0, right = arr.length - 1) {
          if (left < right) {
            let i = left, j = right, tmp;
            const pivot = await this.getPivot(arr[i], arr[i + Math.floor((j - i) / 2)], arr[j], compare);
            while (true) {
              while (await compare(arr[i], pivot) < 0) {
                i++;
              }
              while (await compare(pivot, arr[j]) < 0) {
                j--;
              }
              if (i >= j) {
                break;
              }
              tmp = arr[i];
              arr[i] = arr[j];
              arr[j] = tmp;
              i++;
              j--;
            }
            await this.quickSort(arr, compare, left, i - 1);
            await this.quickSort(arr, compare, j + 1, right);
          }
          return arr;
        }
        listImmutableAsList(list) {
          const newList = [...list];
          return this.initialise(new list_1.List(newList));
        }
        listImmutableAsSet(list) {
          const newList = [...list];
          return this.initialise(new elan_set_1.ElanSet(newList));
        }
        listImmutableAsArray(list) {
          const newList = [...list];
          return this.initialise(new elan_array_1.ElanArray(newList));
        }
        listAsListImmutable(list) {
          const newList = [...list];
          return this.initialise(new list_immutable_1.ListImmutable(newList));
        }
        listAsSet(list) {
          const newList = [...list];
          return this.initialise(new elan_set_1.ElanSet(newList));
        }
        listAsArray(list) {
          const newList = [...list];
          return this.initialise(new elan_array_1.ElanArray(newList));
        }
        arrayAsListImmutable(list) {
          const newList = [...list];
          return this.initialise(new list_immutable_1.ListImmutable(newList));
        }
        arrayAsSet(list) {
          const newList = [...list];
          return this.initialise(new elan_set_1.ElanSet(newList));
        }
        arrayAsList(list) {
          const newList = [...list];
          return this.initialise(new list_1.List(newList));
        }
        dictionaryAsDictionaryImmutable(dictionary) {
          return this.initialise(new dictionary_immutable_1.DictionaryImmutable([...dictionary.contents.entries()]));
        }
        dictionaryImmutableAsDictionary(dictionary) {
          return this.initialise(new dictionary_1.Dictionary([...dictionary.contents.entries()]));
        }
      };
      exports.System = System;
    }
  });

  // out/src/compiler/standard-library/vector-graphic.js
  var require_vector_graphic = __commonJS({
    "out/src/compiler/standard-library/vector-graphic.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var VectorGraphic_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.VectorGraphic = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var VectorGraphic = VectorGraphic_1 = class VectorGraphic {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new VectorGraphic_1();
        }
        asSVG() {
          return "";
        }
        asColour(colour) {
          if (colour > 16777215 || colour < 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`colour must be in the range 0x0 to 0xffffff (0 to 16777215)`);
          }
          const hex = `000000${colour.toString(16)}`;
          const rgb = hex.substring(hex.length - 6, hex.length);
          return `#${rgb}`;
        }
        strokeColourAsHex(strokeColour) {
          if (strokeColour < 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`strokeColour cannot be transparent (negative value)`);
          }
          return this.asColour(strokeColour);
        }
        fillColourAsHex(fillColour) {
          let colour = "";
          if (fillColour < 0) {
            colour = "none";
          } else {
            colour = this.asColour(fillColour);
          }
          return colour;
        }
        strokeAsHtml(strokeWidth, strokeColour) {
          return `stroke="${this.strokeColourAsHex(strokeColour)}" stroke-width="${strokeWidth * 0.3}%"`;
        }
        fillAsHtml(fillColour) {
          return `fill="${this.fillColourAsHex(fillColour)}"`;
        }
      };
      exports.VectorGraphic = VectorGraphic;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], VectorGraphic.prototype, "asSVG", null);
      exports.VectorGraphic = VectorGraphic = VectorGraphic_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.abstract)
      ], VectorGraphic);
    }
  });

  // out/src/compiler/standard-library/circle-vg.js
  var require_circle_vg = __commonJS({
    "out/src/compiler/standard-library/circle-vg.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var CircleVG_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CircleVG = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var vector_graphic_1 = require_vector_graphic();
      var CircleVG = CircleVG_1 = class CircleVG extends vector_graphic_1.VectorGraphic {
        static emptyInstance() {
          return new CircleVG_1();
        }
        async _initialise() {
          return this;
        }
        system;
        constructor(copy) {
          super();
          this.centreX = copy ? copy.centreX : 50;
          this.centreY = copy ? copy.centreY : 37.5;
          this.radius = copy ? copy.radius : 10;
          this.fillColour = copy ? copy.fillColour : 16776960;
          this.strokeColour = copy ? copy.strokeColour : 0;
          this.strokeWidth = copy ? copy.strokeWidth : 1;
        }
        centreX = 0;
        setCentreX(centreX) {
          this.centreX = centreX;
        }
        withCentreX(centreX) {
          const copy = this.system.initialise(new CircleVG_1(this));
          copy.centreX = centreX;
          return copy;
        }
        centreY = 0;
        setCentreY(centreY) {
          this.centreY = centreY;
        }
        withCentreY(centreY) {
          const copy = this.system.initialise(new CircleVG_1(this));
          copy.centreY = centreY;
          return copy;
        }
        radius = 0;
        setRadius(r) {
          this.radius = r;
        }
        withRadius(r) {
          const copy = this.system.initialise(new CircleVG_1(this));
          copy.radius = r;
          return copy;
        }
        strokeColour = 0;
        setStrokeColour(strokeColour) {
          this.strokeColour = strokeColour;
        }
        withStrokeColour(strokeColour) {
          const copy = this.system.initialise(new CircleVG_1(this));
          copy.strokeColour = strokeColour;
          return copy;
        }
        strokeWidth = 0;
        setStrokeWidth(strokeWidth) {
          this.strokeWidth = strokeWidth;
        }
        withStrokeWidth(strokeWidth) {
          const copy = this.system.initialise(new CircleVG_1(this));
          copy.strokeWidth = strokeWidth;
          return copy;
        }
        fillColour = 0;
        setFillColour(fillColour) {
          this.fillColour = fillColour;
        }
        withFillColour(fillColour) {
          const copy = this.system.initialise(new CircleVG_1(this));
          copy.fillColour = fillColour;
          return copy;
        }
        asSVG() {
          return `<circle cx="${this.centreX}%" cy="${this.centreY / 0.75}%" r="${this.radius * 1.125}%" ${this.strokeAsHtml(this.strokeWidth, this.strokeColour)} ${this.fillAsHtml(this.fillColour)}/>`;
        }
      };
      exports.CircleVG = CircleVG;
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], CircleVG.prototype, "centreX", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["centreX"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], CircleVG.prototype, "setCentreX", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["centreX"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(CircleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", CircleVG)
      ], CircleVG.prototype, "withCentreX", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], CircleVG.prototype, "centreY", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["centreY"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], CircleVG.prototype, "setCentreY", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["centreY"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(CircleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", CircleVG)
      ], CircleVG.prototype, "withCentreY", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], CircleVG.prototype, "radius", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["radius"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], CircleVG.prototype, "setRadius", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["radius"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(CircleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", CircleVG)
      ], CircleVG.prototype, "withRadius", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Number)
      ], CircleVG.prototype, "strokeColour", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["colour"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], CircleVG.prototype, "setStrokeColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["colour"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(CircleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", CircleVG)
      ], CircleVG.prototype, "withStrokeColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], CircleVG.prototype, "strokeWidth", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["strokeWidth"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], CircleVG.prototype, "setStrokeWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["width"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(CircleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", CircleVG)
      ], CircleVG.prototype, "withStrokeWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Number)
      ], CircleVG.prototype, "fillColour", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["fillColour"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], CircleVG.prototype, "setFillColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["colour"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(CircleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", CircleVG)
      ], CircleVG.prototype, "withFillColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], CircleVG.prototype, "asSVG", null);
      exports.CircleVG = CircleVG = CircleVG_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.concrete, [], [], [], [(0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic)]),
        __metadata("design:paramtypes", [CircleVG])
      ], CircleVG);
    }
  });

  // out/src/compiler/standard-library/elan-array-2d.js
  var require_elan_array_2d = __commonJS({
    "out/src/compiler/standard-library/elan-array-2d.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var ElanArray2D_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ElanArray2D = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var ElanArray2D = ElanArray2D_1 = class ElanArray2D {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new ElanArray2D_1();
        }
        async _initialise(x, y, value) {
          if (x <= 0 || y <= 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Each dimension of Array2D must be non zero, positive value`);
          }
          if (!(typeof value === "boolean" || typeof value === "string" || typeof value === "number")) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Array2D must be of Type: Int, Float, String, or Boolean, with matching initial value`);
          }
          const toInit = [];
          toInit.length = x;
          for (let i = 0; i < x; i++) {
            const subArr = [];
            subArr.length = y;
            for (let j = 0; j < y; j++) {
              subArr[j] = value;
            }
            toInit[i] = subArr;
          }
          this.contents = toInit;
          return this;
        }
        constructor(arr) {
          this.contents = arr ? [...arr] : [];
        }
        contents;
        read(x, y) {
          return this.contents[x][y];
        }
        system;
        put(col, row, value) {
          this.system.safeArray2DSet(this.contents, col, row, value);
        }
        withPut(col, row, value) {
          const newList = [];
          for (const column of this.contents) {
            const newCol = [...column];
            newList.push(newCol);
          }
          this.system.safeArray2DSet(newList, col, row, value);
          return this.system.initialise(new ElanArray2D_1(newList));
        }
        columns() {
          return this.contents.length;
        }
        rows() {
          return this.contents[0].length;
        }
        indexOf(item) {
          return this.system.tuple(this.system.elan2DIndexOf(this.contents, item));
        }
        contains(item) {
          const [i, _] = this.system.elan2DIndexOf(this.contents, item);
          return i !== -1;
        }
        async asString() {
          const columns = [];
          for (const column of this.contents) {
            const rows = [];
            for (const row of column) {
              const s = await this.system.asString(row);
              rows.push(s);
            }
            columns.push(`[${rows.join(", ")}]`);
          }
          return `[${columns.join(", ")}]`;
        }
        async asCloneableObject() {
          return this.contents;
        }
        safeIndex(index1, index2) {
          if (index2 === void 0) {
            this.system.throwRangeError(this.contents, index2);
            return;
          }
          const r = this.contents[index1];
          if (r === void 0) {
            this.system.throwRangeError(this.contents, index1);
            return;
          }
          const r1 = r[index2];
          if (r1 === void 0) {
            this.system.throwRangeError(r, index2);
            return;
          }
          return r1;
        }
      };
      exports.ElanArray2D = ElanArray2D;
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["column", "row", "value"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __param(2, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number, Object]),
        __metadata("design:returntype", void 0)
      ], ElanArray2D.prototype, "put", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["column", "row", "value"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ElanArray2D)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __param(2, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number, Object]),
        __metadata("design:returntype", ElanArray2D)
      ], ElanArray2D.prototype, "withPut", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ElanArray2D.prototype, "columns", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], ElanArray2D.prototype, "rows", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanInt, elan_type_annotations_1.ElanInt])),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Array)
      ], ElanArray2D.prototype, "indexOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["item"], elan_type_annotations_1.FunctionOptions.pure),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Boolean)
      ], ElanArray2D.prototype, "contains", null);
      exports.ElanArray2D = ElanArray2D = ElanArray2D_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.array2D, [elan_type_annotations_1.ElanT1], ["columns", "rows", "initialValue"], [elan_type_annotations_1.ElanInt, elan_type_annotations_1.ElanInt, elan_type_annotations_1.ElanT1], [], "Array2D"),
        __metadata("design:paramtypes", [Array])
      ], ElanArray2D);
    }
  });

  // out/src/compiler/standard-library/image-vg.js
  var require_image_vg = __commonJS({
    "out/src/compiler/standard-library/image-vg.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var ImageVG_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ImageVG = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var vector_graphic_1 = require_vector_graphic();
      var ImageVG = ImageVG_1 = class ImageVG extends vector_graphic_1.VectorGraphic {
        static emptyInstance() {
          return new ImageVG_1();
        }
        async _initialise(url) {
          this.url = url;
          return this;
        }
        system;
        constructor(copy) {
          super();
          this.x = copy ? copy.x : 0;
          this.y = copy ? copy.y : 0;
          this.width = copy ? copy.width : 13.2;
          this.height = copy ? copy.height : 13.2;
          this.url = copy ? copy.url : "";
          this.alt = copy ? copy.alt : "";
        }
        x = 0;
        setX(x) {
          this.x = x;
        }
        withX(x) {
          const copy = this.system.initialise(new ImageVG_1(this));
          copy.x = x;
          return copy;
        }
        y = 0;
        setY(y) {
          this.y = y;
        }
        withY(y) {
          const copy = this.system.initialise(new ImageVG_1(this));
          copy.y = y;
          return copy;
        }
        alt;
        setAlt(alt) {
          this.alt = alt;
        }
        withAlt(alt) {
          const copy = this.system.initialise(new ImageVG_1(this));
          copy.alt = alt;
          return copy;
        }
        width;
        // for same (default) size as thumbnail in code
        setWidth(width) {
          this.width = width;
        }
        withWidth(width) {
          const copy = this.system.initialise(new ImageVG_1(this));
          copy.width = width;
          return copy;
        }
        height = 13.2;
        // see width
        setHeight(height) {
          this.height = height;
        }
        withHeight(height) {
          const copy = this.system.initialise(new ImageVG_1(this));
          copy.height = height;
          return copy;
        }
        url = "";
        getUrl() {
          return this.url;
        }
        title = "";
        setTitle(title) {
          this.title = title;
        }
        withTitle(title) {
          const copy = this.system.initialise(new ImageVG_1(this));
          copy.title = title;
          return copy;
        }
        asSVG() {
          return `<image x="${this.x}%" y="${this.y / 0.75}%" width="${this.width}" height="${this.height / 0.75}" href="${this.url}" title="${this.title}" alt="${this.alt}"/>`;
        }
        asHtml() {
          return `<img src='${this.url}' width='${this.width}' height='${this.height}' title='${this.title}' alt='${this.alt}'>`;
        }
        asString() {
          return `an ImageVG`;
        }
      };
      exports.ImageVG = ImageVG;
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], ImageVG.prototype, "x", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], ImageVG.prototype, "setX", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["x"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ImageVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", ImageVG)
      ], ImageVG.prototype, "withX", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], ImageVG.prototype, "y", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["y"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], ImageVG.prototype, "setY", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["y"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ImageVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", ImageVG)
      ], ImageVG.prototype, "withY", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", String)
      ], ImageVG.prototype, "alt", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["alt"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", void 0)
      ], ImageVG.prototype, "setAlt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["alt"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ImageVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", ImageVG)
      ], ImageVG.prototype, "withAlt", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], ImageVG.prototype, "width", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["width"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], ImageVG.prototype, "setWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["width"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ImageVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", ImageVG)
      ], ImageVG.prototype, "withWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], ImageVG.prototype, "height", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["height"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], ImageVG.prototype, "setHeight", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["height"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ImageVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", ImageVG)
      ], ImageVG.prototype, "withHeight", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", String)
      ], ImageVG.prototype, "url", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], ImageVG.prototype, "getUrl", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", String)
      ], ImageVG.prototype, "title", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["title"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", void 0)
      ], ImageVG.prototype, "setTitle", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["title"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(ImageVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", ImageVG)
      ], ImageVG.prototype, "withTitle", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], ImageVG.prototype, "asSVG", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], ImageVG.prototype, "asHtml", null);
      exports.ImageVG = ImageVG = ImageVG_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.concrete, [], [], [elan_type_annotations_1.ElanString], [(0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic)]),
        __metadata("design:paramtypes", [ImageVG])
      ], ImageVG);
    }
  });

  // out/src/compiler/standard-library/line-vg.js
  var require_line_vg = __commonJS({
    "out/src/compiler/standard-library/line-vg.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var LineVG_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LineVG = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var vector_graphic_1 = require_vector_graphic();
      var LineVG = LineVG_1 = class LineVG extends vector_graphic_1.VectorGraphic {
        static emptyInstance() {
          return new LineVG_1();
        }
        async _initialise() {
          return this;
        }
        system;
        constructor(copy) {
          super();
          this.x1 = copy ? copy.x1 : 10;
          this.y1 = copy ? copy.y1 : 10;
          this.x2 = copy ? copy.x2 : 70;
          this.y2 = copy ? copy.y2 : 40;
          this.strokeColour = copy ? copy.strokeColour : 0;
          this.strokeWidth = copy ? copy.strokeWidth : 1;
        }
        x1 = 0;
        setX1(x1) {
          this.x1 = x1;
        }
        withX1(x1) {
          const copy = this.system.initialise(new LineVG_1(this));
          copy.x1 = x1;
          return copy;
        }
        y1 = 0;
        setY1(y1) {
          this.y1 = y1;
        }
        withY1(y1) {
          const copy = this.system.initialise(new LineVG_1(this));
          copy.y1 = y1;
          return copy;
        }
        x2 = 0;
        setX2(x2) {
          this.x2 = x2;
        }
        withX2(x2) {
          const copy = this.system.initialise(new LineVG_1(this));
          copy.x2 = x2;
          return copy;
        }
        y2 = 0;
        setY2(y2) {
          this.y2 = y2;
        }
        withY2(y2) {
          const copy = this.system.initialise(new LineVG_1(this));
          copy.y2 = y2;
          return copy;
        }
        strokeColour = 0;
        setStrokeColour(strokeColour) {
          this.strokeColour = strokeColour;
        }
        withStrokeColour(strokeColour) {
          const copy = this.system.initialise(new LineVG_1(this));
          copy.strokeColour = strokeColour;
          return copy;
        }
        strokeWidth = 0;
        setStrokeWidth(strokeWidth) {
          this.strokeWidth = strokeWidth;
        }
        withStrokeWidth(strokeWidth) {
          const copy = this.system.initialise(new LineVG_1(this));
          copy.strokeWidth = strokeWidth;
          return copy;
        }
        asSVG() {
          return `<line x1="${this.x1}%" y1="${this.y1 / 0.75}%" x2="${this.x2}%" y2="${this.y2 / 0.75}%" ${this.strokeAsHtml(this.strokeWidth, this.strokeColour)}/>`;
        }
      };
      exports.LineVG = LineVG;
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], LineVG.prototype, "x1", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x1"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], LineVG.prototype, "setX1", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["x1"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(LineVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", LineVG)
      ], LineVG.prototype, "withX1", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], LineVG.prototype, "y1", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["y1"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], LineVG.prototype, "setY1", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["y1"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(LineVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", LineVG)
      ], LineVG.prototype, "withY1", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], LineVG.prototype, "x2", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x2"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], LineVG.prototype, "setX2", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["x2"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(LineVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", LineVG)
      ], LineVG.prototype, "withX2", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], LineVG.prototype, "y2", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x2"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], LineVG.prototype, "setY2", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["x2"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(LineVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", LineVG)
      ], LineVG.prototype, "withY2", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Number)
      ], LineVG.prototype, "strokeColour", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["colour"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], LineVG.prototype, "setStrokeColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["colour"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(LineVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", LineVG)
      ], LineVG.prototype, "withStrokeColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], LineVG.prototype, "strokeWidth", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["strokeWidth"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], LineVG.prototype, "setStrokeWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["width"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(LineVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", LineVG)
      ], LineVG.prototype, "withStrokeWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], LineVG.prototype, "asSVG", null);
      exports.LineVG = LineVG = LineVG_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.record, [], [], [], [(0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic)]),
        __metadata("design:paramtypes", [LineVG])
      ], LineVG);
    }
  });

  // out/src/compiler/standard-library/queue.js
  var require_queue = __commonJS({
    "out/src/compiler/standard-library/queue.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var Queue_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Queue = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var Queue = Queue_1 = class Queue {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new Queue_1();
        }
        async _initialise() {
          return this;
        }
        constructor(arr) {
          this.contents = arr ? [...arr] : [];
        }
        contents;
        system;
        peek() {
          if (this.contents.length === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Cannot peek an empty Queue - check using length()`);
          }
          return this.contents[0];
        }
        length() {
          return this.contents.length;
        }
        enqueue(item) {
          const newContents = [...this.contents];
          newContents.push(item);
          return this.system.initialise(new Queue_1(newContents));
        }
        dequeue() {
          if (this.contents.length === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Cannot dequeue an empty Queue - check using length()`);
          }
          const newContents = [...this.contents];
          const item = newContents.shift();
          const newQueue = this.system.initialise(new Queue_1(newContents));
          return this.system.tuple([item, newQueue]);
        }
        async asString() {
          const items = [];
          for (const i of this.contents) {
            const s = await this.system.asString(i);
            items.push(s);
          }
          return `[${items.join(", ")}]`;
        }
      };
      exports.Queue = Queue;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanT1),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Object)
      ], Queue.prototype, "peek", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Queue.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(Queue)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], Queue.prototype, "enqueue", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanT1, (0, elan_type_annotations_1.ElanClass)(Queue)])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Array)
      ], Queue.prototype, "dequeue", null);
      exports.Queue = Queue = Queue_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.record, [elan_type_annotations_1.ElanT1]),
        __metadata("design:paramtypes", [Array])
      ], Queue);
    }
  });

  // out/src/compiler/standard-library/random.js
  var require_random = __commonJS({
    "out/src/compiler/standard-library/random.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var Random_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Random = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var Random = Random_1 = class Random {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new Random_1();
        }
        async _initialise() {
          return this;
        }
        constructor() {
          this.u = 521288629;
          this.v = 362436069;
        }
        system;
        u;
        v;
        next() {
          return this.nextImpl();
        }
        nextImpl() {
          const value = this.lo32(this.lo32(this.u * 65536) + this.v + 1) * 2328306435454494e-25;
          const rnd2 = this.system.initialise(new Random_1());
          rnd2.u = 36969 * (this.u % 65536) + this.u / 65536;
          rnd2.v = 18e3 * (this.v % 65536) + this.v / 65536;
          return [value, rnd2];
        }
        lo32(n) {
          return n % 4294967296;
        }
        nextInt(min, max) {
          const [float, rnd2] = this.nextImpl();
          const value = Math.floor(float * (max - min + 1) + min);
          return [value, rnd2];
        }
        initialiseFromClock() {
          const c = (/* @__PURE__ */ new Date()).getTime();
          this.u = c % 1e3 * 1e6;
          this.v = 0;
        }
      };
      exports.Random = Random;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanFloat, (0, elan_type_annotations_1.ElanClass)(Random)])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Random.prototype, "next", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["min", "max"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanInt, (0, elan_type_annotations_1.ElanClass)(Random)])),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", void 0)
      ], Random.prototype, "nextInt", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Random.prototype, "initialiseFromClock", null);
      exports.Random = Random = Random_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.record),
        __metadata("design:paramtypes", [])
      ], Random);
    }
  });

  // out/src/compiler/standard-library/raw-vg.js
  var require_raw_vg = __commonJS({
    "out/src/compiler/standard-library/raw-vg.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var RawVG_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.RawVG = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var vector_graphic_1 = require_vector_graphic();
      var RawVG = RawVG_1 = class RawVG extends vector_graphic_1.VectorGraphic {
        static emptyInstance() {
          return new RawVG_1();
        }
        async _initialise() {
          return this;
        }
        system;
        constructor(copy) {
          super();
          this.rawSVGcontent = copy ? copy?.rawSVGcontent : "";
        }
        rawSVGcontent = "";
        asSVG() {
          return this.rawSVGcontent;
        }
      };
      exports.RawVG = RawVG;
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", String)
      ], RawVG.prototype, "rawSVGcontent", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], RawVG.prototype, "asSVG", null);
      exports.RawVG = RawVG = RawVG_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.concrete, [], [], [], [(0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic)]),
        __metadata("design:paramtypes", [RawVG])
      ], RawVG);
    }
  });

  // out/src/compiler/standard-library/rectangle-vg.js
  var require_rectangle_vg = __commonJS({
    "out/src/compiler/standard-library/rectangle-vg.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var RectangleVG_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.RectangleVG = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var vector_graphic_1 = require_vector_graphic();
      var RectangleVG = RectangleVG_1 = class RectangleVG extends vector_graphic_1.VectorGraphic {
        static emptyInstance() {
          return new RectangleVG_1();
        }
        async _initialise() {
          return this;
        }
        system;
        constructor(copy) {
          super();
          this.x = copy ? copy.x : 10;
          this.y = copy ? copy.y : 10;
          this.width = copy ? copy.width : 40;
          this.height = copy ? copy.height : 20;
          this.fillColour = copy ? copy.fillColour : 16776960;
          this.strokeColour = copy ? copy.strokeColour : 0;
          this.strokeWidth = copy ? copy.strokeWidth : 1;
        }
        x = 0;
        setX(x) {
          this.x = x;
        }
        withX(x) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.x = x;
          return copy;
        }
        y = 0;
        setY(y) {
          this.y = y;
        }
        withY(y) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.y = y;
          return copy;
        }
        width = 0;
        setWidth(width) {
          this.width = width;
        }
        withWidth(width) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.width = width;
          return copy;
        }
        height = 0;
        setHeight(height) {
          this.height = height;
        }
        withHeight(height) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.height = height;
          return copy;
        }
        strokeColour = 0;
        setStrokeColour(strokeColour) {
          this.strokeColour = strokeColour;
        }
        withStrokeColour(strokeColour) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.strokeColour = strokeColour;
          return copy;
        }
        strokeWidth = 0;
        setStrokeWidth(strokeWidth) {
          this.strokeWidth = strokeWidth;
        }
        withStrokeWidth(strokeWidth) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.strokeWidth = strokeWidth;
          return copy;
        }
        fillColour = 0;
        setFillColour(fillColour) {
          this.fillColour = fillColour;
        }
        withFillColour(fillColour) {
          const copy = this.system.initialise(new RectangleVG_1(this));
          copy.fillColour = fillColour;
          return copy;
        }
        asSVG() {
          return `<rect x="${this.x}%" y="${this.y / 0.75}%" width="${this.width}%" height="${this.height / 0.75}%" ${this.strokeAsHtml(this.strokeWidth, this.strokeColour)} ${this.fillAsHtml(this.fillColour)}/>`;
        }
      };
      exports.RectangleVG = RectangleVG;
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "x", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setX", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["x"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withX", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "y", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["y"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setY", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["y"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withY", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "width", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["width"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["width"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "height", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["height"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setHeight", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["height"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withHeight", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "strokeColour", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["colour"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setStrokeColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["colour"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withStrokeColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "strokeWidth", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["strokeWidth"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setStrokeWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["width"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withStrokeWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Number)
      ], RectangleVG.prototype, "fillColour", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["fillColour"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], RectangleVG.prototype, "setFillColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["colour"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(RectangleVG)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", RectangleVG)
      ], RectangleVG.prototype, "withFillColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], RectangleVG.prototype, "asSVG", null);
      exports.RectangleVG = RectangleVG = RectangleVG_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.record, [], [], [], [(0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic)]),
        __metadata("design:paramtypes", [RectangleVG])
      ], RectangleVG);
    }
  });

  // out/src/compiler/standard-library/stack.js
  var require_stack = __commonJS({
    "out/src/compiler/standard-library/stack.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var Stack_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Stack = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var Stack = Stack_1 = class Stack {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new Stack_1();
        }
        async _initialise() {
          return this;
        }
        constructor(arr) {
          this.contents = arr ? [...arr] : [];
        }
        contents;
        system;
        peek() {
          if (this.contents.length === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Cannot peek an empty Stack - check using length()`);
          }
          return this.contents[0];
        }
        length() {
          return this.contents.length;
        }
        push(item) {
          const newContents = [...this.contents];
          newContents.unshift(item);
          return this.system.initialise(new Stack_1(newContents));
        }
        pop() {
          if (this.contents.length === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Cannot pop an empty Stack - check using length()`);
          }
          const newContents = [...this.contents];
          const item = newContents.shift();
          const newStack = this.system.initialise(new Stack_1(newContents));
          return this.system.tuple([item, newStack]);
        }
        async asString() {
          const items = [];
          for (const i of this.contents) {
            const s = await this.system.asString(i);
            items.push(s);
          }
          return `[${items.join(", ")}]`;
        }
      };
      exports.Stack = Stack;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanT1),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Object)
      ], Stack.prototype, "peek", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Stack.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(Stack)),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", void 0)
      ], Stack.prototype, "push", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanT1, (0, elan_type_annotations_1.ElanClass)(Stack)])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Array)
      ], Stack.prototype, "pop", null);
      exports.Stack = Stack = Stack_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.record, [elan_type_annotations_1.ElanT1]),
        __metadata("design:paramtypes", [Array])
      ], Stack);
    }
  });

  // out/src/compiler/standard-library/text-file-reader.js
  var require_text_file_reader = __commonJS({
    "out/src/compiler/standard-library/text-file-reader.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TextFileReader = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var TextFileReader = class _TextFileReader {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new _TextFileReader();
        }
        async _initialise() {
          return this;
        }
        constructor() {
        }
        system;
        status = 0;
        //0 = Closed, 1 = Open
        content = [];
        currentLine = 0;
        readLine() {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          let line = "";
          if (this.currentLine < this.content.length) {
            line = this.content[this.currentLine].trim();
            this.currentLine++;
          }
          return line;
        }
        cannotUseOnClosed = "Cannot use any method on a closed file";
        readWholeFile() {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          this.status = 0;
          return this.content.join("\n");
        }
        close() {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          this.status = 0;
        }
        endOfFile() {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          return this.currentLine >= this.content.length;
        }
      };
      exports.TextFileReader = TextFileReader;
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], TextFileReader.prototype, "readLine", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], TextFileReader.prototype, "readWholeFile", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], TextFileReader.prototype, "close", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanBoolean),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Boolean)
      ], TextFileReader.prototype, "endOfFile", null);
    }
  });

  // out/src/compiler/standard-library/text-file-writer.js
  var require_text_file_writer = __commonJS({
    "out/src/compiler/standard-library/text-file-writer.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TextFileWriter = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var TextFileWriter = class _TextFileWriter {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new _TextFileWriter();
        }
        async _initialise() {
          return this;
        }
        constructor() {
        }
        system;
        status = 0;
        //0 = Closed, 1 = Open
        fileName = "";
        content = [];
        currentLine = 0;
        cannotUseOnClosed = "Cannot use any method on a closed file";
        writeLine(data) {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          this.content.push(data);
        }
        async writeWholeFile(data) {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          if (this.content.length > 0) {
            throw new elan_runtime_error_1.ElanRuntimeError("Cannot call 'writeWholeFile' if content has already been written using 'writeLine'");
          }
          this.status = 0;
          try {
            await this.system.elanInputOutput.writeFile(this.fileName, data);
          } catch (e) {
            throw new elan_runtime_error_1.ElanRuntimeError(e);
          }
        }
        async saveAndClose() {
          if (this.status === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError(this.cannotUseOnClosed);
          }
          this.status = 0;
          try {
            await this.system.elanInputOutput.writeFile(this.fileName, this.content.join("\n"));
          } catch (e) {
            throw new elan_runtime_error_1.ElanRuntimeError(e);
          }
        }
      };
      exports.TextFileWriter = TextFileWriter;
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", void 0)
      ], TextFileWriter.prototype, "writeLine", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], TextFileWriter.prototype, "writeWholeFile", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], TextFileWriter.prototype, "saveAndClose", null);
    }
  });

  // out/src/compiler/standard-library/graphics-base.js
  var require_graphics_base = __commonJS({
    "out/src/compiler/standard-library/graphics-base.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var GraphicsBase_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.GraphicsBase = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var GraphicsBase = GraphicsBase_1 = class GraphicsBase {
        // this must be implemented by hand on all stdlib classes
        static emptyInstance() {
          return new GraphicsBase_1();
        }
        constructor() {
        }
        asHtml() {
          return "";
        }
      };
      exports.GraphicsBase = GraphicsBase;
      exports.GraphicsBase = GraphicsBase = GraphicsBase_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.abstract),
        __metadata("design:paramtypes", [])
      ], GraphicsBase);
    }
  });

  // out/src/compiler/standard-library/turtle.js
  var require_turtle = __commonJS({
    "out/src/compiler/standard-library/turtle.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var Turtle_1;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Turtle = void 0;
      var elan_type_annotations_1 = require_elan_type_annotations();
      var circle_vg_1 = require_circle_vg();
      var graphics_base_1 = require_graphics_base();
      var line_vg_1 = require_line_vg();
      var list_1 = require_list();
      var Turtle = Turtle_1 = class Turtle extends graphics_base_1.GraphicsBase {
        // this must = implemented by hand on all stdlib classes
        static emptyInstance() {
          return new Turtle_1();
        }
        async _initialise() {
          return this;
        }
        _system;
        set system(value) {
          this._system = value;
          this.vg = this._system.initialise(new list_1.List());
        }
        constructor() {
          super();
          this.x = 0;
          this.y = 0;
          this.heading = 0;
          this.pen = true;
          this.shown = true;
          this.colour = 0;
          this.width = 1;
          this.vg = new list_1.List();
        }
        reset() {
          this.x = 0;
          this.y = 0;
          this.heading = 0;
          this.pen = true;
          this.shown = true;
          this.colour = 0;
          this.width = 1;
        }
        stdlib;
        // injected
        vg;
        x;
        y;
        heading;
        pen;
        shown;
        colour;
        width;
        async show() {
          this.removeTurtleIfShown();
          this.shown = true;
          this.addTurtleIfShown();
          await this.stdlib.displayVectorGraphics(this.vg);
        }
        async clearAndReset() {
          this.vg = this._system.initialise(new list_1.List());
          this.x = 0;
          this.y = 0;
          this.heading = 0;
          this.pen = true;
          this.colour = 0;
          this.width = 1;
          await this.stdlib.displayVectorGraphics(this.vg);
        }
        async hide() {
          this.removeTurtleIfShown();
          this.shown = false;
          await this.stdlib.displayVectorGraphics(this.vg);
        }
        penUp() {
          this.pen = false;
        }
        penDown() {
          this.pen = true;
        }
        addTurtleIfShown() {
          if (this.shown) {
            const turtle = new circle_vg_1.CircleVG();
            turtle.centreX = this.asVGx(this.x);
            turtle.centreY = this.asVGy(this.y);
            turtle.radius = 2;
            turtle.fillColour = 32768;
            turtle.strokeWidth = 0;
            const [x2, y2] = this.getDestination(2);
            const pointer = new line_vg_1.LineVG();
            pointer.x1 = this.asVGx(this.x);
            pointer.y1 = this.asVGy(this.y);
            pointer.x2 = this.asVGx(x2);
            pointer.y2 = this.asVGy(y2);
            pointer.strokeWidth = 2;
            this.vg.append(turtle);
            this.vg.append(pointer);
          }
        }
        removeTurtleIfShown() {
          if (this.shown) {
            const len = this.vg.length();
            this.vg.removeAt(len - 1);
            this.vg.removeAt(len - 2);
          }
        }
        getDestination(distance) {
          const newX = this.x + distance * this.stdlib.sinDeg(this.heading);
          const newY = this.y + distance * this.stdlib.cosDeg(this.heading);
          return [newX, newY];
        }
        async move(distance) {
          const [x, y] = this.getDestination(distance);
          await this.moveTo(x, y);
        }
        asVGx(x) {
          return x / 2 + 50;
        }
        asVGy(y) {
          return -y / 2 + 37.5;
        }
        async moveTo(x, y) {
          this.removeTurtleIfShown();
          if (this.pen) {
            const line = new line_vg_1.LineVG();
            line.x1 = this.asVGx(this.x);
            line.y1 = this.asVGy(this.y);
            line.x2 = this.asVGx(x);
            line.y2 = this.asVGy(y);
            line.strokeColour = this.colour;
            line.strokeWidth = this.width;
            this.vg.append(line);
          }
          this.x = x;
          this.y = y;
          this.addTurtleIfShown();
          await this.stdlib.displayVectorGraphics(this.vg);
        }
        async turn(degrees) {
          await this.turnToHeading(this.heading + degrees);
        }
        async turnToHeading(heading) {
          this.removeTurtleIfShown();
          this.heading = this.normaliseHeading(heading);
          this.addTurtleIfShown();
          await this.stdlib.displayVectorGraphics(this.vg);
        }
        normaliseHeading(x) {
          return x >= 360 ? this.normaliseHeading(x - 360) : x < 0 ? this.normaliseHeading(x + 360) : x;
        }
        penColour(colour) {
          this.colour = colour;
        }
        penWidth(width) {
          this.width = width > 0 ? width : 1;
        }
        async placeAt(x, y) {
          this.removeTurtleIfShown();
          this.x = x;
          this.y = y;
          this.addTurtleIfShown();
          await this.stdlib.displayVectorGraphics(this.vg);
        }
        asHtml() {
          return this.stdlib.vectorGraphicsAsHtml(this.vg);
        }
      };
      exports.Turtle = Turtle;
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], Turtle.prototype, "x", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], Turtle.prototype, "y", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProperty)(),
        __metadata("design:type", Number)
      ], Turtle.prototype, "heading", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "show", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "clearAndReset", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "hide", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Turtle.prototype, "penUp", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
      ], Turtle.prototype, "penDown", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["distance"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "move", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x", "y"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "moveTo", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["degrees"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "turn", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "turnToHeading", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["colour"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], Turtle.prototype, "penColour", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["width"]),
        __param(0, (0, elan_type_annotations_1.elanFloatType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], Turtle.prototype, "penWidth", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["x", "y"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Promise)
      ], Turtle.prototype, "placeAt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", String)
      ], Turtle.prototype, "asHtml", null);
      exports.Turtle = Turtle = Turtle_1 = __decorate([
        (0, elan_type_annotations_1.elanClass)(elan_type_annotations_1.ClassOption.concrete, [], [], [], [(0, elan_type_annotations_1.ElanClass)(graphics_base_1.GraphicsBase)]),
        __metadata("design:paramtypes", [])
      ], Turtle);
    }
  });

  // out/src/compiler/standard-library/std-lib.js
  var require_std_lib = __commonJS({
    "out/src/compiler/standard-library/std-lib.js"(exports) {
      "use strict";
      var __decorate = exports && exports.__decorate || function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      var __metadata = exports && exports.__metadata || function(k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
      };
      var __param = exports && exports.__param || function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      var _b;
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StdLib = void 0;
      require_Reflect();
      var elan_type_interfaces_1 = require_elan_type_interfaces();
      var elan_compiler_error_1 = require_elan_compiler_error();
      var elan_type_annotations_1 = require_elan_type_annotations();
      var system_1 = require_system();
      var circle_vg_1 = require_circle_vg();
      var dictionary_1 = require_dictionary();
      var dictionary_immutable_1 = require_dictionary_immutable();
      var elan_array_1 = require_elan_array();
      var elan_array_2d_1 = require_elan_array_2d();
      var elan_runtime_error_1 = require_elan_runtime_error();
      var elan_set_1 = require_elan_set();
      var image_vg_1 = require_image_vg();
      var line_vg_1 = require_line_vg();
      var list_1 = require_list();
      var list_immutable_1 = require_list_immutable();
      var queue_1 = require_queue();
      var random_1 = require_random();
      var raw_vg_1 = require_raw_vg();
      var rectangle_vg_1 = require_rectangle_vg();
      var stack_1 = require_stack();
      var text_file_reader_1 = require_text_file_reader();
      var text_file_writer_1 = require_text_file_writer();
      var turtle_1 = require_turtle();
      var vector_graphic_1 = require_vector_graphic();
      var StdLib = class _StdLib {
        constructor(io) {
          this.system = new system_1.System(io);
        }
        static negatableLitIntOnly = /^\s*-?((0b[0-1]+)|(0x[0-9a-fA-F]+)|([0-9]+))$/;
        static negatableLitFloatOnly = /^\s*-?[0-9]+(\.[0-9]+)?((e|E)[+-]?[0-9]+)?$/;
        system;
        // types
        TextFileReader = text_file_reader_1.TextFileReader;
        TextFileWriter = text_file_writer_1.TextFileWriter;
        Random = random_1.Random;
        Stack = stack_1.Stack;
        Queue = queue_1.Queue;
        Set = elan_set_1.ElanSet;
        Turtle = turtle_1.Turtle;
        VectorGraphic = vector_graphic_1.VectorGraphic;
        CircleVG = circle_vg_1.CircleVG;
        LineVG = line_vg_1.LineVG;
        RectangleVG = rectangle_vg_1.RectangleVG;
        ImageVG = image_vg_1.ImageVG;
        RawVG = raw_vg_1.RawVG;
        List = list_1.List;
        Array = elan_array_1.ElanArray;
        Array2D = elan_array_2d_1.ElanArray2D;
        ListImmutable = list_immutable_1.ListImmutable;
        Dictionary = dictionary_1.Dictionary;
        DictionaryImmutable = dictionary_immutable_1.DictionaryImmutable;
        // Standard colours
        black = 0;
        grey = 8421504;
        white = 16777215;
        red = 16711680;
        green = 32768;
        blue = 255;
        yellow = 16776960;
        brown = 10824234;
        transparent = -1;
        true = true;
        false = false;
        pi = Math.PI;
        meaningOfLife = 42;
        quotes = `"`;
        openBrace = `{`;
        closeBrace = `}`;
        isValueType(v) {
          return typeof v === "boolean" || typeof v === "string" || typeof v === "number";
        }
        async asString(v) {
          if (v === void 0 || v === null) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Out of range error`);
          }
          if (typeof v === "boolean") {
            return v ? "true" : "false";
          }
          if (typeof v === "string") {
            return v.toString();
          }
          if (typeof v === "number") {
            return v.toString();
          }
          if (v instanceof RegExp) {
            return "A RegExp";
          }
          if (Array.isArray(v)) {
            const items = [];
            for (const i of v) {
              const s = await this.asString(i);
              items.push(s);
            }
            if (items.length < 2) {
              return items.join("");
            }
            return `tuple(${items.join(", ")})`;
          }
          if (typeof v === "object" && "asString" in v) {
            return await v.asString();
          }
          if (typeof v === "object") {
            return `a ${v.constructor.name}`;
          }
          if (typeof v === "function") {
            return `function ${v.name}`;
          }
          throw new elan_compiler_error_1.ElanCompilerError("Not implemented: " + typeof v);
        }
        unicode(n) {
          return String.fromCharCode(n);
        }
        asUnicode(s) {
          return s.charCodeAt(0);
        }
        indexOf(s, item) {
          return s.indexOf(item);
        }
        sequence(start, end) {
          const seq = [];
          for (let i = start; i <= end; i++) {
            seq.push(i);
          }
          return this.system.initialise(new list_1.List(seq));
        }
        sequenceWithStep(start, end, step) {
          const seq = [];
          if (step === 0) {
            throw new elan_runtime_error_1.ElanRuntimeError("value for step cannot be zero");
          } else if (step > 0) {
            for (let i = start; i <= end; i = i + step) {
              seq.push(i);
            }
          } else if (step < 0) {
            if (start < end) {
              throw new elan_runtime_error_1.ElanRuntimeError("Loop will not terminate when start < end start with negative step");
            }
            for (let i = start; i >= end; i = i + step) {
              seq.push(i);
            }
          }
          return this.system.initialise(new list_1.List(seq));
        }
        replace(instance, match, replacement) {
          return instance.replaceAll(match, replacement);
        }
        length(coll) {
          return coll.length;
        }
        upperCase(s1) {
          return s1.toUpperCase();
        }
        lowerCase(s1) {
          return s1.toLowerCase();
        }
        isBefore(instance, other) {
          return instance < other;
        }
        isAfter(instance, other) {
          return instance > other;
        }
        isAfterOrSameAs(instance, other) {
          return instance > other || instance === other;
        }
        isBeforeOrSameAs(instance, other) {
          return instance < other || instance === other;
        }
        trim(s) {
          return s.trim();
        }
        split(s, separator) {
          return this.system.initialise(new list_1.List(s.split(separator)));
        }
        floor(n) {
          return Math.floor(n);
        }
        isNaN(n) {
          return isNaN(n);
        }
        isInfinite(n) {
          return n === Number.POSITIVE_INFINITY || n === Number.NEGATIVE_INFINITY;
        }
        round(n, places) {
          const shift = 10 ** places;
          return Math.floor(n * shift + 0.5) / shift;
        }
        ceiling(n) {
          const fl = this.floor(n);
          return n > fl ? fl + 1 : fl;
        }
        maxFloat(source) {
          return Math.max(...source);
        }
        maxInt(source) {
          return Math.max(...source);
        }
        minFloat(source) {
          return Math.min(...source);
        }
        minInt(source) {
          return Math.min(...source);
        }
        contains(source, item) {
          return source.includes(item);
        }
        pause(ms) {
          return new Promise((resolve) => {
            setTimeout(() => resolve(), ms);
          });
        }
        clock() {
          return (/* @__PURE__ */ new Date()).getTime();
        }
        random() {
          return Math.random();
        }
        randomInt(low, high) {
          return Math.floor(Math.random() * (high - low + 1)) + low;
        }
        parseAsFloat(s) {
          if (_StdLib.negatableLitFloatOnly.test(s)) {
            const f = parseFloat(s);
            if (Number.isFinite(f)) {
              return this.system.tuple([true, f]);
            }
          }
          return this.system.tuple([false, 0]);
        }
        parseAsInt(s) {
          if (_StdLib.negatableLitIntOnly.test(s)) {
            const i = parseInt(s);
            if (isFinite(i)) {
              return this.system.tuple([true, i]);
            }
          }
          return this.system.tuple([false, 0]);
        }
        async printLine(s) {
          await this.system.elanInputOutput.print(`${s}
`);
        }
        async printNoLine(s) {
          await this.system.elanInputOutput.print(s);
        }
        async printTab(position, s) {
          await this.system.elanInputOutput.printTab(position, s);
        }
        async clearPrintedText() {
          await this.system.elanInputOutput.clearPrintedText();
        }
        async clearAllDisplays() {
          await this.clearPrintedText();
          await this.clearBlocks();
          await this.clearVectorGraphics();
          await this.clearHtml();
        }
        createList(x, value) {
          if (!this.isValueType(value)) {
            throw new elan_runtime_error_1.ElanRuntimeError(`Can only create List with simple value`);
          }
          const toInit = [];
          for (let i = 0; i < x; i++) {
            toInit[i] = value;
          }
          return this.system.initialise(new list_1.List(toInit));
        }
        //Input functions
        async prompt(prompt2) {
          await this.printLine(prompt2);
        }
        async inputString(prompt2) {
          await this.prompt(prompt2);
          return await this.system.input();
        }
        async inputStringWithLimits(prompt2, minLength, maxLength) {
          const s = await this.inputString(prompt2);
          if (s.length < minLength) {
            await this.prompt(`minimum length ${minLength} characters`);
          } else if (s.length > maxLength) {
            await this.prompt(`maximum length ${maxLength} characters`);
          } else {
            return s;
          }
          return await this.inputStringWithLimits(prompt2, minLength, maxLength);
        }
        async inputStringFromOptions(prompt2, options) {
          const s = await this.inputString(prompt2);
          if (options.contains(s)) {
            return s;
          }
          const valid = await options.asString();
          await this.prompt(`response must be one of ${valid}`);
          return await this.inputStringFromOptions(prompt2, options);
        }
        async inputInt(prompt2) {
          const s = await this.inputString(prompt2);
          const [b, i] = this.parseAsInt(s);
          if (b && i.toString() === s) {
            return i;
          }
          await this.prompt("must be an integer");
          return await this.inputInt(prompt2);
        }
        async inputIntBetween(prompt2, min, max) {
          const s = await this.inputString(prompt2);
          const [b, i] = this.parseAsInt(s);
          if (b && i.toString() === s && i >= min && i <= max) {
            return i;
          }
          await this.prompt(`must be an integer between ${min} and ${max} inclusive`);
          return await this.inputIntBetween(prompt2, min, max);
        }
        async inputFloat(prompt2) {
          const s = await this.inputString(prompt2);
          const [b, i] = this.parseAsFloat(s);
          if (b) {
            return i;
          }
          await this.prompt("not a number");
          return await this.inputFloat(prompt2);
        }
        async inputFloatBetween(prompt2, min, max) {
          const s = await this.inputString(prompt2);
          const [b, i] = this.parseAsFloat(s);
          if (b && i >= min && i <= max) {
            return i;
          }
          await this.prompt(`must be a number between ${min} and ${max} inclusive`);
          return await this.inputFloatBetween(prompt2, min, max);
        }
        //Math
        abs(x) {
          return Math.abs(x);
        }
        // Returns the absolute value of the input.
        acos(x) {
          return Math.acos(x);
        }
        // Returns the arccosine of the input.
        acosDeg(n) {
          return this.radToDeg(this.acos(n));
        }
        asin(x) {
          return Math.asin(x);
        }
        // Returns the arcsine of the input.
        asinDeg(n) {
          return this.radToDeg(this.asin(n));
        }
        atan(x) {
          return Math.atan(x);
        }
        // Returns the arctangent of the input.
        atanDeg(n) {
          return this.radToDeg(this.atan(n));
        }
        cos(x) {
          return Math.cos(x);
        }
        cosDeg(n) {
          return this.cos(this.degToRad(n));
        }
        exp(x) {
          return Math.exp(x);
        }
        // Returns ex, where x is the argument, and e is Euler's number (2.718…, the base of the natural logarithm).
        logE(x) {
          return Math.log(x);
        }
        // Returns the natural logarithm (㏒e; also, ㏑) of the input.
        log10(x) {
          return Math.log10(x);
        }
        // Returns the base-10 logarithm of the input.
        // Returns the base-2 logarithm of the input.
        log2(x) {
          return Math.log2(x);
        }
        sin(x) {
          return Math.sin(x);
        }
        // Returns the sine of the input.
        sinDeg(n) {
          return this.sin(this.degToRad(n));
        }
        sqrt(x) {
          return Math.sqrt(x);
        }
        // Returns the positive square root of the input.
        tan(x) {
          return Math.tan(x);
        }
        // Returns the tangent of the input.
        tanDeg(n) {
          return this.tan(this.degToRad(n));
        }
        degToRad(d) {
          return d * this.pi / 180;
        }
        radToDeg(r) {
          return r / this.pi * 180;
        }
        bitAnd(a, b) {
          return a & b;
        }
        bitOr(a, b) {
          return a | b;
        }
        bitXor(a, b) {
          return a ^ b;
        }
        bitNot(a) {
          return ~a;
        }
        bitShiftL(value, shift) {
          return value << shift;
        }
        bitShiftR(value, places) {
          return value >>> places;
        }
        asBinary(a) {
          return a.toString(2);
        }
        matchesRegExp(a, r) {
          return r.test(a);
        }
        asRegExp(pattern) {
          return new RegExp(pattern, "");
        }
        /*   @elanFunction(["", "flags"], FunctionOptions.pureExtension)
        asRegExpWithFlags(pattern: string, flags: string): RegExp {
          return new RegExp(pattern, flags);
        } */
        //File operations
        openFileForReading() {
          return this.system.elanInputOutput.readFile().then((s) => {
            const tf = this.system.initialise(new text_file_reader_1.TextFileReader());
            tf.status = 1;
            tf.content = s ? s.split("\n") : [];
            return tf;
          }, (e) => {
            throw new elan_runtime_error_1.ElanRuntimeError(e);
          });
        }
        createFileForWriting(fileName) {
          const tf = this.system.initialise(new text_file_writer_1.TextFileWriter());
          tf.fileName = fileName;
          tf.status = 1;
          return tf;
        }
        // Graphics
        async waitForAnyKey() {
          return await this.system.elanInputOutput.waitForAnyKey();
        }
        async pressAnyKeyToContinue(prompt2) {
          if (prompt2) {
            await this.prompt("Press any key to continue");
          }
          await this.waitForKey();
          return;
        }
        async waitForKey() {
          return await this.system.elanInputOutput.waitForKey();
        }
        async getKey() {
          return await this.system.elanInputOutput.getKey();
        }
        async getKeyWithModifier() {
          return await this.system.elanInputOutput.getKeyWithModifier();
        }
        async clearKeyBuffer() {
          await this.system.elanInputOutput.clearKeyBuffer();
        }
        //Block graphics
        blocksAsHtml(blocks) {
          let rendered = ``;
          for (let y = 0; y < 30; y++) {
            for (let x = 0; x < 40; x++) {
              const colour = blocks.read(x, y);
              rendered = `${rendered}<div style="background-color:${this.asHex(colour)};"></div>`;
            }
          }
          return rendered;
        }
        asHex(n) {
          const h = "000000" + n.toString(16);
          const h6 = h.substring(h.length - 6);
          return `#${h6}`;
        }
        async displayBlocks(blocks) {
          if (blocks.columns() !== 40 || blocks.rows() !== 30) {
            throw new elan_runtime_error_1.ElanRuntimeError(`argument must be Array2D<of Int> with dimensions 40 x 30`);
          }
          const html = this.blocksAsHtml(blocks);
          return await this.system.elanInputOutput.drawBlockGraphics(html);
        }
        async clearBlocks() {
          await this.system.elanInputOutput.clearBlockGraphics();
        }
        vectorGraphicsAsHtml(vgs) {
          let content = ``;
          for (let i = 0; i < vgs.length(); i++) {
            const vg = vgs.read(i);
            content = content + vg.asSVG() + "\n";
          }
          const html = `<svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">
${content}</svg>
`;
          return html;
        }
        async displayVectorGraphics(vgs) {
          const html = this.vectorGraphicsAsHtml(vgs);
          return await this.system.elanInputOutput.drawVectorGraphics(html);
        }
        async clearVectorGraphics() {
          await this.system.elanInputOutput.clearVectorGraphics();
        }
        async displayHtml(html) {
          return await this.system.elanInputOutput.drawHtml(html);
        }
        async clearHtml() {
          return await this.system.elanInputOutput.clearHtml();
        }
        async tone(duration, frequency, volume) {
          await this.system.elanInputOutput.tone(duration, frequency, volume);
        }
      };
      exports.StdLib = StdLib;
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(text_file_reader_1.TextFileReader),
        __metadata("design:type", Object)
      ], StdLib.prototype, "TextFileReader", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(text_file_writer_1.TextFileWriter),
        __metadata("design:type", Object)
      ], StdLib.prototype, "TextFileWriter", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(random_1.Random),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Random", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(stack_1.Stack),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Stack", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(queue_1.Queue),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Queue", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(elan_set_1.ElanSet),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Set", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(turtle_1.Turtle),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Turtle", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(vector_graphic_1.VectorGraphic),
        __metadata("design:type", Object)
      ], StdLib.prototype, "VectorGraphic", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(circle_vg_1.CircleVG),
        __metadata("design:type", Object)
      ], StdLib.prototype, "CircleVG", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(line_vg_1.LineVG),
        __metadata("design:type", Object)
      ], StdLib.prototype, "LineVG", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(rectangle_vg_1.RectangleVG),
        __metadata("design:type", Object)
      ], StdLib.prototype, "RectangleVG", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(image_vg_1.ImageVG),
        __metadata("design:type", Object)
      ], StdLib.prototype, "ImageVG", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(raw_vg_1.RawVG),
        __metadata("design:type", Object)
      ], StdLib.prototype, "RawVG", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(list_1.List),
        __metadata("design:type", Object)
      ], StdLib.prototype, "List", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(elan_array_1.ElanArray),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Array", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(elan_array_2d_1.ElanArray2D),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Array2D", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(list_immutable_1.ListImmutable),
        __metadata("design:type", Object)
      ], StdLib.prototype, "ListImmutable", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(dictionary_1.Dictionary),
        __metadata("design:type", Object)
      ], StdLib.prototype, "Dictionary", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanClassExport)(dictionary_immutable_1.DictionaryImmutable),
        __metadata("design:type", Object)
      ], StdLib.prototype, "DictionaryImmutable", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "black", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "grey", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "white", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "red", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "green", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "blue", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "yellow", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "brown", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "transparent", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanBoolean),
        __metadata("design:type", Object)
      ], StdLib.prototype, "true", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanBoolean),
        __metadata("design:type", Object)
      ], StdLib.prototype, "false", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(),
        __metadata("design:type", Number)
      ], StdLib.prototype, "pi", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanInt),
        __metadata("design:type", Object)
      ], StdLib.prototype, "meaningOfLife", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanString),
        __metadata("design:type", Object)
      ], StdLib.prototype, "quotes", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanString),
        __metadata("design:type", Object)
      ], StdLib.prototype, "openBrace", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanConstant)(elan_type_annotations_1.ElanString),
        __metadata("design:type", Object)
      ], StdLib.prototype, "closeBrace", void 0);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureAsyncExtension, elan_type_annotations_1.ElanString),
        __param(0, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "asString", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "unicode", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["character"], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "asUnicode", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["", "item"], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanStringType)()),
        __param(1, (0, elan_type_annotations_1.elanStringType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "indexOf", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["start", "end"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_1.List, [elan_type_annotations_1.ElanInt])),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", list_1.List)
      ], StdLib.prototype, "sequence", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["start", "end", "step"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_1.List, [elan_type_annotations_1.ElanInt])),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __param(2, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number, Number]),
        __metadata("design:returntype", list_1.List)
      ], StdLib.prototype, "sequenceWithStep", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["instance", "match", "replacement"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String, String]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "replace", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", void 0)
      ], StdLib.prototype, "length", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "upperCase", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "lowerCase", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["instance", "other"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", Boolean)
      ], StdLib.prototype, "isBefore", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["instance", "other"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", Boolean)
      ], StdLib.prototype, "isAfter", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["instance", "other"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", Boolean)
      ], StdLib.prototype, "isAfterOrSameAs", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["instance", "other"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", Boolean)
      ], StdLib.prototype, "isBeforeOrSameAs", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "trim", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["", "separator"], elan_type_annotations_1.FunctionOptions.pureExtension, (0, elan_type_annotations_1.ElanClass)(list_1.List, [elan_type_annotations_1.ElanString])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", list_1.List)
      ], StdLib.prototype, "split", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], StdLib.prototype, "floor", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanBoolean),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], StdLib.prototype, "isNaN", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanBoolean),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", void 0)
      ], StdLib.prototype, "isInfinite", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number", "decimalPlaces"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "round", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"], elan_type_annotations_1.FunctionOptions.pureExtension, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "ceiling", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["listOfFloat"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanFloat),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List, [elan_type_annotations_1.ElanFloat])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "maxFloat", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["listOfInt"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List, [elan_type_annotations_1.ElanInt])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "maxInt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["listOfFloat"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanFloat),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List, [elan_type_annotations_1.ElanFloat])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "minFloat", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["listOfInt"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List, [elan_type_annotations_1.ElanInt])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "minInt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["", "item"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String]),
        __metadata("design:returntype", Boolean)
      ], StdLib.prototype, "contains", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["milliseconds"], elan_type_annotations_1.ProcedureOptions.async),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "pause", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "clock", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impure),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "random", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["low", "high"], elan_type_annotations_1.FunctionOptions.impure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "randomInt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["string"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanBoolean, elan_type_annotations_1.ElanFloat])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Array)
      ], StdLib.prototype, "parseAsFloat", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["string"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanBoolean, elan_type_annotations_1.ElanInt])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Array)
      ], StdLib.prototype, "parseAsInt", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["text"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "printLine", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["text"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "printNoLine", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["position", "text"], elan_type_annotations_1.ProcedureOptions.async),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "printTab", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "clearPrintedText", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "clearAllDisplays", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["size", "initialValue"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(list_1.List)),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanGenericParamT1Type)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, typeof (_b = typeof T1 !== "undefined" && T1) === "function" ? _b : Object]),
        __metadata("design:returntype", void 0)
      ], StdLib.prototype, "createList", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputString", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt", "minLength", "maxLength"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanString),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __param(2, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, Number, Number]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputStringWithLimits", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt", "options"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanString),
        __param(1, (0, elan_type_annotations_1.elanClassType)(list_1.List, [elan_type_annotations_1.ElanString])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, list_1.List]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputStringFromOptions", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanInt),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputInt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt", "minValue", "maxValue"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanInt),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __param(2, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, Number, Number]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputIntBetween", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanFloat),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputFloat", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["prompt", "minValue", "maxValue"], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanFloat),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, Number, Number]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "inputFloatBetween", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "abs", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "acos", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "acosDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "asin", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "asinDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "atan", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "atanDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["radians"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "cos", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["degrees"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "cosDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["x"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "exp", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "logE", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "log10", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "log2", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["radians"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "sin", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["degrees"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "sinDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["number"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "sqrt", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["radians"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "tan", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["degrees"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "tanDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["degrees"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "degToRad", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["radians"]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "radToDeg", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["a", "b"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "bitAnd", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["a", "b"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "bitOr", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["a", "b"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "bitXor", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["a"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "bitNot", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value", "places"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "bitShiftL", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["value", "places"], elan_type_annotations_1.FunctionOptions.pure, elan_type_annotations_1.ElanInt),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number]),
        __metadata("design:returntype", Number)
      ], StdLib.prototype, "bitShiftR", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureExtension),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "asBinary", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["", "regExp"], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, RegExp]),
        __metadata("design:returntype", Boolean)
      ], StdLib.prototype, "matchesRegExp", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.pureExtension),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", RegExp)
      ], StdLib.prototype, "asRegExp", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impureAsync, (0, elan_type_annotations_1.ElanClass)(text_file_reader_1.TextFileReader)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "openFileForReading", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)(["fileName"], elan_type_annotations_1.FunctionOptions.pure, (0, elan_type_annotations_1.ElanClass)(text_file_writer_1.TextFileWriter)),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", text_file_writer_1.TextFileWriter)
      ], StdLib.prototype, "createFileForWriting", null);
      __decorate([
        (0, elan_type_annotations_1.elanDeprecated)(elan_type_interfaces_1.Deprecation.methodHidden, 1, 1, ""),
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "waitForAnyKey", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["prompt"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Boolean]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "pressAnyKeyToContinue", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "waitForKey", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impureAsync, elan_type_annotations_1.ElanString),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "getKey", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([], elan_type_annotations_1.FunctionOptions.impureAsync, (0, elan_type_annotations_1.ElanTuple)([elan_type_annotations_1.ElanString, elan_type_annotations_1.ElanString])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "getKeyWithModifier", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "clearKeyBuffer", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([""], elan_type_annotations_1.FunctionOptions.pureExtension),
        __param(0, (0, elan_type_annotations_1.elanClassType)(elan_array_2d_1.ElanArray2D, [elan_type_annotations_1.ElanInt])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [elan_array_2d_1.ElanArray2D]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "blocksAsHtml", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["blocks"], elan_type_annotations_1.ProcedureOptions.async),
        __param(0, (0, elan_type_annotations_1.elanClassType)(elan_array_2d_1.ElanArray2D, [elan_type_annotations_1.ElanInt])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [elan_array_2d_1.ElanArray2D]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "displayBlocks", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "clearBlocks", null);
      __decorate([
        (0, elan_type_annotations_1.elanFunction)([""], elan_type_annotations_1.FunctionOptions.pureExtension),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List, [(0, elan_type_annotations_1.ElanT1Constrained)((0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic))])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", String)
      ], StdLib.prototype, "vectorGraphicsAsHtml", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["listOfVGs"], elan_type_annotations_1.ProcedureOptions.async),
        __param(0, (0, elan_type_annotations_1.elanClassType)(list_1.List, [(0, elan_type_annotations_1.ElanT1Constrained)((0, elan_type_annotations_1.ElanClass)(vector_graphic_1.VectorGraphic))])),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [list_1.List]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "displayVectorGraphics", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "clearVectorGraphics", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["html"], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "displayHtml", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)([], elan_type_annotations_1.ProcedureOptions.async),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "clearHtml", null);
      __decorate([
        (0, elan_type_annotations_1.elanProcedure)(["durationMs", "frequencyHz", "volume"], elan_type_annotations_1.ProcedureOptions.async),
        __param(0, (0, elan_type_annotations_1.elanIntType)()),
        __param(1, (0, elan_type_annotations_1.elanFloatType)()),
        __param(2, (0, elan_type_annotations_1.elanFloatType)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Number, Number, Number]),
        __metadata("design:returntype", Promise)
      ], StdLib.prototype, "tone", null);
    }
  });

  // out/src/environment.js
  var require_environment = __commonJS({
    "out/src/environment.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.elanVersion = exports.isElanProduction = void 0;
      exports.isElanProduction = true;
      exports.elanVersion = {
        major: 1,
        minor: 6,
        patch: 4,
        preRelease: ""
      };
    }
  });

  // out/src/compiler/standard-library/std-lib-symbols.js
  var require_std_lib_symbols = __commonJS({
    "out/src/compiler/standard-library/std-lib-symbols.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StdLibSymbols = void 0;
      var elan_type_interfaces_1 = require_elan_type_interfaces();
      var elan_type_annotations_1 = require_elan_type_annotations();
      var null_scope_1 = require_null_scope();
      var symbol_helpers_1 = require_symbol_helpers();
      var symbol_scope_1 = require_symbol_scope();
      var unknown_symbol_1 = require_unknown_symbol();
      var StdLibSymbols = class {
        constructor(stdlib) {
          try {
            this.loadSymbols(stdlib);
            this.isInitialised = true;
          } catch (e) {
            this.isInitialised = false;
            this.error = e.message;
          }
        }
        isInitialised = false;
        error = "";
        symbols = /* @__PURE__ */ new Map();
        loadSymbols(stdlib) {
          const names = Object.getOwnPropertyNames(Object.getPrototypeOf(stdlib)).concat(Object.getOwnPropertyNames(stdlib));
          for (let i = 0; i < names.length; i++) {
            const name = names[i];
            const metadata = Reflect.getMetadata(elan_type_interfaces_1.elanMetadataKey, stdlib, name);
            if ((0, elan_type_interfaces_1.isFunctionDescriptor)(metadata)) {
              this.symbols.set(name, (0, elan_type_annotations_1.getSymbol)(name, metadata.mapType(this), symbol_scope_1.SymbolScope.stdlib));
            }
            if ((0, elan_type_interfaces_1.isProcedureDescriptor)(metadata)) {
              this.symbols.set(name, (0, elan_type_annotations_1.getSymbol)(name, metadata.mapType(this), symbol_scope_1.SymbolScope.stdlib));
            }
            if ((0, elan_type_interfaces_1.isConstantDescriptor)(metadata)) {
              this.symbols.set(name, (0, elan_type_annotations_1.getConstantSymbol)(name, metadata.mapType(this), symbol_scope_1.SymbolScope.stdlib));
            }
            if ((0, elan_type_interfaces_1.isClassDescriptor)(metadata)) {
              this.symbols.set(name, (0, elan_type_annotations_1.getSymbol)(name, metadata.mapType(this), symbol_scope_1.SymbolScope.stdlib));
            }
          }
        }
        isDeprecated(s) {
          return "deprecated" in s && !!s.deprecated;
        }
        symbolMatches(id, all) {
          return (0, symbol_helpers_1.symbolMatches)(id, all, [...this.symbols.values()]).filter((s) => !this.isDeprecated(s.symbolType()));
        }
        getParentScope() {
          return null_scope_1.NullScope.Instance;
        }
        resolveSymbol(id, _scope) {
          return id ? this.symbols.get(id) ?? new unknown_symbol_1.UnknownSymbol(id) : new unknown_symbol_1.UnknownSymbol();
        }
      };
      exports.StdLibSymbols = StdLibSymbols;
    }
  });

  // out/src/ide/elan-file-error.js
  var require_elan_file_error = __commonJS({
    "out/src/ide/elan-file-error.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ElanFileError = void 0;
      var ElanFileError = class extends Error {
        constructor(err) {
          super(err);
        }
      };
      exports.ElanFileError = ElanFileError;
    }
  });

  // out/src/ide/frames/fields/regexes.js
  var require_regexes = __commonJS({
    "out/src/ide/frames/fields/regexes.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Regexes = void 0;
      var Regexes = class {
        static newLine = /^\r?\n/;
        static anythingToNewLineAsString = "^[^\r\n]*";
        static anythingToNewLineAsRegExp = /^[^\r\n]*/;
        static comment = /# [^\r\n]*/;
        static indent = /^\s*/;
        static ifClause = /^if[^\S\r\n]/;
        static intoClause = /^into[^\S\r\n]/;
        static identifier = /^\s*[a-z]\w*/;
        static literalInt = /^\s*[0-9]+/;
        static negatableLitInt = /^\s*-?((0b[0-1]+)|(0x[0-9a-fA-F]+)|([0-9]+))/;
        static negatableLitFloat = /^\s*-?[0-9]+\.[0-9]+((e|E)-?[0-9]+)?/;
        static charValue = /[^']/;
        static nonEmptyStringContent = /^[^{"]+/;
        static nonInterpolatedStringContent = /^[^']*/;
        static leadingSpaceNotNL = /^[^\S\r\n]+/;
        static anythingExceptUnescapedForwardSlash = /^([^\/\\]|\\.)+/;
        static flags = /^[dgimsuvy]*/;
        static whiteSpaceButNotNewline = /[^\S\r\n]/;
        static url = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&\/=]*)/;
        static compilerDirective = /^\[[A-Za-z]+\]\s/;
        static typeSimpleName = /^\s*[A-Z]\w*/;
      };
      exports.Regexes = Regexes;
    }
  });

  // out/src/ide/frames/frame-interfaces/file.js
  var require_file = __commonJS({
    "out/src/ide/frames/frame-interfaces/file.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ParseMode = void 0;
      var ParseMode;
      (function(ParseMode2) {
        ParseMode2[ParseMode2["loadNew"] = 0] = "loadNew";
        ParseMode2[ParseMode2["append"] = 1] = "append";
        ParseMode2[ParseMode2["import"] = 2] = "import";
      })(ParseMode || (exports.ParseMode = ParseMode = {}));
    }
  });

  // out/src/ide/frames/code-source-from-string.js
  var require_code_source_from_string = __commonJS({
    "out/src/ide/frames/code-source-from-string.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CodeSourceFromString = void 0;
      var regexes_1 = require_regexes();
      var file_1 = require_file();
      var CodeSourceFromString = class {
        noError;
        remainingCode;
        constructor(code, noError = false) {
          this.noError = noError;
          this.remainingCode = code;
        }
        mode = file_1.ParseMode.loadNew;
        pushBackOntoFrontOfCode(pushBack) {
          this.remainingCode = pushBack + this.remainingCode;
        }
        removeNewLine() {
          this.removeRegEx(regexes_1.Regexes.newLine, false);
          return this;
        }
        removeIndent() {
          this.removeRegEx(regexes_1.Regexes.indent, false);
          return this;
        }
        remove(match) {
          if (!this.isMatch(match)) {
            if (this.noError) {
              this.remainingCode = "";
              return this;
            }
            throw new Error(`${this.readToEndOfLine()} does not match ${match}`);
          }
          this.remainingCode = this.remainingCode.substring(match.length);
          return this;
        }
        removeRegEx(regx, optional) {
          if (!this.isMatchRegEx(regx)) {
            if (optional) {
              return "";
            } else if (this.noError) {
              return "";
            }
            throw new Error(`${this.readToEndOfLine()} does not match ${regx}`);
          } else {
            const match = this.remainingCode.match(regx)[0];
            this.remainingCode = this.remainingCode.replace(regx, "");
            return match;
          }
        }
        isMatch(code) {
          return this.remainingCode.startsWith(code);
        }
        isMatchRegEx(regEx) {
          return regEx.test(this.remainingCode);
        }
        hasMoreCode() {
          return this.remainingCode.length > 0;
        }
        getRemainingCode() {
          return this.remainingCode;
        }
        peekNextChar() {
          return this.remainingCode[0];
        }
        readToEndOfLine() {
          return this.removeRegEx(regexes_1.Regexes.anythingToNewLineAsRegExp, false);
        }
        readUntil(regx) {
          const matchIndex = regx.exec(this.remainingCode)?.index;
          const uptoMatch = this.remainingCode.substring(0, matchIndex);
          this.remainingCode = this.remainingCode.slice(matchIndex);
          return uptoMatch;
        }
        readMatching(regx) {
          return this.removeRegEx(regx, true);
        }
        readToNonMatchingCloseBracket() {
          let insideDoubleQuotes = false;
          let insideSingleQuotes = false;
          let openBracketCount = 0;
          let cont = true;
          let result = "";
          while (cont) {
            const c = this.peekNextChar();
            if (insideDoubleQuotes) {
              if (c === `"`) {
                insideDoubleQuotes = false;
              }
            } else if (insideSingleQuotes) {
              if (c === `'`) {
                insideSingleQuotes = false;
              }
            } else if (c === `"`) {
              insideDoubleQuotes = true;
            } else if (c === `'`) {
              insideSingleQuotes = true;
            } else if (c === "(") {
              openBracketCount++;
            } else if (c === ")") {
              if (openBracketCount === 0) {
                cont = false;
              } else {
                openBracketCount--;
              }
            }
            if (cont) {
              result += c;
              this.remove(c);
            }
          }
          return result;
        }
      };
      exports.CodeSourceFromString = CodeSourceFromString;
    }
  });

  // out/src/ide/frames/status-enums.js
  var require_status_enums = __commonJS({
    "out/src/ide/frames/status-enums.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DisplayColour = exports.RunStatus = exports.CompileStatus = exports.ParseStatus = void 0;
      var ParseStatus;
      (function(ParseStatus2) {
        ParseStatus2[ParseStatus2["invalid"] = 0] = "invalid";
        ParseStatus2[ParseStatus2["empty"] = 1] = "empty";
        ParseStatus2[ParseStatus2["incomplete"] = 2] = "incomplete";
        ParseStatus2[ParseStatus2["valid"] = 3] = "valid";
        ParseStatus2[ParseStatus2["default"] = 4] = "default";
      })(ParseStatus || (exports.ParseStatus = ParseStatus = {}));
      var CompileStatus;
      (function(CompileStatus2) {
        CompileStatus2[CompileStatus2["error"] = 0] = "error";
        CompileStatus2[CompileStatus2["unknown_symbol"] = 1] = "unknown_symbol";
        CompileStatus2[CompileStatus2["ok"] = 2] = "ok";
        CompileStatus2[CompileStatus2["default"] = 3] = "default";
      })(CompileStatus || (exports.CompileStatus = CompileStatus = {}));
      var RunStatus;
      (function(RunStatus2) {
        RunStatus2[RunStatus2["error"] = 0] = "error";
        RunStatus2[RunStatus2["paused"] = 1] = "paused";
        RunStatus2[RunStatus2["running"] = 2] = "running";
        RunStatus2[RunStatus2["input"] = 3] = "input";
        RunStatus2[RunStatus2["default"] = 4] = "default";
      })(RunStatus || (exports.RunStatus = RunStatus = {}));
      var DisplayColour;
      (function(DisplayColour2) {
        DisplayColour2[DisplayColour2["error"] = 0] = "error";
        DisplayColour2[DisplayColour2["warning"] = 1] = "warning";
        DisplayColour2[DisplayColour2["ok"] = 2] = "ok";
        DisplayColour2[DisplayColour2["none"] = 3] = "none";
      })(DisplayColour || (exports.DisplayColour = DisplayColour = {}));
    }
  });

  // out/src/ide/frames/frame-helpers.js
  var require_frame_helpers = __commonJS({
    "out/src/ide/frames/frame-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.isCollapsible = isCollapsible;
      exports.isFile = isFile;
      exports.isMain = isMain;
      exports.isFrame = isFrame;
      exports.isFrameWithStatements = isFrameWithStatements;
      exports.isParent = isParent;
      exports.isMember = isMember;
      exports.isFunction = isFunction;
      exports.isProcedure = isProcedure;
      exports.isLet = isLet;
      exports.isConstructor = isConstructor;
      exports.isSelector = isSelector;
      exports.isGlobal = isGlobal;
      exports.isClass = isClass;
      exports.isReturnStatement = isReturnStatement;
      exports.isComment = isComment;
      exports.singleIndent = singleIndent;
      exports.expandCollapseAll = expandCollapseAll;
      exports.escapeHtmlChars = escapeHtmlChars;
      exports.renderBackslashNasABreak = renderBackslashNasABreak;
      exports.helper_pastePopUp = helper_pastePopUp;
      exports.helper_compileMsgAsHtmlNew = helper_compileMsgAsHtmlNew;
      exports.helper_deriveCompileStatusFromErrors = helper_deriveCompileStatusFromErrors;
      exports.helper_CompileOrParseAsDisplayStatus = helper_CompileOrParseAsDisplayStatus;
      exports.helper_parseStatusAsDisplayStatus = helper_parseStatusAsDisplayStatus;
      exports.helper_compileStatusAsDisplayStatus = helper_compileStatusAsDisplayStatus;
      exports.helper_testStatusAsDisplayStatus = helper_testStatusAsDisplayStatus;
      exports.helper_runStatusAsDisplayStatus = helper_runStatusAsDisplayStatus;
      exports.isInsideFunctionOrConstructor = isInsideFunctionOrConstructor;
      exports.isInsideFunction = isInsideFunction;
      exports.mapIds = mapIds;
      exports.currentParameterIndex = currentParameterIndex;
      exports.addPrivateToggleToContextMenu = addPrivateToggleToContextMenu;
      exports.togglePrivatePublic = togglePrivatePublic;
      var compile_error_1 = require_compile_error();
      var test_status_1 = require_test_status();
      var status_enums_1 = require_status_enums();
      function isCollapsible(f) {
        return !!f && "isCollapsible" in f;
      }
      function isFile(f) {
        return !!f && "isFile" in f;
      }
      function isMain(f) {
        return !!f && "isMain" in f;
      }
      function isFrame(f) {
        return !!f && "isFrame" in f;
      }
      function isFrameWithStatements(f) {
        return !!f && "isFrameWithStatements" in f;
      }
      function isParent(f) {
        return !!f && "isParent" in f;
      }
      function isMember(f) {
        return !!f && "isMember" in f;
      }
      function isFunction(f) {
        return !!f && "isFunction" in f;
      }
      function isProcedure(f) {
        return !!f && "isProcedure" in f;
      }
      function isLet(f) {
        return !!f && "isLet" in f;
      }
      function isConstructor(f) {
        return !!f && "isConstructor" in f;
      }
      function isSelector(f) {
        return !!f && "isSelector" in f;
      }
      function isGlobal(f) {
        return !!f && "isGlobal" in f;
      }
      function isClass(f) {
        return !!f && "isClass" in f;
      }
      function isReturnStatement(f) {
        return !!f && "isReturnStatement" in f;
      }
      function isComment(f) {
        return !!f && "isDirective" in f;
      }
      function singleIndent() {
        return "  ";
      }
      function expandCollapseAll(file) {
        const map = file.getMap();
        const collapsible = [...map.values()].filter((s) => isCollapsible(s)).map((s) => s);
        const firstCollapsibleGlobal = collapsible.filter((s) => isGlobal(s))[0];
        let collapse = true;
        if (firstCollapsibleGlobal && firstCollapsibleGlobal.isCollapsed()) {
          collapse = false;
        }
        for (const c of collapsible) {
          if (collapse) {
            c.collapse();
          } else {
            c.expand();
          }
        }
        const globals = [...map.values()].filter((s) => isGlobal(s));
        const selectedGlobals = globals.filter((s) => s.isSelected());
        if (selectedGlobals.length === 0) {
          file.getFirstChild().select(true, false);
        }
      }
      function escapeHtmlChars(str) {
        return str.replaceAll(/&/g, "&amp;").replaceAll(/</g, "&lt;").replaceAll(/>/g, "&gt;");
      }
      function renderBackslashNasABreak(str) {
        return escapeHtmlChars(str).replaceAll(/\\n/g, "<br>");
      }
      function helper_pastePopUp(loc) {
        let popup = "";
        if (isFrame(loc) && loc.pasteError) {
          popup = `<div class="context-menu"><div>${loc.pasteError}</div></div>`;
          loc.pasteError = "";
        }
        return popup;
      }
      function helper_compileMsgAsHtmlNew(file, loc) {
        let msg = "";
        let link = "";
        let help = "";
        const compileErrors = file.getAst(false)?.getCompileErrorsFor(loc.getHtmlId()) ?? [];
        const n = compileErrors.length;
        if (n > 0) {
          const first = compileErrors[0];
          const highest = compileErrors.reduce((prev, curr) => curr.priority < prev.priority ? curr : prev, first);
          msg = highest.message;
          link = highest.link ?? "";
        }
        let cls = "";
        const compile = helper_compileStatusAsDisplayStatus(loc.readCompileStatus());
        if (compile === status_enums_1.DisplayColour.error || compile === status_enums_1.DisplayColour.warning) {
          cls = status_enums_1.DisplayColour[compile];
        }
        if (link) {
          const active = loc.helpActive ? ` class="active"` : "";
          loc.helpActive = false;
          help = `<el-help title="Click to open Help for this error"><a href="documentation/${link}" target="help-iframe" tabindex="-1"${active}>?</a></el-help>`;
        }
        const popUp = helper_pastePopUp(loc);
        const toDisplay = escapeHtmlChars(msg);
        return cls === "" ? `<el-msg></el-msg>${popUp}` : ` <el-msg class="${cls}">${toDisplay}${help}</el-msg>${popUp}`;
      }
      function helper_deriveCompileStatusFromErrors(errors) {
        let result = status_enums_1.CompileStatus.error;
        if (errors.length === 0) {
          result = status_enums_1.CompileStatus.ok;
        } else {
          result = errors.some((e) => e.severity === compile_error_1.Severity.error) ? status_enums_1.CompileStatus.error : status_enums_1.CompileStatus.unknown_symbol;
        }
        return result;
      }
      function helper_CompileOrParseAsDisplayStatus(loc) {
        let status = helper_parseStatusAsDisplayStatus(loc.readParseStatus());
        if (status === status_enums_1.DisplayColour.ok) {
          const compile = helper_compileStatusAsDisplayStatus(loc.readCompileStatus());
          if (compile !== status_enums_1.DisplayColour.none) {
            status = compile;
          }
        }
        return status;
      }
      function helper_parseStatusAsDisplayStatus(ps) {
        let overall = status_enums_1.DisplayColour.none;
        if (ps === status_enums_1.ParseStatus.valid) {
          overall = status_enums_1.DisplayColour.ok;
        } else if (ps === status_enums_1.ParseStatus.incomplete) {
          overall = status_enums_1.DisplayColour.warning;
        } else if (ps === status_enums_1.ParseStatus.invalid) {
          overall = status_enums_1.DisplayColour.error;
        }
        return overall;
      }
      function helper_compileStatusAsDisplayStatus(cs) {
        let overall = status_enums_1.DisplayColour.none;
        if (cs === status_enums_1.CompileStatus.ok) {
          overall = status_enums_1.DisplayColour.ok;
        } else if (cs === status_enums_1.CompileStatus.unknown_symbol) {
          overall = status_enums_1.DisplayColour.warning;
        } else if (cs === status_enums_1.CompileStatus.error) {
          overall = status_enums_1.DisplayColour.error;
        }
        return overall;
      }
      function helper_testStatusAsDisplayStatus(ts) {
        let overall = status_enums_1.DisplayColour.none;
        if (ts === test_status_1.TestStatus.pass) {
          overall = status_enums_1.DisplayColour.ok;
        } else if (ts === test_status_1.TestStatus.running || ts === test_status_1.TestStatus.ignored) {
          overall = status_enums_1.DisplayColour.warning;
        } else if (ts === test_status_1.TestStatus.fail || ts === test_status_1.TestStatus.error) {
          overall = status_enums_1.DisplayColour.error;
        }
        return overall;
      }
      function helper_runStatusAsDisplayStatus(rs) {
        let overall = status_enums_1.DisplayColour.none;
        if (rs === status_enums_1.RunStatus.running) {
          overall = status_enums_1.DisplayColour.ok;
        } else if (rs === status_enums_1.RunStatus.paused) {
          overall = status_enums_1.DisplayColour.warning;
        } else if (rs === status_enums_1.RunStatus.error) {
          overall = status_enums_1.DisplayColour.error;
        }
        return overall;
      }
      function isInsideFunctionOrConstructor(parent) {
        if (isFunction(parent)) {
          return true;
        }
        if (isConstructor(parent)) {
          return true;
        }
        if (isFile(parent)) {
          return false;
        }
        return isInsideFunctionOrConstructor(parent.getParent());
      }
      function isInsideFunction(parent) {
        if (isFunction(parent)) {
          return true;
        }
        if (isFile(parent)) {
          return false;
        }
        return isInsideFunction(parent.getParent());
      }
      function mapIds(ids) {
        return ids.length > 1 ? `[${ids.join(", ")}]` : ids[0];
      }
      function currentParameterIndex(text) {
        if (text) {
          if (text.includes(",")) {
            const parameters = text.split(",");
            const count = parameters.length - 1;
            const startedInput = !!parameters[count].trim();
            return startedInput ? count + 1 : count;
          }
          return 1;
        }
        return 0;
      }
      function addPrivateToggleToContextMenu(member, menu) {
        if (member.private) {
          menu.set("makePublic", ["make public (Ctrl-p)", member.makePublic]);
        } else {
          menu.set("makePrivate", ["make private (Ctrl-p)", member.makePrivate]);
        }
      }
      function togglePrivatePublic(member) {
        if (member.private) {
          return member.makePublic();
        } else {
          return member.makePrivate();
        }
      }
    }
  });

  // out/src/ide/frames/frame-interfaces/profile.js
  var require_profile = __commonJS({
    "out/src/ide/frames/frame-interfaces/profile.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.defaultUsername = void 0;
      exports.defaultUsername = "guest";
    }
  });

  // out/src/ide/frames/parent-helpers.js
  var require_parent_helpers = __commonJS({
    "out/src/ide/frames/parent-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.worstParseStatus = worstParseStatus;
      exports.parentHelper_readWorstParseStatusOfChildren = parentHelper_readWorstParseStatusOfChildren;
      exports.parentHelper_readWorstCompileStatusOfChildren = parentHelper_readWorstCompileStatusOfChildren;
      exports.parentHelper_removeChild = parentHelper_removeChild;
      exports.parentHelper_removeAllSelectedChildren = parentHelper_removeAllSelectedChildren;
      exports.parentHelper_getFirstChild = parentHelper_getFirstChild;
      exports.parentHelper_getLastChild = parentHelper_getLastChild;
      exports.parentHelper_getChildAfter = parentHelper_getChildAfter;
      exports.parentHelper_getChildBefore = parentHelper_getChildBefore;
      exports.parentHelper_getChildRange = parentHelper_getChildRange;
      exports.parentHelper_getFirstSelectorAsDirectChild = parentHelper_getFirstSelectorAsDirectChild;
      exports.parentHelper_selectFirstChild = parentHelper_selectFirstChild;
      exports.parentHelper_addChildBefore = parentHelper_addChildBefore;
      exports.parentHelper_addChildAfter = parentHelper_addChildAfter;
      exports.parentHelper_renderChildrenAsHtml = parentHelper_renderChildrenAsHtml;
      exports.isNotSelectorFrame = isNotSelectorFrame;
      exports.parentHelper_renderChildrenAsSource = parentHelper_renderChildrenAsSource;
      exports.parentHelper_insertOrGotoChildSelector = parentHelper_insertOrGotoChildSelector;
      exports.parentHelper_getAllSelectedChildren = parentHelper_getAllSelectedChildren;
      exports.parentHelper_deleteSelectedChildren = parentHelper_deleteSelectedChildren;
      exports.parentHelper_copySelectedChildren = parentHelper_copySelectedChildren;
      exports.parentHelper_moveSelectedChildrenUpOne = parentHelper_moveSelectedChildrenUpOne;
      exports.parentHelper_moveSelectedChildrenDownOne = parentHelper_moveSelectedChildrenDownOne;
      exports.moveDownOne = moveDownOne;
      exports.moveUpOne = moveUpOne;
      exports.parentHelper_updateBreakpoints = parentHelper_updateBreakpoints;
      exports.setGhostOnSelectedChildren = setGhostOnSelectedChildren;
      var frame_helpers_1 = require_frame_helpers();
      var status_enums_1 = require_status_enums();
      function worstParseStatus(prev, cur) {
        return cur < prev ? cur : prev;
      }
      function parentHelper_readWorstParseStatusOfChildren(parent) {
        return parent.getChildren().map((s) => s.readParseStatus()).reduce(worstParseStatus, status_enums_1.ParseStatus.default);
      }
      function parentHelper_readWorstCompileStatusOfChildren(parent) {
        return parent.getChildren().map((s) => s.readCompileStatus()).reduce((prev, cur) => cur < prev ? cur : prev, status_enums_1.CompileStatus.default);
      }
      function parentHelper_removeChild(parent, child) {
        const i = parent.getChildren().indexOf(child);
        if (i >= 0) {
          parent.getChildren().splice(i, 1);
        } else {
          parent.getFile().getMap().delete(child.getHtmlId());
        }
        child.deselect();
      }
      function parentHelper_removeAllSelectedChildren(parent) {
        const selected = parentHelper_getAllSelectedChildren(parent);
        const nonSelectors = selected.filter((s) => !(s.initialKeywords() === "selector"));
        for (const child of nonSelectors) {
          parentHelper_removeChild(parent, child);
        }
        return selected;
      }
      function parentHelper_getFirstChild(parent) {
        return parent.getChildren()[0];
      }
      function parentHelper_getLastChild(parent) {
        return parent.getChildren()[parent.getChildren().length - 1];
      }
      function parentHelper_getChildAfter(parent, child) {
        const index = parent.getChildren().indexOf(child);
        return index < parent.getChildren().length - 1 ? parent.getChildren()[index + 1] : child;
      }
      function parentHelper_getChildBefore(parent, child) {
        const index = parent.getChildren().indexOf(child);
        return index > 0 ? parent.getChildren()[index - 1] : child;
      }
      function parentHelper_getChildRange(parent, first, last) {
        const fst = parent.getChildren().indexOf(first);
        const lst = parent.getChildren().indexOf(last);
        return fst < lst ? parent.getChildren().slice(fst, lst + 1) : parent.getChildren().slice(lst, fst + 1);
      }
      function parentHelper_getFirstSelectorAsDirectChild(parent) {
        return parent.getChildren().filter((g) => (0, frame_helpers_1.isSelector)(g))[0];
      }
      function parentHelper_selectFirstChild(parent, multiSelect) {
        if (parent.getChildren().length > 0) {
          parent.getChildren()[0].select(true, multiSelect);
          return true;
        }
        return false;
      }
      function parentHelper_addChildBefore(parent, child, before) {
        const i = parent.getChildren().indexOf(before);
        child.setParent(parent);
        parent.getChildren().splice(i, 0, child);
      }
      function parentHelper_addChildAfter(parent, child, after) {
        const i = parent.getChildren().indexOf(after) + 1;
        parent.getChildren().splice(i, 0, child);
      }
      function parentHelper_renderChildrenAsHtml(parent) {
        const ss = [];
        for (const m of parent.getChildren()) {
          ss.push(m.renderAsHtml());
        }
        return ss.join("\n");
      }
      function isNotSelectorFrame(f) {
        return !!f && !("isSelector" in f);
      }
      function parentHelper_renderChildrenAsSource(parent) {
        let result = "";
        if (parent.getChildren().length > 0) {
          const ss = [];
          for (const frame of parent.getChildren().filter(isNotSelectorFrame)) {
            ss.push(frame.renderAsSource());
          }
          result = ss.join("\r\n");
        }
        return result;
      }
      function parentHelper_insertOrGotoChildSelector(parent, after, child) {
        if (after) {
          return insertOrGotoChildSelectorAfter(parent, child);
        } else {
          return insertOrGotoChildSelectorBefore(parent, child);
        }
      }
      function insertOrGotoChildSelectorBefore(parent, child) {
        const prev = parent.getChildBefore(child);
        if ((0, frame_helpers_1.isSelector)(prev)) {
          prev.select(true, false);
          return prev;
        } else {
          const selector = parent.newChildSelector();
          parent.addChildBefore(selector, child);
          selector.select(true, false);
          return selector;
        }
      }
      function insertOrGotoChildSelectorAfter(parent, child) {
        const follow = parent.getChildAfter(child);
        if ((0, frame_helpers_1.isSelector)(follow)) {
          follow.select(true, false);
          return follow;
        } else {
          const selector = parent.newChildSelector();
          parent.addChildAfter(selector, child);
          selector.select(true, false);
          return selector;
        }
      }
      function parentHelper_getAllSelectedChildren(parent) {
        return parent.getChildren().filter((g) => g.isSelected());
      }
      function parentHelper_deleteSelectedChildren(parent) {
        const toDelete = parentHelper_getAllSelectedChildren(parent);
        for (let i = toDelete.length - 1; i >= 0; i--) {
          toDelete[i].deleteIfPermissible();
        }
      }
      function isValidOrIncomplete(f) {
        const status = f.readParseStatus();
        return status === status_enums_1.ParseStatus.valid || status === status_enums_1.ParseStatus.incomplete;
      }
      function parentHelper_copySelectedChildren(parent) {
        const toCopy = parentHelper_getAllSelectedChildren(parent);
        if (toCopy.some((tc) => !isValidOrIncomplete(tc))) {
          return false;
        }
        for (const tc of toCopy) {
          tc.copy();
        }
        return true;
      }
      function parentHelper_moveSelectedChildrenUpOne(parent) {
        const toMove = parentHelper_getAllSelectedChildren(parent);
        let cont = true;
        let i = 0;
        while (cont && i < toMove.length) {
          cont = moveUpOne(parent, toMove[i]);
          i++;
        }
      }
      function parentHelper_moveSelectedChildrenDownOne(parent) {
        const toMove = parentHelper_getAllSelectedChildren(parent);
        let cont = true;
        let i = toMove.length - 1;
        while (cont && i >= 0) {
          cont = moveDownOne(parent, toMove[i]);
          i--;
        }
      }
      function moveDownOne(parent, child) {
        let result = false;
        const i = parent.getChildren().indexOf(child);
        if (i < parent.getChildren().length - 1 && parent.getChildren()[i + 1].canInsertAfter()) {
          parent.getChildren().splice(i, 1);
          parent.getChildren().splice(i + 1, 0, child);
          result = true;
        }
        return result;
      }
      function moveUpOne(parent, child) {
        let result = false;
        const i = parent.getChildren().indexOf(child);
        if (i > 0 && parent.getChildren()[i - 1].canInsertBefore()) {
          parent.getChildren().splice(i, 1);
          parent.getChildren().splice(i - 1, 0, child);
          result = true;
        }
        return result;
      }
      function parentHelper_updateBreakpoints(parent, event) {
        for (const frame of parent.getChildren()) {
          frame.updateBreakpoints(event);
        }
      }
      function setGhostOnSelectedChildren(parent, ghost) {
        const toGhost = parentHelper_getAllSelectedChildren(parent);
        for (const child of toGhost) {
          if (child.isGhostable()) {
            child.setGhosted(ghost);
          }
        }
      }
    }
  });

  // out/src/ide/frames/abstract-frame.js
  var require_abstract_frame = __commonJS({
    "out/src/ide/frames/abstract-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractFrame = void 0;
      var breakpoint_event_1 = require_breakpoint_event();
      var breakpoint_status_1 = require_breakpoint_status();
      var keywords_1 = require_keywords();
      var frame_helpers_1 = require_frame_helpers();
      var parent_helpers_1 = require_parent_helpers();
      var status_enums_1 = require_status_enums();
      var AbstractFrame = class {
        isFrame = true;
        isNew = true;
        breakpointStatus = breakpoint_status_1.BreakpointStatus.none;
        pasteError = "";
        helpActive = false;
        htmlId = "";
        ghostable = true;
        canHaveBreakPoint = true;
        showContextMenu = false;
        paused = false;
        _parent;
        _map;
        _selected = false;
        _focused = false;
        _collapsed = false;
        _classes = new Array();
        _movable = true;
        _parseStatus = status_enums_1.ParseStatus.default;
        _ghosted = false;
        _imported = false;
        constructor(parent) {
          this._parent = parent;
          const file = this.getFile();
          const map = file.getMap();
          this.htmlId = `${this.getIdPrefix()}${file.getNextId()}`;
          map.set(this.htmlId, this);
          this.setMap(map);
        }
        helpId() {
          return this.initialKeywords().replace(/\s/g, "");
        }
        helpAsHtml() {
          const active = this.helpActive ? ` class="active"` : "";
          this.helpActive = false;
          return this._selected ? `<el-help title="Click to open Help for this instruction"> <a href="documentation/LangRef.html#${this.helpId()}" target="help-iframe" tabindex="-1"${active}>?</a></el-help>` : ``;
        }
        showHelp() {
          this.helpActive = true;
        }
        hasBeenAddedTo() {
          this.isNew = false;
        }
        isMovable() {
          return this._movable && !this.isImported();
        }
        isDeletable() {
          return true;
        }
        getFile() {
          return this.getParent().getFile();
        }
        getHtmlId() {
          return this.htmlId;
        }
        getFrNo() {
          return this.isGhostedOrWithinAGhostedFrame() || this.isWithinAnImportedFrame() ? "" : this.getFile().getFrNo();
        }
        fieldUpdated(_field) {
        }
        getFirstPeerFrame() {
          return this.getParent().getFirstChild();
        }
        getLastPeerFrame() {
          return this.getParent().getLastChild();
        }
        getPreviousPeerFrame() {
          return this.getParent().getChildBefore(this);
        }
        getNextPeerFrame() {
          return this.getParent().getChildAfter(this);
        }
        selectFieldBefore(current) {
          const fields = this.getFields();
          const i = fields.indexOf(current);
          if (i > 0) {
            this.getFields()[i - 1].select(true, false);
          } else {
            this.select(true, false);
          }
        }
        selectFieldAfter(current) {
          const fields = this.getFields();
          const i = fields.indexOf(current);
          if (i < fields.length - 1) {
            fields[i + 1].select(true, false);
          } else {
            this.select(true, false);
          }
        }
        getNextFrameInTabOrder() {
          let result = this;
          if (this.getNextPeerFrame() !== this) {
            result = this.getNextPeerFrame();
          } else {
            const parent = this.getParent();
            if ((0, frame_helpers_1.isFrame)(parent)) {
              const parentNextPeer = parent.getNextFrameInTabOrder();
              if (parentNextPeer !== parent) {
                result = parentNextPeer;
              }
            }
          }
          return result;
        }
        getPreviousFrameInTabOrder() {
          let result = this;
          if (this.getPreviousPeerFrame() !== this) {
            result = this.getPreviousPeerFrame();
          } else {
            const parent = this.getParent();
            if ((0, frame_helpers_1.isFrame)(parent)) {
              result = parent.getPreviousFrameInTabOrder();
            }
          }
          return result;
        }
        //Overridden by any frames that have children
        selectFirstField() {
          let result = false;
          if (this.getFields().length > 0) {
            this.getFields()[0].select(true, false);
            result = true;
          }
          return result;
        }
        selectLastField() {
          let result = false;
          const length = this.getFields().length;
          if (length > 0) {
            this.getFields()[length - 1].select(true, false);
            result = true;
          }
          return result;
        }
        controlKeys = [
          "o",
          "O",
          "ArrowUp",
          "ArrowDown",
          "Backspace",
          "Delete",
          "x",
          "m",
          "c",
          "?"
        ];
        processKey(e) {
          let codeHasChanged = false;
          const key = e.key;
          if (e.modKey.control && !this.controlKeys.includes(key ?? "")) {
            return false;
          }
          switch (key) {
            case "Home": {
              this.getFirstPeerFrame().select(true, false);
              break;
            }
            case "End": {
              this.getLastPeerFrame().select(true, false);
              break;
            }
            case "o": {
              if (e.modKey.control && (0, frame_helpers_1.isCollapsible)(this)) {
                this.expandCollapse();
              }
              break;
            }
            case "O": {
              if (e.modKey.control) {
                this.expandCollapseAll();
              }
              break;
            }
            case "t": {
              if (e.modKey.alt) {
                this.getFile().removeAllSelectorsThatCanBe();
              }
              break;
            }
            case "ArrowUp": {
              if (e.modKey.control) {
                this.up();
              } else {
                this.selectSingleOrMulti(this.getPreviousPeerFrame(), e.modKey.shift);
              }
              break;
            }
            case "ArrowDown": {
              if (e.modKey.control) {
                this.down();
              } else {
                this.selectSingleOrMulti(this.getNextPeerFrame(), e.modKey.shift);
              }
              break;
            }
            case "ArrowLeft": {
              const pt = this.getParent();
              if ((0, frame_helpers_1.isFrame)(pt)) {
                pt.select(true, false);
              }
              break;
            }
            case "ArrowRight": {
              if ((0, frame_helpers_1.isParent)(this)) {
                this.getFirstChild().select(true, false);
              }
              break;
            }
            case "Enter": {
              this.insertPeerSelector(e.modKey.shift);
              break;
            }
            case "Tab": {
              if (e.modKey.shift) {
                this.selectLastField();
              } else {
                this.selectFirstField();
              }
              break;
            }
            case "Delete": {
              if (e.modKey.control) {
                this.deleteSelected();
                codeHasChanged = true;
              }
              break;
            }
            case "Backspace": {
              if (e.modKey.control || this.isNew) {
                this.deleteSelected();
                codeHasChanged = true;
              }
              break;
            }
            case "c": {
              if (e.modKey.control) {
                this.copySelected();
                codeHasChanged = true;
              }
              break;
            }
            case "x": {
              if (e.modKey.control) {
                this.cutSelected();
                codeHasChanged = true;
              }
              break;
            }
            case "?": {
              if (e.modKey.control) {
                this.showHelp();
              }
              break;
            }
            case "m": {
              if (!e.modKey.control) {
                break;
              }
            }
            case "ContextMenu": {
              if (e.command) {
                const map = this.getContextMenuItems();
                codeHasChanged = map.get(e.command)[1]?.(e.optionalData);
              } else {
                if (!this.isSelected()) {
                  this.select(true, false);
                }
                this.showContextMenu = true;
              }
              break;
            }
          }
          return codeHasChanged;
        }
        up = () => {
          if (this.isMovable()) {
            this.getParent().moveSelectedChildrenUpOne();
            return true;
          }
          return false;
        };
        down = () => {
          if (this.isMovable()) {
            this.getParent().moveSelectedChildrenDownOne();
            return true;
          }
          return false;
        };
        deleteSelected = () => {
          this.getParent().deleteSelectedChildren();
          return true;
        };
        copySelected = () => {
          if (!this.getParent().copySelectedChildren()) {
            this.pasteError = "Copy Failed: At least one selected frame does not parse";
            return true;
          }
          return false;
        };
        cutSelected = () => {
          const selected = (0, parent_helpers_1.parentHelper_getAllSelectedChildren)(this.getParent());
          const nonSelectors = selected.filter((s) => !(s.initialKeywords() === "selector"));
          if (nonSelectors.length === 0) {
            this.pasteError = "Cut Failed: No code to cut";
            return true;
          }
          const movable = nonSelectors.filter((s) => s.isMovable());
          if (movable.length !== nonSelectors.length) {
            this.pasteError = "Cut Failed: At least one selected frame is not moveable";
            return true;
          }
          if (!(0, parent_helpers_1.parentHelper_copySelectedChildren)(this.getParent())) {
            this.pasteError = "Cut Failed: At least one selected frame does not parse";
            return true;
          }
          (0, parent_helpers_1.parentHelper_removeAllSelectedChildren)(this.getParent());
          const last = selected[selected.length - 1];
          const newFocus = (0, parent_helpers_1.parentHelper_getChildAfter)(this.getParent(), last);
          newFocus.select(true, false);
          if (!(0, frame_helpers_1.isSelector)(newFocus) && !newFocus.getParent().minimumNumberOfChildrenExceeded()) {
            newFocus.insertPeerSelector(false);
          }
          return true;
        };
        deleteIfPermissible() {
          if (this.isDeletable()) {
            this.insertNewSelectorIfNecessary();
            this.delete();
          }
        }
        delete() {
          const parent = this.getParent();
          const newFocus = this.getAdjacentPeer();
          parent.removeChild(this);
          this.getMap().delete(this.htmlId);
          newFocus.select(true, false);
        }
        insertNewSelectorIfNecessary() {
          if (!this.getParent().minimumNumberOfChildrenExceeded()) {
            this.insertPeerSelector(true);
          }
        }
        getAdjacentPeer() {
          const parent = this.getParent();
          let adjacent = parent.getChildAfter(this);
          if (adjacent === this) {
            adjacent = parent.getChildBefore(this);
          }
          return adjacent;
        }
        insertSelectorAfterLastField() {
          this.insertPeerSelector(false);
        }
        selectNextFrame() {
          const parent = this.getParent();
          let next = parent.getChildAfter(this);
          if (next === this) {
            if ((0, frame_helpers_1.isFrame)(parent)) {
              next = parent;
            }
          }
          next.select(true, false);
        }
        above = () => {
          this.insertPeerSelector(true);
          return false;
        };
        below = () => {
          this.insertPeerSelector(false);
          return false;
        };
        insertPeerSelector(before) {
          const parent = this.getParent();
          if (before && this.canInsertBefore()) {
            parent.insertOrGotoChildSelector(false, this);
          } else if (!before && this.canInsertAfter()) {
            parent.insertOrGotoChildSelector(true, this);
          }
        }
        canInsertBefore() {
          return true;
        }
        canInsertAfter() {
          return true;
        }
        selectSingleOrMulti(other, multiSelect) {
          if (multiSelect && other.isSelected()) {
            this.deselect();
            other.select(true, true);
          } else if (multiSelect) {
            this.select(false, true);
            other.select(true, true);
          } else {
            other.select(true, false);
          }
        }
        getMap() {
          if (this._map) {
            return this._map;
          }
          throw new Error(`Frame : ${this.htmlId} has no Map`);
        }
        setMap(Map2) {
          this._map = Map2;
        }
        pushClass(flag, cls) {
          if (flag) {
            this._classes.push(cls);
          }
        }
        setClasses() {
          this._classes = new Array();
          this.pushClass(this._collapsed, "collapsed");
          this.pushClass(this._selected, "selected");
          this.pushClass(this._focused, "focused");
          this.pushClass(this.breakpointStatus !== breakpoint_status_1.BreakpointStatus.none, "breakpoint");
          this.pushClass(this.paused, "paused");
          this.pushClass(this.isGhosted(), keywords_1.ghostedAnnotation);
          this.pushClass(this.isImported(), keywords_1.importedAnnotation);
          this._classes.push(status_enums_1.DisplayColour[this.readDisplayStatus()]);
        }
        readDisplayStatus() {
          return (0, frame_helpers_1.helper_CompileOrParseAsDisplayStatus)(this);
        }
        cls() {
          this.setClasses();
          return this._classes.join(" ");
        }
        indent() {
          if (this.hasParent()) {
            return this.getParent().indent() + (0, frame_helpers_1.singleIndent)();
          } else {
            return (0, frame_helpers_1.singleIndent)();
          }
        }
        isSelected() {
          return this._selected;
        }
        select(withFocus, multiSelect) {
          if (!multiSelect) {
            this.deselectAll();
          }
          this._selected = true;
          this._focused = withFocus;
        }
        deselect() {
          this._selected = false;
          this._focused = false;
        }
        deselectAll() {
          for (const f of this.getMap().values()) {
            if (f.isSelected()) {
              f.deselect();
            }
          }
        }
        getAllSelected() {
          const selected = [];
          for (const f of this.getMap().values()) {
            if (f.isSelected()) {
              selected.push(f);
            }
          }
          return selected;
        }
        hasParent() {
          return !!this._parent;
        }
        setParent(parent) {
          this._parent = parent;
        }
        getParent() {
          if (this._parent) {
            return this._parent;
          }
          throw new Error(`Frame : ${this.htmlId} has no Parent`);
        }
        expandCollapse() {
          if (this.isCollapsed()) {
            this.expand();
          } else {
            this.collapse();
          }
        }
        expandCollapseAll() {
          (0, frame_helpers_1.expandCollapseAll)(this.getFile());
        }
        isCollapsed() {
          return this._collapsed;
        }
        collapse() {
          if ((0, frame_helpers_1.isCollapsible)(this)) {
            this._collapsed = true;
          }
        }
        expand() {
          if ((0, frame_helpers_1.isCollapsible)(this)) {
            this._collapsed = false;
          }
        }
        isFocused() {
          return this._focused;
        }
        focus() {
          this._focused = true;
        }
        defocus() {
          this._focused = false;
        }
        isComplete() {
          return true;
        }
        updateParseStatus() {
          this._parseStatus = this.worstParseStatusOfFields();
        }
        updateDirectives() {
        }
        worstParseStatusOfFields() {
          return this.getFields().map((g) => g.readParseStatus()).reduce((prev, cur) => cur < prev ? cur : prev, status_enums_1.ParseStatus.valid);
        }
        readParseStatus() {
          return this._parseStatus;
        }
        setParseStatus(newStatus) {
          this._parseStatus = newStatus;
        }
        worstCompileStatusOfFields() {
          return this.getFields().map((g) => g.readCompileStatus()).reduce((prev, cur) => cur < prev ? cur : prev, status_enums_1.CompileStatus.default);
        }
        readCompileStatus() {
          const own = (0, frame_helpers_1.helper_deriveCompileStatusFromErrors)(this.getFile().getAst(false)?.getCompileErrorsFor(this.htmlId) ?? []);
          const worstField = this.worstCompileStatusOfFields();
          return Math.min(own, worstField);
        }
        compileMsgAsHtml() {
          return (0, frame_helpers_1.helper_compileMsgAsHtmlNew)(this.getFile(), this);
        }
        copy = () => {
          const source = this.renderAsSource();
          this.getFile().addCopiedSource(source);
          return false;
        };
        getNextState(currentState, event) {
          switch (currentState) {
            case breakpoint_status_1.BreakpointStatus.none:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.singlestep;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.none;
              }
            case breakpoint_status_1.BreakpointStatus.disabled:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.active;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.disabled;
              }
            case breakpoint_status_1.BreakpointStatus.active:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.active;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.disabled;
              }
            case breakpoint_status_1.BreakpointStatus.singlestep:
              switch (event) {
                case breakpoint_event_1.BreakpointEvent.clear:
                  return breakpoint_status_1.BreakpointStatus.none;
                case breakpoint_event_1.BreakpointEvent.activate:
                  return breakpoint_status_1.BreakpointStatus.singlestep;
                case breakpoint_event_1.BreakpointEvent.disable:
                  return breakpoint_status_1.BreakpointStatus.none;
              }
          }
        }
        updateBreakpoints(event) {
          this.breakpointStatus = this.getNextState(this.breakpointStatus, event);
        }
        setBreakPoint = () => {
          this.breakpointStatus = breakpoint_status_1.BreakpointStatus.active;
          return false;
        };
        clearBreakPoint = () => {
          this.breakpointStatus = breakpoint_status_1.BreakpointStatus.none;
          return false;
        };
        toggleBreakPoint = () => {
          if (this.hasBreakpoint()) {
            this.clearBreakPoint();
          } else {
            this.setBreakPoint();
          }
        };
        clearAllBreakPoints = () => {
          this.getFile().updateBreakpoints(breakpoint_event_1.BreakpointEvent.clear);
          return false;
        };
        hasBreakpoint() {
          return this.breakpointStatus === breakpoint_status_1.BreakpointStatus.active || this.breakpointStatus === breakpoint_status_1.BreakpointStatus.disabled;
        }
        isGhostable() {
          return this.ghostable;
        }
        setGhosted(flag) {
          this._ghosted = flag;
        }
        ghost = () => {
          this.getParent().ghostSelectedChildren();
          return true;
        };
        unGhost = () => {
          this.getParent().unghostSelectedChildren();
          return true;
        };
        isGhosted() {
          return this._ghosted;
        }
        isImported() {
          return this._imported;
        }
        setImported(flag) {
          this._imported = flag;
        }
        isGhostedOrWithinAGhostedFrame() {
          return this.isGhosted() || this.getParent().isGhostedOrWithinAGhostedFrame();
        }
        isWithinAnImportedFrame() {
          const parent = this.getParent();
          return parent.isImported() || parent.isWithinAnImportedFrame();
        }
        sourceAnnotations() {
          return this.isImported() ? `[${keywords_1.importedAnnotation}] ` : this.isGhosted() ? `[${keywords_1.ghostedAnnotation}] ` : "";
        }
        getContextMenuItems() {
          const map = /* @__PURE__ */ new Map();
          if (this.isGhosted()) {
            map.set("unghost", ["unghost", this.unGhost]);
          } else if (!this.isGhostedOrWithinAGhostedFrame()) {
            if (this.isGhostable()) {
              map.set("ghost", ["ghost", this.ghost]);
            }
            map.set("copy", ["copy (Ctrl-c)", this.copySelected]);
            if (this.isDeletable()) {
              map.set("cut", ["cut (Ctrl-x)", this.cutSelected]);
              map.set("delete", ["delete (Ctrl-Delete or Ctrl-Backspace)", this.deleteSelected]);
            }
            if (this.canInsertAfter()) {
              map.set("below", ["insert new code below (Enter)", this.below]);
            }
            if (this.canInsertBefore()) {
              map.set("above", ["insert new code above (Shift-Enter)", this.above]);
            }
            if (this.isMovable()) {
              map.set("up", ["move up (Ctrl-ArrowUp)", this.up]);
              map.set("down", ["move down (Ctrl-ArrowDown)", this.down]);
            }
            if (this.canHaveBreakPoint) {
              if (this.hasBreakpoint()) {
                map.set("clearBP", ["clear breakpoint", this.clearBreakPoint]);
                map.set("clearAllBP", ["clear all breakpoints", this.clearAllBreakPoints]);
              } else {
                map.set("setBP", ["set breakpoint", this.setBreakPoint]);
              }
            }
          }
          return map;
        }
        contextMenu() {
          if (this.showContextMenu) {
            this.showContextMenu = false;
            const items = [];
            const map = this.getContextMenuItems();
            for (const k of map.keys()) {
              const val = map.get(k);
              items.push(`<div class='context-menu-item' data-id='${this.htmlId}' data-func='${k}' title="" tabindex="-1">${val[0]}</div>`);
            }
            return `<div class='context-menu'>${items.join("")}</div>`;
          }
          return "";
        }
        bpAsHtml() {
          return this.hasBreakpoint() ? `<el-bp>&#x1f5f2;</el-bp>` : "";
        }
        toolTip() {
          return ``;
        }
      };
      exports.AbstractFrame = AbstractFrame;
    }
  });

  // out/src/ide/frames/symbol-completion-helpers.js
  var require_symbol_completion_helpers = __commonJS({
    "out/src/ide/frames/symbol-completion-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SymbolCompletionSpec = exports.KeywordCompletion = exports.TokenType = void 0;
      exports.matchingSymbols = matchingSymbols;
      exports.filteredSymbols = filteredSymbols;
      exports.filterForTokenType = filterForTokenType;
      exports.filtersForTokenType = filtersForTokenType;
      exports.getFilteredSymbols = getFilteredSymbols;
      exports.removeIfSingleFullMatch = removeIfSingleFullMatch;
      var keywords_1 = require_keywords();
      var function_type_1 = require_function_type();
      var null_scope_1 = require_null_scope();
      var procedure_type_1 = require_procedure_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var TokenType;
      (function(TokenType2) {
        TokenType2[TokenType2["id_let"] = 0] = "id_let";
        TokenType2[TokenType2["id_variable"] = 1] = "id_variable";
        TokenType2[TokenType2["id_property"] = 2] = "id_property";
        TokenType2[TokenType2["id_parameter_regular"] = 3] = "id_parameter_regular";
        TokenType2[TokenType2["id_parameter_out"] = 4] = "id_parameter_out";
        TokenType2[TokenType2["id_constant"] = 5] = "id_constant";
        TokenType2[TokenType2["id_enumValue"] = 6] = "id_enumValue";
        TokenType2[TokenType2["type_concrete"] = 7] = "type_concrete";
        TokenType2[TokenType2["type_abstract"] = 8] = "type_abstract";
        TokenType2[TokenType2["type_enum"] = 9] = "type_enum";
        TokenType2[TokenType2["type_notInheritable"] = 10] = "type_notInheritable";
        TokenType2[TokenType2["method_procedure"] = 11] = "method_procedure";
        TokenType2[TokenType2["method_function"] = 12] = "method_function";
        TokenType2[TokenType2["method_system"] = 13] = "method_system";
      })(TokenType || (exports.TokenType = TokenType = {}));
      var KeywordCompletion = class _KeywordCompletion {
        keyword;
        spaceAfter;
        dotAfter;
        openBracketAfter;
        constructor(keyword, spaceAfter, dotAfter, openBracketAfter) {
          this.keyword = keyword;
          this.spaceAfter = spaceAfter;
          this.dotAfter = dotAfter;
          this.openBracketAfter = openBracketAfter;
        }
        static map = /* @__PURE__ */ new Map();
        static create(keyword, spaceAfter = true, dotAfter = false, openBracketAfter = false) {
          if (!this.map.has(keyword)) {
            this.map.set(keyword, new _KeywordCompletion(keyword, spaceAfter, dotAfter, openBracketAfter));
          }
          return this.map.get(keyword);
        }
        static reset() {
          this.map.clear();
        }
      };
      exports.KeywordCompletion = KeywordCompletion;
      var SymbolCompletionSpec = class {
        toMatch;
        tokenTypes;
        keywords;
        context;
        constructor(toMatch, tokenTypes, keywords, context) {
          this.toMatch = toMatch;
          this.tokenTypes = tokenTypes;
          this.keywords = keywords;
          this.context = context;
        }
      };
      exports.SymbolCompletionSpec = SymbolCompletionSpec;
      function matchingSymbols(spec, scope) {
        if (spec.context) {
          return (0, symbol_helpers_1.matchingSymbolsWithQualifier)(spec.toMatch, spec.context, scope);
        }
        const allNotExtensions = scope.symbolMatches(spec.toMatch, !spec.toMatch, scope).filter((s) => {
          const st = s.symbolType();
          let isCall = false;
          let isExtension = false;
          if (st instanceof procedure_type_1.ProcedureType || st instanceof function_type_1.FunctionType) {
            isCall = true;
            isExtension = st.isExtension;
          }
          return !isCall || isCall && !isExtension;
        });
        return allNotExtensions;
      }
      function filteredSymbols(spec, scope) {
        const matches = matchingSymbols(spec, scope);
        const filters = filtersForTokenType(spec.tokenTypes);
        const filtered = ensureUnique(filterSymbols(matches, filters));
        const startsWith = filtered.filter((s) => s.symbolId.toUpperCase().startsWith(spec.toMatch.toUpperCase())).sort(symbol_helpers_1.orderSymbol);
        const includes = filtered.filter((s) => !startsWith.includes(s)).sort(symbol_helpers_1.orderSymbol);
        return startsWith.concat(includes);
      }
      function filterSymbols(matches, filters) {
        let filtered = [];
        for (const f of filters) {
          filtered = filtered.concat(matches.filter(f));
        }
        return filtered.filter((e) => !e.symbolId.startsWith("_"));
      }
      function ensureUnique(symbols) {
        const uniqueNames = Array.from(new Set(symbols.map((s) => s.symbolId)));
        return uniqueNames.map((n) => symbols.find((s) => s.symbolId === n));
      }
      function filterForTokenType(tt) {
        switch (tt) {
          case TokenType.method_function:
            return (s) => (0, symbol_helpers_1.isPureFunction)(s);
          case TokenType.method_procedure:
            return (s) => (0, symbol_helpers_1.isProcedure)(s);
          case TokenType.method_system:
            return (s) => (0, symbol_helpers_1.isSystemFunction)(s);
          case TokenType.type_concrete:
            return symbol_helpers_1.isConcreteTypeName;
          case TokenType.type_abstract:
            return symbol_helpers_1.isAbstractTypeName;
          case TokenType.type_enum:
            return symbol_helpers_1.isEnum;
          case TokenType.type_notInheritable:
            return symbol_helpers_1.isNotInheritableTypeName;
          case TokenType.id_constant:
            return symbol_helpers_1.isConstant;
          case TokenType.id_let:
            return symbol_helpers_1.isLet;
          case TokenType.id_variable:
            return symbol_helpers_1.isVariable;
          case TokenType.id_parameter_regular:
            return symbol_helpers_1.isParameter;
          case TokenType.id_parameter_out:
            return symbol_helpers_1.isOutParameter;
          case TokenType.id_property:
            return symbol_helpers_1.isProperty;
          case TokenType.id_enumValue:
            return symbol_helpers_1.isEnumValue;
        }
      }
      function filtersForTokenType(tokenTypes) {
        const filters = [];
        for (const f of tokenTypes) {
          filters.push(filterForTokenType(f));
        }
        return filters;
      }
      function getFilteredSymbols(spec, ast, htmlId) {
        const scope = ast?.getScopeById(htmlId) ?? null_scope_1.NullScope.Instance;
        let symbols = filteredSymbols(spec, scope);
        if ((0, symbol_helpers_1.isInsideClass)(scope)) {
          if (keywords_1.propertyKeyword.startsWith(spec.toMatch)) {
            const allProperties = (0, symbol_helpers_1.allPropertiesInScope)((0, symbol_helpers_1.getClassScope)(scope)).sort(symbol_helpers_1.orderSymbol);
            symbols = symbols.filter((s) => !allProperties.includes(s)).concat(allProperties);
          } else if (spec.context === keywords_1.propertyKeyword) {
            const newSpec = new SymbolCompletionSpec(spec.toMatch, /* @__PURE__ */ new Set([TokenType.id_property]), /* @__PURE__ */ new Set(), "");
            symbols = filteredSymbols(newSpec, scope);
          }
        }
        return symbols;
      }
      function removeIfSingleFullMatch(symbols, id) {
        if (symbols.length === 1 && symbols[0].symbolId === id) {
          return [];
        } else {
          return symbols;
        }
      }
    }
  });

  // out/src/ide/frames/parse-nodes/abstract-parse-node.js
  var require_abstract_parse_node = __commonJS({
    "out/src/ide/frames/parse-nodes/abstract-parse-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractParseNode = void 0;
      var status_enums_1 = require_status_enums();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var AbstractParseNode = class {
        status = status_enums_1.ParseStatus.empty;
        matchedText = "";
        completionWhenEmpty = "";
        remainingText = "";
        activeNodeForSymbolCompl = this;
        //'done' means that parseNode is valid and that no more text may be taken
        //Most parse nodes are never 'done'. Only ones that can return true are:
        //SpaceNode and sub-classes of FixedTextNode or of AbstractSequence
        _done = false;
        setSyntaxCompletionWhenEmpty(ph) {
          this.completionWhenEmpty = ph;
        }
        getSyntaxCompletionAsHtml() {
          return this.matchedText === "" ? `${this.completionWhenEmpty}` : "";
        }
        renderAsSource() {
          return this.matchedText.trim();
        }
        renderAsHtml() {
          return this.renderAsSource();
        }
        set(status, matched, remaining) {
          this.status = status;
          this.matchedText = matched;
          this.remainingText = remaining;
        }
        numLeadingSpaces(text) {
          return text.length - text.trimStart().length;
        }
        updateFrom(other) {
          this.status = other.status;
          this.matchedText = other.matchedText;
          this.remainingText = other.remainingText;
        }
        symbolCompletion_getSpec() {
          const active = this.getActiveNode();
          const isThis = active === this;
          const toMatch = isThis ? this.symbolCompletion_toMatch() : active.symbolCompletion_toMatch();
          const tokens = isThis ? this.symbolCompletion_tokenTypes() : active.symbolCompletion_tokenTypes();
          const keywords = isThis ? this.symbolCompletion_keywords() : active.symbolCompletion_keywords();
          const context = isThis ? this.symbolCompletion_context() : active.symbolCompletion_context();
          const spec = new symbol_completion_helpers_1.SymbolCompletionSpec(toMatch, tokens, keywords, context);
          return spec;
        }
        symbolCompletion_toMatch() {
          const active = this.getActiveNode();
          return active === this ? this.matchedText : active.symbolCompletion_toMatch();
        }
        symbolCompletion_tokenTypes() {
          const active = this.getActiveNode();
          return active === this ? /* @__PURE__ */ new Set() : active.symbolCompletion_tokenTypes();
        }
        symbolCompletion_keywords() {
          const active = this.getActiveNode();
          return active === this ? /* @__PURE__ */ new Set() : active.symbolCompletion_keywords();
        }
        symbolCompletion_context() {
          const active = this.getActiveNode();
          return active === this ? "" : active.symbolCompletion_context();
        }
        getActiveNode() {
          const active = this.activeNodeForSymbolCompl;
          return active === this ? active : active.getActiveNode();
        }
        isDone() {
          return this._done;
        }
        isValid() {
          return this.status === status_enums_1.ParseStatus.valid;
        }
        isIncomplete() {
          return this.status === status_enums_1.ParseStatus.incomplete;
        }
        isEmpty() {
          return this.status === status_enums_1.ParseStatus.empty;
        }
        isInvalid() {
          return this.status === status_enums_1.ParseStatus.invalid;
        }
      };
      exports.AbstractParseNode = AbstractParseNode;
    }
  });

  // out/src/ide/frames/parse-nodes/space-node.js
  var require_space_node = __commonJS({
    "out/src/ide/frames/parse-nodes/space-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SpaceNode = void 0;
      var regexes_1 = require_regexes();
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var SpaceNode = class extends abstract_parse_node_1.AbstractParseNode {
        type;
        constructor(type) {
          super();
          this.type = type;
        }
        parseText(text) {
          if (text.length === 0) {
            if (this.type === parse_node_helpers_1.Space.required) {
              this.status = status_enums_1.ParseStatus.empty;
            } else {
              this.status = status_enums_1.ParseStatus.valid;
            }
          } else {
            this.remainingText = text;
            const matches = text.match(regexes_1.Regexes.leadingSpaceNotNL);
            if (matches !== null && matches.length > 0) {
              this.remainingText = text.replace(matches[0], "");
              this.status = status_enums_1.ParseStatus.valid;
              this._done = true;
            } else if (this.type === parse_node_helpers_1.Space.required) {
              this.status = status_enums_1.ParseStatus.invalid;
            } else {
              this.status = status_enums_1.ParseStatus.valid;
              this._done = true;
            }
          }
        }
        renderAsHtml() {
          return this.renderAsSource();
        }
        renderAsSource() {
          return this.type === parse_node_helpers_1.Space.ignored || this.status === status_enums_1.ParseStatus.empty ? "" : " ";
        }
        getSyntaxCompletionAsHtml() {
          return this.status === status_enums_1.ParseStatus.empty && this.type === parse_node_helpers_1.Space.required ? " " : "";
        }
        compile() {
          return this.type === parse_node_helpers_1.Space.ignored ? "" : " ";
        }
      };
      exports.SpaceNode = SpaceNode;
    }
  });

  // out/src/ide/frames/parse-nodes/parse-node-helpers.js
  var require_parse_node_helpers = __commonJS({
    "out/src/ide/frames/parse-nodes/parse-node-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.allKeywordsThatCanStartAnExpression = exports.concreteAndAbstractTypes = exports.assignableIds = exports.allIdsAndMethods = exports.allMethods = exports.allIds = exports.noTokenTypes = exports.Space = void 0;
      exports.matchRegEx = matchRegEx;
      exports.isFixedText = isFixedText;
      exports.spIgn = spIgn;
      exports.spAdd = spAdd;
      exports.spReq = spReq;
      exports.removeUnmatchedClosingBracket = removeUnmatchedClosingBracket;
      var keywords_1 = require_keywords();
      var status_enums_1 = require_status_enums();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var space_node_1 = require_space_node();
      function matchRegEx(text, regx) {
        let status = status_enums_1.ParseStatus.invalid;
        let match = "";
        let remaining = text;
        const matches = text.match(regx);
        if (matches !== null && matches.length > 0) {
          match = matches[0];
          status = status_enums_1.ParseStatus.valid;
          remaining = text.replace(match, "");
        }
        return [status, match, remaining];
      }
      function isFixedText(f) {
        return !!f && "fixedText" in f;
      }
      function spIgn() {
        return () => new space_node_1.SpaceNode(Space.ignored);
      }
      function spAdd() {
        return () => new space_node_1.SpaceNode(Space.added);
      }
      function spReq() {
        return () => new space_node_1.SpaceNode(Space.required);
      }
      var Space;
      (function(Space2) {
        Space2[Space2["ignored"] = 0] = "ignored";
        Space2[Space2["added"] = 1] = "added";
        Space2[Space2["required"] = 2] = "required";
      })(Space || (exports.Space = Space = {}));
      exports.noTokenTypes = /* @__PURE__ */ new Set();
      exports.allIds = [
        symbol_completion_helpers_1.TokenType.id_constant,
        symbol_completion_helpers_1.TokenType.id_let,
        symbol_completion_helpers_1.TokenType.id_parameter_out,
        symbol_completion_helpers_1.TokenType.id_parameter_regular,
        symbol_completion_helpers_1.TokenType.id_property,
        symbol_completion_helpers_1.TokenType.id_variable,
        symbol_completion_helpers_1.TokenType.id_enumValue
      ];
      exports.allMethods = [
        symbol_completion_helpers_1.TokenType.method_function,
        symbol_completion_helpers_1.TokenType.method_function,
        symbol_completion_helpers_1.TokenType.method_system
      ];
      exports.allIdsAndMethods = [
        symbol_completion_helpers_1.TokenType.id_constant,
        symbol_completion_helpers_1.TokenType.id_let,
        symbol_completion_helpers_1.TokenType.id_parameter_out,
        symbol_completion_helpers_1.TokenType.id_parameter_regular,
        symbol_completion_helpers_1.TokenType.id_property,
        symbol_completion_helpers_1.TokenType.id_variable,
        symbol_completion_helpers_1.TokenType.id_enumValue,
        symbol_completion_helpers_1.TokenType.method_function,
        symbol_completion_helpers_1.TokenType.method_function,
        symbol_completion_helpers_1.TokenType.method_system
      ];
      exports.assignableIds = [
        symbol_completion_helpers_1.TokenType.id_parameter_out,
        symbol_completion_helpers_1.TokenType.id_variable,
        symbol_completion_helpers_1.TokenType.id_property
      ];
      exports.concreteAndAbstractTypes = [
        symbol_completion_helpers_1.TokenType.type_abstract,
        symbol_completion_helpers_1.TokenType.type_notInheritable,
        symbol_completion_helpers_1.TokenType.type_concrete,
        symbol_completion_helpers_1.TokenType.type_enum
      ];
      exports.allKeywordsThatCanStartAnExpression = new Set([keywords_1.newKeyword, keywords_1.copyKeyword, keywords_1.ifKeyword, keywords_1.lambdaKeyword, keywords_1.emptyKeyword].map((kw) => symbol_completion_helpers_1.KeywordCompletion.create(kw)));
      function removeUnmatchedClosingBracket(text) {
        if (text.endsWith(")") && text.split("(").length - text.split(")").length !== 0) {
          text = text.slice(0, text.length - 1);
        }
        return text;
      }
    }
  });

  // out/src/ide/frames/parse-nodes/identifier-node.js
  var require_identifier_node = __commonJS({
    "out/src/ide/frames/parse-nodes/identifier-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IdentifierNode = void 0;
      var keywords_1 = require_keywords();
      var regexes_1 = require_regexes();
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var IdentifierNode = class extends abstract_parse_node_1.AbstractParseNode {
        tokenTypes;
        contextGenerator;
        constructor(tokenTypes = /* @__PURE__ */ new Set(), contextGenerator = () => "") {
          super();
          this.tokenTypes = tokenTypes;
          this.contextGenerator = contextGenerator;
          this.completionWhenEmpty = "<i>name</i>";
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            [this.status, this.matchedText, this.remainingText] = (0, parse_node_helpers_1.matchRegEx)(text.trimStart(), regexes_1.Regexes.identifier);
          }
          if (this.isValid() && this.remainingText.length > 0) {
            if (this.matchesKeyword()) {
              this.status = status_enums_1.ParseStatus.invalid;
            } else {
              this._done = true;
            }
          }
        }
        matchesKeyword() {
          return keywords_1.allKeywords.filter((k) => this.matchedText === k).length > 0;
        }
        symbolCompletion_tokenTypes() {
          return this.tokenTypes;
        }
        symbolCompletion_context() {
          return this.contextGenerator();
        }
        renderAsHtml() {
          return `<el-id>${this.renderAsSource()}</el-id>`;
        }
      };
      exports.IdentifierNode = IdentifierNode;
    }
  });

  // out/src/ide/frames/overtyper.js
  var require_overtyper = __commonJS({
    "out/src/ide/frames/overtyper.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Overtyper = void 0;
      var Overtyper = class {
        hasNotConsumed = (_s) => true;
        toConsume = "";
        timer;
        timeOut;
        consuming(k) {
          if (k) {
            if (this.toConsume.length > 0 && k.toUpperCase() === this.toConsume[0].toUpperCase()) {
              this.toConsume = this.toConsume.slice(1);
              clearTimeout(this.timer);
              this.timer = setTimeout(() => this.hasNotConsumed = (_s) => true, this.timeOut);
              return false;
            }
            this.toConsume = "";
            this.hasNotConsumed = (_s) => true;
            clearTimeout(this.timer);
          }
          return true;
        }
        consumeChars(toConsume, timeOut) {
          if (toConsume.length > 0) {
            this.timeOut = timeOut;
            this.toConsume = toConsume;
            this.hasNotConsumed = this.consuming;
            this.timer = setTimeout(() => this.hasNotConsumed = (_s) => true, timeOut);
          }
        }
      };
      exports.Overtyper = Overtyper;
    }
  });

  // out/src/ide/frames/symbol-wrapper.js
  var require_symbol_wrapper = __commonJS({
    "out/src/ide/frames/symbol-wrapper.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SymbolWrapper = void 0;
      var keywords_1 = require_keywords();
      var symbol_helpers_1 = require_symbol_helpers();
      var empty_asn_1 = require_empty_asn();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var SymbolWrapper = class {
        wrapped;
        scope;
        constructor(wrapped, scope) {
          this.wrapped = wrapped;
          this.scope = scope;
          if (wrapped instanceof symbol_completion_helpers_1.KeywordCompletion) {
            this.name = wrapped.keyword;
            this.isKeyword = true;
          } else {
            this.name = wrapped.symbolId;
            this.isKeyword = false;
          }
        }
        isKeyword;
        name;
        get displayName() {
          if (this.isKeyword) {
            return this.name;
          }
          const symbol = this.wrapped;
          if ((0, symbol_helpers_1.isProperty)(symbol) && (0, symbol_helpers_1.isMemberOnFieldsClass)(symbol, this.scope)) {
            return `${keywords_1.propertyKeyword}.${symbol.symbolId}`;
          }
          return this.name;
        }
        get class() {
          if (this.isKeyword) {
            return " keyword";
          }
          const symbol = this.wrapped;
          if ((0, symbol_helpers_1.isConcreteTypeName)(symbol) || (0, symbol_helpers_1.isAbstractTypeName)(symbol) || (0, symbol_helpers_1.isNotInheritableClass)(symbol)) {
            return " type";
          }
          if ((0, symbol_helpers_1.isFunction)(symbol) || (0, symbol_helpers_1.isProcedure)(symbol)) {
            return " method";
          }
          if ((0, symbol_helpers_1.isId)(symbol)) {
            return " id";
          }
          return "";
        }
        get insertedText() {
          if (this.wrapped instanceof symbol_completion_helpers_1.KeywordCompletion) {
            const postfix = this.wrapped.dotAfter ? "." : this.wrapped.spaceAfter ? " " : this.wrapped.openBracketAfter ? "(" : "";
            return `${this.name}${postfix}`;
          }
          const symbol = this.wrapped;
          if ((0, symbol_helpers_1.isGenericClass)(symbol)) {
            return `${this.name}<of `;
          }
          if ((0, symbol_helpers_1.isFunction)(symbol)) {
            return `${this.name}(`;
          }
          if ((0, symbol_helpers_1.isProcedure)(symbol)) {
            return `${this.name}`;
          }
          if ((0, symbol_helpers_1.isConcreteTypeName)(symbol) || (0, symbol_helpers_1.isAbstractTypeName)(symbol)) {
            return `${this.name}`;
          }
          if ((0, symbol_helpers_1.isMemberOnFieldsClass)(symbol, this.scope)) {
            return `${keywords_1.propertyKeyword}.${symbol.symbolId}`;
          }
          if ((0, symbol_helpers_1.isCall)(this.scope) && this.scope.args instanceof empty_asn_1.EmptyAsn) {
            return `${this.name}.`;
          }
          return this.name;
        }
        matches(other) {
          if (!other) {
            return false;
          }
          if (this.isKeyword && other.isKeyword) {
            return this.name === other.name;
          }
          if (!this.isKeyword && !other.isKeyword) {
            return this.name === other.name && this.wrapped.symbolScope === other.wrapped.symbolScope;
          }
          return false;
        }
      };
      exports.SymbolWrapper = SymbolWrapper;
    }
  });

  // out/src/ide/frames/fields/abstract-field.js
  var require_abstract_field = __commonJS({
    "out/src/ide/frames/fields/abstract-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractField = void 0;
      var keywords_1 = require_keywords();
      var frame_helpers_1 = require_frame_helpers();
      var overtyper_1 = require_overtyper();
      var status_enums_1 = require_status_enums();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbol_wrapper_1 = require_symbol_wrapper();
      var AbstractField = class {
        isField = true;
        text = "";
        placeholder = "";
        placeholderIsCode = false;
        useHtmlTags = false;
        htmlId = "";
        selected = false;
        focused = false;
        _classes = new Array();
        holder;
        _optional = false;
        map;
        _parseStatus;
        cursorPos = 0;
        //Relative to LH end of text
        selectionEnd = 0;
        //Relative to LH end of text
        rootNode;
        completion = "";
        overtyper = new overtyper_1.Overtyper();
        codeHasChanged = false;
        allPossibleSymbolCompletions = [];
        symbolToMatch = "";
        selectedSymbolCompletion;
        showingSymbolCompletion = false;
        helpActive = false;
        constructor(holder) {
          this.holder = holder;
          const map = holder.getMap();
          this.htmlId = `${this.getIdPrefix()}${this.getFile().getNextId()}`;
          map.set(this.htmlId, this);
          this.map = map;
          this._parseStatus = status_enums_1.ParseStatus.incomplete;
        }
        getRootNode() {
          return this.rootNode;
        }
        getFile() {
          return this.holder.getFile();
        }
        getHtmlId() {
          return this.htmlId;
        }
        showHelp() {
          this.helpActive = true;
        }
        alertHolderToUpdate() {
          this.getHolder().fieldUpdated(this);
        }
        parseCurrentText() {
          const root = this.initialiseRoot();
          this.parseCompleteTextUsingNode(this.text, root);
        }
        parseFrom(source) {
          this.holder.hasBeenAddedTo();
          const text = this.readToDelimiter(source);
          const root = this.initialiseRoot();
          this.parseCompleteTextUsingNode(text, root);
          if (this.isOptional() && this._parseStatus === status_enums_1.ParseStatus.empty) {
            this._parseStatus = status_enums_1.ParseStatus.valid;
          } else if (this._parseStatus === status_enums_1.ParseStatus.invalid) {
            throw new Error(`Parse error at ${source.getRemainingCode()}`);
          }
        }
        parseCompleteTextUsingNode(text, root) {
          if (text.length === 0) {
            this.setParseStatus(this.isOptional() ? status_enums_1.ParseStatus.valid : status_enums_1.ParseStatus.incomplete);
          } else {
            root.parseText(text.trimStart());
            if (root.remainingText.trim().length > 0 || root.status === status_enums_1.ParseStatus.invalid) {
              this.setParseStatus(status_enums_1.ParseStatus.invalid);
              this.text = text.trimStart();
            } else {
              this.setParseStatus(root.status);
              this.text = root.renderAsSource();
            }
          }
        }
        getCompletion() {
          return this.rootNode ? this.rootNode.getSyntaxCompletionAsHtml() : "";
        }
        getPlainTextCompletion() {
          const comps = this.getCompletion();
          const i = comps.indexOf("<i>");
          return i === -1 ? comps : comps.substring(0, i);
        }
        setOptional(optional) {
          this._optional = optional;
          if (this.text === "" && optional) {
            this._parseStatus = status_enums_1.ParseStatus.valid;
          } else if (this.text === "" && !optional) {
            this._parseStatus = status_enums_1.ParseStatus.incomplete;
          }
        }
        getOptional() {
          return this._optional;
        }
        isOptional() {
          return this._optional;
        }
        processAutocompleteText(txt) {
          if (txt) {
            this.selectedSymbolCompletion = this.allPossibleSymbolCompletions.find((s) => s.displayName === txt);
          }
        }
        setSelection(start, end) {
          this.cursorPos = start;
          this.selectionEnd = end ?? start;
        }
        deleteSelection(selection) {
          const [start, end] = selection;
          const textLen = this.text.length;
          if (start !== textLen) {
            const endMod = start === end ? start + 1 : end;
            this.text = this.text.slice(0, start) + this.text.slice(endMod);
            this.setSelection(start);
          }
        }
        deleteNewSelection(e) {
          if (e.selection) {
            this.deleteSelection(e.selection);
          }
        }
        hasSelection() {
          return this.cursorPos !== this.selectionEnd;
        }
        deleteExistingSelection() {
          if (this.hasSelection()) {
            this.deleteSelection([this.cursorPos, this.selectionEnd]);
          }
        }
        controlKeys = ["o", "O", "ArrowLeft", "ArrowRight", "a", "v", "?"];
        processKey(e) {
          this.codeHasChanged = false;
          const key = e.key;
          if (e.modKey.control && !this.controlKeys.includes(key ?? "")) {
            return false;
          }
          const textLen = this.text.length;
          this.processAutocompleteText(e.optionalData);
          switch (key) {
            case "Home": {
              this.setSelection(0);
              break;
            }
            case "End": {
              this.setSelection(textLen);
              break;
            }
            case "Tab": {
              this.tab(e.modKey.shift);
              this.noLongerEditingField();
              break;
            }
            case "Enter": {
              this.enter();
              break;
            }
            case "ArrowLeft": {
              if (e.modKey.control) {
                this.cursorWordLeft(e.modKey.shift);
              } else {
                this.cursorLeft(e.modKey.shift);
              }
              break;
            }
            case "ArrowRight": {
              if (e.modKey.control) {
                this.cursorWordRight(e.modKey.shift);
              } else {
                this.cursorRight(e.modKey.shift);
              }
              break;
            }
            case "ArrowUp": {
              if (this.showingSymbolCompletion) {
                this.selectFromAutoCompleteItems(true);
              }
              break;
            }
            case "ArrowDown": {
              if (this.showingSymbolCompletion) {
                this.selectFromAutoCompleteItems(false);
              }
              break;
            }
            case "Backspace": {
              if (this.holder.isNew) {
                this.holder.deleteIfPermissible();
                this.codeHasChanged = true;
              } else if (this.hasSelection()) {
                this.deleteExistingSelection();
                this.parseCurrentText();
              } else if (this.cursorPos > 0) {
                const reduced = this.text.slice(0, this.cursorPos - 1) + this.text.slice(this.cursorPos);
                this.text = reduced;
                this.setSelection(this.cursorPos - 1);
                const cursorBeforeParse = this.cursorPos;
                this.parseCurrentText();
                if (this.text.length > reduced.length) {
                  this.text = reduced;
                  this.setSelection(cursorBeforeParse);
                }
                this.codeHasChanged = true;
                this.editingField();
              }
              break;
            }
            case "Delete": {
              this.deleteNewSelection(e);
              this.parseCurrentText();
              this.codeHasChanged = true;
              this.editingField();
              break;
            }
            case "ContextMenu": {
              break;
            }
            case "t": {
              if (e.modKey.alt) {
                this.getFile().removeAllSelectorsThatCanBe();
                break;
              }
            }
            case "a": {
              if (e.modKey.control) {
                this.setSelection(0, this.text.length);
                break;
              }
            }
            case "?": {
              if (e.modKey.control) {
                this.showHelp();
                break;
              }
            }
            case "v": {
              if (e.modKey.control) {
                const toPaste = e.optionalData ?? "";
                this.deleteExistingSelection();
                for (const c of toPaste) {
                  this.processInput(c);
                }
                this.codeHasChanged = true;
                this.holder.hasBeenAddedTo();
                this.editingField();
                break;
              }
            }
            default: {
              if (key === "o" && e.modKey.control && (0, frame_helpers_1.isCollapsible)(this.holder)) {
                this.holder.expandCollapse();
                this.noLongerEditingField();
              } else if (key === "O" && e.modKey.control) {
                this.holder.expandCollapseAll();
                this.noLongerEditingField();
              } else if (key?.length === 1) {
                this.deleteExistingSelection();
                this.processInput(key);
                this.codeHasChanged = true;
                this.holder.hasBeenAddedTo();
                this.editingField();
              }
            }
          }
          if (this.codeHasChanged) {
            this.selectedSymbolCompletion = void 0;
          }
          return this.codeHasChanged;
        }
        editingField() {
          this.getFile().setFieldBeingEdited(true);
        }
        noLongerEditingField() {
          this.getFile().setFieldBeingEdited(false);
          this.codeHasChanged = true;
        }
        isEndMarker(_key) {
          return false;
        }
        processInput(key) {
          if (this.overtyper.hasNotConsumed(key)) {
            if (this.isEndMarker(key)) {
              this.enter();
            } else {
              this.text = this.text.slice(0, this.cursorPos) + key + this.text.slice(this.cursorPos);
              const preParse = this.text.length;
              this.parseCurrentText();
              const afterParse = this.text.length;
              this.setSelection(this.cursorPos + 1 + afterParse - preParse);
            }
          }
        }
        cursorSelectRight() {
          const textLen = this.text.length;
          if (this.selectionEnd < textLen) {
            this.setSelection(this.cursorPos, this.selectionEnd + 1);
          }
        }
        cursorSelectLeft() {
          if (this.cursorPos > 0) {
            this.setSelection(this.cursorPos - 1, this.selectionEnd);
          }
        }
        cursorMoveRight() {
          const textLen = this.text.length;
          if (this.cursorPos < textLen) {
            this.setSelection(this.cursorPos + 1);
          } else {
            const completions = this.getPlainTextCompletion();
            if (completions.length > 0) {
              this.text = this.text + completions;
              this.parseCurrentText();
              this.setSelection(this.text.length);
              this.codeHasChanged = true;
            }
          }
        }
        cursorMoveLeft() {
          if (this.cursorPos > 0) {
            this.setSelection(this.cursorPos - 1);
          }
        }
        cursorRight(shift) {
          if (shift) {
            this.cursorSelectRight();
          } else {
            this.cursorMoveRight();
          }
        }
        cursorLeft(shift) {
          if (shift) {
            this.cursorSelectLeft();
          } else {
            this.cursorMoveLeft();
          }
        }
        isWordBreakCharRight(c) {
          return c === " " || c === "." || c === "(";
        }
        isWordBreakCharLeft(c) {
          return c === " " || c === "." || c === ")";
        }
        cursorSelectWordRight() {
          const textLen = this.text.length;
          if (this.selectionEnd < textLen) {
            for (let i = this.selectionEnd + 1; i < textLen; i++) {
              const nextChar = this.text[i];
              if (this.isWordBreakCharRight(nextChar)) {
                this.setSelection(this.cursorPos, i);
                return;
              }
            }
            this.setSelection(this.cursorPos, textLen);
          }
        }
        cursorMoveWordRight() {
          const textLen = this.text.length;
          if (this.cursorPos < textLen) {
            for (let i = this.cursorPos + 1; i < textLen; i++) {
              const nextChar = this.text[i];
              if (this.isWordBreakCharRight(nextChar)) {
                this.setSelection(i);
                return;
              }
            }
            this.setSelection(textLen);
          }
        }
        cursorWordRight(shift) {
          if (shift) {
            this.cursorSelectWordRight();
          } else {
            this.cursorMoveWordRight();
          }
        }
        cursorSelectWordLeft() {
          if (this.cursorPos > 0) {
            const startIndex = this.isWordBreakCharLeft(this.text[this.cursorPos - 1]) ? this.cursorPos - 1 : this.cursorPos;
            for (let i = startIndex; i > 0; i--) {
              const nextChar = this.text[i - 1];
              if (this.isWordBreakCharLeft(nextChar)) {
                this.setSelection(i, this.selectionEnd);
                return;
              }
            }
            this.setSelection(0, this.selectionEnd);
          }
        }
        cursorMoveWordLeft() {
          if (this.cursorPos > 0) {
            const startIndex = this.isWordBreakCharLeft(this.text[this.cursorPos - 1]) ? this.cursorPos - 1 : this.cursorPos;
            for (let i = startIndex; i > 0; i--) {
              const nextChar = this.text[i - 1];
              if (this.isWordBreakCharLeft(nextChar)) {
                this.setSelection(i);
                return;
              }
            }
            this.setSelection(0);
          }
        }
        cursorWordLeft(shift) {
          if (shift) {
            this.cursorSelectWordLeft();
          } else {
            this.cursorMoveWordLeft();
          }
        }
        replaceAutocompletedText() {
          if (this.symbolToMatch !== "") {
            const li = this.text.lastIndexOf(this.symbolToMatch);
            this.text = this.text.slice(0, li);
          }
          const propertyPrefix = `${keywords_1.propertyKeyword}.`;
          const appendText = this.selectedSymbolCompletion?.insertedText ?? "";
          if (this.text === propertyPrefix && appendText.startsWith(propertyPrefix)) {
            this.text = "";
          }
          const optSpace = this.text && this.selectedSymbolCompletion?.isKeyword ? " " : "";
          this.text = `${this.text}${optSpace}${appendText}`;
          this.selectedSymbolCompletion = void 0;
          this.parseCurrentText();
          this.setSelection(this.text.length);
          this.codeHasChanged = true;
          this.holder.hasBeenAddedTo();
        }
        tab(back) {
          if (back) {
            this.holder.selectFieldBefore(this);
          } else if (this.selectedSymbolCompletion) {
            this.replaceAutocompletedText();
          } else {
            const completions = this.getPlainTextCompletion();
            if (completions.length > 0) {
              this.cursorRight(false);
            } else {
              this.holder.selectFieldAfter(this);
            }
          }
        }
        enter() {
          if (this.selectedSymbolCompletion) {
            this.replaceAutocompletedText();
          } else {
            const completions = this.getPlainTextCompletion();
            if (completions.length > 0) {
              this.cursorRight(false);
            } else {
              const peerFields = this.holder.getFields();
              const last = peerFields.length - 1;
              const thisField = peerFields.indexOf(this);
              if (thisField === last) {
                this.holder.selectNextFrame();
              } else {
                this.tab(false);
              }
              this.noLongerEditingField();
            }
          }
        }
        isFocused() {
          return this.focused;
        }
        getHolder() {
          return this.holder;
        }
        getIdPrefix() {
          return "text";
        }
        focus() {
          this.focused = true;
        }
        defocus() {
          this.focused = false;
        }
        deselectAll() {
          for (const f of this.map.values()) {
            if (f.isSelected()) {
              f.deselect();
            }
          }
          this.noLongerEditingField();
        }
        setParseStatus(newStatus) {
          this._parseStatus = newStatus;
        }
        readParseStatus() {
          return this._parseStatus;
        }
        readCompileStatus() {
          return (0, frame_helpers_1.helper_deriveCompileStatusFromErrors)(this.getFile().getAst(false)?.getCompileErrorsFor(this.htmlId) ?? []);
        }
        select(_withFocus, _multiSelect, selection) {
          if (!this.isWithinAGhostedFrame() && !this.getHolder().isImported()) {
            this.deselectAll();
            this.selected = true;
            this.focus();
            if (selection) {
              let [start, end] = selection;
              if (start === this.cursorPos && end === this.selectionEnd) {
                start = end = this.cursorPos;
              }
              this.setSelection(start, end);
            } else {
              this.setSelection(this.text.length);
            }
          }
        }
        isSelected() {
          return this.selected === true;
        }
        deselect() {
          this.selected = false;
          this.defocus();
          this.noLongerEditingField();
        }
        setPlaceholder(placeholder) {
          this.placeholder = placeholder;
        }
        textAsHtml() {
          let html = "";
          if (this.selected) {
            html = this.fieldAsInput() + this.symbolCompletion();
          } else {
            if (this.rootNode && this._parseStatus === status_enums_1.ParseStatus.valid) {
              html = this.rootNode.renderAsHtml();
            } else {
              html = (0, frame_helpers_1.escapeHtmlChars)(this.text);
            }
          }
          return html;
        }
        fieldAsInput() {
          return `<input spellcheck="false" data-cursorstart="${this.cursorPos}" data-cursorend="${this.selectionEnd}" size="${this.charCount()}" style="width: ${this.fieldWidth()}" value="${this.escapeDoubleQuotesAndEscapes(this.text)}" tabindex="-1">`;
        }
        charCount() {
          return this.text ? this.text.length > 1 ? this.text.length - 1 : 1 : 1;
        }
        fieldWidth() {
          return this.text.length === 0 ? "2px" : `${this.text.length}ch`;
        }
        escapeDoubleQuotesAndEscapes(str) {
          return str.replace(/&/g, "&amp;").replace(/"/g, "&quot;");
        }
        textAsSource() {
          return this.text;
        }
        setClasses() {
          this._classes = new Array();
          this.pushClass(this.selected, "selected");
          this.pushClass(this.focused, "focused");
          this.pushClass(!this.text, "empty");
          this.pushClass(this.isOptional(), "optional");
          this._classes.push(status_enums_1.DisplayColour[this.readDisplayStatus()]);
        }
        readDisplayStatus() {
          return (0, frame_helpers_1.helper_CompileOrParseAsDisplayStatus)(this);
        }
        pushClass(flag, cls) {
          if (flag) {
            this._classes.push(cls);
          }
        }
        cls() {
          this.setClasses();
          return this._classes.join(" ");
        }
        getMessage() {
          const cls = status_enums_1.DisplayColour[status_enums_1.DisplayColour.error];
          return this._parseStatus === status_enums_1.ParseStatus.invalid ? `<el-msg class="${cls}"> Invalid.${this.helpAsHtml()}</el-msg>` : (0, frame_helpers_1.helper_compileMsgAsHtmlNew)(this.getFile(), this);
        }
        helpAsHtml() {
          const active = this.helpActive ? ` class="active"` : "";
          this.helpActive = false;
          return `<el-help title="Click to open Help for this field"><a href="documentation/LangRef.html#${this.helpId()}" target="help-iframe" tabindex="-1"${active}>?</a></el-help>`;
        }
        renderAsHtml() {
          return `<el-field id="${this.htmlId}" class="${this.cls()}" tabindex="-1"><el-txt>${this.textAsHtml()}</el-txt><el-place>${this.placeholder}</el-place><el-compl>${this.getCompletion().replace("<of", "&lt;of")}</el-compl>${this.getMessage()}${this.helpAsHtml()}</el-field>`;
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return this.textAsSource();
        }
        setFieldToKnownValidText(text) {
          this.text = text;
          const root = this.initialiseRoot();
          this.parseCompleteTextUsingNode(this.text, root);
          this._parseStatus = status_enums_1.ParseStatus.valid;
        }
        matchingSymbolsForId(spec) {
          const ast = this.getFile().getAst(false);
          const symbols = (0, symbol_completion_helpers_1.getFilteredSymbols)(spec, ast, this.getHolder().getHtmlId());
          return (0, symbol_completion_helpers_1.removeIfSingleFullMatch)(symbols, spec.toMatch);
        }
        popupAsHtml() {
          const symbols = this.allPossibleSymbolCompletions;
          const symbolAsHtml = [];
          const count = this.allPossibleSymbolCompletions.length;
          this.selectedSymbolCompletion = this.selectedSymbolCompletion ? symbols.filter((s) => s.matches(this.selectedSymbolCompletion))[0] : void 0;
          const selectedIndex = this.selectedSymbolCompletion ? symbols.indexOf(this.selectedSymbolCompletion) : 0;
          let popupAsHtml = "";
          let startIndex = 0;
          let lastIndex = count > 10 ? 10 : count;
          let lastName = "";
          if (count > 10 && selectedIndex > 5) {
            startIndex = selectedIndex - 5;
            lastIndex = selectedIndex + 5;
            lastIndex = lastIndex > count ? count : lastIndex;
          }
          if (count === 0) {
            this.selectedSymbolCompletion = void 0;
          }
          for (let i = startIndex; i < lastIndex; i++) {
            const symbol = symbols[i];
            const name = symbol.displayName;
            const cls = symbol.class;
            const selected = this.markIfSelected(symbol) ? " selected" : "";
            lastName = name;
            symbolAsHtml.push(`<div class="autocomplete-item${selected}${cls}" data-id="${this.htmlId}">${name}</div>`);
          }
          if (count > 10 && selectedIndex + 5 < count) {
            symbolAsHtml.push(`<div class="autocomplete-ellipsis" data-id="${this.htmlId}" data-selected="${lastName}" >...</div>`);
          }
          if (symbolAsHtml.length > 0) {
            popupAsHtml = `<div class="autocomplete-popup">${symbolAsHtml.join("")}</div>`;
          }
          return popupAsHtml;
        }
        markIfSelected(symbol) {
          return symbol === this.selectedSymbolCompletion;
        }
        selectFromAutoCompleteItems(up) {
          const options = this.allPossibleSymbolCompletions;
          let matched = false;
          for (let i = 0; i < options.length; i++) {
            if (!matched && options[i] === this.selectedSymbolCompletion) {
              if (i > 0 && up) {
                this.selectedSymbolCompletion = options[i - 1];
                matched = true;
              } else if (i < options.length - 1 && !up) {
                this.selectedSymbolCompletion = options[i + 1];
                matched = true;
              }
            }
          }
          if (!matched && options.length > 0) {
            this.selectedSymbolCompletion = options[0];
          }
        }
        showAutoComplete(spec) {
          return (spec.tokenTypes.size > 0 || spec.keywords.size > 0) && this.selected && this.cursorPos === this.text.length && this.readParseStatus() !== status_enums_1.ParseStatus.invalid;
        }
        getSymbolCompletionSpec() {
          symbol_completion_helpers_1.KeywordCompletion.reset();
          const rn = this.rootNode ?? this.initialiseRoot();
          const spec = rn.symbolCompletion_getSpec();
          if (spec.context === "") {
            spec.context = this.extractContextFromText();
          } else if (spec.context === "none") {
            spec.context = "";
          }
          return spec;
        }
        orderSymbol(s1, s2) {
          return s1.name.localeCompare(s2.name);
        }
        extractContextFromText() {
          const rgx = /([[A-Za-z][A-Za-z0-9_]*)(\(.*\))?\.([[A-Za-z][A-Za-z0-9_]*)?$/;
          return rgx.test(this.text) ? this.text.match(rgx)[1] : "";
        }
        symbolCompletionAsHtml() {
          let popupAsHtml = "";
          const spec = this.getSymbolCompletionSpec();
          if (this.showAutoComplete(spec)) {
            this.symbolToMatch = spec.toMatch;
            const scope = this.getFile().getAst(false)?.getScopeById(this.getHolder().getHtmlId());
            const keywords = Array.from(spec.keywords).map((k) => new symbol_wrapper_1.SymbolWrapper(k, scope)).sort(this.orderSymbol);
            const symbols = this.matchingSymbolsForId(spec).map((s) => new symbol_wrapper_1.SymbolWrapper(s, scope));
            this.allPossibleSymbolCompletions = keywords.concat(symbols);
            popupAsHtml = this.popupAsHtml();
          }
          this.showingSymbolCompletion = !!popupAsHtml;
          return popupAsHtml;
        }
        isWithinAGhostedFrame() {
          return this.getHolder().isGhostedOrWithinAGhostedFrame();
        }
      };
      exports.AbstractField = AbstractField;
    }
  });

  // out/src/ide/frames/fields/identifier-field.js
  var require_identifier_field = __commonJS({
    "out/src/ide/frames/fields/identifier-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IdentifierField = void 0;
      var identifier_node_1 = require_identifier_node();
      var abstract_field_1 = require_abstract_field();
      var IdentifierField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>name</i>");
        }
        helpId() {
          return "IdentifierField";
        }
        initialiseRoot() {
          this.rootNode = new identifier_node_1.IdentifierNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/[^a-zA-Z0-9_]/);
        getIdPrefix() {
          return "ident";
        }
        isEndMarker(key) {
          return key === " " || key === "(";
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.IdentifierField = IdentifierField;
    }
  });

  // out/src/ide/frames/parse-nodes/abstract-sequence.js
  var require_abstract_sequence = __commonJS({
    "out/src/ide/frames/parse-nodes/abstract-sequence.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractSequence = void 0;
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var AbstractSequence = class extends abstract_parse_node_1.AbstractParseNode {
        elements = [];
        addElement(node) {
          this.elements.push(node);
        }
        getElements() {
          return this.elements;
        }
        parseText(text) {
          let i = -1;
          this.remainingText = text;
          let continueLoop = true;
          while (this.elements.length > 0 && continueLoop) {
            i++;
            const node = this.elements[i];
            const firstNode = i === 0;
            const lastNode = i === this.elements.length - 1;
            const nextNode = lastNode ? void 0 : this.elements[i + 1];
            node.parseText(this.remainingText);
            this.remainingText = node.remainingText;
            const moreText = this.remainingText.length > 0;
            if (node.isDone()) {
              if (lastNode) {
                this.status = status_enums_1.ParseStatus.valid;
                this._done = true;
                continueLoop = false;
              } else {
                this.status = status_enums_1.ParseStatus.incomplete;
                this.activeNodeForSymbolCompl = nextNode.getActiveNode();
                continueLoop = true;
              }
            } else if (node.isValid()) {
              if (moreText) {
                if (lastNode) {
                  this.status = status_enums_1.ParseStatus.valid;
                  this._done = true;
                  continueLoop = false;
                } else {
                  this.activeNodeForSymbolCompl = nextNode.getActiveNode();
                  continueLoop = true;
                }
              } else {
                if (node.matchedText.length > 0 || firstNode) {
                  this.activeNodeForSymbolCompl = node.getActiveNode();
                }
                this.status = status_enums_1.ParseStatus.valid;
                continueLoop = !lastNode;
              }
            } else if (node.isIncomplete()) {
              continueLoop = false;
              if (moreText) {
                this.status = status_enums_1.ParseStatus.invalid;
              } else {
                this.status = status_enums_1.ParseStatus.incomplete;
                this.activeNodeForSymbolCompl = node.getActiveNode();
              }
            } else if (node.isEmpty()) {
              if (firstNode) {
                this.status = status_enums_1.ParseStatus.empty;
                this.activeNodeForSymbolCompl = node.getActiveNode();
              } else {
                this.status = status_enums_1.ParseStatus.incomplete;
              }
              continueLoop = false;
            } else if (node.isInvalid()) {
              this.status = status_enums_1.ParseStatus.invalid;
              continueLoop = false;
            }
          }
          if (this.isInvalid() || this.isEmpty()) {
            this.remainingText = text;
            this.elements = [];
          } else {
            this.matchedText = text.substring(0, text.length - this.remainingText.length);
          }
        }
        renderAsHtml() {
          return this.elements.reduce((result, current) => result + current.renderAsHtml(), "");
        }
        renderAsSource() {
          return this.elements.reduce((result, current) => result + current.renderAsSource(), "");
        }
        getSyntaxCompletionAsHtml() {
          const c = this.elements.length > 0 ? this.elements.reduce((result, current) => `${result}${current.getSyntaxCompletionAsHtml()}`, "") : super.getSyntaxCompletionAsHtml();
          return c;
        }
      };
      exports.AbstractSequence = AbstractSequence;
    }
  });

  // out/src/ide/frames/symbols.js
  var require_symbols = __commonJS({
    "out/src/ide/frames/symbols.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SINGLE_QUOTE = exports.DOUBLE_QUOTES = exports.UNDERSCORE = exports.GE = exports.LE = exports.GT = exports.LT = exports.POWER = exports.DIVIDE = exports.MULT = exports.MINUS = exports.PLUS = exports.COLON = exports.COMMA = exports.DOT = exports.DOUBLE_DOT = exports.CLOSE_BRACKET = exports.OPEN_BRACKET = exports.CLOSE_SQ_BRACKET = exports.OPEN_SQ_BRACKET = exports.CLOSE_BRACE = exports.OPEN_BRACE = exports.ARROW = exports.EQUALS = void 0;
      exports.EQUALS = "=";
      exports.ARROW = "=>";
      exports.OPEN_BRACE = "{";
      exports.CLOSE_BRACE = "}";
      exports.OPEN_SQ_BRACKET = "[";
      exports.CLOSE_SQ_BRACKET = "]";
      exports.OPEN_BRACKET = "(";
      exports.CLOSE_BRACKET = ")";
      exports.DOUBLE_DOT = "..";
      exports.DOT = ".";
      exports.COMMA = ",";
      exports.COLON = ":";
      exports.PLUS = "+";
      exports.MINUS = "-";
      exports.MULT = "*";
      exports.DIVIDE = "/";
      exports.POWER = "^";
      exports.LT = "<";
      exports.GT = ">";
      exports.LE = "<=";
      exports.GE = ">=";
      exports.UNDERSCORE = "_";
      exports.DOUBLE_QUOTES = `"`;
      exports.SINGLE_QUOTE = `'`;
    }
  });

  // out/src/ide/frames/parse-nodes/comma-node.js
  var require_comma_node = __commonJS({
    "out/src/ide/frames/parse-nodes/comma-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CommaNode = void 0;
      var symbols_1 = require_symbols();
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var CommaNode = class extends abstract_parse_node_1.AbstractParseNode {
        parseText(text) {
          const trim = text.trimStart();
          if (trim.length > 0) {
            if (trim.startsWith(symbols_1.COMMA)) {
              this.status = status_enums_1.ParseStatus.valid;
              this._done = true;
              this.matchedText = symbols_1.COMMA;
              text = trim.slice(1);
            } else {
              this.status = status_enums_1.ParseStatus.invalid;
              this.remainingText = text;
            }
            text = text.trimStart();
            this.remainingText = text;
          }
        }
        renderAsSource() {
          return this.matchedText + " ";
        }
      };
      exports.CommaNode = CommaNode;
    }
  });

  // out/src/ide/frames/parse-nodes/multiple.js
  var require_multiple = __commonJS({
    "out/src/ide/frames/parse-nodes/multiple.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Multiple = void 0;
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var Multiple = class extends abstract_parse_node_1.AbstractParseNode {
        elementConstructor;
        minimum;
        elements = [];
        constructor(elementConstructor, minimum) {
          super();
          this.elementConstructor = elementConstructor;
          this.minimum = minimum;
        }
        getElements() {
          return this.elements;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length === 0) {
            this.status = this.minimum === 0 ? status_enums_1.ParseStatus.valid : status_enums_1.ParseStatus.empty;
          } else {
            let toParse = text;
            let cont = true;
            while (cont && toParse.length > 0) {
              const node = this.elementConstructor();
              node.parseText(toParse);
              if (node.status === status_enums_1.ParseStatus.valid) {
                this.elements.push(node);
                toParse = node.remainingText;
                this.activeNodeForSymbolCompl = node.getActiveNode();
              } else if (node.status === status_enums_1.ParseStatus.incomplete && node.remainingText.trim() === "") {
                this.elements.push(node);
                toParse = node.remainingText;
                this.activeNodeForSymbolCompl = node.getActiveNode();
              } else {
                cont = false;
              }
              if (this.elements.length === 0 && this.minimum === 0) {
                this.status = status_enums_1.ParseStatus.valid;
                this.remainingText = toParse;
              } else if (this.elements.length >= this.minimum) {
                const last = this.elements[this.elements.length - 1];
                this.status = last.status;
                const matchedLength = text.length - toParse.length;
                this.matchedText = text.substring(0, matchedLength);
                this.remainingText = toParse;
              } else {
                this.status = status_enums_1.ParseStatus.invalid;
                this.remainingText = text;
              }
            }
          }
        }
        renderAsHtml() {
          return this.elements.reduce((result, current) => result + current.renderAsHtml(), "");
        }
        renderAsSource() {
          return this.elements.reduce((result, current) => result + current.renderAsSource(), "");
        }
        getSyntaxCompletionAsHtml() {
          return this.elements.reduce((result, current) => `${result}${current.getSyntaxCompletionAsHtml()}`, "");
        }
        getActiveNode() {
          const n = this.elements.length;
          return n > 0 ? this.elements[n - 1].getActiveNode() : this;
        }
      };
      exports.Multiple = Multiple;
    }
  });

  // out/src/ide/frames/parse-nodes/optional-node.js
  var require_optional_node = __commonJS({
    "out/src/ide/frames/parse-nodes/optional-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.OptionalNode = void 0;
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var OptionalNode = class extends abstract_parse_node_1.AbstractParseNode {
        option;
        matchedNode;
        constructor(option) {
          super();
          this.option = option;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            const option = this.option;
            option.parseText(text);
            if (option.status === status_enums_1.ParseStatus.valid || option.status === status_enums_1.ParseStatus.incomplete && option.remainingText.trim() === "") {
              this._done = option.isDone();
              this.updateFrom(option);
              this.matchedNode = option;
            } else {
              this.status = status_enums_1.ParseStatus.valid;
              this.remainingText = text;
              this._done = true;
            }
          } else {
            this.status = status_enums_1.ParseStatus.valid;
          }
        }
        renderAsHtml() {
          return this.matchedNode ? this.matchedNode.renderAsHtml() : "";
        }
        renderAsSource() {
          return this.matchedNode ? this.matchedNode.renderAsSource() : "";
        }
        getSyntaxCompletionAsHtml() {
          const c = this.matchedNode ? this.matchedNode.getSyntaxCompletionAsHtml() : super.getSyntaxCompletionAsHtml();
          return c;
        }
        getActiveNode() {
          return this.matchedNode ? this.matchedNode.getActiveNode() : this;
        }
        symbolCompletion_tokenTypes() {
          return this.option.symbolCompletion_tokenTypes();
        }
        symbolCompletion_keywords() {
          return this.option.symbolCompletion_keywords();
        }
      };
      exports.OptionalNode = OptionalNode;
    }
  });

  // out/src/ide/frames/parse-nodes/sequence.js
  var require_sequence = __commonJS({
    "out/src/ide/frames/parse-nodes/sequence.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Sequence = void 0;
      var abstract_sequence_1 = require_abstract_sequence();
      var Sequence = class extends abstract_sequence_1.AbstractSequence {
        elementConstructors;
        constructor(elementConstructors) {
          super();
          this.elementConstructors = elementConstructors;
        }
        parseText(text) {
          if (text.length > 0) {
            this.elementConstructors.forEach((ec) => {
              this.addElement(ec());
            });
          }
          super.parseText(text);
        }
      };
      exports.Sequence = Sequence;
    }
  });

  // out/src/ide/frames/parse-nodes/csv.js
  var require_csv = __commonJS({
    "out/src/ide/frames/parse-nodes/csv.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CSV = void 0;
      var abstract_sequence_1 = require_abstract_sequence();
      var comma_node_1 = require_comma_node();
      var multiple_1 = require_multiple();
      var optional_node_1 = require_optional_node();
      var sequence_1 = require_sequence();
      var CSV = class extends abstract_sequence_1.AbstractSequence {
        elementConstructor;
        minimum;
        constructor(elementConstructor, minimum) {
          super();
          this.elementConstructor = elementConstructor;
          this.minimum = minimum;
        }
        parseText(text) {
          this.remainingText = text;
          let commaNodesMin = 0;
          const commaNode = () => new sequence_1.Sequence([() => new comma_node_1.CommaNode(), this.elementConstructor]);
          if (this.minimum === 0) {
            this.addElement(new optional_node_1.OptionalNode(this.elementConstructor()));
          } else {
            this.addElement(this.elementConstructor());
            commaNodesMin = this.minimum - 1;
          }
          this.addElement(new multiple_1.Multiple(commaNode, commaNodesMin));
          super.parseText(text);
        }
        getSyntaxCompletionAsHtml() {
          let comp = super.getSyntaxCompletionAsHtml();
          if (this.minimum > 0 && this.matchedText.length === 0) {
            const el = this.elementConstructor();
            comp = el.getSyntaxCompletionAsHtml();
          }
          return comp;
        }
      };
      exports.CSV = CSV;
    }
  });

  // out/src/ide/frames/parse-nodes/fixed-text-node.js
  var require_fixed_text_node = __commonJS({
    "out/src/ide/frames/parse-nodes/fixed-text-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FixedTextNode = void 0;
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var FixedTextNode = class extends abstract_parse_node_1.AbstractParseNode {
        fixedText;
        constructor(fixedText) {
          super();
          this.fixedText = fixedText;
          this.completionWhenEmpty = fixedText;
        }
        getErrorMessage() {
          return `must match ${this.fixedText}`;
        }
        getSyntaxCompletionAsHtml() {
          return this.status === status_enums_1.ParseStatus.empty ? `${this.fixedText}` : "";
        }
      };
      exports.FixedTextNode = FixedTextNode;
    }
  });

  // out/src/ide/frames/parse-nodes/keyword-node.js
  var require_keyword_node = __commonJS({
    "out/src/ide/frames/parse-nodes/keyword-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.KeywordNode = void 0;
      var keywords_1 = require_keywords();
      var status_enums_1 = require_status_enums();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var fixed_text_node_1 = require_fixed_text_node();
      var KeywordNode = class extends fixed_text_node_1.FixedTextNode {
        spaceAfter;
        dotAfter;
        constructor(keyword, spaceAfter = false, dotAfter = false) {
          super(keyword);
          this.spaceAfter = spaceAfter;
          this.dotAfter = dotAfter;
          this.completionWhenEmpty = keyword;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            const target = this.fixedText;
            const trimmed = text.trimStart();
            const lcLetters = trimmed.match(/^[a-z]*/);
            if (lcLetters && lcLetters.length === 1) {
              if (lcLetters[0] === target) {
                const n = this.numLeadingSpaces(text) + this.fixedText.length;
                this.set(status_enums_1.ParseStatus.valid, text.substring(0, n), text.substring(n));
                this._done = true;
              } else if (target.startsWith(trimmed)) {
                this.set(status_enums_1.ParseStatus.incomplete, text, "");
              } else {
                this.set(status_enums_1.ParseStatus.invalid, "", text);
              }
            }
          }
        }
        getSyntaxCompletionAsHtml() {
          let comp = ``;
          const matched = this.matchedText.length;
          const kw = this.fixedText.length;
          if (matched === 0) {
            comp = `${this.fixedText}`;
          } else if (matched === kw && this.remainingText === "") {
            comp = ``;
          } else if (matched < kw) {
            comp = `${this.fixedText.substring(this.matchedText.length)}`;
          }
          return comp;
        }
        renderAsHtml() {
          return `<el-kw>${this.renderAsSource()}</el-kw>`;
        }
        renderAsSource() {
          return this.matchedText.trim();
        }
        compile() {
          switch (this.fixedText) {
            case keywords_1.isKeyword:
              return "===";
            case `${keywords_1.isKeyword} ${keywords_1.notKeyword}`:
              return "!==";
            case keywords_1.notKeyword:
              return "!";
            case keywords_1.andKeyword:
              return "&&";
            case keywords_1.orKeyword:
              return "||";
            default:
              return this.matchedText;
          }
        }
        symbolCompletion_keywords() {
          return /* @__PURE__ */ new Set([
            symbol_completion_helpers_1.KeywordCompletion.create(this.fixedText, this.spaceAfter, this.dotAfter)
          ]);
        }
      };
      exports.KeywordNode = KeywordNode;
    }
  });

  // out/src/ide/frames/parse-nodes/abstract-alternatives.js
  var require_abstract_alternatives = __commonJS({
    "out/src/ide/frames/parse-nodes/abstract-alternatives.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractAlternatives = void 0;
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var AbstractAlternatives = class extends abstract_parse_node_1.AbstractParseNode {
        alternatives = [];
        bestMatch;
        constructor() {
          super();
        }
        parseText(text) {
          this.remainingText = text;
          if (this.remainingText.length > 0) {
            let open = true;
            let i = 0;
            while (i < this.alternatives.length) {
              const alt = this.alternatives[i];
              alt.parseText(text);
              if (open) {
                if (alt.isValid() && alt.remainingText.length === 0) {
                  this.bestMatch = alt;
                  open = false;
                  this._done = alt.isDone();
                } else if (!this.bestMatch || alt.remainingText.length < this.bestMatch.remainingText.length || alt.remainingText.length === this.bestMatch.remainingText.length && alt.status > this.bestMatch.status) {
                  this.bestMatch = alt;
                }
              }
              i++;
            }
            if (this.bestMatch.status > status_enums_1.ParseStatus.invalid) {
              this.status = this.bestMatch.status;
              this.matchedText = this.bestMatch.matchedText;
              this.remainingText = this.bestMatch.remainingText;
              this.alternatives = this.alternatives.filter((alt) => alt.status > status_enums_1.ParseStatus.invalid);
            } else {
              this.bestMatch = void 0;
              this.status = status_enums_1.ParseStatus.invalid;
              this.alternatives = [];
            }
          }
          if (this.isDone()) {
            this.alternatives = [];
          }
        }
        renderAsHtml() {
          return this.bestMatch ? this.bestMatch.renderAsHtml() : "";
        }
        renderAsSource() {
          return this.bestMatch ? this.bestMatch.renderAsSource() : "";
        }
        getSyntaxCompletionAsHtml() {
          const c = this.bestMatch ? this.bestMatch.getSyntaxCompletionAsHtml() : super.getSyntaxCompletionAsHtml();
          return c;
        }
        getActiveNode() {
          if (this.bestMatchIsOnlyMatch()) {
            return this.bestMatch.getActiveNode();
          } else {
            return this;
          }
        }
        bestMatchIsOnlyMatch() {
          return this.potentialMatches().length === 1;
        }
        potentialMatches() {
          const best = this.bestMatch;
          const bestMatchLength = best ? best.matchedText.length : 0;
          return this.alternatives.filter((alt) => alt.status !== status_enums_1.ParseStatus.invalid && alt.matchedText.length === bestMatchLength);
        }
        symbolCompletion_tokenTypes() {
          return this.potentialMatches().reduce((prev, m) => prev.union(m.symbolCompletion_tokenTypes()), /* @__PURE__ */ new Set());
        }
        symbolCompletion_keywords() {
          return this.potentialMatches().reduce((prev, m) => prev.union(m.symbolCompletion_keywords()), /* @__PURE__ */ new Set());
        }
      };
      exports.AbstractAlternatives = AbstractAlternatives;
    }
  });

  // out/src/ide/frames/parse-nodes/punctuation-node.js
  var require_punctuation_node = __commonJS({
    "out/src/ide/frames/parse-nodes/punctuation-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.PunctuationNode = void 0;
      var frame_helpers_1 = require_frame_helpers();
      var status_enums_1 = require_status_enums();
      var fixed_text_node_1 = require_fixed_text_node();
      var PunctuationNode = class extends fixed_text_node_1.FixedTextNode {
        constructor(symbol) {
          super(symbol);
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            const target = this.fixedText;
            if (text.startsWith(target)) {
              const n = this.numLeadingSpaces(text) + this.fixedText.length;
              this.set(status_enums_1.ParseStatus.valid, text.substring(0, n), text.substring(n));
              this._done = true;
            } else if (target.startsWith(text)) {
              this.set(status_enums_1.ParseStatus.incomplete, text, "");
            } else {
              this.set(status_enums_1.ParseStatus.invalid, "", text);
            }
          }
        }
        renderAsHtml() {
          return (0, frame_helpers_1.escapeHtmlChars)(this.renderAsSource());
        }
        getSyntaxCompletionAsHtml() {
          let comp = ``;
          const matched = this.matchedText.length;
          const kw = this.fixedText.length;
          if (matched === 0) {
            comp = `${this.fixedText}`;
          } else if (matched === kw && this.remainingText === "") {
            comp = ``;
          } else if (matched < kw) {
            comp = `${this.fixedText.substring(this.matchedText.length)}`;
          }
          return comp;
        }
      };
      exports.PunctuationNode = PunctuationNode;
    }
  });

  // out/src/ide/frames/parse-nodes/regex-match-node.js
  var require_regex_match_node = __commonJS({
    "out/src/ide/frames/parse-nodes/regex-match-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.RegExMatchNode = void 0;
      var abstract_parse_node_1 = require_abstract_parse_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var RegExMatchNode = class extends abstract_parse_node_1.AbstractParseNode {
        regx;
        constructor(regx) {
          super();
          this.regx = regx;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            [this.status, this.matchedText, this.remainingText] = (0, parse_node_helpers_1.matchRegEx)(text, this.regx);
          }
        }
        renderAsSource() {
          return this.matchedText;
        }
      };
      exports.RegExMatchNode = RegExMatchNode;
    }
  });

  // out/src/ide/frames/parse-nodes/type-specific-func-node.js
  var require_type_specific_func_node = __commonJS({
    "out/src/ide/frames/parse-nodes/type-specific-func-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeSpecificFuncNode = void 0;
      var regex_match_node_1 = require_regex_match_node();
      var TypeSpecificFuncNode = class extends regex_match_node_1.RegExMatchNode {
        constructor() {
          super(/^\s*Func/);
          this.completionWhenEmpty = "<i>Func</i>";
        }
        renderAsHtml() {
          return `<el-type>${this.renderAsSource()}</el-type>`;
        }
        symbolCompletion_tokenTypes() {
          return /* @__PURE__ */ new Set();
        }
      };
      exports.TypeSpecificFuncNode = TypeSpecificFuncNode;
    }
  });

  // out/src/ide/frames/parse-nodes/type-func-node.js
  var require_type_func_node = __commonJS({
    "out/src/ide/frames/parse-nodes/type-func-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeFuncNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var sequence_1 = require_sequence();
      var space_node_1 = require_space_node();
      var type_node_1 = require_type_node();
      var type_specific_func_node_1 = require_type_specific_func_node();
      var TypeFuncNode = class extends abstract_sequence_1.AbstractSequence {
        inputTypes;
        returnType;
        tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.type_concrete,
          symbol_completion_helpers_1.TokenType.type_abstract,
          symbol_completion_helpers_1.TokenType.type_notInheritable
        ]);
        constructor() {
          super();
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.addElement(new type_specific_func_node_1.TypeSpecificFuncNode());
            this.addElement(new punctuation_node_1.PunctuationNode("<"));
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.ofKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            const inputTypes = () => new csv_1.CSV(() => new type_node_1.TypeNode(this.tokenTypes), 1);
            const sp = () => new space_node_1.SpaceNode(parse_node_helpers_1.Space.required);
            const inputTypesSp = new sequence_1.Sequence([inputTypes, sp]);
            this.inputTypes = new optional_node_1.OptionalNode(inputTypesSp);
            this.inputTypes.setSyntaxCompletionWhenEmpty("<i>InputType(s) </i>");
            this.addElement(this.inputTypes);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.ARROW));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.returnType = new type_node_1.TypeNode(this.tokenTypes);
            this.returnType.setSyntaxCompletionWhenEmpty("<i>ReturnType</i>");
            this.addElement(this.returnType);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.GT));
            super.parseText(text.trimStart());
          }
        }
        getSyntaxCompletionAsHtml() {
          return super.getSyntaxCompletionAsHtml();
        }
      };
      exports.TypeFuncNode = TypeFuncNode;
    }
  });

  // out/src/ide/frames/parse-nodes/dot-after.js
  var require_dot_after = __commonJS({
    "out/src/ide/frames/parse-nodes/dot-after.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DotAfter = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var punctuation_node_1 = require_punctuation_node();
      var DotAfter = class extends abstract_sequence_1.AbstractSequence {
        node;
        constructor(node) {
          super();
          this.node = node;
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(this.node);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOT));
            super.parseText(text);
          }
        }
      };
      exports.DotAfter = DotAfter;
    }
  });

  // out/src/ide/frames/parse-nodes/type-simple-name.js
  var require_type_simple_name = __commonJS({
    "out/src/ide/frames/parse-nodes/type-simple-name.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeSimpleName = void 0;
      var regexes_1 = require_regexes();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var regex_match_node_1 = require_regex_match_node();
      var TypeSimpleName = class extends regex_match_node_1.RegExMatchNode {
        tokenTypes = /* @__PURE__ */ new Set();
        constructor(tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.type_abstract,
          symbol_completion_helpers_1.TokenType.type_concrete,
          symbol_completion_helpers_1.TokenType.type_notInheritable,
          symbol_completion_helpers_1.TokenType.type_enum
        ])) {
          super(regexes_1.Regexes.typeSimpleName);
          this.completionWhenEmpty = "<i>Type</i>";
          this.tokenTypes = tokenTypes;
        }
        renderAsHtml() {
          return `<el-type>${this.renderAsSource()}</el-type>`;
        }
        symbolCompletion_tokenTypes() {
          return this.tokenTypes;
        }
      };
      exports.TypeSimpleName = TypeSimpleName;
    }
  });

  // out/src/ide/frames/parse-nodes/type-name-node.js
  var require_type_name_node = __commonJS({
    "out/src/ide/frames/parse-nodes/type-name-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeNameNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var dot_after_1 = require_dot_after();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var type_simple_name_1 = require_type_simple_name();
      var TypeNameNode = class extends abstract_sequence_1.AbstractSequence {
        tokenTypes = /* @__PURE__ */ new Set();
        name;
        libraryQualifier;
        constructor(tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.type_abstract,
          symbol_completion_helpers_1.TokenType.type_concrete,
          symbol_completion_helpers_1.TokenType.type_notInheritable,
          symbol_completion_helpers_1.TokenType.type_enum
        ])) {
          super();
          this.completionWhenEmpty = "<i>Type</i>";
          this.tokenTypes = tokenTypes;
        }
        parseText(text) {
          if (text.length > 0) {
            this.libraryQualifier = new optional_node_1.OptionalNode(new dot_after_1.DotAfter(new keyword_node_1.KeywordNode(keywords_1.libraryKeyword, false, true)));
            this.addElement(this.libraryQualifier);
            this.name = new type_simple_name_1.TypeSimpleName();
            this.addElement(this.name);
            super.parseText(text);
          }
        }
        renderAsHtml() {
          const qualifier = this.libraryQualifier?.matchedNode ? `<el-kw>${keywords_1.libraryKeyword}</el-kw>.` : ``;
          return `${qualifier}<el-type>${this.name?.renderAsSource()}</el-type>`;
        }
        symbolCompletion_tokenTypes() {
          return this.tokenTypes;
        }
      };
      exports.TypeNameNode = TypeNameNode;
    }
  });

  // out/src/ide/frames/parse-nodes/type-generic-node.js
  var require_type_generic_node = __commonJS({
    "out/src/ide/frames/parse-nodes/type-generic-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeGenericNode = void 0;
      var keywords_1 = require_keywords();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var comma_node_1 = require_comma_node();
      var keyword_node_1 = require_keyword_node();
      var multiple_1 = require_multiple();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var sequence_1 = require_sequence();
      var space_node_1 = require_space_node();
      var type_name_node_1 = require_type_name_node();
      var type_node_1 = require_type_node();
      var TypeGenericNode = class extends abstract_sequence_1.AbstractSequence {
        simpleType;
        generic;
        tokenTypes = /* @__PURE__ */ new Set();
        concreteAndAbstract = new Set(parse_node_helpers_1.concreteAndAbstractTypes);
        constructor(tokenTypes) {
          super();
          this.tokenTypes = tokenTypes;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.simpleType = new type_name_node_1.TypeNameNode(this.tokenTypes);
            const lt = () => new punctuation_node_1.PunctuationNode(symbols_1.LT);
            const of = () => new keyword_node_1.KeywordNode(keywords_1.ofKeyword);
            const sp = () => new space_node_1.SpaceNode(parse_node_helpers_1.Space.required);
            const type = () => new type_node_1.TypeNode(this.concreteAndAbstract);
            const commaType = () => new sequence_1.Sequence([() => new comma_node_1.CommaNode(), () => new type_node_1.TypeNode(this.concreteAndAbstract)]);
            const commaTypes = () => new multiple_1.Multiple(commaType, 0);
            const gt = () => new punctuation_node_1.PunctuationNode(symbols_1.GT);
            this.generic = new sequence_1.Sequence([lt, of, sp, type, commaTypes, gt]);
            this.addElement(this.simpleType);
            this.addElement(this.generic);
            super.parseText(text);
          }
        }
        symbolCompletion_tokenTypes() {
          if (this.getElements().length === 0) {
            return this.concreteAndAbstract;
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
      };
      exports.TypeGenericNode = TypeGenericNode;
    }
  });

  // out/src/ide/frames/parse-nodes/type-tuple-node.js
  var require_type_tuple_node = __commonJS({
    "out/src/ide/frames/parse-nodes/type-tuple-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeTupleNode = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var punctuation_node_1 = require_punctuation_node();
      var type_node_1 = require_type_node();
      var TypeTupleNode = class extends abstract_sequence_1.AbstractSequence {
        types;
        parseText(text) {
          if (text.length > 0) {
            this.types = new csv_1.CSV(() => new type_node_1.TypeNode(/* @__PURE__ */ new Set([
              symbol_completion_helpers_1.TokenType.type_concrete,
              symbol_completion_helpers_1.TokenType.type_abstract,
              symbol_completion_helpers_1.TokenType.type_notInheritable
            ])), 2);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACKET));
            this.addElement(this.types);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACKET));
            super.parseText(text);
          }
        }
      };
      exports.TypeTupleNode = TypeTupleNode;
    }
  });

  // out/src/ide/frames/parse-nodes/type-node.js
  var require_type_node = __commonJS({
    "out/src/ide/frames/parse-nodes/type-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeNode = void 0;
      var symbols_1 = require_symbols();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var type_func_node_1 = require_type_func_node();
      var type_generic_node_1 = require_type_generic_node();
      var type_name_node_1 = require_type_name_node();
      var type_tuple_node_1 = require_type_tuple_node();
      var TypeNode = class extends abstract_alternatives_1.AbstractAlternatives {
        tokenTypes = /* @__PURE__ */ new Set();
        constructor(tokenTypes = /* @__PURE__ */ new Set()) {
          super();
          this.completionWhenEmpty = "<i>Type</i>";
          this.tokenTypes = tokenTypes;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            if (text.trimStart().startsWith("Func")) {
              this.alternatives.push(new type_func_node_1.TypeFuncNode());
            } else if (text.trimStart().startsWith(symbols_1.OPEN_BRACKET)) {
              this.alternatives.push(new type_tuple_node_1.TypeTupleNode());
            } else {
              this.alternatives.push(new type_name_node_1.TypeNameNode(this.tokenTypes));
              this.alternatives.push(new type_generic_node_1.TypeGenericNode(this.tokenTypes));
            }
            super.parseText(text.trimStart());
          }
        }
        symbolCompletion_tokenTypes() {
          return this.matchedText.length === 0 ? this.tokenTypes : super.symbolCompletion_tokenTypes();
        }
      };
      exports.TypeNode = TypeNode;
    }
  });

  // out/src/ide/frames/parse-nodes/param-def-node.js
  var require_param_def_node = __commonJS({
    "out/src/ide/frames/parse-nodes/param-def-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ParamDefNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var identifier_node_1 = require_identifier_node();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var sequence_1 = require_sequence();
      var space_node_1 = require_space_node();
      var type_node_1 = require_type_node();
      var ParamDefNode = class extends abstract_sequence_1.AbstractSequence {
        name;
        type;
        out;
        outPermitted;
        constructor(outPermitted) {
          super();
          this.outPermitted = outPermitted;
          this.completionWhenEmpty = "<i>name</i> as <i>Type</i>";
        }
        parseText(text) {
          if (text.trim().length > 0) {
            const outSpace = new sequence_1.Sequence([
              () => new keyword_node_1.KeywordNode(keywords_1.outKeyword),
              () => new space_node_1.SpaceNode(parse_node_helpers_1.Space.required)
            ]);
            if (this.outPermitted) {
              this.out = new optional_node_1.OptionalNode(outSpace);
              this.addElement(this.out);
            }
            this.name = new identifier_node_1.IdentifierNode();
            this.addElement(this.name);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.asKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.type = new type_node_1.TypeNode(/* @__PURE__ */ new Set([
              symbol_completion_helpers_1.TokenType.type_concrete,
              symbol_completion_helpers_1.TokenType.type_abstract,
              symbol_completion_helpers_1.TokenType.type_notInheritable
            ]));
            this.addElement(this.type);
            super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? this.outPermitted ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.outKeyword)]) : /* @__PURE__ */ new Set([]) : super.symbolCompletion_keywords();
        }
      };
      exports.ParamDefNode = ParamDefNode;
    }
  });

  // out/src/ide/frames/parse-nodes/param-list-node.js
  var require_param_list_node = __commonJS({
    "out/src/ide/frames/parse-nodes/param-list-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ParamListNode = void 0;
      var csv_1 = require_csv();
      var param_def_node_1 = require_param_def_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var ParamListNode = class extends csv_1.CSV {
        outPermitted;
        constructor(outPermitted) {
          super(() => new param_def_node_1.ParamDefNode(outPermitted), 0);
          this.outPermitted = outPermitted;
          this.setSyntaxCompletionWhenEmpty("<i>parameter definitions</i>");
        }
        parseText(text) {
          text = (0, parse_node_helpers_1.removeUnmatchedClosingBracket)(text);
          super.parseText(text);
        }
      };
      exports.ParamListNode = ParamListNode;
    }
  });

  // out/src/ide/frames/fields/param-list-field.js
  var require_param_list_field = __commonJS({
    "out/src/ide/frames/fields/param-list-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ParamListField = void 0;
      var param_list_node_1 = require_param_list_node();
      var abstract_field_1 = require_abstract_field();
      var ParamListField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        outPermitted;
        constructor(holder, outPermitted) {
          super(holder);
          this.outPermitted = outPermitted;
          this.setPlaceholder("<i>parameter definitions</i>");
          this.useHtmlTags = true;
          this.setOptional(true);
        }
        helpId() {
          return "ParamListField";
        }
        getIdPrefix() {
          return "params";
        }
        contentAsSource() {
          if (this.text) {
            return this.text;
          } else {
            return "";
          }
        }
        initialiseRoot() {
          this.rootNode = new param_list_node_1.ParamListNode(this.outPermitted);
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToNonMatchingCloseBracket();
        isEndMarker(key) {
          return this.text === "" && key === ")";
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.ParamListField = ParamListField;
    }
  });

  // out/src/ide/frames/fields/type-field.js
  var require_type_field = __commonJS({
    "out/src/ide/frames/fields/type-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeField = void 0;
      var type_node_1 = require_type_node();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_field_1 = require_abstract_field();
      var TypeField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.useHtmlTags = true;
          this.placeholder = "<i>Type</i>";
        }
        helpId() {
          return "TypeField";
        }
        getIdPrefix() {
          return "type";
        }
        initialiseRoot() {
          this.rootNode = new type_node_1.TypeNode(/* @__PURE__ */ new Set([
            symbol_completion_helpers_1.TokenType.type_concrete,
            symbol_completion_helpers_1.TokenType.type_abstract,
            symbol_completion_helpers_1.TokenType.type_notInheritable
          ]));
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToEndOfLine();
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.TypeField = TypeField;
    }
  });

  // out/src/ide/frames/class-members/abstract-function.js
  var require_abstract_function = __commonJS({
    "out/src/ide/frames/class-members/abstract-function.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractFunction = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var identifier_field_1 = require_identifier_field();
      var param_list_field_1 = require_param_list_field();
      var type_field_1 = require_type_field();
      var frame_helpers_1 = require_frame_helpers();
      var AbstractFunction = class extends abstract_frame_1.AbstractFrame {
        isAbstract = true;
        isMember = true;
        private = false;
        name;
        params;
        returnType;
        hrefForFrameHelp = "LangRef.html#Abstract_function";
        constructor(parent) {
          super(parent);
          this.name = new identifier_field_1.IdentifierField(this);
          this.params = new param_list_field_1.ParamListField(this, false);
          this.returnType = new type_field_1.TypeField(this);
          this.canHaveBreakPoint = false;
        }
        initialKeywords() {
          return keywords_1.abstractFunctionKeywords;
        }
        getFields() {
          return [this.name, this.params, this.returnType];
        }
        getIdPrefix() {
          return "func";
        }
        indent() {
          return (0, frame_helpers_1.singleIndent)();
        }
        renderAsHtml() {
          return `<el-func class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-kw>${keywords_1.abstractKeyword} ${keywords_1.functionKeyword} </el-kw><el-method>${this.name.renderAsHtml()}</el-method><el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc><el-kw> ${keywords_1.returnsKeyword} </el-kw>${this.returnType.renderAsHtml()}${this.helpAsHtml()}</el-top>${this.compileMsgAsHtml()}${this.getFrNo()}</el-func>
`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.abstractKeyword} ${keywords_1.functionKeyword} ${this.name.renderAsSource()}(${this.params.renderAsSource()}) ${keywords_1.returnsKeyword} ${this.returnType.renderAsSource()}\r
`;
        }
        parseFrom(source) {
          source.remove(`${keywords_1.abstractKeyword} ${keywords_1.functionKeyword} `);
          this.name.parseFrom(source);
          source.remove("(");
          this.params.parseFrom(source);
          source.remove(`) ${keywords_1.returnsKeyword} `);
          this.returnType.parseFrom(source);
        }
      };
      exports.AbstractFunction = AbstractFunction;
    }
  });

  // out/src/ide/frames/class-members/abstract-procedure.js
  var require_abstract_procedure = __commonJS({
    "out/src/ide/frames/class-members/abstract-procedure.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractProcedure = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var identifier_field_1 = require_identifier_field();
      var param_list_field_1 = require_param_list_field();
      var frame_helpers_1 = require_frame_helpers();
      var AbstractProcedure = class extends abstract_frame_1.AbstractFrame {
        isAbstract = true;
        isMember = true;
        private = false;
        name;
        params;
        constructor(parent) {
          super(parent);
          this.name = new identifier_field_1.IdentifierField(this);
          this.params = new param_list_field_1.ParamListField(this, true);
          this.canHaveBreakPoint = false;
        }
        initialKeywords() {
          return keywords_1.abstractProcedureKeywords;
        }
        getFields() {
          return [this.name, this.params];
        }
        getIdPrefix() {
          return "proc";
        }
        indent() {
          return (0, frame_helpers_1.singleIndent)();
        }
        renderAsHtml() {
          return `<el-proc class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-kw>abstract procedure </el-kw><el-method>${this.name.renderAsHtml()}</el-method><el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc>${this.helpAsHtml()}</el-top>${this.compileMsgAsHtml()}${this.getFrNo()}</el-proc>
`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}abstract procedure ${this.name.renderAsSource()}(${this.params.renderAsSource()})\r
`;
        }
        parseFrom(source) {
          source.remove("abstract procedure ");
          this.name.parseFrom(source);
          source.remove("(");
          this.params.parseFrom(source);
          source.remove(")");
        }
      };
      exports.AbstractProcedure = AbstractProcedure;
    }
  });

  // out/src/ide/frames/class-members/abstract-property.js
  var require_abstract_property = __commonJS({
    "out/src/ide/frames/class-members/abstract-property.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractProperty = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var identifier_field_1 = require_identifier_field();
      var type_field_1 = require_type_field();
      var AbstractProperty = class extends abstract_frame_1.AbstractFrame {
        isAbstract = true;
        isMember = true;
        name;
        type;
        private = false;
        constructor(parent) {
          super(parent);
          this.name = new identifier_field_1.IdentifierField(this);
          this.type = new type_field_1.TypeField(this);
          this.canHaveBreakPoint = false;
        }
        getClass() {
          return this.getParent();
        }
        initialKeywords() {
          return keywords_1.abstractPropertyKeywords;
        }
        getFields() {
          return [this.name, this.type];
        }
        getIdPrefix() {
          return "prop";
        }
        renderAsHtml() {
          return `<el-prop class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}><el-top>${this.contextMenu()}${this.bpAsHtml()}<el-kw>${keywords_1.abstractKeyword} ${keywords_1.propertyKeyword} </el-kw>${this.name.renderAsHtml()}<el-kw> ${keywords_1.asKeyword} </el-kw>${this.type.renderAsHtml()}${this.helpAsHtml()}</el-top>${this.compileMsgAsHtml()}${this.getFrNo()}</el-prop>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.abstractKeyword} ${keywords_1.propertyKeyword} ${this.name.renderAsSource()} ${keywords_1.asKeyword} ${this.type.renderAsSource()}\r
`;
        }
        parseFrom(source) {
          source.remove("abstract property ");
          this.name.parseFrom(source);
          source.remove(" as ");
          this.type.parseFrom(source);
        }
      };
      exports.AbstractProperty = AbstractProperty;
    }
  });

  // out/src/ide/frames/parse-nodes/binary-operation.js
  var require_binary_operation = __commonJS({
    "out/src/ide/frames/parse-nodes/binary-operation.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BinaryOperation = void 0;
      var keywords_1 = require_keywords();
      var status_enums_1 = require_status_enums();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var BinaryOperation = class extends abstract_parse_node_1.AbstractParseNode {
        constructor() {
          super();
          this.completionWhenEmpty = "<i>operator </i>";
        }
        keyword = false;
        closePacked = false;
        completion = "";
        parseText(text) {
          this.remainingText = text;
          if (this.remainingText.length > 0) {
            while (this.nextChar() === " ") {
              this.moveCharsToMatched(1, status_enums_1.ParseStatus.incomplete);
            }
            if (this.nextChar() === symbols_1.GT || this.nextChar() === symbols_1.LT) {
              this.processComparison();
            } else if (this.nextChar() === "i") {
              this.processEquality();
            } else if (this.nextChar() === symbols_1.POWER || this.nextChar() === symbols_1.MULT || this.nextChar() === symbols_1.DIVIDE) {
              this.moveCharsToMatched(1, status_enums_1.ParseStatus.valid);
              this.closePacked = true;
            } else if (this.nextChar() === symbols_1.PLUS || this.nextChar() === symbols_1.MINUS) {
              this.moveCharsToMatched(1, status_enums_1.ParseStatus.valid);
              this._done = true;
            } else {
              this.processKeywords();
            }
            while (this.status === status_enums_1.ParseStatus.valid && this.nextChar() === " ") {
              this.moveCharsToMatched(1, status_enums_1.ParseStatus.valid);
            }
            if (this.remainingText.length > 0 && (this.status === status_enums_1.ParseStatus.empty || this.status === status_enums_1.ParseStatus.incomplete)) {
              this.status = status_enums_1.ParseStatus.invalid;
            }
          }
        }
        nextChar() {
          return this.remainingText.length > 0 ? this.remainingText[0] : "";
        }
        moveCharsToMatched(n, st) {
          this.matchedText = this.matchedText + this.remainingText.slice(0, n);
          this.remainingText = this.remainingText.slice(n);
          this.status = st;
        }
        processComparison() {
          this.moveCharsToMatched(1, status_enums_1.ParseStatus.incomplete);
          if (this.nextChar() === "=") {
            this.moveCharsToMatched(1, status_enums_1.ParseStatus.valid);
            this._done = true;
          } else if (this.remainingText.length === 0) {
            this.status = status_enums_1.ParseStatus.incomplete;
          } else {
            this.status = status_enums_1.ParseStatus.valid;
            this._done = true;
          }
        }
        processEquality() {
          if (this.remainingText.length === 1) {
            this.moveCharsToMatched(1, status_enums_1.ParseStatus.incomplete);
            this.completion = "s";
          } else if (this.remainingText.startsWith("isnt")) {
            this.moveCharsToMatched(4, status_enums_1.ParseStatus.valid);
            this.keyword = true;
            this._done = true;
          } else if (this.remainingText.startsWith("isn")) {
            this.moveCharsToMatched(3, status_enums_1.ParseStatus.incomplete);
            this.completion = "t";
          } else if (this.remainingText.length > 2 && this.remainingText.startsWith("is")) {
            this.moveCharsToMatched(2, status_enums_1.ParseStatus.valid);
            this.keyword = true;
            this._done = true;
          } else if (this.remainingText.startsWith("is")) {
            this.moveCharsToMatched(2, status_enums_1.ParseStatus.incomplete);
          }
        }
        attemptToMatchKw(kw) {
          if (this.remainingText.startsWith(kw)) {
            this.moveCharsToMatched(kw.length, status_enums_1.ParseStatus.valid);
            this.keyword = true;
            this._done = true;
            return true;
          } else if (kw.startsWith(this.remainingText)) {
            this.completion = kw.slice(this.remainingText.length);
            this.moveCharsToMatched(this.remainingText.length, status_enums_1.ParseStatus.incomplete);
            return true;
          }
          return false;
        }
        processKeywords() {
          const keywords = [keywords_1.andKeyword, keywords_1.orKeyword, keywords_1.divKeyword, keywords_1.modKeyword];
          let match = false;
          let i = 0;
          while (!match && i < keywords.length) {
            match = this.attemptToMatchKw(keywords[i]);
            i++;
          }
        }
        renderAsHtml() {
          const open = this.keyword ? "<el-kw>" : "";
          const close = this.keyword ? "</el-kw>" : "";
          return `${open}${this.renderAsSource()}${close}`;
        }
        renderAsSource() {
          let source = "";
          if (this.status === status_enums_1.ParseStatus.valid) {
            const space = this.closePacked ? "" : " ";
            source = `${space}${this.matchedText.trim()}${space}`;
          } else {
            source = this.matchedText;
          }
          return source;
        }
        getSyntaxCompletionAsHtml() {
          let completion = this.completion;
          if (this.matchedText === "" || this.matchedText === " ") {
            completion = "<i>operator </i>";
          }
          return completion;
        }
        symbolCompletion_keywords() {
          let kws = [keywords_1.andKeyword, keywords_1.divKeyword, keywords_1.isKeyword, keywords_1.isntKeyword, keywords_1.modKeyword, keywords_1.orKeyword].map((kw) => symbol_completion_helpers_1.KeywordCompletion.create(kw));
          const trim = this.matchedText.trim();
          if (trim.length > 0) {
            kws = kws.filter((kw) => kw.keyword.startsWith(trim));
          }
          return new Set(kws);
        }
      };
      exports.BinaryOperation = BinaryOperation;
    }
  });

  // out/src/ide/frames/parse-nodes/index-double.js
  var require_index_double = __commonJS({
    "out/src/ide/frames/parse-nodes/index-double.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IndexDouble = void 0;
      var abstract_sequence_1 = require_abstract_sequence();
      var comma_node_1 = require_comma_node();
      var expr_node_1 = require_expr_node();
      var IndexDouble = class extends abstract_sequence_1.AbstractSequence {
        index1;
        index2;
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.index1 = new expr_node_1.ExprNode();
            this.index2 = new expr_node_1.ExprNode();
            this.addElement(this.index1);
            this.addElement(new comma_node_1.CommaNode());
            this.addElement(this.index2);
            super.parseText(text);
          }
        }
      };
      exports.IndexDouble = IndexDouble;
    }
  });

  // out/src/ide/frames/parse-nodes/index-range.js
  var require_index_range = __commonJS({
    "out/src/ide/frames/parse-nodes/index-range.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IndexRange = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var expr_node_1 = require_expr_node();
      var optional_node_1 = require_optional_node();
      var punctuation_node_1 = require_punctuation_node();
      var IndexRange = class extends abstract_sequence_1.AbstractSequence {
        fromIndex;
        toIndex;
        parseText(text) {
          if (text.length > 0) {
            this.fromIndex = new optional_node_1.OptionalNode(new expr_node_1.ExprNode());
            this.toIndex = new optional_node_1.OptionalNode(new expr_node_1.ExprNode());
            this.addElement(this.fromIndex);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOUBLE_DOT));
            this.addElement(this.toIndex);
            return super.parseText(text);
          }
        }
      };
      exports.IndexRange = IndexRange;
    }
  });

  // out/src/ide/frames/parse-nodes/index-value.js
  var require_index_value = __commonJS({
    "out/src/ide/frames/parse-nodes/index-value.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IndexValue = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var expr_node_1 = require_expr_node();
      var index_double_1 = require_index_double();
      var index_range_1 = require_index_range();
      var IndexValue = class extends abstract_alternatives_1.AbstractAlternatives {
        contents;
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.alternatives.push(new expr_node_1.ExprNode());
            this.alternatives.push(new index_double_1.IndexDouble());
            this.alternatives.push(new index_range_1.IndexRange());
            super.parseText(text);
          }
        }
      };
      exports.IndexValue = IndexValue;
    }
  });

  // out/src/ide/frames/parse-nodes/index.js
  var require_parse_nodes = __commonJS({
    "out/src/ide/frames/parse-nodes/index.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Index = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var index_value_1 = require_index_value();
      var punctuation_node_1 = require_punctuation_node();
      var Index = class extends abstract_sequence_1.AbstractSequence {
        contents;
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_SQ_BRACKET));
            this.contents = new index_value_1.IndexValue();
            this.addElement(this.contents);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_SQ_BRACKET));
            super.parseText(text);
          }
        }
      };
      exports.Index = Index;
    }
  });

  // out/src/ide/frames/parse-nodes/alternatives.js
  var require_alternatives = __commonJS({
    "out/src/ide/frames/parse-nodes/alternatives.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Alternatives = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var Alternatives = class extends abstract_alternatives_1.AbstractAlternatives {
        elementConstructors;
        tokenTypes;
        context;
        constructor(elementConstructors, tokenTypes = /* @__PURE__ */ new Set(), context = () => "") {
          super();
          this.elementConstructors = elementConstructors;
          this.tokenTypes = tokenTypes;
          this.context = context;
        }
        parseText(text) {
          if (text.length > 0) {
            this.elementConstructors.forEach((ec) => {
              this.alternatives.push(ec());
            });
          }
          super.parseText(text);
        }
        symbolCompletion_tokenTypes() {
          return this.matchedText.length === 0 && this.tokenTypes.size > 0 ? this.tokenTypes : super.symbolCompletion_tokenTypes();
        }
      };
      exports.Alternatives = Alternatives;
    }
  });

  // out/src/ide/frames/parse-nodes/dotted-term.js
  var require_dotted_term = __commonJS({
    "out/src/ide/frames/parse-nodes/dotted-term.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DottedTerm = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var identifier_node_1 = require_identifier_node();
      var method_call_node_1 = require_method_call_node();
      var punctuation_node_1 = require_punctuation_node();
      var DottedTerm = class extends abstract_sequence_1.AbstractSequence {
        term;
        tokenTypes = /* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_property, symbol_completion_helpers_1.TokenType.method_function, symbol_completion_helpers_1.TokenType.method_system]);
        constructor() {
          super();
          const prop = () => new identifier_node_1.IdentifierNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_property]));
          const method = () => new method_call_node_1.MethodCallNode();
          this.term = new alternatives_1.Alternatives([prop, method], this.tokenTypes);
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOT));
            this.addElement(this.term);
            super.parseText(text);
          }
        }
      };
      exports.DottedTerm = DottedTerm;
    }
  });

  // out/src/ide/frames/parse-nodes/qualifier.js
  var require_qualifier = __commonJS({
    "out/src/ide/frames/parse-nodes/qualifier.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Qualifier = void 0;
      var keywords_1 = require_keywords();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var keyword_node_1 = require_keyword_node();
      var Qualifier = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.completionWhenEmpty = "";
        }
        parseText(text) {
          if (text.trim().length > 0) {
            const glb = new keyword_node_1.KeywordNode(keywords_1.globalKeyword, false, true);
            const lib = new keyword_node_1.KeywordNode(keywords_1.libraryKeyword, false, true);
            const prop = new keyword_node_1.KeywordNode(keywords_1.propertyKeyword, false, true);
            this.alternatives.push(glb);
            this.alternatives.push(lib);
            this.alternatives.push(prop);
            super.parseText(text);
          }
        }
      };
      exports.Qualifier = Qualifier;
    }
  });

  // out/src/ide/frames/parse-nodes/bracketed-expression.js
  var require_bracketed_expression = __commonJS({
    "out/src/ide/frames/parse-nodes/bracketed-expression.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BracketedExpression = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var expr_node_1 = require_expr_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var space_node_1 = require_space_node();
      var BracketedExpression = class extends abstract_sequence_1.AbstractSequence {
        expr;
        constructor() {
          super();
          this.completionWhenEmpty = "";
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACKET));
            this.expr = new expr_node_1.ExprNode();
            this.addElement(this.expr);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACKET));
            super.parseText(text);
          }
        }
      };
      exports.BracketedExpression = BracketedExpression;
    }
  });

  // out/src/ide/frames/parse-nodes/kvp-node.js
  var require_kvp_node = __commonJS({
    "out/src/ide/frames/parse-nodes/kvp-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.KVPnode = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var punctuation_node_1 = require_punctuation_node();
      var KVPnode = class extends abstract_sequence_1.AbstractSequence {
        key;
        value;
        keyConstructor;
        valueConstructor;
        constructor(keyConstructor, valueConstructor) {
          super();
          this.keyConstructor = keyConstructor;
          this.valueConstructor = valueConstructor;
        }
        parseText(text) {
          if (text.length > 0) {
            this.key = this.keyConstructor();
            this.value = this.valueConstructor();
            this.addElement(this.key);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.COLON));
            this.addElement(this.value);
            super.parseText(text);
          }
        }
      };
      exports.KVPnode = KVPnode;
    }
  });

  // out/src/ide/frames/parse-nodes/dictionary-node.js
  var require_dictionary_node = __commonJS({
    "out/src/ide/frames/parse-nodes/dictionary-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DictionaryNode = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var kvp_node_1 = require_kvp_node();
      var punctuation_node_1 = require_punctuation_node();
      var DictionaryNode = class extends abstract_sequence_1.AbstractSequence {
        csv;
        elementConstructor;
        constructor(keyConstructor, valueConstructor) {
          super();
          this.elementConstructor = () => new kvp_node_1.KVPnode(keyConstructor, valueConstructor);
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_SQ_BRACKET));
            this.csv = new csv_1.CSV(this.elementConstructor, 1);
            this.addElement(this.csv);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_SQ_BRACKET));
            super.parseText(text);
          }
        }
      };
      exports.DictionaryNode = DictionaryNode;
    }
  });

  // out/src/ide/frames/parse-nodes/immutable-dictionary-node.js
  var require_immutable_dictionary_node = __commonJS({
    "out/src/ide/frames/parse-nodes/immutable-dictionary-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DictionaryImmutableNode = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var kvp_node_1 = require_kvp_node();
      var punctuation_node_1 = require_punctuation_node();
      var DictionaryImmutableNode = class extends abstract_sequence_1.AbstractSequence {
        csv;
        elementConstructor;
        constructor(keyConstructor, valueConstructor) {
          super();
          this.elementConstructor = () => new kvp_node_1.KVPnode(keyConstructor, valueConstructor);
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACE));
            this.csv = new csv_1.CSV(this.elementConstructor, 1);
            this.addElement(this.csv);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACE));
            super.parseText(text);
          }
        }
      };
      exports.DictionaryImmutableNode = DictionaryImmutableNode;
    }
  });

  // out/src/ide/frames/parse-nodes/list-immutable-node.js
  var require_list_immutable_node = __commonJS({
    "out/src/ide/frames/parse-nodes/list-immutable-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ListImmutableNode = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var space_node_1 = require_space_node();
      var ListImmutableNode = class extends abstract_sequence_1.AbstractSequence {
        csv;
        elementConstructor;
        constructor(elementConstructor) {
          super();
          this.elementConstructor = elementConstructor;
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACE));
            this.csv = new csv_1.CSV(this.elementConstructor, 1);
            this.addElement(this.csv);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACE));
            super.parseText(text);
          }
        }
      };
      exports.ListImmutableNode = ListImmutableNode;
    }
  });

  // out/src/ide/frames/parse-nodes/list-node.js
  var require_list_node = __commonJS({
    "out/src/ide/frames/parse-nodes/list-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ListNode = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var space_node_1 = require_space_node();
      var ListNode = class extends abstract_sequence_1.AbstractSequence {
        csv;
        elementConstructor;
        constructor(elementConstructor) {
          super();
          this.elementConstructor = elementConstructor;
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_SQ_BRACKET));
            this.csv = new csv_1.CSV(this.elementConstructor, 1);
            this.addElement(this.csv);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_SQ_BRACKET));
            super.parseText(text);
          }
        }
      };
      exports.ListNode = ListNode;
    }
  });

  // out/src/ide/frames/parse-nodes/enum-val.js
  var require_enum_val = __commonJS({
    "out/src/ide/frames/parse-nodes/enum-val.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumVal = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var identifier_node_1 = require_identifier_node();
      var punctuation_node_1 = require_punctuation_node();
      var type_name_node_1 = require_type_name_node();
      var EnumVal = class extends abstract_sequence_1.AbstractSequence {
        type;
        val;
        parseText(text) {
          this.type = new type_name_node_1.TypeNameNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.type_enum]));
          this.addElement(this.type);
          this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOT));
          this.val = new identifier_node_1.IdentifierNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_enumValue]), () => this.type.matchedText);
          this.addElement(this.val);
          super.parseText(text.trimStart());
        }
      };
      exports.EnumVal = EnumVal;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-int.js
  var require_lit_int = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-int.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitInt = void 0;
      var regexes_1 = require_regexes();
      var regex_match_node_1 = require_regex_match_node();
      var LitInt = class extends regex_match_node_1.RegExMatchNode {
        constructor() {
          super(regexes_1.Regexes.negatableLitInt);
          this.completionWhenEmpty = "<i>integer value </i>";
        }
        renderAsHtml() {
          return `<el-lit>${super.renderAsHtml()}</el-lit>`;
        }
        renderAsSource() {
          return super.renderAsSource().trim();
        }
      };
      exports.LitInt = LitInt;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-float.js
  var require_lit_float = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-float.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitFloat = void 0;
      var regexes_1 = require_regexes();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var lit_int_1 = require_lit_int();
      var optional_node_1 = require_optional_node();
      var punctuation_node_1 = require_punctuation_node();
      var regex_match_node_1 = require_regex_match_node();
      var sequence_1 = require_sequence();
      var LitFloat = class extends abstract_sequence_1.AbstractSequence {
        constructor() {
          super();
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.addElement(new lit_int_1.LitInt());
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOT));
            this.addElement(new regex_match_node_1.RegExMatchNode(regexes_1.Regexes.literalInt));
            const exponent = new optional_node_1.OptionalNode(new sequence_1.Sequence([
              () => new regex_match_node_1.RegExMatchNode(/e|E/),
              () => new regex_match_node_1.RegExMatchNode(regexes_1.Regexes.negatableLitInt)
            ]));
            this.addElement(exponent);
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `<el-lit>${super.renderAsHtml()}</el-lit>`;
        }
        compile() {
          return this.matchedText.toUpperCase();
        }
        //For the exponent e -> E
      };
      exports.LitFloat = LitFloat;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-regExp.js
  var require_lit_regExp = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-regExp.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitRegExp = void 0;
      var regexes_1 = require_regexes();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var optional_node_1 = require_optional_node();
      var punctuation_node_1 = require_punctuation_node();
      var regex_match_node_1 = require_regex_match_node();
      var LitRegExp = class extends abstract_sequence_1.AbstractSequence {
        open;
        content;
        flags;
        close;
        constructor() {
          super();
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.open = new punctuation_node_1.PunctuationNode(symbols_1.DIVIDE);
            this.content = new regex_match_node_1.RegExMatchNode(regexes_1.Regexes.anythingExceptUnescapedForwardSlash);
            this.close = new punctuation_node_1.PunctuationNode(symbols_1.DIVIDE);
            this.flags = new optional_node_1.OptionalNode(new regex_match_node_1.RegExMatchNode(regexes_1.Regexes.flags));
            this.addElement(this.open);
            this.addElement(this.content);
            this.addElement(this.close);
            this.addElement(this.flags);
            super.parseText(text);
          }
        }
        renderAsSource() {
          return `${this.open?.matchedText}${this.content?.matchedText}${this.close?.matchedText}${this.flags?.matchedText}`;
        }
        renderAsHtml() {
          let flags = ``;
          if (this.flags) {
            flags = this.flags.matchedText.length > 0 ? `<el-regex>${this.flags?.renderAsHtml()}</el-regex>` : ``;
          }
          return `/<el-regex>${this.content?.renderAsHtml()}</el-regex>/${flags}`;
        }
      };
      exports.LitRegExp = LitRegExp;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string-double-quotes-empty.js
  var require_lit_string_double_quotes_empty = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string-double-quotes-empty.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitStringDoubleQuotesEmpty = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var punctuation_node_1 = require_punctuation_node();
      var LitStringDoubleQuotesEmpty = class extends abstract_sequence_1.AbstractSequence {
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOUBLE_QUOTES));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOUBLE_QUOTES));
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `""`;
        }
      };
      exports.LitStringDoubleQuotesEmpty = LitStringDoubleQuotesEmpty;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string-interpolation.js
  var require_lit_string_interpolation = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string-interpolation.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitStringInterpolation = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var expr_node_1 = require_expr_node();
      var punctuation_node_1 = require_punctuation_node();
      var LitStringInterpolation = class extends abstract_sequence_1.AbstractSequence {
        expr;
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACE));
            this.expr = new expr_node_1.ExprNode();
            this.addElement(this.expr);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACE));
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `</el-lit>{${this.expr.renderAsHtml()}}<el-lit>`;
        }
      };
      exports.LitStringInterpolation = LitStringInterpolation;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string-double-quotes-contents.js
  var require_lit_string_double_quotes_contents = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string-double-quotes-contents.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitStringDoubleQuotesContents = void 0;
      var regexes_1 = require_regexes();
      var frame_helpers_1 = require_frame_helpers();
      var regex_match_node_1 = require_regex_match_node();
      var LitStringDoubleQuotesContents = class extends regex_match_node_1.RegExMatchNode {
        constructor() {
          super(regexes_1.Regexes.nonEmptyStringContent);
        }
        parseText(text) {
          super.parseText(text);
        }
        renderAsHtml() {
          return `${(0, frame_helpers_1.renderBackslashNasABreak)(super.renderAsHtml())}`;
        }
      };
      exports.LitStringDoubleQuotesContents = LitStringDoubleQuotesContents;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string-double-quotes-non-empty.js
  var require_lit_string_double_quotes_non_empty = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string-double-quotes-non-empty.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitStringDoubleQuotesNonEmpty = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var lit_string_interpolation_1 = require_lit_string_interpolation();
      var lit_string_double_quotes_contents_1 = require_lit_string_double_quotes_contents();
      var multiple_1 = require_multiple();
      var punctuation_node_1 = require_punctuation_node();
      var LitStringDoubleQuotesNonEmpty = class extends abstract_sequence_1.AbstractSequence {
        segments;
        constructor() {
          super();
          this.completionWhenEmpty = `"string"`;
        }
        parseText(text) {
          if (text.length > 0) {
            const field = () => new lit_string_interpolation_1.LitStringInterpolation();
            const plainText = () => new lit_string_double_quotes_contents_1.LitStringDoubleQuotesContents();
            const segment = () => new alternatives_1.Alternatives([field, plainText]);
            this.segments = new multiple_1.Multiple(segment, 1);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOUBLE_QUOTES));
            this.addElement(this.segments);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOUBLE_QUOTES));
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `"<el-lit>${this.segments.renderAsHtml()}</el-lit>"`;
        }
      };
      exports.LitStringDoubleQuotesNonEmpty = LitStringDoubleQuotesNonEmpty;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string-single-quotes-contents.js
  var require_lit_string_single_quotes_contents = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string-single-quotes-contents.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitStringSingleQuotesContents = void 0;
      var regexes_1 = require_regexes();
      var frame_helpers_1 = require_frame_helpers();
      var regex_match_node_1 = require_regex_match_node();
      var LitStringSingleQuotesContents = class extends regex_match_node_1.RegExMatchNode {
        constructor() {
          super(regexes_1.Regexes.nonInterpolatedStringContent);
        }
        sanitise(s) {
          return s.replaceAll("\r", "").replaceAll("\n", "\\n");
        }
        renderAsSource() {
          return this.sanitise(this.matchedText);
        }
        parseText(text) {
          super.parseText(text);
        }
        renderAsHtml() {
          return `${(0, frame_helpers_1.renderBackslashNasABreak)(super.renderAsHtml())}`;
        }
      };
      exports.LitStringSingleQuotesContents = LitStringSingleQuotesContents;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string-single-quotes.js
  var require_lit_string_single_quotes = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string-single-quotes.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitStringSingleQuotes = void 0;
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var lit_string_single_quotes_contents_1 = require_lit_string_single_quotes_contents();
      var punctuation_node_1 = require_punctuation_node();
      var LitStringSingleQuotes = class extends abstract_sequence_1.AbstractSequence {
        contents;
        parseText(text) {
          if (text.length > 0) {
            this.contents = new lit_string_single_quotes_contents_1.LitStringSingleQuotesContents();
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.SINGLE_QUOTE));
            this.addElement(this.contents);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.SINGLE_QUOTE));
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `'<el-lit>${this.contents.renderAsHtml()}</el-lit>'`;
        }
      };
      exports.LitStringSingleQuotes = LitStringSingleQuotes;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-string.js
  var require_lit_string = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-string.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitString = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var lit_string_double_quotes_empty_1 = require_lit_string_double_quotes_empty();
      var lit_string_double_quotes_non_empty_1 = require_lit_string_double_quotes_non_empty();
      var lit_string_single_quotes_1 = require_lit_string_single_quotes();
      var LitString = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.completionWhenEmpty = `"string"`;
        }
        parseText(text) {
          if (text.length > 0) {
            this.alternatives.push(new lit_string_single_quotes_1.LitStringSingleQuotes());
            this.alternatives.push(new lit_string_double_quotes_empty_1.LitStringDoubleQuotesEmpty());
            this.alternatives.push(new lit_string_double_quotes_non_empty_1.LitStringDoubleQuotesNonEmpty());
            super.parseText(text);
          }
        }
      };
      exports.LitString = LitString;
    }
  });

  // out/src/ide/frames/parse-nodes/lit-value-node.js
  var require_lit_value_node = __commonJS({
    "out/src/ide/frames/parse-nodes/lit-value-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LitValueNode = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var enum_val_1 = require_enum_val();
      var lit_float_1 = require_lit_float();
      var lit_int_1 = require_lit_int();
      var lit_regExp_1 = require_lit_regExp();
      var lit_string_1 = require_lit_string();
      var LitValueNode = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.completionWhenEmpty = "";
        }
        parseText(text) {
          this.alternatives.push(new lit_int_1.LitInt());
          this.alternatives.push(new lit_float_1.LitFloat());
          this.alternatives.push(new lit_string_1.LitString());
          this.alternatives.push(new enum_val_1.EnumVal());
          this.alternatives.push(new lit_regExp_1.LitRegExp());
          super.parseText(text);
        }
      };
      exports.LitValueNode = LitValueNode;
    }
  });

  // out/src/ide/frames/parse-nodes/method-name-node.js
  var require_method_name_node = __commonJS({
    "out/src/ide/frames/parse-nodes/method-name-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MethodNameNode = void 0;
      var identifier_node_1 = require_identifier_node();
      var MethodNameNode = class extends identifier_node_1.IdentifierNode {
        renderAsHtml() {
          return `<el-method>${this.renderAsSource()}</el-method>`;
        }
      };
      exports.MethodNameNode = MethodNameNode;
    }
  });

  // out/src/ide/frames/parse-nodes/function-ref-node.js
  var require_function_ref_node = __commonJS({
    "out/src/ide/frames/parse-nodes/function-ref-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FunctionRefNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var keyword_node_1 = require_keyword_node();
      var method_name_node_1 = require_method_name_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var FunctionRefNode = class extends abstract_sequence_1.AbstractSequence {
        name;
        parseText(text) {
          if (text.trim().length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.refKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.name = new method_name_node_1.MethodNameNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.method_function]));
            this.addElement(this.name);
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `<el-kw>${keywords_1.refKeyword}</el-kw> <el-method>${this.name.renderAsHtml()}</el-method>`;
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.refKeyword)]) : super.symbolCompletion_keywords();
        }
      };
      exports.FunctionRefNode = FunctionRefNode;
    }
  });

  // out/src/ide/frames/parse-nodes/reference-node.js
  var require_reference_node = __commonJS({
    "out/src/ide/frames/parse-nodes/reference-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ReferenceNode = void 0;
      var keywords_1 = require_keywords();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var function_ref_node_1 = require_function_ref_node();
      var identifier_node_1 = require_identifier_node();
      var keyword_node_1 = require_keyword_node();
      var method_call_node_1 = require_method_call_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var ReferenceNode = class extends abstract_alternatives_1.AbstractAlternatives {
        tokenTypes = new Set(parse_node_helpers_1.allIds);
        parseText(text) {
          if (text.length > 0) {
            this.alternatives.push(new keyword_node_1.KeywordNode(keywords_1.thisKeyword));
            this.alternatives.push(new identifier_node_1.IdentifierNode(this.tokenTypes));
            this.alternatives.push(new method_call_node_1.MethodCallNode());
            this.alternatives.push(new function_ref_node_1.FunctionRefNode());
            super.parseText(text);
          }
        }
      };
      exports.ReferenceNode = ReferenceNode;
    }
  });

  // out/src/ide/frames/parse-nodes/unary-expression.js
  var require_unary_expression = __commonJS({
    "out/src/ide/frames/parse-nodes/unary-expression.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.UnaryExpression = void 0;
      var keywords_1 = require_keywords();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var sequence_1 = require_sequence();
      var space_node_1 = require_space_node();
      var term_1 = require_term();
      var UnaryExpression = class extends abstract_sequence_1.AbstractSequence {
        unaryOp;
        term;
        constructor() {
          super();
        }
        parseText(text) {
          if (text.length > 0) {
            const minus = () => new punctuation_node_1.PunctuationNode(symbols_1.MINUS);
            const not = () => new keyword_node_1.KeywordNode(keywords_1.notKeyword);
            const sp = () => new space_node_1.SpaceNode(parse_node_helpers_1.Space.added);
            const notSp = () => new sequence_1.Sequence([not, sp]);
            this.unaryOp = new alternatives_1.Alternatives([minus, notSp]);
            this.addElement(this.unaryOp);
            this.term = new term_1.Term();
            this.addElement(this.term);
            return super.parseText(text);
          }
        }
      };
      exports.UnaryExpression = UnaryExpression;
    }
  });

  // out/src/ide/frames/parse-nodes/term-simple.js
  var require_term_simple = __commonJS({
    "out/src/ide/frames/parse-nodes/term-simple.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TermSimple = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var bracketed_expression_1 = require_bracketed_expression();
      var dictionary_node_1 = require_dictionary_node();
      var expr_node_1 = require_expr_node();
      var immutable_dictionary_node_1 = require_immutable_dictionary_node();
      var list_immutable_node_1 = require_list_immutable_node();
      var list_node_1 = require_list_node();
      var lit_value_node_1 = require_lit_value_node();
      var reference_node_1 = require_reference_node();
      var unary_expression_1 = require_unary_expression();
      var TermSimple = class extends abstract_alternatives_1.AbstractAlternatives {
        defaultTokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_constant,
          symbol_completion_helpers_1.TokenType.id_let,
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_parameter_regular,
          symbol_completion_helpers_1.TokenType.id_property,
          symbol_completion_helpers_1.TokenType.id_variable,
          symbol_completion_helpers_1.TokenType.id_enumValue,
          symbol_completion_helpers_1.TokenType.method_function,
          symbol_completion_helpers_1.TokenType.method_system
        ]);
        constructor() {
          super();
          this.completionWhenEmpty = "<i>expression</i>";
        }
        parseText(text) {
          if (text.trim().length > 0) {
            this.alternatives.push(new list_immutable_node_1.ListImmutableNode(() => new expr_node_1.ExprNode()));
            this.alternatives.push(new list_node_1.ListNode(() => new expr_node_1.ExprNode()));
            this.alternatives.push(new dictionary_node_1.DictionaryNode(() => new expr_node_1.ExprNode(), () => new expr_node_1.ExprNode()));
            this.alternatives.push(new immutable_dictionary_node_1.DictionaryImmutableNode(() => new expr_node_1.ExprNode(), () => new expr_node_1.ExprNode()));
            this.alternatives.push(new unary_expression_1.UnaryExpression());
            this.alternatives.push(new bracketed_expression_1.BracketedExpression());
            this.alternatives.push(new lit_value_node_1.LitValueNode());
            this.alternatives.push(new reference_node_1.ReferenceNode());
            super.parseText(text);
          }
        }
        symbolCompletion_toMatch() {
          const startsWithBracket = /[\[\(\{].*/;
          if (startsWithBracket.test(this.matchedText)) {
            return this.matchedText.slice(1);
          } else {
            return super.symbolCompletion_toMatch();
          }
        }
      };
      exports.TermSimple = TermSimple;
    }
  });

  // out/src/ide/frames/parse-nodes/term-chained.js
  var require_term_chained = __commonJS({
    "out/src/ide/frames/parse-nodes/term-chained.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TermChained = void 0;
      var _1 = require_parse_nodes();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var dotted_term_1 = require_dotted_term();
      var multiple_1 = require_multiple();
      var qualifier_1 = require_qualifier();
      var term_simple_1 = require_term_simple();
      var TermChained = class extends abstract_sequence_1.AbstractSequence {
        chainedHead;
        tail;
        parseText(text) {
          if (text.length > 0) {
            const termSimple = () => new term_simple_1.TermSimple();
            const qualifier = () => new qualifier_1.Qualifier();
            this.chainedHead = new alternatives_1.Alternatives([qualifier, termSimple]);
            const dottedTerm = () => new dotted_term_1.DottedTerm();
            const index = () => new _1.Index();
            const dottedSymbolOrIndex = () => new alternatives_1.Alternatives([dottedTerm, index]);
            this.tail = new multiple_1.Multiple(dottedSymbolOrIndex, 1);
            this.addElement(this.chainedHead);
            this.addElement(this.tail);
            super.parseText(text);
          }
        }
      };
      exports.TermChained = TermChained;
    }
  });

  // out/src/ide/frames/parse-nodes/term-simple-with-opt-index.js
  var require_term_simple_with_opt_index = __commonJS({
    "out/src/ide/frames/parse-nodes/term-simple-with-opt-index.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TermSimpleWithOptIndex = void 0;
      var _1 = require_parse_nodes();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var optional_node_1 = require_optional_node();
      var term_simple_1 = require_term_simple();
      var TermSimpleWithOptIndex = class extends abstract_sequence_1.AbstractSequence {
        termSimple;
        optIndex;
        defaultTokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_constant,
          symbol_completion_helpers_1.TokenType.id_let,
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_parameter_regular,
          symbol_completion_helpers_1.TokenType.id_property,
          symbol_completion_helpers_1.TokenType.id_variable,
          symbol_completion_helpers_1.TokenType.id_enumValue,
          symbol_completion_helpers_1.TokenType.method_function,
          symbol_completion_helpers_1.TokenType.method_system
        ]);
        constructor() {
          super();
          this.completionWhenEmpty = "<i>expression</i>";
        }
        parseText(text) {
          if (text.trim().length > 0) {
            this.termSimple = new term_simple_1.TermSimple();
            this.addElement(this.termSimple);
            this.optIndex = new optional_node_1.OptionalNode(new _1.Index());
            this.addElement(this.optIndex);
            super.parseText(text);
          }
        }
      };
      exports.TermSimpleWithOptIndex = TermSimpleWithOptIndex;
    }
  });

  // out/src/ide/frames/parse-nodes/term.js
  var require_term = __commonJS({
    "out/src/ide/frames/parse-nodes/term.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Term = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var term_chained_1 = require_term_chained();
      var term_simple_with_opt_index_1 = require_term_simple_with_opt_index();
      var Term = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.completionWhenEmpty = "<i>expression</i>";
        }
        parseText(text) {
          this.alternatives.push(new term_simple_with_opt_index_1.TermSimpleWithOptIndex());
          this.alternatives.push(new term_chained_1.TermChained());
          super.parseText(text);
        }
        symbolCompletion_tokenTypes() {
          if (this.alternatives.length === 0) {
            return new Set(parse_node_helpers_1.allIdsAndMethods);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
        symbolCompletion_keywords() {
          if (this.alternatives.length === 0) {
            return /* @__PURE__ */ new Set([
              symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.thisKeyword),
              symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.refKeyword)
            ]);
          } else {
            return super.symbolCompletion_keywords();
          }
        }
        getActiveNode() {
          const best = this.bestMatch;
          if (best) {
            return best.getActiveNode();
          } else {
            return this;
          }
        }
      };
      exports.Term = Term;
    }
  });

  // out/src/ide/frames/parse-nodes/binary-expression.js
  var require_binary_expression = __commonJS({
    "out/src/ide/frames/parse-nodes/binary-expression.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BinaryExpression = void 0;
      var abstract_sequence_1 = require_abstract_sequence();
      var binary_operation_1 = require_binary_operation();
      var expr_node_1 = require_expr_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var term_1 = require_term();
      var BinaryExpression = class extends abstract_sequence_1.AbstractSequence {
        lhs;
        op;
        rhs;
        constructor() {
          super();
          this.completionWhenEmpty = "<i>expression</i>";
        }
        parseText(text) {
          this.lhs = new term_1.Term();
          this.addElement(this.lhs);
          this.op = new binary_operation_1.BinaryOperation();
          this.addElement(this.op);
          this.rhs = new expr_node_1.ExprNode();
          this.addElement(this.rhs);
          return super.parseText(text);
        }
        renderAsHtml() {
          return `${this.lhs?.renderAsHtml()}${this.op.renderAsHtml()}${this.rhs?.renderAsHtml()}`;
        }
        renderAsSource() {
          return `${this.lhs?.renderAsSource()}${this.op.renderAsSource()}${this.rhs?.renderAsSource()}`;
        }
        symbolCompletion_tokenTypes() {
          if (this.getElements().length === 0) {
            return new Set(parse_node_helpers_1.allIdsAndMethods);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? parse_node_helpers_1.allKeywordsThatCanStartAnExpression : super.symbolCompletion_keywords();
        }
      };
      exports.BinaryExpression = BinaryExpression;
    }
  });

  // out/src/ide/frames/parse-nodes/identiferOrThis.js
  var require_identiferOrThis = __commonJS({
    "out/src/ide/frames/parse-nodes/identiferOrThis.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IdentifierOrThis = void 0;
      var keywords_1 = require_keywords();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var identifier_node_1 = require_identifier_node();
      var keyword_node_1 = require_keyword_node();
      var IdentifierOrThis = class extends abstract_alternatives_1.AbstractAlternatives {
        parseText(text) {
          this.alternatives.push(new identifier_node_1.IdentifierNode());
          this.alternatives.push(new keyword_node_1.KeywordNode(keywords_1.thisKeyword));
          super.parseText(text);
        }
      };
      exports.IdentifierOrThis = IdentifierOrThis;
    }
  });

  // out/src/ide/frames/parse-nodes/set-to-clause.js
  var require_set_to_clause = __commonJS({
    "out/src/ide/frames/parse-nodes/set-to-clause.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SetToClause = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var expr_node_1 = require_expr_node();
      var identifier_node_1 = require_identifier_node();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var SetToClause = class extends abstract_sequence_1.AbstractSequence {
        property;
        expr;
        context;
        constructor(context) {
          super();
          this.context = context;
          this.completionWhenEmpty = "<i>name</i> set to <i>expression</i>";
        }
        parseText(text) {
          this.property = new identifier_node_1.IdentifierNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_property]), this.context);
          const sp0 = new space_node_1.SpaceNode(parse_node_helpers_1.Space.required);
          const set = new keyword_node_1.KeywordNode(keywords_1.setKeyword);
          const sp1 = new space_node_1.SpaceNode(parse_node_helpers_1.Space.required);
          const to = new keyword_node_1.KeywordNode(keywords_1.toKeyword);
          const sp2 = new space_node_1.SpaceNode(parse_node_helpers_1.Space.required);
          this.expr = new expr_node_1.ExprNode();
          this.addElement(this.property);
          this.addElement(sp0);
          this.addElement(set);
          this.addElement(sp1);
          this.addElement(to);
          this.addElement(sp2);
          this.addElement(this.expr);
          return super.parseText(text);
        }
        symbolCompletion_tokenTypes() {
          if (this.getElements().length === 0) {
            return /* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_property]);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
        symbolCompletion_context() {
          return this.context();
        }
        renderAsHtml() {
          return `<br>${this.property?.renderAsHtml()}<el-kw> set to </el-kw>${this.expr?.renderAsHtml()}`;
        }
      };
      exports.SetToClause = SetToClause;
    }
  });

  // out/src/ide/frames/parse-nodes/with-clause.js
  var require_with_clause = __commonJS({
    "out/src/ide/frames/parse-nodes/with-clause.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.WithClause = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var set_to_clause_1 = require_set_to_clause();
      var space_node_1 = require_space_node();
      var WithClause = class extends abstract_sequence_1.AbstractSequence {
        toClauses;
        context;
        constructor(context) {
          super();
          this.context = context;
          this.completionWhenEmpty = " with <i>name</i> set to <i>expression</i>";
        }
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.added));
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.withKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.toClauses = new csv_1.CSV(() => new set_to_clause_1.SetToClause(this.context), 1);
            this.addElement(this.toClauses);
            return super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.withKeyword)]) : super.symbolCompletion_keywords();
        }
        renderAsHtml() {
          return `<el-kw> with </el-kw>${this.toClauses?.renderAsHtml()}`;
        }
      };
      exports.WithClause = WithClause;
    }
  });

  // out/src/ide/frames/parse-nodes/copy-with.js
  var require_copy_with = __commonJS({
    "out/src/ide/frames/parse-nodes/copy-with.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CopyWith = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var identiferOrThis_1 = require_identiferOrThis();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var with_clause_1 = require_with_clause();
      var CopyWith = class extends abstract_sequence_1.AbstractSequence {
        original;
        withClause;
        tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_let,
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_parameter_regular,
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_property,
          symbol_completion_helpers_1.TokenType.id_variable
        ]);
        constructor() {
          super();
          this.original = new identiferOrThis_1.IdentifierOrThis();
        }
        parseText(text) {
          if (text.trim().length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.copyKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.addElement(this.original);
            this.withClause = new with_clause_1.WithClause(() => this.original.matchedText);
            this.addElement(this.withClause);
            return super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.copyKeyword)]) : super.symbolCompletion_keywords();
        }
      };
      exports.CopyWith = CopyWith;
    }
  });

  // out/src/ide/frames/parse-nodes/empty-of-type-node.js
  var require_empty_of_type_node = __commonJS({
    "out/src/ide/frames/parse-nodes/empty-of-type-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EmptyOfTypeNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var type_node_1 = require_type_node();
      var EmptyOfTypeNode = class extends abstract_sequence_1.AbstractSequence {
        type;
        parseText(text) {
          if (text.trim().length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.emptyKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.type = new type_node_1.TypeNode(/* @__PURE__ */ new Set([
              symbol_completion_helpers_1.TokenType.type_concrete,
              symbol_completion_helpers_1.TokenType.type_abstract,
              symbol_completion_helpers_1.TokenType.type_enum,
              symbol_completion_helpers_1.TokenType.type_notInheritable
            ]));
            this.addElement(this.type);
            super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.emptyKeyword)]) : super.symbolCompletion_keywords();
        }
      };
      exports.EmptyOfTypeNode = EmptyOfTypeNode;
    }
  });

  // out/src/ide/frames/parse-nodes/if-expr.js
  var require_if_expr = __commonJS({
    "out/src/ide/frames/parse-nodes/if-expr.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IfExpr = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var expr_node_1 = require_expr_node();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var IfExpr = class extends abstract_sequence_1.AbstractSequence {
        condition;
        whenTrue;
        whenFalse;
        parseText(text) {
          if (text.trim().length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.ifKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.condition = new expr_node_1.ExprNode();
            this.condition.setSyntaxCompletionWhenEmpty("<i>condition </i>");
            this.addElement(this.condition);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.thenKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.whenTrue = new expr_node_1.ExprNode();
            this.addElement(this.whenTrue);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.elseKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.whenFalse = new expr_node_1.ExprNode();
            this.addElement(this.whenFalse);
            super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.ifKeyword)]) : super.symbolCompletion_keywords();
        }
        renderAsHtml() {
          return `<el-kw>${keywords_1.ifKeyword} </el-kw>${this.condition?.renderAsHtml()}<el-kw><br>${keywords_1.thenKeyword} </el-kw>${this.whenTrue?.renderAsHtml()}<el-kw><br>${keywords_1.elseKeyword} </el-kw>${this.whenFalse?.renderAsHtml()}`;
        }
      };
      exports.IfExpr = IfExpr;
    }
  });

  // out/src/ide/frames/parse-nodes/url-node.js
  var require_url_node = __commonJS({
    "out/src/ide/frames/parse-nodes/url-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.UrlNode = void 0;
      var status_enums_1 = require_status_enums();
      var abstract_parse_node_1 = require_abstract_parse_node();
      var UrlNode = class extends abstract_parse_node_1.AbstractParseNode {
        constructor() {
          super();
        }
        validateUrl(text) {
          try {
            let url = text;
            let remainingText = "";
            const firstSpace = text.indexOf(" ");
            if (firstSpace > 0) {
              url = text.slice(0, firstSpace);
              remainingText = text.slice(firstSpace);
            }
            new URL(url);
            this.set(status_enums_1.ParseStatus.valid, url, remainingText);
          } catch {
            this.set(status_enums_1.ParseStatus.invalid, text, "");
          }
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            if (text.length <= 7) {
              if ("https:/".startsWith(text) || "http://".startsWith(text)) {
                this.set(status_enums_1.ParseStatus.incomplete, text, "");
              } else {
                this.set(status_enums_1.ParseStatus.invalid, text, "");
              }
            } else if (text.length === 8 && text.startsWith("https://")) {
              this.set(status_enums_1.ParseStatus.incomplete, text, "");
            } else {
              if (text.startsWith("https://") || text.startsWith("http://")) {
                this.validateUrl(text);
              } else {
                this.set(status_enums_1.ParseStatus.invalid, text, "");
              }
            }
          }
        }
      };
      exports.UrlNode = UrlNode;
    }
  });

  // out/src/ide/frames/parse-nodes/image-node.js
  var require_image_node = __commonJS({
    "out/src/ide/frames/parse-nodes/image-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ImageNode = void 0;
      var keywords_1 = require_keywords();
      var abstract_sequence_1 = require_abstract_sequence();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var url_node_1 = require_url_node();
      var with_clause_1 = require_with_clause();
      var ImageNode = class extends abstract_sequence_1.AbstractSequence {
        url;
        withClause;
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.imageKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.added));
            this.url = new url_node_1.UrlNode();
            this.url.completionWhenEmpty = "<i>url</i>";
            this.addElement(this.url);
            this.withClause = new optional_node_1.OptionalNode(new with_clause_1.WithClause(() => "ImageVG"));
            this.addElement(this.withClause);
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `<img src="${this.url.renderAsHtml()}">${this.withClause.renderAsHtml()}`;
        }
      };
      exports.ImageNode = ImageNode;
    }
  });

  // out/src/ide/frames/parse-nodes/lambda.js
  var require_lambda = __commonJS({
    "out/src/ide/frames/parse-nodes/lambda.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Lambda = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var expr_node_1 = require_expr_node();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var param_def_node_1 = require_param_def_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var sequence_1 = require_sequence();
      var space_node_1 = require_space_node();
      var Lambda = class extends abstract_sequence_1.AbstractSequence {
        params;
        expr;
        parseText(text) {
          if (text.trim().length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.lambdaKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            const paramList = () => new csv_1.CSV(() => new param_def_node_1.ParamDefNode(false), 1);
            const sp = () => new space_node_1.SpaceNode(parse_node_helpers_1.Space.required);
            const paramListSp = new sequence_1.Sequence([paramList, sp]);
            this.params = new optional_node_1.OptionalNode(paramListSp);
            this.params.setSyntaxCompletionWhenEmpty("<i>name</i> as <i>Type</i>, ...");
            this.addElement(this.params);
            const arrow = new punctuation_node_1.PunctuationNode(symbols_1.ARROW);
            this.addElement(arrow);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.expr = new expr_node_1.ExprNode();
            this.addElement(this.expr);
            super.parseText(text);
            if (!arrow.isEmpty()) {
              this.params.setSyntaxCompletionWhenEmpty("");
            }
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.lambdaKeyword)]) : super.symbolCompletion_keywords();
        }
      };
      exports.Lambda = Lambda;
    }
  });

  // out/src/ide/frames/parse-nodes/type-simple-or-generic.js
  var require_type_simple_or_generic = __commonJS({
    "out/src/ide/frames/parse-nodes/type-simple-or-generic.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeSimpleOrGeneric = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var type_generic_node_1 = require_type_generic_node();
      var type_name_node_1 = require_type_name_node();
      var TypeSimpleOrGeneric = class extends abstract_alternatives_1.AbstractAlternatives {
        tokenTypes = /* @__PURE__ */ new Set();
        constructor(tokenTypes = /* @__PURE__ */ new Set()) {
          super();
          this.completionWhenEmpty = "<i>Type</i>";
          this.tokenTypes = tokenTypes;
        }
        parseText(text) {
          this.remainingText = text;
          if (text.length > 0) {
            this.alternatives.push(new type_name_node_1.TypeNameNode(this.tokenTypes));
            this.alternatives.push(new type_generic_node_1.TypeGenericNode(this.tokenTypes));
            super.parseText(text);
          }
        }
        symbolCompletion_tokenTypes() {
          return this.matchedText.length === 0 ? this.tokenTypes : super.symbolCompletion_tokenTypes();
        }
        symbolCompletion_context() {
          return "none";
        }
      };
      exports.TypeSimpleOrGeneric = TypeSimpleOrGeneric;
    }
  });

  // out/src/ide/frames/parse-nodes/new-instance.js
  var require_new_instance = __commonJS({
    "out/src/ide/frames/parse-nodes/new-instance.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.NewInstance = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var arg_list_node_1 = require_arg_list_node();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var space_node_1 = require_space_node();
      var type_simple_or_generic_1 = require_type_simple_or_generic();
      var with_clause_1 = require_with_clause();
      var NewInstance = class extends abstract_sequence_1.AbstractSequence {
        type;
        args;
        withClause;
        parseText(text) {
          if (text.trim().length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.newKeyword));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.type = new type_simple_or_generic_1.TypeSimpleOrGeneric(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.type_concrete]));
            this.addElement(this.type);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACKET));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.args = new arg_list_node_1.ArgListNode(() => this.type.matchedText);
            this.addElement(this.args);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACKET));
            this.withClause = new optional_node_1.OptionalNode(new with_clause_1.WithClause(() => this.type.matchedText));
            this.addElement(this.withClause);
            super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.newKeyword)]) : super.symbolCompletion_keywords();
        }
      };
      exports.NewInstance = NewInstance;
    }
  });

  // out/src/ide/frames/parse-nodes/tuple-node.js
  var require_tuple_node = __commonJS({
    "out/src/ide/frames/parse-nodes/tuple-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TupleNode = void 0;
      var keywords_1 = require_keywords();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var expr_node_1 = require_expr_node();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var space_node_1 = require_space_node();
      var TupleNode = class extends abstract_sequence_1.AbstractSequence {
        csv;
        parseText(text) {
          if (text.length > 0) {
            this.addElement(new keyword_node_1.KeywordNode(keywords_1.tupleKeyword));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACKET));
            this.csv = new csv_1.CSV(() => new expr_node_1.ExprNode(), 2);
            this.addElement(this.csv);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACKET));
            super.parseText(text);
          }
        }
      };
      exports.TupleNode = TupleNode;
    }
  });

  // out/src/ide/frames/parse-nodes/expr-node.js
  var require_expr_node = __commonJS({
    "out/src/ide/frames/parse-nodes/expr-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ExprNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var binary_expression_1 = require_binary_expression();
      var copy_with_1 = require_copy_with();
      var empty_of_type_node_1 = require_empty_of_type_node();
      var if_expr_1 = require_if_expr();
      var image_node_1 = require_image_node();
      var lambda_1 = require_lambda();
      var new_instance_1 = require_new_instance();
      var term_1 = require_term();
      var tuple_node_1 = require_tuple_node();
      var ExprNode = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.completionWhenEmpty = "<i>value or expression</i>";
        }
        parseText(text) {
          if (text.trim().length > 0) {
            this.alternatives.push(new new_instance_1.NewInstance());
            this.alternatives.push(new copy_with_1.CopyWith());
            this.alternatives.push(new if_expr_1.IfExpr());
            this.alternatives.push(new lambda_1.Lambda());
            this.alternatives.push(new empty_of_type_node_1.EmptyOfTypeNode());
            this.alternatives.push(new tuple_node_1.TupleNode());
            this.alternatives.push(new image_node_1.ImageNode());
            this.alternatives.push(new term_1.Term());
            this.alternatives.push(new binary_expression_1.BinaryExpression());
            super.parseText(text);
          }
        }
        getActiveNode() {
          let active = this;
          const best = this.bestMatch;
          if (this.bestMatchIsOnlyMatch() || best instanceof term_1.Term && this.potentialMatches().length === 2 && this.potentialMatches()[1] instanceof binary_expression_1.BinaryExpression) {
            active = best.getActiveNode();
          }
          return active;
        }
        symbolCompletion_tokenTypes() {
          return /* @__PURE__ */ new Set([
            symbol_completion_helpers_1.TokenType.id_constant,
            symbol_completion_helpers_1.TokenType.id_let,
            symbol_completion_helpers_1.TokenType.id_parameter_out,
            symbol_completion_helpers_1.TokenType.id_parameter_regular,
            symbol_completion_helpers_1.TokenType.id_property,
            symbol_completion_helpers_1.TokenType.id_variable,
            symbol_completion_helpers_1.TokenType.id_enumValue,
            symbol_completion_helpers_1.TokenType.method_function,
            symbol_completion_helpers_1.TokenType.method_system,
            symbol_completion_helpers_1.TokenType.type_enum
          ]);
        }
        symbolCompletion_keywords() {
          let kws = [
            keywords_1.newKeyword,
            keywords_1.copyKeyword,
            keywords_1.ifKeyword,
            keywords_1.imageKeyword,
            keywords_1.lambdaKeyword,
            keywords_1.emptyKeyword,
            keywords_1.thisKeyword,
            keywords_1.refKeyword,
            keywords_1.notKeyword
          ].map((kw) => symbol_completion_helpers_1.KeywordCompletion.create(kw));
          kws.push(symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.tupleKeyword, false, false, true));
          const trim = this.matchedText.trim();
          if (trim.length > 0) {
            kws = kws.filter((kw) => kw.keyword.startsWith(trim));
          }
          return new Set(kws);
        }
      };
      exports.ExprNode = ExprNode;
    }
  });

  // out/src/ide/frames/parse-nodes/arg-list-node.js
  var require_arg_list_node = __commonJS({
    "out/src/ide/frames/parse-nodes/arg-list-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ArgListNode = void 0;
      var csv_1 = require_csv();
      var expr_node_1 = require_expr_node();
      var ArgListNode = class extends csv_1.CSV {
        context;
        constructor(context) {
          super(() => new expr_node_1.ExprNode(), 0);
          this.context = context;
        }
        getActiveNode() {
          return this.matchedText.length === 0 ? this : super.getActiveNode();
        }
      };
      exports.ArgListNode = ArgListNode;
    }
  });

  // out/src/ide/frames/parse-nodes/method-call-node.js
  var require_method_call_node = __commonJS({
    "out/src/ide/frames/parse-nodes/method-call-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MethodCallNode = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var arg_list_node_1 = require_arg_list_node();
      var method_name_node_1 = require_method_name_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var space_node_1 = require_space_node();
      var MethodCallNode = class extends abstract_sequence_1.AbstractSequence {
        name;
        args;
        tokenTypes;
        constructor(tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.method_function,
          symbol_completion_helpers_1.TokenType.method_system
        ])) {
          super();
          this.tokenTypes = tokenTypes;
        }
        parseText(text) {
          if (text.trim().length > 0) {
            this.name = new method_name_node_1.MethodNameNode(this.tokenTypes);
            this.addElement(this.name);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.OPEN_BRACKET));
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.args = new arg_list_node_1.ArgListNode(() => this.name.matchedText);
            this.addElement(this.args);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.ignored));
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.CLOSE_BRACKET));
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `${this.name.renderAsHtml()}(${this.args.renderAsHtml()})`;
        }
        symbolCompletion_tokenTypes() {
          if (this.getElements().length === 0) {
            return /* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.method_function, symbol_completion_helpers_1.TokenType.method_system]);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
      };
      exports.MethodCallNode = MethodCallNode;
    }
  });

  // out/src/ide/frames/parse-nodes/assert-actual-node.js
  var require_assert_actual_node = __commonJS({
    "out/src/ide/frames/parse-nodes/assert-actual-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssertActualNode = void 0;
      var status_enums_1 = require_status_enums();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var identifier_node_1 = require_identifier_node();
      var method_call_node_1 = require_method_call_node();
      var term_chained_1 = require_term_chained();
      var term_simple_1 = require_term_simple();
      var AssertActualNode = class extends abstract_alternatives_1.AbstractAlternatives {
        idTypes = /* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_let, symbol_completion_helpers_1.TokenType.id_variable]);
        methodTypes = /* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.method_function]);
        constructor() {
          super();
          this.alternatives.push(new identifier_node_1.IdentifierNode(this.idTypes));
          this.alternatives.push(new method_call_node_1.MethodCallNode(this.methodTypes));
          this.alternatives.push(new term_simple_1.TermSimple());
          this.alternatives.push(new term_chained_1.TermChained());
        }
        parseText(text) {
          super.parseText(text);
          if (this.status === status_enums_1.ParseStatus.valid && text.includes(" is ")) {
            this.status = status_enums_1.ParseStatus.invalid;
          }
        }
      };
      exports.AssertActualNode = AssertActualNode;
    }
  });

  // out/src/ide/frames/fields/assert-actual-field.js
  var require_assert_actual_field = __commonJS({
    "out/src/ide/frames/fields/assert-actual-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssertActualField = void 0;
      var assert_actual_node_1 = require_assert_actual_node();
      var abstract_field_1 = require_abstract_field();
      var AssertActualField = class extends abstract_field_1.AbstractField {
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>actual (computed) value</i>");
        }
        helpId() {
          return "AssertActualField";
        }
        initialiseRoot() {
          this.rootNode = new assert_actual_node_1.AssertActualNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/\sis\s/);
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.AssertActualField = AssertActualField;
    }
  });

  // out/src/ide/frames/fields/expression-field.js
  var require_expression_field = __commonJS({
    "out/src/ide/frames/fields/expression-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ExpressionField = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_symbol_1 = require_unknown_symbol();
      var arg_list_node_1 = require_arg_list_node();
      var expr_node_1 = require_expr_node();
      var abstract_field_1 = require_abstract_field();
      var ExpressionField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        readUntil;
        constructor(holder, readUntil = /\r?\n/) {
          super(holder);
          this.readUntil = readUntil;
          this.setPlaceholder("<i>value or expression</i>");
        }
        helpId() {
          return "ExpressionField";
        }
        getIdPrefix() {
          return "expr";
        }
        initialiseRoot() {
          this.rootNode = new expr_node_1.ExprNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(this.readUntil);
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
        completionOverride = "";
        argumentDescriptions(scope) {
          let descriptions = "";
          const an = this.rootNode?.getActiveNode();
          if (an instanceof arg_list_node_1.ArgListNode) {
            const context = an.context();
            const ps = scope?.resolveSymbol(context, scope);
            descriptions = "<i>arguments</i>";
            if (ps && !(ps instanceof unknown_symbol_1.UnknownSymbol)) {
              const names = (0, symbol_helpers_1.parameterNames)(ps.symbolType());
              descriptions = names.length > 0 ? names.join(", ") : "";
            }
          }
          return descriptions;
        }
        textAsHtml() {
          const holder = this.getHolder();
          const descriptions = this.argumentDescriptions(this.getFile().getAst(false)?.getScopeById(holder.getHtmlId()));
          this.completionOverride = descriptions ? `<i>${descriptions}</i>)` : "";
          return super.textAsHtml();
        }
        getCompletion() {
          return this.completionOverride || super.getCompletion();
        }
      };
      exports.ExpressionField = ExpressionField;
    }
  });

  // out/src/ide/frames/statements/assert-statement.js
  var require_assert_statement = __commonJS({
    "out/src/ide/frames/statements/assert-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssertStatement = void 0;
      var keywords_1 = require_keywords();
      var test_status_1 = require_test_status();
      var abstract_frame_1 = require_abstract_frame();
      var assert_actual_field_1 = require_assert_actual_field();
      var expression_field_1 = require_expression_field();
      var frame_helpers_1 = require_frame_helpers();
      var status_enums_1 = require_status_enums();
      var AssertStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        actual;
        expected;
        outcome;
        constructor(parent) {
          super(parent);
          this.actual = new assert_actual_field_1.AssertActualField(this);
          this.expected = new expression_field_1.ExpressionField(this, /\r|\n/);
          this.expected.setPlaceholder("<i>expected value</i>");
        }
        initialKeywords() {
          return keywords_1.assertKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("assert ");
          this.actual.parseFrom(source);
          source.remove(" is ");
          this.expected.parseFrom(source);
          source.removeNewLine();
        }
        getFields() {
          return [this.actual, this.expected];
        }
        getIdPrefix() {
          return "assert";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}<el-kw>assert </el-kw>${this.actual.renderAsHtml()}<el-kw> is </el-kw>${this.expected.renderAsHtml()}${this.helpAsHtml()}${this.compileOrTestMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}assert ${this.actual.renderAsSource()} is ${this.expected.renderAsSource()}`;
        }
        setOutcome(outcome) {
          this.outcome = outcome;
        }
        getTestStatus() {
          return this.outcome ? this.outcome.status : test_status_1.TestStatus.running;
        }
        compileOrTestMsgAsHtml() {
          let msg = "";
          if (this.readCompileStatus() === status_enums_1.CompileStatus.ok) {
            msg = this.testMsgAsHtml();
          } else {
            msg = (0, frame_helpers_1.helper_compileMsgAsHtmlNew)(this.getFile(), this);
          }
          return msg;
        }
        testMsgAsHtml() {
          let cls = "";
          let msg = "";
          if (!this.outcome || this.outcome.status === test_status_1.TestStatus.ignored) {
            cls = status_enums_1.DisplayColour[status_enums_1.DisplayColour.warning];
            msg = `not run`;
          } else if (this.outcome.status === test_status_1.TestStatus.fail) {
            cls = status_enums_1.DisplayColour[status_enums_1.DisplayColour.error];
            msg = (0, frame_helpers_1.escapeHtmlChars)(`actual (computed): ${this.outcome.actual}`);
          } else if (this.outcome.status === test_status_1.TestStatus.pass) {
            cls = status_enums_1.DisplayColour[status_enums_1.DisplayColour.ok];
            msg = `pass`;
          }
          return ` <el-msg class="${cls}">${msg}</el-msg>`;
        }
      };
      exports.AssertStatement = AssertStatement;
    }
  });

  // out/src/ide/frames/abstract-selector.js
  var require_abstract_selector = __commonJS({
    "out/src/ide/frames/abstract-selector.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractSelector = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var code_source_from_string_1 = require_code_source_from_string();
      var regexes_1 = require_regexes();
      var frame_helpers_1 = require_frame_helpers();
      var file_1 = require_file();
      var overtyper_1 = require_overtyper();
      var parent_helpers_1 = require_parent_helpers();
      var status_enums_1 = require_status_enums();
      var AbstractSelector = class _AbstractSelector extends abstract_frame_1.AbstractFrame {
        isSelector = true;
        isStatement = true;
        text = "";
        label = "new code";
        profile;
        overtyper = new overtyper_1.Overtyper();
        constructor(parent) {
          super(parent);
          this.profile = this.getFile().getProfile();
          this.setParseStatus(status_enums_1.ParseStatus.valid);
        }
        initialKeywords() {
          return "selector";
        }
        helpAsHtml() {
          const active = this.helpActive ? ` class="active"` : "";
          this.helpActive = false;
          return this.isSelected() ? `<el-help contenteditable="false" title="Click to open Help for any of these instructions"> <a href="documentation/LangRef.html#${this.helpId()}" target="help-iframe" tabindex="-1"${active}>?</a></el-help>` : ``;
        }
        optionsFilteredByContext(userEntry) {
          return this.defaultOptions().filter((o) => this.validWithinCurrentContext(o[0], userEntry));
        }
        optionsFilteredByProfile(userEntry) {
          return this.optionsFilteredByContext(userEntry).filter((o) => this.profileAllows(o[0]));
        }
        parseFrom(source) {
          let compilerDirective = "";
          source.removeIndent();
          if (source.isMatchRegEx(regexes_1.Regexes.compilerDirective)) {
            compilerDirective = source.removeRegEx(regexes_1.Regexes.compilerDirective, false).replace("[", "").replace("] ", "");
          } else if (source.mode === file_1.ParseMode.import) {
            compilerDirective = keywords_1.importedAnnotation;
          }
          const options = this.optionsFilteredByContext(false).filter((o) => source.isMatch(o[0]));
          if (options.length === 1) {
            const typeToAdd = options[0][0];
            const frame = this.addFrame(typeToAdd, "");
            this.processCompilerDirective(frame, compilerDirective);
            frame.parseFrom(source);
            return frame;
          } else {
            throw new Error(`${options.length} matches found at ${source.readToEndOfLine()} `);
          }
        }
        processCompilerDirective(frame, compilerDirective) {
          if (compilerDirective === keywords_1.importedAnnotation && ((0, frame_helpers_1.isGlobal)(frame) || (0, frame_helpers_1.isClass)(frame))) {
            frame.setImported(true);
          } else if (compilerDirective === keywords_1.ghostedAnnotation) {
            frame.setGhosted(true);
          }
        }
        optionsMatchingUserInput(match) {
          return this.optionsFilteredByProfile(true).filter((o) => o[0].startsWith(match));
        }
        commonStartText(match) {
          return this.optionsMatchingUserInput(match).map((o) => o[0]).reduce((soFar, o) => this.maxCommonStart(soFar, o));
        }
        maxCommonStart(a, b) {
          return a !== "" && b !== "" && a[0] === b[0] ? a[0] + this.maxCommonStart(a.slice(1), b.slice(1)) : "";
        }
        getCompletion() {
          return this.optionsMatchingUserInput(this.text).map((o) => o[0]).reduce((soFar, kw) => `${soFar} ${this.adjusted(kw, this.text, soFar)}`, "");
        }
        adjusted(kw, input, soFar) {
          const words = kw.split(" ");
          if (words.length === 1) {
            return kw;
          } else if (input.startsWith(`${words[0]}`)) {
            return words[1];
          } else if (soFar.includes(`${words[0]}...`)) {
            return "";
          } else {
            return `${words[0]}...`;
          }
        }
        addFrame(keyword, pendingChars) {
          const func = this.defaultOptions().filter((o) => o[0] === keyword)[0][1];
          const parent = this.getParent();
          const newFrame = func(parent);
          parent.addChildBefore(newFrame, this);
          newFrame.selectFirstField();
          const fields = newFrame.getFields();
          if (fields.length > 0) {
            fields[0].overtyper.consumeChars(pendingChars, 500);
          } else if ((0, frame_helpers_1.isFrameWithStatements)(newFrame)) {
            const ss = newFrame.getFirstChild();
            if (ss instanceof _AbstractSelector) {
              ss.overtyper.consumeChars(pendingChars, 500);
            }
          }
          return newFrame;
        }
        setClasses() {
          super.setClasses();
          this.pushClass(this.text === "", "empty");
        }
        clearText() {
          this.text = "";
        }
        getFields() {
          return [];
        }
        getIdPrefix() {
          return "select";
        }
        deselect() {
          super.deselect();
          this.text = "";
        }
        textToDisplayAsHtml() {
          return `<el-select><el-txt>${this.text}</el-txt><el-place>${this.label}</el-place><div class="options">${this.getCompletion()}</div>${(0, frame_helpers_1.helper_pastePopUp)(this)}${this.helpAsHtml()}</el-select>`;
        }
        renderAsSource() {
          return `${this.indent()}`;
        }
        selectorControlKeys = ["d", "O", "v", "?"];
        processKey(e) {
          let codeHasChanged = false;
          let key = e.key;
          if (e.modKey.control && !this.selectorControlKeys.includes(key ?? "")) {
            return super.processKey(e);
          }
          switch (key) {
            case "Backspace": {
              this.text = this.text.substring(0, this.text.length - 1);
              break;
            }
            case "Delete": {
              this.deleteIfPermissible();
              codeHasChanged = true;
              break;
            }
            case "Enter": {
              break;
            }
            case "d": {
              if (e.modKey.control) {
                this.deleteIfPermissible();
                codeHasChanged = true;
                break;
              }
            }
            case "v": {
              if (e.modKey.control) {
                this.paste(e.optionalData ?? "");
                codeHasChanged = true;
                break;
              }
            }
            case "O": {
              if (e.modKey.control) {
                this.expandCollapseAll();
                break;
              }
            }
            case "t": {
              if (e.modKey.alt) {
                this.getFile().removeAllSelectorsThatCanBe();
                break;
              }
            }
            case "?": {
              if (e.modKey.control) {
                this.showHelp();
                break;
              }
            }
            default: {
              if (!key || key.length === 1) {
                key = key?.toLowerCase();
                this.processOptions(key);
                codeHasChanged = true;
              } else {
                codeHasChanged = super.processKey(e);
              }
            }
          }
          return codeHasChanged;
        }
        deleteIfPermissible() {
          if (this.getParent().minimumNumberOfChildrenExceeded()) {
            this.delete();
          }
        }
        paste = (code) => {
          try {
            code = (code ?? "").trim() + "\n";
            const source = new code_source_from_string_1.CodeSourceFromString(code, true);
            const newFrame = this.parseFrom(source);
            if (source.hasMoreCode() && source.getRemainingCode().trim()) {
              const remainingCode = source.getRemainingCode();
              const frame = this.getParent().getChildAfter(newFrame);
              const selector = (0, frame_helpers_1.isSelector)(frame) ? frame : (0, parent_helpers_1.parentHelper_insertOrGotoChildSelector)(this.getParent(), false, frame);
              selector.paste(remainingCode);
            }
          } catch (_e) {
            this.pasteError = `Paste failed: Cannot paste '${code}' into prompt`;
          }
          return true;
        };
        canBePastedIn(frame) {
          return this.optionsMatchingUserInput(frame.initialKeywords()).length === 1;
        }
        processOptions(key) {
          if (this.overtyper.hasNotConsumed(key)) {
            const options = this.optionsMatchingUserInput(this.text + key);
            if (options.length > 1) {
              this.text += this.commonStartText(this.text + key).substring(this.text.length);
            } else if (options.length === 1) {
              const typeToAdd = options[0][0];
              const pendingChars = typeToAdd.slice((this.text + key).length);
              this.addFrame(typeToAdd, pendingChars);
              this.text = "";
            }
          }
        }
        insertPeerSelector(_after) {
          throw new Error("Should never be called on a Selector");
        }
        selectFirstField() {
          this.select(true, false);
          return true;
        }
        selectLastField() {
          this.select(true, false);
          return true;
        }
        worstParseStatusOfFields() {
          return this.text ? status_enums_1.ParseStatus.incomplete : status_enums_1.ParseStatus.valid;
        }
        getContextMenuItems() {
          const map = /* @__PURE__ */ new Map();
          map.set("delete", ["delete (Ctrl-Delete or Ctrl-Backspace)", this.deleteSelected]);
          map.set("paste", ["paste (Ctrl-v)", this.paste]);
          return map;
        }
      };
      exports.AbstractSelector = AbstractSelector;
    }
  });

  // out/src/ide/frames/statements/statement-selector.js
  var require_statement_selector = __commonJS({
    "out/src/ide/frames/statements/statement-selector.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StatementSelector = void 0;
      var keywords_1 = require_keywords();
      var abstract_selector_1 = require_abstract_selector();
      var StatementSelector = class extends abstract_selector_1.AbstractSelector {
        isStatement = true;
        factory;
        constructor(parent) {
          super(parent);
          this.factory = parent.getFactory();
        }
        helpId() {
          return "StatementInstructions";
        }
        defaultOptions() {
          return [
            [keywords_1.assertKeyword, (parent) => this.factory.newAssert(parent)],
            [keywords_1.callKeyword, (parent) => this.factory.newCall(parent)],
            [keywords_1.eachKeyword, (parent) => this.factory.newEach(parent)],
            [keywords_1.elseKeyword, (parent) => this.factory.newElse(parent)],
            [keywords_1.forKeyword, (parent) => this.factory.newFor(parent)],
            [keywords_1.ifKeyword, (parent) => this.factory.newIf(parent)],
            [keywords_1.letKeyword, (parent) => this.factory.newLet(parent)],
            [keywords_1.printKeyword, (parent) => this.factory.newPrint(parent)],
            [keywords_1.repeatKeyword, (parent) => this.factory.newRepeat(parent)],
            [keywords_1.setKeyword, (parent) => this.factory.newSet(parent)],
            [keywords_1.throwKeyword, (parent) => this.factory.newThrow(parent)],
            [keywords_1.tryKeyword, (parent) => this.factory.newTryCatch(parent)],
            [keywords_1.variableKeyword, (parent) => this.factory.newVar(parent)],
            [keywords_1.whileKeyword, (parent) => this.factory.newWhile(parent)],
            [keywords_1.commentMarker, (parent) => this.factory.newComment(parent)]
          ];
        }
        profileAllows(keyword) {
          return this.profile.statements.includes(keyword);
        }
        validWithinCurrentContext(keyword, _userEntry) {
          const parent = this.getParent();
          let result = false;
          if (keyword === keywords_1.elseKeyword) {
            result = parent.getIdPrefix() === keywords_1.ifKeyword;
          } else if (keyword === keywords_1.assertKeyword) {
            return this.isDirectlyWithinATest();
          } else if (keyword === keywords_1.printKeyword || keyword === keywords_1.callKeyword) {
            result = !(this.isWithinAFunction() || this.isDirectlyWithinATest() || this.isWithinAConstructor());
          } else {
            result = true;
          }
          return result;
        }
        isWithinAFunction() {
          return this.isWithinContext(this.getParent(), "func");
        }
        isDirectlyWithinATest() {
          return this.getParent().getIdPrefix() === "test";
        }
        isWithinAConstructor() {
          return this.isWithinContext(this.getParent(), "constructor");
        }
        isWithinContext(parent, parentPrefix) {
          return parent.getIdPrefix() === parentPrefix ? true : parent.hasParent() && this.isWithinContext(parent.getParent(), parentPrefix);
        }
        renderAsHtml() {
          return `<el-statement contenteditable spellcheck="false" class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}${this.textToDisplayAsHtml()}</el-statement>`;
        }
      };
      exports.StatementSelector = StatementSelector;
    }
  });

  // out/src/ide/frames/frame-with-statements.js
  var require_frame_with_statements = __commonJS({
    "out/src/ide/frames/frame-with-statements.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FrameWithStatements = void 0;
      var abstract_frame_1 = require_abstract_frame();
      var regexes_1 = require_regexes();
      var frame_helpers_1 = require_frame_helpers();
      var parent_helpers_1 = require_parent_helpers();
      var assert_statement_1 = require_assert_statement();
      var statement_selector_1 = require_statement_selector();
      var FrameWithStatements = class _FrameWithStatements extends abstract_frame_1.AbstractFrame {
        isFrameWithStatements = true;
        isCollapsible = true;
        isParent = true;
        _children = new Array();
        constructor(parent) {
          super(parent);
          this.getChildren().push(new statement_selector_1.StatementSelector(this));
        }
        getProfile() {
          return this.getFile().getProfile();
        }
        setClasses() {
          super.setClasses();
          this.pushClass(true, "multiline");
        }
        getFactory() {
          return this.getParent().getFactory();
        }
        updateParseStatus() {
          this.getChildren().forEach((c) => c.updateParseStatus());
          const worstOfFieldsOrChildren = Math.min(this.worstParseStatusOfFields(), (0, parent_helpers_1.parentHelper_readWorstParseStatusOfChildren)(this));
          this.setParseStatus(worstOfFieldsOrChildren);
        }
        readCompileStatus() {
          const worstOfFieldsOrChildren = Math.min(this.worstCompileStatusOfFields(), (0, parent_helpers_1.parentHelper_readWorstCompileStatusOfChildren)(this));
          const newStatus = Math.min(super.readCompileStatus(), worstOfFieldsOrChildren);
          return newStatus;
        }
        getChildren() {
          return this._children;
        }
        minimumNumberOfChildrenExceeded() {
          return this.getChildren().length > 1;
        }
        expandCollapse() {
          if (this.isCollapsed()) {
            this.expand();
          } else {
            this.collapse();
          }
        }
        newChildSelector() {
          return new statement_selector_1.StatementSelector(this);
        }
        insertOrGotoChildSelector(after, child) {
          (0, parent_helpers_1.parentHelper_insertOrGotoChildSelector)(this, after, child);
        }
        insertSelectorAfterLastField() {
          const firstChild = this._children[0];
          if ((0, frame_helpers_1.isSelector)(firstChild)) {
            firstChild.select(true, false);
          } else {
            const selector = this.newChildSelector();
            this.addChildBefore(selector, firstChild);
            selector.select(true, false);
          }
        }
        selectNextFrame() {
          this._children[0]?.select(true, false);
        }
        removeChild(child) {
          (0, parent_helpers_1.parentHelper_removeChild)(this, child);
        }
        getFirstChild() {
          return (0, parent_helpers_1.parentHelper_getFirstChild)(this);
        }
        getLastChild() {
          return (0, parent_helpers_1.parentHelper_getLastChild)(this);
        }
        getChildAfter(child) {
          return (0, parent_helpers_1.parentHelper_getChildAfter)(this, child);
        }
        getChildBefore(child) {
          return (0, parent_helpers_1.parentHelper_getChildBefore)(this, child);
        }
        getChildRange(first, last) {
          return (0, parent_helpers_1.parentHelper_getChildRange)(this, first, last);
        }
        getFirstSelectorAsDirectChild() {
          return (0, parent_helpers_1.parentHelper_getFirstSelectorAsDirectChild)(this);
        }
        selectFirstChild(multiSelect) {
          return (0, parent_helpers_1.parentHelper_selectFirstChild)(this, multiSelect);
        }
        addChildBefore(child, before) {
          this.hasBeenAddedTo();
          (0, parent_helpers_1.parentHelper_addChildBefore)(this, child, before);
        }
        addChildAfter(child, before) {
          this.hasBeenAddedTo();
          (0, parent_helpers_1.parentHelper_addChildAfter)(this, child, before);
        }
        renderChildrenAsHtml() {
          return this.isImported() ? "" : (0, parent_helpers_1.parentHelper_renderChildrenAsHtml)(this);
        }
        renderChildrenAsSource() {
          return (0, parent_helpers_1.parentHelper_renderChildrenAsSource)(this);
        }
        selectFirstField() {
          let result = super.selectFirstField();
          if (!result) {
            result = this.getChildren()[0].selectFirstField();
          }
          return result;
        }
        selectFirstChildIfAny() {
          let result = false;
          if (this.getChildren().length > 0) {
            this.getChildren()[0].select(true, false);
            result = true;
          }
          return result;
        }
        deleteSelectedChildren() {
          (0, parent_helpers_1.parentHelper_deleteSelectedChildren)(this);
        }
        copySelectedChildren() {
          return (0, parent_helpers_1.parentHelper_copySelectedChildren)(this);
        }
        moveSelectedChildrenUpOne() {
          (0, parent_helpers_1.parentHelper_moveSelectedChildrenUpOne)(this);
        }
        moveSelectedChildrenDownOne() {
          (0, parent_helpers_1.parentHelper_moveSelectedChildrenDownOne)(this);
        }
        parseFrom(source) {
          this.parseTop(source);
          while (!this.parseBottom(source)) {
            if (source.isMatchRegEx(regexes_1.Regexes.newLine)) {
              source.removeRegEx(regexes_1.Regexes.newLine, false);
            } else {
              this.getFirstSelectorAsDirectChild().parseFrom(source);
            }
            source.removeIndent();
          }
        }
        parseStandardEnding(source, keywords) {
          source.removeIndent();
          let result = false;
          if (source.isMatch(keywords)) {
            source.remove(keywords);
            result = true;
          }
          return result;
        }
        multipleIds(sid) {
          return sid.includes(",") || sid.includes(":");
        }
        getAsserts() {
          const children = this.getChildren();
          let asserts = children.filter((c) => c instanceof assert_statement_1.AssertStatement && !c.isGhosted());
          for (const f of children.filter((c) => c instanceof _FrameWithStatements)) {
            asserts = asserts.concat(f.getAsserts());
          }
          return asserts;
        }
        updateBreakpoints(event) {
          super.updateBreakpoints(event);
          (0, parent_helpers_1.parentHelper_updateBreakpoints)(this, event);
        }
        ghostSelectedChildren() {
          (0, parent_helpers_1.setGhostOnSelectedChildren)(this, true);
        }
        unghostSelectedChildren() {
          (0, parent_helpers_1.setGhostOnSelectedChildren)(this, false);
        }
      };
      exports.FrameWithStatements = FrameWithStatements;
    }
  });

  // out/src/ide/frames/class-members/constructor.js
  var require_constructor = __commonJS({
    "out/src/ide/frames/class-members/constructor.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Constructor = void 0;
      var keywords_1 = require_keywords();
      var param_list_field_1 = require_param_list_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var Constructor = class extends frame_with_statements_1.FrameWithStatements {
        isConstructor = true;
        isMember = true;
        isAbstract = false;
        private = false;
        params;
        constructor(parent) {
          super(parent);
          this.params = new param_list_field_1.ParamListField(this, false);
        }
        initialKeywords() {
          return keywords_1.constructorKeyword;
        }
        getFields() {
          return [this.params];
        }
        getIdPrefix() {
          return "constructor";
        }
        renderAsHtml() {
          return `<el-constructor class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>constructor</el-kw><el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc>${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end constructor</el-kw>
</el-constructor>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}constructor(${this.params.renderAsSource()})\r
${this.renderChildrenAsSource()}\r
${this.indent()}end constructor\r
`;
        }
        parseTop(source) {
          source.removeIndent();
          source.remove("constructor(");
          this.params.parseFrom(source);
          source.remove(")");
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, "end constructor");
        }
      };
      exports.Constructor = Constructor;
    }
  });

  // out/src/ide/frames/fields/method-name-field.js
  var require_method_name_field = __commonJS({
    "out/src/ide/frames/fields/method-name-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MethodNameField = void 0;
      var method_name_node_1 = require_method_name_node();
      var abstract_field_1 = require_abstract_field();
      var MethodNameField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>name</i>");
        }
        helpId() {
          return "MethodNameField";
        }
        initialiseRoot() {
          this.rootNode = new method_name_node_1.MethodNameNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/[^a-zA-Z0-9_]/);
        getIdPrefix() {
          return "ident";
        }
        isEndMarker(key) {
          return key === " " || key === "(";
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.MethodNameField = MethodNameField;
    }
  });

  // out/src/ide/frames/statements/return-statement.js
  var require_return_statement = __commonJS({
    "out/src/ide/frames/statements/return-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ReturnStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var expression_field_1 = require_expression_field();
      var ReturnStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        isReturnStatement = true;
        expr;
        constructor(parent) {
          super(parent);
          this.ghostable = false;
          this.expr = new expression_field_1.ExpressionField(this);
        }
        initialKeywords() {
          return keywords_1.returnKeyword;
        }
        isDeletable() {
          return false;
        }
        isMovable() {
          return false;
        }
        getFields() {
          return [this.expr];
        }
        getIdPrefix() {
          return "return";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-kw>return </el-kw>${this.expr.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}return ${this.expr.renderAsSource()}`;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("return ");
          this.expr.parseFrom(source);
        }
        canInsertAfter() {
          return false;
        }
      };
      exports.ReturnStatement = ReturnStatement;
    }
  });

  // out/src/ide/frames/globals/function-frame.js
  var require_function_frame = __commonJS({
    "out/src/ide/frames/globals/function-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FunctionFrame = void 0;
      var keywords_1 = require_keywords();
      var method_name_field_1 = require_method_name_field();
      var param_list_field_1 = require_param_list_field();
      var type_field_1 = require_type_field();
      var frame_helpers_1 = require_frame_helpers();
      var frame_with_statements_1 = require_frame_with_statements();
      var return_statement_1 = require_return_statement();
      var FunctionFrame = class extends frame_with_statements_1.FrameWithStatements {
        name;
        params;
        returnType;
        file;
        isFunction = true;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.name = new method_name_field_1.MethodNameField(this);
          this.params = new param_list_field_1.ParamListField(this, false);
          this.returnType = new type_field_1.TypeField(this);
          this.getChildren().push(new return_statement_1.ReturnStatement(this));
        }
        initialKeywords() {
          return keywords_1.functionKeyword;
        }
        getProfile() {
          return this.getFile().getProfile();
        }
        minimumNumberOfChildrenExceeded() {
          return this.getChildren().length > 1;
        }
        getFields() {
          return [this.name, this.params, this.returnType];
        }
        getIdPrefix() {
          return "func";
        }
        renderAsHtml() {
          return `<el-func class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>${keywords_1.functionKeyword} </el-kw>${this.name.renderAsHtml()}<el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc><el-kw> ${keywords_1.returnsKeyword} </el-kw>${this.returnType.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>${keywords_1.endKeyword} ${keywords_1.functionKeyword}</el-kw>
</el-func>`;
        }
        parseTop(source) {
          source.remove(`${keywords_1.functionKeyword} `);
          this.name.parseFrom(source);
          source.remove("(");
          this.params.parseFrom(source);
          source.remove(`) ${keywords_1.returnsKeyword} `);
          this.returnType.parseFrom(source);
        }
        parseBottom(source) {
          let result = false;
          const keyword = `${keywords_1.returnKeyword} `;
          source.removeIndent();
          if (source.isMatch(keyword)) {
            this.getReturnStatement().parseFrom(source);
            source.removeNewLine().removeIndent();
            this.parseStandardEnding(source, `${keywords_1.endKeyword} ${keywords_1.functionKeyword}`);
            result = true;
          }
          return result;
        }
        getReturnStatement() {
          return this.getChildren().filter((s) => (0, frame_helpers_1.isReturnStatement)(s))[0];
        }
      };
      exports.FunctionFrame = FunctionFrame;
    }
  });

  // out/src/ide/frames/class-members/function-method.js
  var require_function_method = __commonJS({
    "out/src/ide/frames/class-members/function-method.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FunctionMethod = void 0;
      var keywords_1 = require_keywords();
      var frame_helpers_1 = require_frame_helpers();
      var function_frame_1 = require_function_frame();
      var FunctionMethod = class extends function_frame_1.FunctionFrame {
        isMember = true;
        private;
        isAbstract = false;
        constructor(parent, priv = false) {
          super(parent);
          this.private = priv;
        }
        helpId() {
          return "function_method";
        }
        modifierAsHtml() {
          return this.private ? `<el-kw>private </el-kw>` : "";
        }
        modifierAsSource() {
          return this.private ? `private ` : "";
        }
        indent() {
          return (0, frame_helpers_1.singleIndent)();
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${this.modifierAsSource()}${keywords_1.functionKeyword} ${this.name.renderAsSource()}(${this.params.renderAsSource()}) ${keywords_1.returnsKeyword} ${this.returnType.renderAsSource()}\r
${this.renderChildrenAsSource()}\r
${this.indent()}${keywords_1.endKeyword} ${keywords_1.functionKeyword}\r
`;
        }
        renderAsHtml() {
          return `<el-func class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand>${this.modifierAsHtml()}<el-kw>${keywords_1.functionKeyword} </el-kw>${this.name.renderAsHtml()}<el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc><el-kw> ${keywords_1.returnsKeyword} </el-kw>${this.returnType.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>${keywords_1.endKeyword} ${keywords_1.functionKeyword}</el-kw>
</el-func>`;
        }
        parseTop(source) {
          source.removeIndent();
          const priv = `${keywords_1.privateKeyword} `;
          if (source.isMatch(priv)) {
            source.remove(priv);
            this.private = true;
          }
          super.parseTop(source);
        }
        parseBottom(source) {
          return super.parseBottom(source);
        }
        makePublic = () => {
          this.private = false;
          return true;
        };
        makePrivate = () => {
          this.private = true;
          return true;
        };
        getContextMenuItems() {
          const map = super.getContextMenuItems();
          (0, frame_helpers_1.addPrivateToggleToContextMenu)(this, map);
          return map;
        }
        processKey(e) {
          if (e.modKey.control && e.key === "p") {
            return (0, frame_helpers_1.togglePrivatePublic)(this);
          }
          return super.processKey(e);
        }
      };
      exports.FunctionMethod = FunctionMethod;
    }
  });

  // out/src/ide/frames/class-members/member-selector.js
  var require_member_selector = __commonJS({
    "out/src/ide/frames/class-members/member-selector.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MemberSelector = void 0;
      var keywords_1 = require_keywords();
      var abstract_selector_1 = require_abstract_selector();
      var frame_helpers_1 = require_frame_helpers();
      var MemberSelector = class extends abstract_selector_1.AbstractSelector {
        isMember = true;
        isAbstract = false;
        private = false;
        class;
        constructor(parent) {
          super(parent);
          this.class = parent;
        }
        helpId() {
          return "MemberInstructions";
        }
        getClass() {
          return this.getParent();
        }
        defaultOptions() {
          const options = [
            [keywords_1.constructorKeyword, (_parent) => this.class.createConstructor()],
            [keywords_1.propertyKeyword, (_parent) => this.class.createProperty()],
            [keywords_1.procedureKeyword, (_parent) => this.class.createProcedure()],
            [keywords_1.functionKeyword, (_parent) => this.class.createFunction()],
            [keywords_1.abstractPropertyKeywords, (_parent) => this.class.createAbstractProperty()],
            [keywords_1.abstractProcedureKeywords, (_parent) => this.class.createAbstractProcedure()],
            [keywords_1.abstractFunctionKeywords, (_parent) => this.class.createAbstractFunction()],
            [keywords_1.privatePropertyKeywords, (_parent) => this.class.createProperty(true)],
            [keywords_1.privateProcedureKeywords, (_parent) => this.class.createProcedure(true)],
            [keywords_1.privateFunctionKeywords, (_parent) => this.class.createFunction(true)],
            [keywords_1.commentMarker, (_parent) => this.class.createComment()]
          ];
          return options;
        }
        profileAllows(keyword) {
          return this.profile.class_members.includes(keyword);
        }
        validWithinCurrentContext(keyword, _userEntry) {
          let result = false;
          if (keyword.startsWith(keywords_1.abstractKeyword)) {
            result = this.class.isAbstract || this.class.isInterface;
          } else if (this.class.isInterface) {
            result = keyword === keywords_1.commentMarker;
          } else if (this.class.isRecord) {
            result = keyword === keywords_1.propertyKeyword || keyword === keywords_1.functionKeyword || keyword === keywords_1.commentMarker;
          } else if (keyword === keywords_1.constructorKeyword) {
            result = this.class.isConcrete && !this.getClass().getConstructor();
          } else {
            result = true;
          }
          return result;
        }
        renderAsHtml() {
          return `<el-member contenteditable spellcheck="false" class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.textToDisplayAsHtml()}</el-member>`;
        }
        indent() {
          return (0, frame_helpers_1.singleIndent)();
        }
      };
      exports.MemberSelector = MemberSelector;
    }
  });

  // out/src/ide/frames/globals/procedure-frame.js
  var require_procedure_frame = __commonJS({
    "out/src/ide/frames/globals/procedure-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProcedureFrame = void 0;
      var keywords_1 = require_keywords();
      var method_name_field_1 = require_method_name_field();
      var param_list_field_1 = require_param_list_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var ProcedureFrame = class extends frame_with_statements_1.FrameWithStatements {
        name;
        params;
        file;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.name = new method_name_field_1.MethodNameField(this);
          this.params = new param_list_field_1.ParamListField(this, true);
        }
        isProcedure = true;
        initialKeywords() {
          return keywords_1.procedureKeyword;
        }
        getFields() {
          return [this.name, this.params];
        }
        getIdPrefix() {
          return "proc";
        }
        renderAsHtml() {
          return `<el-proc class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>procedure </el-kw>${this.name.renderAsHtml()}<el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc>${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end procedure</el-kw>
</el-proc>`;
        }
        parseTop(source) {
          source.remove("procedure ");
          this.name.parseFrom(source);
          source.remove("(");
          this.params.parseFrom(source);
          source.remove(")");
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, "end procedure");
        }
      };
      exports.ProcedureFrame = ProcedureFrame;
    }
  });

  // out/src/ide/frames/class-members/procedure-method.js
  var require_procedure_method = __commonJS({
    "out/src/ide/frames/class-members/procedure-method.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProcedureMethod = void 0;
      var keywords_1 = require_keywords();
      var frame_helpers_1 = require_frame_helpers();
      var procedure_frame_1 = require_procedure_frame();
      var ProcedureMethod = class extends procedure_frame_1.ProcedureFrame {
        isMember = true;
        private;
        isAbstract = false;
        constructor(parent, priv = false) {
          super(parent);
          this.private = priv;
        }
        helpId() {
          return "procedure_method";
        }
        modifierAsHtml() {
          return this.private ? `<el-kw>private </el-kw>` : "";
        }
        modifierAsSource() {
          return this.private ? `private ` : "";
        }
        indent() {
          return (0, frame_helpers_1.singleIndent)();
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${this.modifierAsSource()}procedure ${this.name.renderAsSource()}(${this.params.renderAsSource()})\r
${this.renderChildrenAsSource()}\r
${this.indent()}end procedure\r
`;
        }
        renderAsHtml() {
          return `<el-proc class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand>${this.modifierAsHtml()}<el-kw>procedure </el-kw>${this.name.renderAsHtml()}<el-punc>(</el-punc>${this.params.renderAsHtml()}<el-punc>)</el-punc>${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end procedure</el-kw>
</el-proc>`;
        }
        parseTop(source) {
          source.removeIndent();
          const priv = `${keywords_1.privateKeyword} `;
          if (source.isMatch(priv)) {
            source.remove(priv);
            this.private = true;
          }
          return super.parseTop(source);
        }
        parseBottom(source) {
          return super.parseBottom(source);
        }
        makePublic = () => {
          this.private = false;
          return true;
        };
        makePrivate = () => {
          this.private = true;
          return true;
        };
        getContextMenuItems() {
          const map = super.getContextMenuItems();
          (0, frame_helpers_1.addPrivateToggleToContextMenu)(this, map);
          return map;
        }
        processKey(e) {
          if (e.modKey.control && e.key === "p") {
            return (0, frame_helpers_1.togglePrivatePublic)(this);
          }
          return super.processKey(e);
        }
      };
      exports.ProcedureMethod = ProcedureMethod;
    }
  });

  // out/src/ide/frames/class-members/property.js
  var require_property = __commonJS({
    "out/src/ide/frames/class-members/property.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Property = void 0;
      var keywords_1 = require_keywords();
      var class_type_1 = require_class_type();
      var abstract_frame_1 = require_abstract_frame();
      var identifier_field_1 = require_identifier_field();
      var type_field_1 = require_type_field();
      var frame_helpers_1 = require_frame_helpers();
      var Property = class extends abstract_frame_1.AbstractFrame {
        isMember = true;
        isProperty = true;
        isAbstract = false;
        name;
        type;
        private = false;
        constructor(parent, priv = false) {
          super(parent);
          this.name = new identifier_field_1.IdentifierField(this);
          this.type = new type_field_1.TypeField(this);
          this.private = priv;
          this.canHaveBreakPoint = false;
        }
        initialKeywords() {
          return keywords_1.propertyKeyword;
        }
        getFields() {
          return [this.name, this.type];
        }
        getIdPrefix() {
          return "prop";
        }
        modifierAsHtml() {
          return this.private ? `<el-kw>private </el-kw>` : "";
        }
        modifierAsSource() {
          return this.private ? `private ` : "";
        }
        renderAsHtml() {
          return `<el-prop class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.modifierAsHtml()}<el-kw>${keywords_1.propertyKeyword} </el-kw>${this.name.renderAsHtml()}<el-kw> ${keywords_1.asKeyword} </el-kw>${this.type.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-prop>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${this.modifierAsSource()}${keywords_1.propertyKeyword} ${this.name.renderAsSource()} ${keywords_1.asKeyword} ${this.type.renderAsSource()}\r
`;
        }
        isGlobalClass(st) {
          return st instanceof class_type_1.ClassType && !st.typeOptions.isIndexable;
        }
        parseFrom(source) {
          source.removeIndent();
          const priv = `${keywords_1.privateKeyword} `;
          if (source.isMatch(priv)) {
            source.remove(priv);
            this.private = true;
          }
          source.remove(`${keywords_1.propertyKeyword} `);
          this.name.parseFrom(source);
          source.remove(` ${keywords_1.asKeyword} `);
          this.type.parseFrom(source);
        }
        makePublic = () => {
          this.private = false;
          return true;
        };
        makePrivate = () => {
          this.private = true;
          return true;
        };
        getContextMenuItems() {
          const map = super.getContextMenuItems();
          (0, frame_helpers_1.addPrivateToggleToContextMenu)(this, map);
          return map;
        }
        processKey(e) {
          if (e.modKey.control && e.key === "p") {
            return (0, frame_helpers_1.togglePrivatePublic)(this);
          }
          return super.processKey(e);
        }
      };
      exports.Property = Property;
    }
  });

  // out/src/ide/frames/parse-nodes/inheritanceNode.js
  var require_inheritanceNode = __commonJS({
    "out/src/ide/frames/parse-nodes/inheritanceNode.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.InheritanceNode = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var csv_1 = require_csv();
      var keyword_node_1 = require_keyword_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var space_node_1 = require_space_node();
      var type_node_1 = require_type_node();
      var InheritanceNode = class extends abstract_sequence_1.AbstractSequence {
        inherits;
        typeList;
        parseText(text) {
          if (text.length > 0) {
            this.inherits = new keyword_node_1.KeywordNode(keywords_1.inheritsKeyword);
            this.addElement(this.inherits);
            this.addElement(new space_node_1.SpaceNode(parse_node_helpers_1.Space.required));
            this.typeList = new csv_1.CSV(() => new type_node_1.TypeNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.type_abstract])), 1);
            this.typeList.setSyntaxCompletionWhenEmpty("Type(s) - comma-separated");
            this.addElement(this.typeList);
            super.parseText(text);
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.inheritsKeyword)]) : super.symbolCompletion_keywords();
        }
      };
      exports.InheritanceNode = InheritanceNode;
    }
  });

  // out/src/ide/frames/fields/inherits-from-field.js
  var require_inherits_from_field = __commonJS({
    "out/src/ide/frames/fields/inherits-from-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.InheritsFromField = void 0;
      var inheritanceNode_1 = require_inheritanceNode();
      var abstract_field_1 = require_abstract_field();
      var InheritsFromField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setOptional(true);
          this.setPlaceholder("<i>inherits ClassName(s)</i>");
        }
        helpId() {
          return "InheritsFromField";
        }
        getIdPrefix() {
          return "text";
        }
        initialiseRoot() {
          this.rootNode = new inheritanceNode_1.InheritanceNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToEndOfLine();
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.InheritsFromField = InheritsFromField;
    }
  });

  // out/src/ide/frames/fields/type-name-field.js
  var require_type_name_field = __commonJS({
    "out/src/ide/frames/fields/type-name-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TypeNameField = void 0;
      var type_name_node_1 = require_type_name_node();
      var abstract_field_1 = require_abstract_field();
      var TypeNameField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.useHtmlTags = true;
          this.placeholder = "Name";
        }
        helpId() {
          return "TypeNameField";
        }
        initialiseRoot() {
          this.rootNode = new type_name_node_1.TypeNameNode(/* @__PURE__ */ new Set());
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/[^a-zA-Z0-9_]/);
        getIdPrefix() {
          return "type";
        }
        textAsHtml() {
          if (this.selected) {
            return super.textAsHtml();
          } else {
            return `<el-type>${this.text}</el-type>`;
          }
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.TypeNameField = TypeNameField;
    }
  });

  // out/src/ide/frames/parse-nodes/comment-node.js
  var require_comment_node = __commonJS({
    "out/src/ide/frames/parse-nodes/comment-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CommentNode = void 0;
      var regexes_1 = require_regexes();
      var regex_match_node_1 = require_regex_match_node();
      var CommentNode = class extends regex_match_node_1.RegExMatchNode {
        constructor() {
          super(regexes_1.Regexes.anythingToNewLineAsRegExp);
        }
      };
      exports.CommentNode = CommentNode;
    }
  });

  // out/src/ide/frames/fields/comment-field.js
  var require_comment_field = __commonJS({
    "out/src/ide/frames/fields/comment-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CommentField = void 0;
      var frame_helpers_1 = require_frame_helpers();
      var comment_node_1 = require_comment_node();
      var status_enums_1 = require_status_enums();
      var abstract_field_1 = require_abstract_field();
      var CommentField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setOptional(true);
          this.setPlaceholder("<i>comment</i>");
        }
        helpId() {
          return "CommentField";
        }
        initialiseRoot() {
          this.rootNode = new comment_node_1.CommentNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToEndOfLine();
        getIdPrefix() {
          return "comment";
        }
        renderAsHtml() {
          const txt = this.isSelected() ? this.textAsHtml() : this.handleLeadingAndMultipleSpaces((0, frame_helpers_1.escapeHtmlChars)(this.textAsHtml()));
          return `<el-field id="${this.htmlId}" class="${this.cls()}" tabindex="-1"><el-txt>${txt}</el-txt><el-place>${this.placeholder}</el-place><el-compl>${this.getCompletion()}</el-compl>${this.getMessage()}${this.helpAsHtml()}</el-field>`;
        }
        // Converts leading spaces to &nbsp; and multi-spaces to a space + &nbsp;s
        handleLeadingAndMultipleSpaces(raw) {
          const words = raw.split(" ");
          const withNbsp = words.map((w) => w === "" ? "&nbsp;" : w + " ");
          return withNbsp.join("").trimEnd();
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
        //Overridden to avoid trimming
        parseCompleteTextUsingNode(text, root) {
          if (text.length === 0) {
            this.setParseStatus(this.isOptional() ? status_enums_1.ParseStatus.valid : status_enums_1.ParseStatus.incomplete);
          } else {
            root.parseText(text);
            this.setParseStatus(root.status);
            this.text = root.renderAsSource();
          }
        }
      };
      exports.CommentField = CommentField;
    }
  });

  // out/src/ide/frames/statements/comment-statement.js
  var require_comment_statement = __commonJS({
    "out/src/ide/frames/statements/comment-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CommentStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var comment_field_1 = require_comment_field();
      var CommentStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        isMember = true;
        isAbstract = false;
        private = false;
        text;
        constructor(parent) {
          super(parent);
          this.text = new comment_field_1.CommentField(this);
        }
        initialKeywords() {
          return keywords_1.commentMarker;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("# ");
          this.text.parseFrom(source);
          source.removeNewLine();
        }
        getFields() {
          return [this.text];
        }
        getIdPrefix() {
          return "com";
        }
        renderAsHtml() {
          return `<el-statement>${this.contextMenu()}${this.bpAsHtml()}<el-comment class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}><el-top>${this.bpAsHtml()}<el-kw># </el-kw>${this.text.renderAsHtml()}</el-top></el-comment></el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}# ${this.text.renderAsSource()}`;
        }
        deleteIfPermissible() {
          this.insertNewSelectorIfNecessary();
          this.delete();
        }
      };
      exports.CommentStatement = CommentStatement;
    }
  });

  // out/src/ide/frames/globals/class-frame.js
  var require_class_frame = __commonJS({
    "out/src/ide/frames/globals/class-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ClassFrame = void 0;
      var keywords_1 = require_keywords();
      var class_type_1 = require_class_type();
      var abstract_frame_1 = require_abstract_frame();
      var abstract_function_1 = require_abstract_function();
      var abstract_procedure_1 = require_abstract_procedure();
      var abstract_property_1 = require_abstract_property();
      var constructor_1 = require_constructor();
      var function_method_1 = require_function_method();
      var member_selector_1 = require_member_selector();
      var procedure_method_1 = require_procedure_method();
      var property_1 = require_property();
      var inherits_from_field_1 = require_inherits_from_field();
      var regexes_1 = require_regexes();
      var type_name_field_1 = require_type_name_field();
      var frame_helpers_1 = require_frame_helpers();
      var parent_helpers_1 = require_parent_helpers();
      var comment_statement_1 = require_comment_statement();
      var ClassFrame = class extends abstract_frame_1.AbstractFrame {
        isCollapsible = true;
        isParent = true;
        isClass = true;
        isAbstract = false;
        isConcrete = false;
        isRecord = false;
        isInterface = false;
        name;
        isNotInheritable = false;
        inheritance;
        _children = new Array();
        constructor(parent) {
          super(parent);
          this.name = new type_name_field_1.TypeNameField(this);
          this.inheritance = new inherits_from_field_1.InheritsFromField(this);
          this.getChildren().push(new member_selector_1.MemberSelector(this));
          this.canHaveBreakPoint = false;
        }
        updateOfTypes(_ofTypes) {
          return this;
        }
        get subType() {
          if (this.isInterface) {
            return class_type_1.ClassSubType.interface;
          }
          if (this.isAbstract) {
            return class_type_1.ClassSubType.abstract;
          }
          return class_type_1.ClassSubType.concrete;
        }
        getFile() {
          return this.getParent();
        }
        initialKeywords() {
          return keywords_1.classKeyword;
        }
        getProfile() {
          return this.getFile().getProfile();
        }
        setClasses() {
          super.setClasses();
          this.pushClass(true, "multiline");
        }
        updateParseStatus() {
          this.getChildren().forEach((c) => c.updateParseStatus());
          const worstOfFieldOrChildParseStatus = Math.min(this.worstParseStatusOfFields(), (0, parent_helpers_1.parentHelper_readWorstParseStatusOfChildren)(this));
          this.setParseStatus(worstOfFieldOrChildParseStatus);
        }
        readCompileStatus() {
          const worstOfChildren = (0, parent_helpers_1.parentHelper_readWorstCompileStatusOfChildren)(this);
          const newStatus = Math.min(super.readCompileStatus(), worstOfChildren);
          return newStatus;
        }
        getFactory() {
          return this.getParent().getFactory();
        }
        getChildren() {
          return this._children;
        }
        getFirstChild() {
          return (0, parent_helpers_1.parentHelper_getFirstChild)(this);
        }
        getLastChild() {
          return (0, parent_helpers_1.parentHelper_getLastChild)(this);
        }
        getChildAfter(child) {
          return (0, parent_helpers_1.parentHelper_getChildAfter)(this, child);
        }
        getChildBefore(child) {
          return (0, parent_helpers_1.parentHelper_getChildBefore)(this, child);
        }
        getChildRange(first, last) {
          return (0, parent_helpers_1.parentHelper_getChildRange)(this, first, last);
        }
        getFirstSelectorAsDirectChild() {
          return (0, parent_helpers_1.parentHelper_getFirstSelectorAsDirectChild)(this);
        }
        addChildBefore(child, before) {
          (0, parent_helpers_1.parentHelper_addChildBefore)(this, child, before);
        }
        addChildAfter(child, before) {
          (0, parent_helpers_1.parentHelper_addChildAfter)(this, child, before);
        }
        removeChild(child) {
          (0, parent_helpers_1.parentHelper_removeChild)(this, child);
        }
        insertOrGotoChildSelector(after, child) {
          (0, parent_helpers_1.parentHelper_insertOrGotoChildSelector)(this, after, child);
        }
        deleteSelectedChildren() {
          (0, parent_helpers_1.parentHelper_deleteSelectedChildren)(this);
        }
        copySelectedChildren() {
          return (0, parent_helpers_1.parentHelper_copySelectedChildren)(this);
        }
        moveSelectedChildrenUpOne() {
          (0, parent_helpers_1.parentHelper_moveSelectedChildrenUpOne)(this);
        }
        moveSelectedChildrenDownOne() {
          (0, parent_helpers_1.parentHelper_moveSelectedChildrenDownOne)(this);
        }
        fieldUpdated(_field) {
        }
        minimumNumberOfChildrenExceeded() {
          return this.getChildren().length > 1;
        }
        selectNextFrame() {
          this._children[0]?.select(true, false);
        }
        doesInherit() {
          return this.inheritance.text !== "";
        }
        getFields() {
          return [this.name, this.inheritance];
        }
        getIdPrefix() {
          return "class";
        }
        inheritanceAsHtml() {
          return ` ${this.inheritance.renderAsHtml()}`;
        }
        inheritanceAsSource() {
          return this.doesInherit() ? ` ${this.inheritance.renderAsSource()}` : ``;
        }
        indent() {
          return "";
        }
        properties() {
          return this.getChildren().filter((c) => c instanceof property_1.Property || c instanceof abstract_property_1.AbstractProperty);
        }
        seenTwice(name, seenNames) {
          return seenNames.filter((s) => s === name).length > 1;
        }
        createConstructor() {
          return new constructor_1.Constructor(this);
        }
        createFunction(priv = false) {
          return new function_method_1.FunctionMethod(this, priv);
        }
        createProperty(priv = false) {
          return new property_1.Property(this, priv);
        }
        createProcedure(priv = false) {
          return new procedure_method_1.ProcedureMethod(this, priv);
        }
        createAbstractFunction() {
          return new abstract_function_1.AbstractFunction(this);
        }
        createAbstractProperty() {
          return new abstract_property_1.AbstractProperty(this);
        }
        createAbstractProcedure() {
          return new abstract_procedure_1.AbstractProcedure(this);
        }
        createComment() {
          return new comment_statement_1.CommentStatement(this);
        }
        getConstructor() {
          return this.getChildren().filter((m) => (0, frame_helpers_1.isConstructor)(m))[0];
        }
        parseFrom(source) {
          this.parseTop(source);
          while (!this.parseBottom(source)) {
            if (source.isMatchRegEx(regexes_1.Regexes.newLine)) {
              source.removeRegEx(regexes_1.Regexes.newLine, false);
              source.removeIndent();
            } else {
              this.getFirstSelectorAsDirectChild().parseFrom(source);
            }
          }
        }
        parseTop(source) {
          source.remove(this.topKeywords());
          this.name.parseFrom(source);
          this.inheritance.parseFrom(source);
          return true;
        }
        parseBottom(source) {
          let result = false;
          source.removeIndent();
          if (source.isMatch(this.bottomKeywords())) {
            source.remove(this.bottomKeywords());
            result = true;
          }
          return result;
        }
        newChildSelector() {
          return new member_selector_1.MemberSelector(this);
        }
        getClassIndex() {
          return this.getParent().getChildren().indexOf(this);
        }
        updateBreakpoints(event) {
          super.updateBreakpoints(event);
          (0, parent_helpers_1.parentHelper_updateBreakpoints)(this, event);
        }
        ghostSelectedChildren() {
          (0, parent_helpers_1.setGhostOnSelectedChildren)(this, true);
        }
        unghostSelectedChildren() {
          (0, parent_helpers_1.setGhostOnSelectedChildren)(this, false);
        }
      };
      exports.ClassFrame = ClassFrame;
    }
  });

  // out/src/ide/frames/globals/abstract-class.js
  var require_abstract_class = __commonJS({
    "out/src/ide/frames/globals/abstract-class.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractClass = void 0;
      var keywords_1 = require_keywords();
      var parent_helpers_1 = require_parent_helpers();
      var class_frame_1 = require_class_frame();
      var AbstractClass = class extends class_frame_1.ClassFrame {
        constructor(parent) {
          super(parent);
          this.isAbstract = true;
        }
        initialKeywords() {
          return keywords_1.abstractClassKeywords;
        }
        doesInherit() {
          return this.inheritance.text !== "";
        }
        getFields() {
          return [this.name, this.inheritance];
        }
        getIdPrefix() {
          return "class";
        }
        renderAsHtml() {
          return `<el-class class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>abstract class </el-kw>${this.name.renderAsHtml()}${this.inheritanceAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${(0, parent_helpers_1.parentHelper_renderChildrenAsHtml)(this)}
<el-kw>end class</el-kw>
</el-class>`;
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}abstract class ${this.name.renderAsSource()}${this.inheritanceAsSource()}\r
${(0, parent_helpers_1.parentHelper_renderChildrenAsSource)(this)}\r
end class\r
`;
        }
        topKeywords() {
          return `${keywords_1.abstractClassKeywords} `;
        }
        bottomKeywords() {
          return `${keywords_1.endKeyword} ${keywords_1.classKeyword}`;
        }
      };
      exports.AbstractClass = AbstractClass;
    }
  });

  // out/src/ide/frames/globals/concrete-class.js
  var require_concrete_class = __commonJS({
    "out/src/ide/frames/globals/concrete-class.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ConcreteClass = void 0;
      var keywords_1 = require_keywords();
      var parent_helpers_1 = require_parent_helpers();
      var class_frame_1 = require_class_frame();
      var ConcreteClass = class extends class_frame_1.ClassFrame {
        constructor(parent) {
          super(parent);
          this.isConcrete = true;
        }
        initialKeywords() {
          return keywords_1.classKeyword;
        }
        doesInherit() {
          return this.inheritance.text !== "";
        }
        getFields() {
          return [this.name, this.inheritance];
        }
        getIdPrefix() {
          return "class";
        }
        renderAsHtml() {
          return `<el-class class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>class </el-kw>${this.name.renderAsHtml()}${this.inheritanceAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${(0, parent_helpers_1.parentHelper_renderChildrenAsHtml)(this)}
<el-kw>end class</el-kw>
</el-class>`;
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}class ${this.name.renderAsSource()}${this.inheritanceAsSource()}\r
${(0, parent_helpers_1.parentHelper_renderChildrenAsSource)(this)}\r
end class\r
`;
        }
        topKeywords() {
          return `${keywords_1.classKeyword} `;
        }
        bottomKeywords() {
          return `${keywords_1.endKeyword} ${keywords_1.classKeyword}`;
        }
      };
      exports.ConcreteClass = ConcreteClass;
    }
  });

  // out/src/ide/frames/parse-nodes/constant-value-node.js
  var require_constant_value_node = __commonJS({
    "out/src/ide/frames/parse-nodes/constant-value-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ConstantValueNode = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var dictionary_node_1 = require_dictionary_node();
      var identifier_node_1 = require_identifier_node();
      var immutable_dictionary_node_1 = require_immutable_dictionary_node();
      var list_immutable_node_1 = require_list_immutable_node();
      var list_node_1 = require_list_node();
      var lit_value_node_1 = require_lit_value_node();
      var tuple_node_1 = require_tuple_node();
      var ConstantValueNode = class _ConstantValueNode extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.completionWhenEmpty = "";
        }
        parseText(text) {
          this.alternatives.push(new identifier_node_1.IdentifierNode());
          this.alternatives.push(new lit_value_node_1.LitValueNode());
          this.alternatives.push(new tuple_node_1.TupleNode());
          this.alternatives.push(new list_immutable_node_1.ListImmutableNode(() => new _ConstantValueNode()));
          this.alternatives.push(new immutable_dictionary_node_1.DictionaryImmutableNode(() => new _ConstantValueNode(), () => new _ConstantValueNode()));
          this.alternatives.push(new list_node_1.ListNode(() => new _ConstantValueNode()));
          this.alternatives.push(new dictionary_node_1.DictionaryNode(() => new _ConstantValueNode(), () => new _ConstantValueNode()));
          super.parseText(text);
        }
      };
      exports.ConstantValueNode = ConstantValueNode;
    }
  });

  // out/src/ide/frames/fields/constant-value-field.js
  var require_constant_value_field = __commonJS({
    "out/src/ide/frames/fields/constant-value-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ConstantValueField = void 0;
      var constant_value_node_1 = require_constant_value_node();
      var abstract_field_1 = require_abstract_field();
      var ConstantValueField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>literal</i>");
        }
        helpId() {
          return "ConstantValueField";
        }
        initialiseRoot() {
          this.rootNode = new constant_value_node_1.ConstantValueNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToEndOfLine();
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.ConstantValueField = ConstantValueField;
    }
  });

  // out/src/ide/frames/globals/constant.js
  var require_constant = __commonJS({
    "out/src/ide/frames/globals/constant.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Constant = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var constant_value_field_1 = require_constant_value_field();
      var identifier_field_1 = require_identifier_field();
      var Constant = class extends abstract_frame_1.AbstractFrame {
        isCollapsible = true;
        isGlobal = true;
        name;
        value;
        file;
        isConstant = true;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.name = new identifier_field_1.IdentifierField(this);
          this.value = new constant_value_field_1.ConstantValueField(this);
          this.value.setPlaceholder("<i>literal value or data structure</i>");
          this.canHaveBreakPoint = false;
        }
        initialKeywords() {
          return keywords_1.constantKeyword;
        }
        parseFrom(source) {
          source.remove("constant ");
          this.name.parseFrom(source);
          source.remove(" set to ");
          this.value.parseFrom(source);
        }
        setClasses() {
          super.setClasses();
          this.pushClass(true, "multiline");
        }
        getFields() {
          return [this.name, this.value];
        }
        getIdPrefix() {
          return "const";
        }
        renderAsHtml() {
          return `<el-const class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}><el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>constant </el-kw>${this.name.renderAsHtml()}</el-top><el-kw> set to </el-kw>${this.isImported() ? "" : this.value.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-const>`;
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}constant ${this.name.renderAsSource()} set to ${this.value.renderAsSource()}\r
`;
        }
        isWithinAnImportedFrame() {
          return false;
        }
      };
      exports.Constant = Constant;
    }
  });

  // out/src/ide/frames/parse-nodes/enum-values-node.js
  var require_enum_values_node = __commonJS({
    "out/src/ide/frames/parse-nodes/enum-values-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumValuesNode = void 0;
      var csv_1 = require_csv();
      var identifier_node_1 = require_identifier_node();
      var EnumValuesNode = class extends csv_1.CSV {
        constructor() {
          super(() => new identifier_node_1.IdentifierNode(), 1);
          this.setSyntaxCompletionWhenEmpty("<i>enum values (comma separated)</i>");
        }
      };
      exports.EnumValuesNode = EnumValuesNode;
    }
  });

  // out/src/ide/frames/fields/enum-values-field.js
  var require_enum_values_field = __commonJS({
    "out/src/ide/frames/fields/enum-values-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnumValuesField = void 0;
      var enum_values_node_1 = require_enum_values_node();
      var abstract_field_1 = require_abstract_field();
      var EnumValuesField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>values</i>");
        }
        helpId() {
          return "EnumValuesField";
        }
        getIdPrefix() {
          return "enumVals";
        }
        initialiseRoot() {
          this.rootNode = new enum_values_node_1.EnumValuesNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToEndOfLine();
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.EnumValuesField = EnumValuesField;
    }
  });

  // out/src/ide/frames/globals/enum.js
  var require_enum = __commonJS({
    "out/src/ide/frames/globals/enum.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Enum = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var enum_values_field_1 = require_enum_values_field();
      var type_name_field_1 = require_type_name_field();
      var Enum = class extends abstract_frame_1.AbstractFrame {
        isCollapsible = true;
        isGlobal = true;
        name;
        values;
        file;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.name = new type_name_field_1.TypeNameField(this);
          this.name.setPlaceholder("<i>Name</i>");
          this.values = new enum_values_field_1.EnumValuesField(this);
          this.canHaveBreakPoint = false;
        }
        setClasses() {
          super.setClasses();
          this.pushClass(true, "multiline");
        }
        initialKeywords() {
          return keywords_1.enumKeyword;
        }
        getFields() {
          return [this.name, this.values];
        }
        getIdPrefix() {
          return "enum";
        }
        renderAsHtml() {
          return `<el-enum class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}><el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>enum </el-kw>${this.name.renderAsHtml()}</el-top> ${this.isImported() ? "" : this.values.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-enum>`;
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}enum ${this.name.renderAsSource()} ${this.values.renderAsSource()}\r
`;
        }
        parseFrom(source) {
          source.remove("enum ");
          this.name.parseFrom(source);
          this.values.parseFrom(source);
        }
        isWithinAnImportedFrame() {
          return false;
        }
      };
      exports.Enum = Enum;
    }
  });

  // out/src/ide/frames/globals/global-comment.js
  var require_global_comment = __commonJS({
    "out/src/ide/frames/globals/global-comment.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.GlobalComment = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var comment_field_1 = require_comment_field();
      var GlobalComment = class extends abstract_frame_1.AbstractFrame {
        isGlobal = true;
        text;
        file;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.text = new comment_field_1.CommentField(this);
        }
        initialKeywords() {
          return keywords_1.commentMarker;
        }
        getFields() {
          return [this.text];
        }
        getIdPrefix() {
          return "com";
        }
        renderAsHtml() {
          return `<el-global>${this.contextMenu()}<el-comment class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}><el-top>${this.bpAsHtml()}<el-kw># </el-kw>${this.text.renderAsHtml()}</el-top></el-comment></el-global>`;
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}# ${this.text.renderAsSource()}`;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("# ");
          this.text.parseFrom(source);
          source.removeNewLine();
        }
        deleteIfPermissible() {
          this.insertNewSelectorIfNecessary();
          this.delete();
        }
      };
      exports.GlobalComment = GlobalComment;
    }
  });

  // out/src/ide/frames/globals/global-function.js
  var require_global_function = __commonJS({
    "out/src/ide/frames/globals/global-function.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.GlobalFunction = void 0;
      var keywords_1 = require_keywords();
      var function_frame_1 = require_function_frame();
      var GlobalFunction = class extends function_frame_1.FunctionFrame {
        isGlobal = true;
        constructor(parent) {
          super(parent);
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}${keywords_1.functionKeyword} ${this.name.renderAsSource()}(${this.params.renderAsSource()}) ${keywords_1.returnsKeyword} ${this.returnType.renderAsSource()}\r
${this.renderChildrenAsSource()}\r
${keywords_1.endKeyword} ${keywords_1.functionKeyword}\r
`;
        }
      };
      exports.GlobalFunction = GlobalFunction;
    }
  });

  // out/src/ide/frames/globals/global-procedure.js
  var require_global_procedure = __commonJS({
    "out/src/ide/frames/globals/global-procedure.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.GlobalProcedure = void 0;
      var procedure_frame_1 = require_procedure_frame();
      var GlobalProcedure = class extends procedure_frame_1.ProcedureFrame {
        isGlobal = true;
        constructor(parent) {
          super(parent);
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}procedure ${this.name.renderAsSource()}(${this.params.renderAsSource()})\r
${this.renderChildrenAsSource()}\r
end procedure\r
`;
        }
      };
      exports.GlobalProcedure = GlobalProcedure;
    }
  });

  // out/src/ide/frames/globals/global-selector.js
  var require_global_selector = __commonJS({
    "out/src/ide/frames/globals/global-selector.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.GlobalSelector = void 0;
      var keywords_1 = require_keywords();
      var abstract_selector_1 = require_abstract_selector();
      var frame_helpers_1 = require_frame_helpers();
      var status_enums_1 = require_status_enums();
      var GlobalSelector = class extends abstract_selector_1.AbstractSelector {
        isGlobal = true;
        file;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.setParseStatus(status_enums_1.ParseStatus.default);
        }
        helpId() {
          return "GlobalInstructions";
        }
        defaultOptions() {
          return [
            [keywords_1.mainKeyword, (_parent) => this.file.createMain()],
            [keywords_1.procedureKeyword, (_parent) => this.file.createProcedure()],
            [keywords_1.functionKeyword, (_parent) => this.file.createFunction()],
            [keywords_1.testKeyword, (_parent) => this.file.createTest()],
            [keywords_1.constantKeyword, (_parent) => this.file.createConstant()],
            [keywords_1.enumKeyword, (_parent) => this.file.createEnum()],
            [keywords_1.recordKeyword, (_parent) => this.file.createRecord()],
            [keywords_1.classKeyword, (_parent) => this.file.createConcreteClass()],
            [keywords_1.abstractKeyword, (_parent) => this.file.createAbstractClass()],
            [keywords_1.interfaceKeyword, (_parent) => this.file.createInterface()],
            [keywords_1.commentMarker, (_parent) => this.file.createGlobalComment()],
            [keywords_1.ignoreKeyword, (_parent) => this.file.createTest()]
          ];
        }
        profileAllows(keyword) {
          return this.profile.globals.includes(keyword);
        }
        validWithinCurrentContext(keyword, userEntry) {
          let result = false;
          if (keyword === keywords_1.mainKeyword && userEntry) {
            result = !this.file.containsMain();
          } else {
            result = true;
          }
          return result;
        }
        renderAsHtml() {
          return `<el-global contenteditable spellcheck="false" class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.textToDisplayAsHtml()}</el-global>`;
        }
        indent() {
          return "";
        }
        canBePastedIn(frame) {
          if ((0, frame_helpers_1.isGlobal)(frame)) {
            return this.optionsMatchingUserInput(frame.initialKeywords()).length === 1;
          } else {
            return false;
          }
        }
      };
      exports.GlobalSelector = GlobalSelector;
    }
  });

  // out/src/ide/frames/globals/interface-frame.js
  var require_interface_frame = __commonJS({
    "out/src/ide/frames/globals/interface-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.InterfaceFrame = void 0;
      var keywords_1 = require_keywords();
      var parent_helpers_1 = require_parent_helpers();
      var class_frame_1 = require_class_frame();
      var InterfaceFrame = class extends class_frame_1.ClassFrame {
        constructor(parent) {
          super(parent);
          this.isAbstract = true;
          this.isInterface = true;
          this.canHaveBreakPoint = false;
        }
        initialKeywords() {
          return keywords_1.abstractClassKeywords;
        }
        doesInherit() {
          return this.inheritance.text !== "";
        }
        getFields() {
          return [this.name, this.inheritance];
        }
        getIdPrefix() {
          return "class";
        }
        renderAsHtml() {
          return `<el-class class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>${keywords_1.interfaceKeyword} </el-kw>${this.name.renderAsHtml()}${this.helpAsHtml()}${this.inheritanceAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${(0, parent_helpers_1.parentHelper_renderChildrenAsHtml)(this)}
<el-kw>${keywords_1.endKeyword} ${keywords_1.interfaceKeyword}</el-kw>
</el-class>`;
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}${keywords_1.interfaceKeyword} ${this.name.renderAsSource()}${this.inheritanceAsSource()}\r
${(0, parent_helpers_1.parentHelper_renderChildrenAsSource)(this)}\r
${keywords_1.endKeyword} ${keywords_1.interfaceKeyword}\r
`;
        }
        topKeywords() {
          return `${keywords_1.interfaceKeyword} `;
        }
        bottomKeywords() {
          return `${keywords_1.endKeyword} ${keywords_1.interfaceKeyword}`;
        }
      };
      exports.InterfaceFrame = InterfaceFrame;
    }
  });

  // out/src/ide/frames/globals/main-frame.js
  var require_main_frame = __commonJS({
    "out/src/ide/frames/globals/main-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MainFrame = void 0;
      var keywords_1 = require_keywords();
      var frame_with_statements_1 = require_frame_with_statements();
      var MainFrame = class extends frame_with_statements_1.FrameWithStatements {
        isMain = true;
        isGlobal = true;
        file;
        constructor(parent) {
          super(parent);
          this.file = parent;
        }
        initialKeywords() {
          return keywords_1.mainKeyword;
        }
        getFields() {
          return [];
        }
        getIdPrefix() {
          return "main";
        }
        get symbolId() {
          return "__main";
        }
        renderAsHtml() {
          return `<main class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>main</el-kw>${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end main</el-kw>
</main>`;
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}main\r
${this.renderChildrenAsSource()}\r
end main\r
`;
        }
        parseTop(source) {
          source.remove("main");
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, "end main");
        }
      };
      exports.MainFrame = MainFrame;
    }
  });

  // out/src/ide/frames/globals/record-frame.js
  var require_record_frame = __commonJS({
    "out/src/ide/frames/globals/record-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.RecordFrame = void 0;
      var keywords_1 = require_keywords();
      var parent_helpers_1 = require_parent_helpers();
      var class_frame_1 = require_class_frame();
      var RecordFrame = class extends class_frame_1.ClassFrame {
        constructor(parent) {
          super(parent);
          this.isNotInheritable = true;
          this.isRecord = true;
        }
        initialKeywords() {
          return keywords_1.recordKeyword;
        }
        getFields() {
          return [this.name];
        }
        getIdPrefix() {
          return "class";
        }
        renderAsHtml() {
          return `<el-class class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>record </el-kw>${this.name.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${(0, parent_helpers_1.parentHelper_renderChildrenAsHtml)(this)}
<el-kw>end record</el-kw>
</el-class>`;
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}record ${this.name.renderAsSource()}\r
${(0, parent_helpers_1.parentHelper_renderChildrenAsSource)(this)}\r
end record\r
`;
        }
        topKeywords() {
          return `${keywords_1.recordKeyword} `;
        }
        bottomKeywords() {
          return `${keywords_1.endKeyword} ${keywords_1.recordKeyword}`;
        }
      };
      exports.RecordFrame = RecordFrame;
    }
  });

  // out/src/ide/frames/globals/test-frame.js
  var require_test_frame = __commonJS({
    "out/src/ide/frames/globals/test-frame.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TestFrame = void 0;
      var breakpoint_status_1 = require_breakpoint_status();
      var keywords_1 = require_keywords();
      var test_status_1 = require_test_status();
      var comment_field_1 = require_comment_field();
      var frame_helpers_1 = require_frame_helpers();
      var frame_with_statements_1 = require_frame_with_statements();
      var assert_statement_1 = require_assert_statement();
      var status_enums_1 = require_status_enums();
      var TestFrame = class extends frame_with_statements_1.FrameWithStatements {
        isTest = true;
        isGlobal = true;
        testDescription;
        file;
        _testStatus;
        ignored = false;
        canHaveBreakPoint = false;
        constructor(parent) {
          super(parent);
          this.file = parent;
          this.testDescription = new comment_field_1.CommentField(this);
          this.testDescription.setPlaceholder("<i>optional description</i>");
          const selector = this.getChildren().pop();
          this.getChildren().push(selector);
          this._testStatus = test_status_1.TestStatus.default;
        }
        readDisplayStatus() {
          let overall = status_enums_1.DisplayColour.error;
          const parseCompile = (0, frame_helpers_1.helper_CompileOrParseAsDisplayStatus)(this);
          if (parseCompile !== status_enums_1.DisplayColour.ok) {
            overall = parseCompile;
          } else {
            overall = (0, frame_helpers_1.helper_testStatusAsDisplayStatus)(this._testStatus);
          }
          return overall;
        }
        readTestStatus() {
          return this._testStatus;
        }
        updateTestStatus() {
          const tests = this.getChildren().filter((c) => c instanceof assert_statement_1.AssertStatement && !c.isGhosted()).map((c) => c);
          const worstOf = (a, b) => a < b ? a : b;
          const worst = tests.reduce((prev, t) => worstOf(t.getTestStatus(), prev), test_status_1.TestStatus.default);
          this._testStatus = worstOf(this._testStatus, worst);
        }
        resetTestStatus() {
          this._testStatus = test_status_1.TestStatus.default;
          for (const assert of this.getAsserts()) {
            assert.outcome = void 0;
          }
        }
        initialKeywords() {
          return keywords_1.testKeyword;
        }
        getFields() {
          return [this.testDescription];
        }
        getIdPrefix() {
          return "test";
        }
        renderAsHtml() {
          return `<el-test class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>${this.ignoreKw()}test </el-kw>${this.testDescription.renderAsHtml()}${this.helpAsHtml()}${this.compileOrTestMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end test</el-kw>
</el-test>`;
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return `${this.sourceAnnotations()}${this.ignoreKw()}test ${this.testDescription.renderAsSource()}\r
${this.renderChildrenAsSource()}\r
end test\r
`;
        }
        parseTop(source) {
          if (source.isMatch("ignore ")) {
            source.remove("ignore ");
            this.ignored = true;
          }
          source.remove("test ");
          this.testDescription.parseFrom(source);
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, "end test");
        }
        setAssertOutcomes(outcomes) {
          this.resetTestStatus();
          const asserts = this.getAsserts();
          if (outcomes.some((o) => o.status === test_status_1.TestStatus.error)) {
            this._testStatus = test_status_1.TestStatus.error;
            for (const assert of asserts) {
              assert.outcome = void 0;
            }
          } else {
            for (const assert of asserts) {
              const match = outcomes.filter((o) => o.htmlId === assert.getHtmlId());
              if (match.length === 1) {
                assert.setOutcome(match[0]);
              }
            }
          }
        }
        compileOrTestMsgAsHtml() {
          if (this._testStatus === test_status_1.TestStatus.error) {
            return this.testMsgAsHtml();
          }
          return super.compileMsgAsHtml();
        }
        testMsgAsHtml() {
          return ` <el-msg class="${status_enums_1.DisplayColour[status_enums_1.DisplayColour.error]}">failed to run</el-msg>`;
        }
        processKey(e) {
          if (e.key === "i" && e.modKey.control) {
            this.ignored = !this.ignored;
            return true;
          } else {
            return super.processKey(e);
          }
        }
        ignoreKw() {
          return this.ignored ? `${keywords_1.ignoreKeyword} ` : ``;
        }
        ignore = () => {
          this.ignored = true;
          return true;
        };
        unignore = () => {
          this.ignored = false;
          return true;
        };
        getContextMenuItems() {
          const map = super.getContextMenuItems();
          if (this.ignored) {
            map.set("unignore", ["un-ignore test (Ctrl-i)", this.unignore]);
          } else {
            map.set("ignore", ["ignore test (Ctrl-i)", this.ignore]);
          }
          return map;
        }
        clearBreakPoint = () => {
          this.breakpointStatus = breakpoint_status_1.BreakpointStatus.none;
          return false;
        };
      };
      exports.TestFrame = TestFrame;
    }
  });

  // out/src/ide/frames/fields/arg-list-field.js
  var require_arg_list_field = __commonJS({
    "out/src/ide/frames/fields/arg-list-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ArgListField = void 0;
      var symbol_helpers_1 = require_symbol_helpers();
      var unknown_symbol_1 = require_unknown_symbol();
      var frame_helpers_1 = require_frame_helpers();
      var arg_list_node_1 = require_arg_list_node();
      var status_enums_1 = require_status_enums();
      var abstract_field_1 = require_abstract_field();
      var ArgListField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>arguments</i>");
          this.setOptional(true);
        }
        helpId() {
          return "ArgListField";
        }
        getIdPrefix() {
          return "args";
        }
        contentAsSource() {
          if (this.text) {
            return this.text;
          } else {
            return "";
          }
        }
        initialiseRoot() {
          this.rootNode = new arg_list_node_1.ArgListNode(() => "");
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToNonMatchingCloseBracket();
        isEndMarker(key) {
          return this.text === "" && key === ")";
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
        completionOverride = "";
        argumentDescriptions(holder, scope) {
          const proc = holder.proc.text;
          const ps = scope?.resolveSymbol(proc, scope);
          let descriptions = ["<i>arguments</i>"];
          if (ps && !(ps instanceof unknown_symbol_1.UnknownSymbol)) {
            descriptions = (0, symbol_helpers_1.parameterNames)(ps.symbolType());
          }
          return descriptions;
        }
        textAsHtml() {
          const holder = this.getHolder();
          const descriptions = this.argumentDescriptions(holder, this.getFile().getAst(false)?.getScopeById(holder.getHtmlId()));
          if (this.text) {
            const count = (0, frame_helpers_1.currentParameterIndex)(this.text);
            const remainingTypes = descriptions.slice(count).join(", ");
            this.completionOverride = remainingTypes ? `<i>${remainingTypes}</i>` : "";
          } else {
            this.completionOverride = "";
            const allTypes = descriptions.join(", ");
            this.setPlaceholder(`<i>${allTypes}</i>`);
          }
          return super.textAsHtml();
        }
        getCompletion() {
          return this.completionOverride || super.getCompletion();
        }
        parseCurrentText() {
          super.parseCurrentText();
          if (this.readParseStatus() === status_enums_1.ParseStatus.invalid && this.text.endsWith(")")) {
            this.text = this.text.slice(0, this.text.length - 1);
            super.parseCurrentText();
          }
        }
      };
      exports.ArgListField = ArgListField;
    }
  });

  // out/src/ide/frames/parse-nodes/instanceNode.js
  var require_instanceNode = __commonJS({
    "out/src/ide/frames/parse-nodes/instanceNode.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.InstanceNode = void 0;
      var _1 = require_parse_nodes();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var identifier_node_1 = require_identifier_node();
      var optional_node_1 = require_optional_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var InstanceNode = class extends abstract_sequence_1.AbstractSequence {
        variable;
        index;
        tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_let,
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_parameter_regular,
          symbol_completion_helpers_1.TokenType.id_property,
          symbol_completion_helpers_1.TokenType.id_variable
        ]);
        parseText(text) {
          if (text.length > 0) {
            this.variable = new identifier_node_1.IdentifierNode(this.tokenTypes);
            this.index = new optional_node_1.OptionalNode(new _1.Index());
            this.addElement(this.variable);
            this.addElement(this.index);
            super.parseText(text);
          }
        }
        symbolCompletion_tokenTypes() {
          if (this.getElements().length === 0) {
            return new Set(parse_node_helpers_1.allIds);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
      };
      exports.InstanceNode = InstanceNode;
    }
  });

  // out/src/ide/frames/parse-nodes/property-ref.js
  var require_property_ref = __commonJS({
    "out/src/ide/frames/parse-nodes/property-ref.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.PropertyRef = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var identifier_node_1 = require_identifier_node();
      var keyword_node_1 = require_keyword_node();
      var punctuation_node_1 = require_punctuation_node();
      var PropertyRef = class extends abstract_sequence_1.AbstractSequence {
        qualifier;
        name;
        constructor() {
          super();
          this.qualifier = new keyword_node_1.KeywordNode(keywords_1.propertyKeyword);
          this.addElement(this.qualifier);
          this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.DOT));
          this.name = new identifier_node_1.IdentifierNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.id_property]));
          this.addElement(this.name);
        }
      };
      exports.PropertyRef = PropertyRef;
    }
  });

  // out/src/ide/frames/parse-nodes/instanceProcRef.js
  var require_instanceProcRef = __commonJS({
    "out/src/ide/frames/parse-nodes/instanceProcRef.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.InstanceProcRef = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var dot_after_1 = require_dot_after();
      var instanceNode_1 = require_instanceNode();
      var method_name_node_1 = require_method_name_node();
      var property_ref_1 = require_property_ref();
      var qualifier_1 = require_qualifier();
      var InstanceProcRef = class extends abstract_sequence_1.AbstractSequence {
        prefix;
        procName;
        tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_let,
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_parameter_regular,
          symbol_completion_helpers_1.TokenType.id_property,
          symbol_completion_helpers_1.TokenType.id_variable,
          symbol_completion_helpers_1.TokenType.method_procedure
        ]);
        parseText(text) {
          if (text.length > 0) {
            const qualifierDot = () => new dot_after_1.DotAfter(new qualifier_1.Qualifier());
            const instance = new instanceNode_1.InstanceNode();
            const instanceDot = () => new dot_after_1.DotAfter(instance);
            const propertyRef = () => new dot_after_1.DotAfter(new property_ref_1.PropertyRef());
            this.prefix = new alternatives_1.Alternatives([propertyRef, qualifierDot, instanceDot]);
            this.procName = new method_name_node_1.MethodNameNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.method_procedure]), () => instance.matchedText);
            this.addElement(this.prefix);
            this.addElement(this.procName);
            super.parseText(text);
          }
        }
        renderAsHtml() {
          return `${this.prefix.bestMatch.renderAsHtml()}<el-method>${this.procName?.renderAsHtml()}</el-method>`;
        }
        symbolCompletion_tokenTypes() {
          if (this.getElements().length === 0) {
            return new Set(this.tokenTypes);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
        symbolCompletion_keywords() {
          return this.getElements().length === 0 ? /* @__PURE__ */ new Set([
            symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.globalKeyword, false, true),
            symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.libraryKeyword, false, true),
            symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.propertyKeyword, false, true)
          ]) : super.symbolCompletion_keywords();
        }
      };
      exports.InstanceProcRef = InstanceProcRef;
    }
  });

  // out/src/ide/frames/parse-nodes/proc-ref-node.js
  var require_proc_ref_node = __commonJS({
    "out/src/ide/frames/parse-nodes/proc-ref-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProcRefNode = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var instanceProcRef_1 = require_instanceProcRef();
      var method_name_node_1 = require_method_name_node();
      var ProcRefNode = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.alternatives.push(new instanceProcRef_1.InstanceProcRef());
          this.alternatives.push(new method_name_node_1.MethodNameNode(/* @__PURE__ */ new Set([symbol_completion_helpers_1.TokenType.method_procedure])));
        }
        getProcName() {
          let procName = "";
          if (this.bestMatch instanceof instanceProcRef_1.InstanceProcRef) {
            procName = this.bestMatch.procName.matchedText;
          } else if (this.bestMatch instanceof method_name_node_1.MethodNameNode) {
            procName = this.matchedText;
          }
          return procName;
        }
      };
      exports.ProcRefNode = ProcRefNode;
    }
  });

  // out/src/ide/frames/fields/proc-ref-field.js
  var require_proc_ref_field = __commonJS({
    "out/src/ide/frames/fields/proc-ref-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProcRefField = void 0;
      var identifier_node_1 = require_identifier_node();
      var proc_ref_node_1 = require_proc_ref_node();
      var status_enums_1 = require_status_enums();
      var abstract_field_1 = require_abstract_field();
      var ProcRefField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>procedureName</i>");
        }
        helpId() {
          return "ProcRefField";
        }
        getIdPrefix() {
          return "ident";
        }
        initialiseRoot() {
          this.rootNode = new proc_ref_node_1.ProcRefNode();
          this.rootNode.setSyntaxCompletionWhenEmpty(this.placeholder);
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/\(/);
        textAsHtml() {
          let text;
          if (this.isSelected()) {
            text = this.fieldAsInput() + this.symbolCompletion();
          } else if (this.readParseStatus() === status_enums_1.ParseStatus.valid) {
            const bestMatch = this.rootNode.bestMatch;
            if (bestMatch instanceof identifier_node_1.IdentifierNode) {
              text = `<el-method>${this.text}</el-method>`;
            } else {
              text = bestMatch.renderAsHtml();
            }
          } else {
            text = super.textAsHtml();
          }
          return text;
        }
        isEndMarker(key) {
          return key === "(";
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.ProcRefField = ProcRefField;
    }
  });

  // out/src/ide/frames/statements/call-statement.js
  var require_call_statement = __commonJS({
    "out/src/ide/frames/statements/call-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CallStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var arg_list_field_1 = require_arg_list_field();
      var proc_ref_field_1 = require_proc_ref_field();
      var CallStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        isCall = true;
        proc;
        args;
        constructor(parent) {
          super(parent);
          this.proc = new proc_ref_field_1.ProcRefField(this);
          this.proc.setPlaceholder("<i>procedureName</i>");
          this.args = new arg_list_field_1.ArgListField(this);
        }
        initialKeywords() {
          return keywords_1.callKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("call ");
          this.proc.parseFrom(source);
          source.remove("(");
          this.args.parseFrom(source);
          source.remove(")");
          source.removeNewLine();
        }
        getFields() {
          return [this.proc, this.args];
        }
        getIdPrefix() {
          return "call";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-top><el-kw>call </el-kw>${this.proc.renderAsHtml()}(${this.args.renderAsHtml()})${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top></el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}call ${this.proc.renderAsSource()}(${this.args.renderAsSource()})`;
        }
      };
      exports.CallStatement = CallStatement;
    }
  });

  // out/src/ide/frames/statements/catch-statement.js
  var require_catch_statement = __commonJS({
    "out/src/ide/frames/statements/catch-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.CatchStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var identifier_field_1 = require_identifier_field();
      var CatchStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        isCatch = true;
        variable;
        constructor(parent) {
          super(parent);
          this.variable = new identifier_field_1.IdentifierField(this);
          this.variable.setPlaceholder("<i>variableName</i>");
          this.variable.setFieldToKnownValidText("e");
          this.ghostable = false;
        }
        isDeletable() {
          return false;
        }
        deleteIfPermissible() {
        }
        // does nothing - catch can't be deleted
        setClasses() {
          super.setClasses();
          this.pushClass(true, "outdent");
        }
        initialKeywords() {
          return keywords_1.catchKeyword;
        }
        getFields() {
          return [this.variable];
        }
        getIdPrefix() {
          return "catch";
        }
        indent() {
          return this.getParent().indent();
        }
        parentIndent() {
          return this.getParent().indent();
        }
        keywords = `${keywords_1.catchKeyword} ${keywords_1.exceptionKeyword} ${keywords_1.inKeyword} `;
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1"><el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>${this.keywords}</el-kw>${this.variable.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top></el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.keywords}${this.variable.renderAsSource()}`;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove(this.keywords);
          this.variable.parseFrom(source);
          source.removeNewLine();
        }
        isGhosted() {
          return false;
        }
      };
      exports.CatchStatement = CatchStatement;
    }
  });

  // out/src/ide/frames/statements/each.js
  var require_each = __commonJS({
    "out/src/ide/frames/statements/each.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Each = void 0;
      var keywords_1 = require_keywords();
      var expression_field_1 = require_expression_field();
      var identifier_field_1 = require_identifier_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var Each = class extends frame_with_statements_1.FrameWithStatements {
        isStatement = true;
        variable;
        iter;
        constructor(parent) {
          super(parent);
          this.variable = new identifier_field_1.IdentifierField(this);
          this.variable.setPlaceholder("<i>elementName</i>");
          this.iter = new expression_field_1.ExpressionField(this);
          this.iter.setPlaceholder("<i>source</i>");
        }
        initialKeywords() {
          return keywords_1.eachKeyword;
        }
        getFields() {
          return [this.variable, this.iter];
        }
        getIdPrefix() {
          return "each";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>each </el-kw>${this.variable.renderAsHtml()}<el-kw> in </el-kw>${this.iter.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end each</el-kw>
</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}each ${this.variable.renderAsSource()} in ${this.iter.renderAsSource()}\r
${this.renderChildrenAsSource()}\r
${this.indent()}end each`;
        }
        parseTop(source) {
          source.remove("each ");
          this.variable.parseFrom(source);
          source.remove(" in ");
          this.iter.parseFrom(source);
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, "end each");
        }
      };
      exports.Each = Each;
    }
  });

  // out/src/ide/frames/fields/if-selector-field.js
  var require_if_selector_field = __commonJS({
    "out/src/ide/frames/fields/if-selector-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IfSelectorField = void 0;
      var keywords_1 = require_keywords();
      var keyword_node_1 = require_keyword_node();
      var optional_node_1 = require_optional_node();
      var status_enums_1 = require_status_enums();
      var abstract_field_1 = require_abstract_field();
      var regexes_1 = require_regexes();
      var IfSelectorField = class extends abstract_field_1.AbstractField {
        placeholderIsCode = true;
        else;
        constructor(holder) {
          super(holder);
          this.else = holder;
          this.setPlaceholder("<i>if</i>");
          this.setOptional(true);
          this.setParseStatus(status_enums_1.ParseStatus.valid);
        }
        helpId() {
          return "IfSelectorField";
        }
        initialiseRoot() {
          this.rootNode = new optional_node_1.OptionalNode(new keyword_node_1.KeywordNode(keywords_1.ifKeyword));
          return this.rootNode;
        }
        readToDelimiter = (_source) => "";
        parseFrom(source) {
          if (source.isMatchRegEx(regexes_1.Regexes.ifClause)) {
            source.remove("if ");
            this.else.setIfExtension(true);
          }
        }
        getIdPrefix() {
          return "elif";
        }
        indent() {
          return "";
        }
        renderAsSource() {
          return ``;
        }
        processKey(keyEvent) {
          this.codeHasChanged = false;
          const char = keyEvent.key;
          if (!keyEvent.modKey.control && char?.length === 1) {
            if (char === "i" && this.text === "") {
              this.else.setIfExtension(true);
              this.else.condition.select();
              this.codeHasChanged = true;
            }
          } else {
            this.codeHasChanged = super.processKey(keyEvent);
          }
          return this.codeHasChanged;
        }
        symbolCompletion() {
          return "";
        }
      };
      exports.IfSelectorField = IfSelectorField;
    }
  });

  // out/src/ide/frames/statements/else.js
  var require_else = __commonJS({
    "out/src/ide/frames/statements/else.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Else = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var code_source_from_string_1 = require_code_source_from_string();
      var expression_field_1 = require_expression_field();
      var if_selector_field_1 = require_if_selector_field();
      var Else = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        selectIfClause;
        hasIf = false;
        condition;
        constructor(parent) {
          super(parent);
          this.condition = new expression_field_1.ExpressionField(this);
          this.condition.setPlaceholder("<i>condition</i>");
          this.selectIfClause = new if_selector_field_1.IfSelectorField(this);
        }
        setClasses() {
          super.setClasses();
          this.pushClass(true, "outdent");
        }
        initialKeywords() {
          return keywords_1.elseKeyword;
        }
        getFields() {
          return this.hasIf ? [this.condition] : [this.selectIfClause];
        }
        setIfExtension(to) {
          this.hasIf = to;
        }
        getIdPrefix() {
          return "else";
        }
        ifClauseAsHtml() {
          return this.hasIf ? `<el-kw>if </el-kw>${this.condition.renderAsHtml()}` : `${this.selectIfClause.renderAsHtml()}`;
        }
        ifClauseAsSource() {
          return this.hasIf ? ` if ${this.condition.renderAsSource()}` : ``;
        }
        indent() {
          return this.getParent().indent();
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}><el-top>${this.contextMenu()}${this.bpAsHtml()}
    <el-kw>${keywords_1.elseKeyword} </el-kw>${this.ifClauseAsHtml()}${this.hasIf ? "<el-kw> " + keywords_1.thenKeyword + "</el-kw>" : ""}${this.helpAsHtml()}</el-top>${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.elseKeyword}${this.ifClauseAsSource()}${this.hasIf ? " " + keywords_1.thenKeyword : ""}`;
        }
        parseFrom(source) {
          source.remove("else");
          if (source.isMatch(" if ")) {
            this.hasIf = true;
            source.remove(" if ");
            const condition = source.readUntil(/\sthen/);
            this.condition.parseFrom(new code_source_from_string_1.CodeSourceFromString(condition));
            source.remove(" then");
          }
        }
      };
      exports.Else = Else;
    }
  });

  // out/src/ide/frames/statements/for.js
  var require_for = __commonJS({
    "out/src/ide/frames/statements/for.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.For = void 0;
      var keywords_1 = require_keywords();
      var expression_field_1 = require_expression_field();
      var identifier_field_1 = require_identifier_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var For = class extends frame_with_statements_1.FrameWithStatements {
        isStatement = true;
        variable;
        from;
        to;
        step;
        constructor(parent) {
          super(parent);
          this.variable = new identifier_field_1.IdentifierField(this);
          this.variable.setPlaceholder("<i>counterName</i>");
          this.from = new expression_field_1.ExpressionField(this, / to /);
          this.from.setPlaceholder("<i>firstValue</i>");
          this.to = new expression_field_1.ExpressionField(this, / step /);
          this.to.setPlaceholder("<i>lastValue</i>");
          this.step = new expression_field_1.ExpressionField(this);
          this.step.setPlaceholder("<i>stepValue</i>");
          this.step.setFieldToKnownValidText("1");
        }
        initialKeywords() {
          return keywords_1.forKeyword;
        }
        getFields() {
          return [this.variable, this.from, this.to, this.step];
        }
        getIdPrefix() {
          return "for";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>for </el-kw>${this.variable.renderAsHtml()}<el-kw> from </el-kw>${this.from.renderAsHtml()}<el-kw> to </el-kw>${this.to.renderAsHtml()}<el-kw> step </el-kw>${this.step.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end for</el-kw>
</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}for ${this.variable.renderAsSource()} from ${this.from.renderAsSource()} to ${this.to.renderAsSource()} step ${this.step.renderAsSource()}\r
${this.renderChildrenAsSource()}\r
${this.indent()}end for`;
        }
        parseTop(source) {
          source.remove("for ");
          this.variable.parseFrom(source);
          source.remove(" from ");
          this.from.parseFrom(source);
          source.remove(" to ");
          this.to.parseFrom(source);
          source.remove(" step ");
          this.step.parseFrom(source);
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, "end for");
        }
      };
      exports.For = For;
    }
  });

  // out/src/ide/frames/statements/if-statement.js
  var require_if_statement = __commonJS({
    "out/src/ide/frames/statements/if-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.IfStatement = void 0;
      var keywords_1 = require_keywords();
      var code_source_from_string_1 = require_code_source_from_string();
      var expression_field_1 = require_expression_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var IfStatement = class extends frame_with_statements_1.FrameWithStatements {
        isStatement = true;
        condition;
        constructor(parent) {
          super(parent);
          this.condition = new expression_field_1.ExpressionField(this);
          this.condition.setPlaceholder("<i>condition</i>");
        }
        initialKeywords() {
          return keywords_1.ifKeyword;
        }
        getFields() {
          return [this.condition];
        }
        getIdPrefix() {
          return "if";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>${keywords_1.ifKeyword} </el-kw>${this.condition.renderAsHtml()}<el-kw> ${keywords_1.thenKeyword}</el-kw>${this.helpAsHtml()}${this.getFrNo()}</el-top>${this.compileMsgAsHtml()}
${this.renderChildrenAsHtml()}
<el-kw>${keywords_1.endKeyword} ${keywords_1.ifKeyword}</el-kw>
</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.ifKeyword} ${this.condition.renderAsSource()} ${keywords_1.thenKeyword}\r
${this.renderChildrenAsSource()}\r
${this.indent()}${keywords_1.endKeyword} ${keywords_1.ifKeyword}`;
        }
        parseTop(source) {
          source.remove("if ");
          const condition = source.readUntil(/\sthen/);
          this.condition.parseFrom(new code_source_from_string_1.CodeSourceFromString(condition));
          source.remove(" then");
          source.removeNewLine();
        }
        parseBottom(source) {
          source.removeIndent();
          return this.parseStandardEnding(source, "end if");
        }
        insertSelectorAfterLastField() {
          this.getFirstChild().select(true, false);
        }
      };
      exports.IfStatement = IfStatement;
    }
  });

  // out/src/ide/frames/parse-nodes/deconstructed-list.js
  var require_deconstructed_list = __commonJS({
    "out/src/ide/frames/parse-nodes/deconstructed-list.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedList = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var identifier_node_1 = require_identifier_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var DeconstructedList = class extends abstract_sequence_1.AbstractSequence {
        head;
        tail;
        readonly;
        constructor(readOnly = false) {
          super();
          this.readonly = readOnly;
        }
        parseText(text) {
          if (text.length > 0) {
            const head = () => new identifier_node_1.IdentifierNode();
            const discard = () => new punctuation_node_1.PunctuationNode(symbols_1.UNDERSCORE);
            this.head = new alternatives_1.Alternatives([head, discard]);
            this.addElement(this.head);
            this.addElement(new punctuation_node_1.PunctuationNode(symbols_1.COLON));
            const tail = () => new identifier_node_1.IdentifierNode();
            this.tail = new alternatives_1.Alternatives([tail, discard]);
            this.addElement(this.tail);
            super.parseText(text);
          }
        }
        symbolCompletion_tokenTypes() {
          if (this.readonly) {
            return parse_node_helpers_1.noTokenTypes;
          } else if (this.getElements().length === 0) {
            return new Set(parse_node_helpers_1.assignableIds);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
        symbolCompletion_keywords() {
          let kw = /* @__PURE__ */ new Set();
          if (!this.readonly) {
            if (this.getElements().length === 0) {
              kw = /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.propertyKeyword, false, true)]);
            } else {
              kw = super.symbolCompletion_keywords();
            }
          }
          return kw;
        }
      };
      exports.DeconstructedList = DeconstructedList;
    }
  });

  // out/src/ide/frames/parse-nodes/deconstructed-tuple.js
  var require_deconstructed_tuple = __commonJS({
    "out/src/ide/frames/parse-nodes/deconstructed-tuple.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DeconstructedTuple = void 0;
      var keywords_1 = require_keywords();
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var symbols_1 = require_symbols();
      var abstract_sequence_1 = require_abstract_sequence();
      var alternatives_1 = require_alternatives();
      var csv_1 = require_csv();
      var identifier_node_1 = require_identifier_node();
      var parse_node_helpers_1 = require_parse_node_helpers();
      var punctuation_node_1 = require_punctuation_node();
      var DeconstructedTuple = class extends abstract_sequence_1.AbstractSequence {
        csv;
        readonly;
        constructor(readOnly = false) {
          super();
          this.readonly = readOnly;
        }
        parseText(text) {
          if (text.length > 0) {
            const id = () => new identifier_node_1.IdentifierNode();
            const discard = () => new punctuation_node_1.PunctuationNode(symbols_1.UNDERSCORE);
            const element = () => new alternatives_1.Alternatives([id, discard]);
            this.csv = new csv_1.CSV(element, 2);
            this.addElement(this.csv);
            super.parseText(text);
          }
        }
        symbolCompletion_tokenTypes() {
          if (this.readonly) {
            return parse_node_helpers_1.noTokenTypes;
          } else if (this.getElements().length === 0) {
            return new Set(parse_node_helpers_1.assignableIds);
          } else {
            return super.symbolCompletion_tokenTypes();
          }
        }
        symbolCompletion_keywords() {
          let kw = /* @__PURE__ */ new Set();
          if (!this.readonly) {
            if (this.getElements().length === 0) {
              kw = /* @__PURE__ */ new Set([symbol_completion_helpers_1.KeywordCompletion.create(keywords_1.propertyKeyword, false, true)]);
            } else {
              kw = super.symbolCompletion_keywords();
            }
          }
          return kw;
        }
      };
      exports.DeconstructedTuple = DeconstructedTuple;
    }
  });

  // out/src/ide/frames/parse-nodes/value-def-node.js
  var require_value_def_node = __commonJS({
    "out/src/ide/frames/parse-nodes/value-def-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ValueDefNode = void 0;
      var abstract_alternatives_1 = require_abstract_alternatives();
      var deconstructed_list_1 = require_deconstructed_list();
      var deconstructed_tuple_1 = require_deconstructed_tuple();
      var identifier_node_1 = require_identifier_node();
      var ValueDefNode = class extends abstract_alternatives_1.AbstractAlternatives {
        constructor() {
          super();
          this.alternatives.push(new identifier_node_1.IdentifierNode());
          this.alternatives.push(new deconstructed_tuple_1.DeconstructedTuple(true));
          this.alternatives.push(new deconstructed_list_1.DeconstructedList(true));
        }
      };
      exports.ValueDefNode = ValueDefNode;
    }
  });

  // out/src/ide/frames/fields/value-def-field.js
  var require_value_def_field = __commonJS({
    "out/src/ide/frames/fields/value-def-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ValueDefField = void 0;
      var value_def_node_1 = require_value_def_node();
      var abstract_field_1 = require_abstract_field();
      var ValueDefField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>name</i>");
        }
        helpId() {
          return "ValueDefField";
        }
        getIdPrefix() {
          return "var";
        }
        initialiseRoot() {
          this.rootNode = new value_def_node_1.ValueDefNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/(\s+((set to)|(be))\s+)|\r|\n/);
        isEndMarker(key) {
          return this.text.length === 0 ? false : key === " ";
        }
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.ValueDefField = ValueDefField;
    }
  });

  // out/src/ide/frames/statements/abstract-definition.statement.js
  var require_abstract_definition_statement = __commonJS({
    "out/src/ide/frames/statements/abstract-definition.statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractDefinitionStatement = void 0;
      var abstract_frame_1 = require_abstract_frame();
      var expression_field_1 = require_expression_field();
      var value_def_field_1 = require_value_def_field();
      var AbstractDefinitionStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        name;
        expr;
        constructor(parent) {
          super(parent);
          this.name = new value_def_field_1.ValueDefField(this);
          this.expr = new expression_field_1.ExpressionField(this);
        }
        getFields() {
          return [this.name, this.expr];
        }
      };
      exports.AbstractDefinitionStatement = AbstractDefinitionStatement;
    }
  });

  // out/src/ide/frames/statements/let-statement.js
  var require_let_statement = __commonJS({
    "out/src/ide/frames/statements/let-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LetStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_definition_statement_1 = require_abstract_definition_statement();
      var LetStatement = class extends abstract_definition_statement_1.AbstractDefinitionStatement {
        isStatement = true;
        constructor(parent) {
          super(parent);
        }
        isLet = true;
        initialKeywords() {
          return keywords_1.letKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove(`${keywords_1.letKeyword} `);
          this.name.parseFrom(source);
          source.remove(` ${keywords_1.beKeyword} `);
          this.expr.parseFrom(source);
          source.removeNewLine();
        }
        getIdPrefix() {
          return "let";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-kw>${keywords_1.letKeyword} </el-kw>${this.name.renderAsHtml()}<el-kw> ${keywords_1.beKeyword} </el-kw>${this.expr.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.letKeyword} ${this.name.renderAsSource()} ${keywords_1.beKeyword} ${this.expr.renderAsSource()}`;
        }
      };
      exports.LetStatement = LetStatement;
    }
  });

  // out/src/ide/frames/statements/print.js
  var require_print = __commonJS({
    "out/src/ide/frames/statements/print.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Print = void 0;
      var abstract_frame_1 = require_abstract_frame();
      var keywords_1 = require_keywords();
      var expression_field_1 = require_expression_field();
      var Print = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        expr;
        constructor(parent) {
          super(parent);
          this.expr = new expression_field_1.ExpressionField(this);
          this.expr.setOptional(true);
          this.expr.setPlaceholder("<i>expression</i>");
        }
        initialKeywords() {
          return keywords_1.printKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("print");
          this.expr.parseFrom(source);
          source.removeNewLine();
        }
        getFields() {
          return [this.expr];
        }
        getIdPrefix() {
          return "print";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-kw>print </el-kw>${this.expr.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}print ${this.expr.renderAsSource()}`;
        }
      };
      exports.Print = Print;
    }
  });

  // out/src/ide/frames/statements/repeat.js
  var require_repeat = __commonJS({
    "out/src/ide/frames/statements/repeat.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Repeat = void 0;
      var keywords_1 = require_keywords();
      var expression_field_1 = require_expression_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var Repeat = class extends frame_with_statements_1.FrameWithStatements {
        isStatement = true;
        condition;
        constructor(parent) {
          super(parent);
          this.condition = new expression_field_1.ExpressionField(this);
          this.condition.setPlaceholder("<i>condition</i>");
        }
        initialKeywords() {
          return keywords_1.repeatKeyword;
        }
        getFields() {
          return [this.condition];
        }
        getIdPrefix() {
          return "repeat";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>repeat</el-kw>${this.helpAsHtml()}</el-top>${this.getFrNo()}
${this.renderChildrenAsHtml()}
<el-kw>end repeat when </el-kw>${this.condition.renderAsHtml()}
${this.compileMsgAsHtml()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}repeat\r
${this.renderChildrenAsSource()}\r
${this.indent()}end repeat when ${this.condition.renderAsSource()}`;
        }
        parseTop(source) {
          source.remove("repeat");
        }
        parseBottom(source) {
          let result = false;
          if (this.parseStandardEnding(source, "end repeat when ")) {
            this.condition.parseFrom(source);
            result = true;
          }
          return result;
        }
      };
      exports.Repeat = Repeat;
    }
  });

  // out/src/ide/frames/parse-nodes/assignable-node.js
  var require_assignable_node = __commonJS({
    "out/src/ide/frames/parse-nodes/assignable-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssignableNode = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var deconstructed_list_1 = require_deconstructed_list();
      var deconstructed_tuple_1 = require_deconstructed_tuple();
      var identifier_node_1 = require_identifier_node();
      var property_ref_1 = require_property_ref();
      var AssignableNode = class extends abstract_alternatives_1.AbstractAlternatives {
        tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_parameter_out,
          symbol_completion_helpers_1.TokenType.id_property,
          symbol_completion_helpers_1.TokenType.id_variable
        ]);
        constructor() {
          super();
          this.alternatives.push(new identifier_node_1.IdentifierNode(this.tokenTypes));
          this.alternatives.push(new property_ref_1.PropertyRef());
          this.alternatives.push(new deconstructed_tuple_1.DeconstructedTuple());
          this.alternatives.push(new deconstructed_list_1.DeconstructedList());
        }
      };
      exports.AssignableNode = AssignableNode;
    }
  });

  // out/src/ide/frames/fields/assignableField.js
  var require_assignableField = __commonJS({
    "out/src/ide/frames/fields/assignableField.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AssignableField = void 0;
      var assignable_node_1 = require_assignable_node();
      var abstract_field_1 = require_abstract_field();
      var AssignableField = class extends abstract_field_1.AbstractField {
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>variable</i>");
        }
        helpId() {
          return "AssignableField";
        }
        getIdPrefix() {
          return "ident";
        }
        initialiseRoot() {
          this.rootNode = new assignable_node_1.AssignableNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readUntil(/(\s+to\s+)|\r|\n/);
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.AssignableField = AssignableField;
    }
  });

  // out/src/ide/frames/statements/set-statement.js
  var require_set_statement = __commonJS({
    "out/src/ide/frames/statements/set-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SetStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var assignableField_1 = require_assignableField();
      var expression_field_1 = require_expression_field();
      var SetStatement = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        assignable;
        expr;
        constructor(parent) {
          super(parent);
          this.assignable = new assignableField_1.AssignableField(this);
          this.assignable.setPlaceholder("<i>variableName</i>");
          this.expr = new expression_field_1.ExpressionField(this);
        }
        initialKeywords() {
          return keywords_1.setKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove("set ");
          this.assignable.parseFrom(source);
          source.remove(" to ");
          this.expr.parseFrom(source);
          source.removeNewLine();
        }
        getFields() {
          return [this.assignable, this.expr];
        }
        getIdPrefix() {
          return "set";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-kw>${keywords_1.setKeyword} </el-kw>${this.assignable.renderAsHtml()}<el-kw> ${keywords_1.toKeyword} </el-kw>${this.expr.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.setKeyword} ${this.assignable.renderAsSource()} ${keywords_1.toKeyword} ${this.expr.renderAsSource()}`;
        }
      };
      exports.SetStatement = SetStatement;
    }
  });

  // out/src/ide/frames/parse-nodes/exception-msg-node.js
  var require_exception_msg_node = __commonJS({
    "out/src/ide/frames/parse-nodes/exception-msg-node.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ExceptionMsgNode = void 0;
      var symbol_completion_helpers_1 = require_symbol_completion_helpers();
      var abstract_alternatives_1 = require_abstract_alternatives();
      var identifier_node_1 = require_identifier_node();
      var lit_string_1 = require_lit_string();
      var ExceptionMsgNode = class extends abstract_alternatives_1.AbstractAlternatives {
        tokenTypes = /* @__PURE__ */ new Set([
          symbol_completion_helpers_1.TokenType.id_constant,
          symbol_completion_helpers_1.TokenType.id_let,
          symbol_completion_helpers_1.TokenType.id_variable
        ]);
        constructor() {
          super();
          this.alternatives.push(new lit_string_1.LitString());
          this.alternatives.push(new identifier_node_1.IdentifierNode(this.tokenTypes));
        }
      };
      exports.ExceptionMsgNode = ExceptionMsgNode;
    }
  });

  // out/src/ide/frames/fields/exception-message-field.js
  var require_exception_message_field = __commonJS({
    "out/src/ide/frames/fields/exception-message-field.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ExceptionMessageField = void 0;
      var exception_msg_node_1 = require_exception_msg_node();
      var abstract_field_1 = require_abstract_field();
      var ExceptionMessageField = class extends abstract_field_1.AbstractField {
        isParseByNodes = true;
        constructor(holder) {
          super(holder);
          this.setPlaceholder("<i>message</i>");
        }
        helpId() {
          return "ExceptionMessageField";
        }
        getIdPrefix() {
          return "msg";
        }
        initialiseRoot() {
          this.rootNode = new exception_msg_node_1.ExceptionMsgNode();
          return this.rootNode;
        }
        readToDelimiter = (source) => source.readToEndOfLine();
        symbolCompletion() {
          return this.symbolCompletionAsHtml();
        }
      };
      exports.ExceptionMessageField = ExceptionMessageField;
    }
  });

  // out/src/ide/frames/statements/throw.js
  var require_throw = __commonJS({
    "out/src/ide/frames/statements/throw.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Throw = void 0;
      var keywords_1 = require_keywords();
      var abstract_frame_1 = require_abstract_frame();
      var exception_message_field_1 = require_exception_message_field();
      var Throw = class extends abstract_frame_1.AbstractFrame {
        isStatement = true;
        text;
        constructor(parent) {
          super(parent);
          this.text = new exception_message_field_1.ExceptionMessageField(this);
        }
        initialKeywords() {
          return keywords_1.throwKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove(`${keywords_1.throwKeyword} ${keywords_1.exceptionKeyword} `);
          this.text.parseFrom(source);
          source.removeNewLine();
        }
        getFields() {
          return [this.text];
        }
        getIdPrefix() {
          return "throw";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-kw>${keywords_1.throwKeyword} ${keywords_1.exceptionKeyword} </el-kw>${this.text.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.throwKeyword} ${keywords_1.exceptionKeyword} ${this.text.renderAsSource()}`;
        }
      };
      exports.Throw = Throw;
    }
  });

  // out/src/ide/frames/statements/try.js
  var require_try = __commonJS({
    "out/src/ide/frames/statements/try.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TryStatement = void 0;
      var keywords_1 = require_keywords();
      var frame_with_statements_1 = require_frame_with_statements();
      var catch_statement_1 = require_catch_statement();
      var statement_selector_1 = require_statement_selector();
      var TryStatement = class extends frame_with_statements_1.FrameWithStatements {
        catch;
        constructor(parent) {
          super(parent);
          this.catch = new catch_statement_1.CatchStatement(this);
          this.getChildren().push(this.catch);
          this.getChildren().push(new statement_selector_1.StatementSelector(this));
        }
        initialKeywords() {
          return keywords_1.tryKeyword;
        }
        minimumNumberOfChildrenExceeded() {
          return this.getChildren().length > 2;
        }
        getFields() {
          return [];
        }
        getIdPrefix() {
          return "try";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>${keywords_1.tryKeyword} </el-kw>${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end try</el-kw>
</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}try\r
${this.renderChildrenAsSource()}\r
${this.indent()}${keywords_1.endKeyword} ${keywords_1.tryKeyword}`;
        }
        parseTop(source) {
          source.remove(keywords_1.tryKeyword);
        }
        parseBottom(source) {
          source.removeIndent();
          if (source.isMatchRegEx(/^catch\s/)) {
            this.catch.parseFrom(source);
            const redundantSelector = this.getFirstSelectorAsDirectChild();
            this.removeChild(redundantSelector);
          }
          return this.parseStandardEnding(source, `${keywords_1.endKeyword} ${keywords_1.tryKeyword}`);
        }
      };
      exports.TryStatement = TryStatement;
    }
  });

  // out/src/ide/frames/statements/variable-statement.js
  var require_variable_statement = __commonJS({
    "out/src/ide/frames/statements/variable-statement.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.VariableStatement = void 0;
      var keywords_1 = require_keywords();
      var abstract_definition_statement_1 = require_abstract_definition_statement();
      var VariableStatement = class extends abstract_definition_statement_1.AbstractDefinitionStatement {
        isVariableStatement = true;
        constructor(parent) {
          super(parent);
        }
        initialKeywords() {
          return keywords_1.variableKeyword;
        }
        parseFrom(source) {
          source.removeIndent();
          source.remove(`${keywords_1.variableKeyword} `);
          this.name.parseFrom(source);
          source.remove(" set to ");
          this.expr.parseFrom(source);
          source.removeNewLine();
        }
        getIdPrefix() {
          return "var";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>${this.contextMenu()}${this.bpAsHtml()}<el-kw>${keywords_1.variableKeyword} </el-kw>${this.name.renderAsHtml()}<el-kw> ${keywords_1.setKeyword} ${keywords_1.toKeyword} </el-kw>${this.expr.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}${keywords_1.variableKeyword} ${this.name.renderAsSource()} ${keywords_1.setKeyword} ${keywords_1.toKeyword} ${this.expr.renderAsSource()}`;
        }
      };
      exports.VariableStatement = VariableStatement;
    }
  });

  // out/src/ide/frames/statements/while.js
  var require_while = __commonJS({
    "out/src/ide/frames/statements/while.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.While = void 0;
      var keywords_1 = require_keywords();
      var expression_field_1 = require_expression_field();
      var frame_with_statements_1 = require_frame_with_statements();
      var While = class extends frame_with_statements_1.FrameWithStatements {
        isStatement = true;
        condition;
        constructor(parent) {
          super(parent);
          this.condition = new expression_field_1.ExpressionField(this);
          this.condition.setPlaceholder("<i>condition</i>");
        }
        initialKeywords() {
          return keywords_1.whileKeyword;
        }
        getFields() {
          return [this.condition];
        }
        getIdPrefix() {
          return "while";
        }
        renderAsHtml() {
          return `<el-statement class="${this.cls()}" id='${this.htmlId}' tabindex="-1" ${this.toolTip()}>
<el-top>${this.contextMenu()}${this.bpAsHtml()}<el-expand>+</el-expand><el-kw>while </el-kw>${this.condition.renderAsHtml()}${this.helpAsHtml()}${this.compileMsgAsHtml()}${this.getFrNo()}</el-top>
${this.renderChildrenAsHtml()}
<el-kw>end while</el-kw>
</el-statement>`;
        }
        renderAsSource() {
          return `${this.indent()}${this.sourceAnnotations()}while ${this.condition.renderAsSource()}\r
${this.renderChildrenAsSource()}\r
${this.indent()}end while`;
        }
        parseTop(source) {
          source.remove(`${keywords_1.whileKeyword} `);
          this.condition.parseFrom(source);
        }
        parseBottom(source) {
          return this.parseStandardEnding(source, `${keywords_1.endKeyword} ${keywords_1.whileKeyword}`);
        }
      };
      exports.While = While;
    }
  });

  // out/src/ide/frames/statement-factory-impl.js
  var require_statement_factory_impl = __commonJS({
    "out/src/ide/frames/statement-factory-impl.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StatementFactoryImpl = void 0;
      var assert_statement_1 = require_assert_statement();
      var call_statement_1 = require_call_statement();
      var catch_statement_1 = require_catch_statement();
      var comment_statement_1 = require_comment_statement();
      var each_1 = require_each();
      var else_1 = require_else();
      var for_1 = require_for();
      var if_statement_1 = require_if_statement();
      var let_statement_1 = require_let_statement();
      var print_1 = require_print();
      var repeat_1 = require_repeat();
      var set_statement_1 = require_set_statement();
      var throw_1 = require_throw();
      var try_1 = require_try();
      var variable_statement_1 = require_variable_statement();
      var while_1 = require_while();
      var StatementFactoryImpl = class {
        newAssert(parent) {
          return new assert_statement_1.AssertStatement(parent);
        }
        newCall(parent) {
          return new call_statement_1.CallStatement(parent);
        }
        newCatch(parent) {
          return new catch_statement_1.CatchStatement(parent);
        }
        newEach(parent) {
          return new each_1.Each(parent);
        }
        newElse(parent) {
          return new else_1.Else(parent);
        }
        newFor(parent) {
          return new for_1.For(parent);
        }
        newIf(parent) {
          return new if_statement_1.IfStatement(parent);
        }
        newLet(parent) {
          return new let_statement_1.LetStatement(parent);
        }
        newPrint(parent) {
          return new print_1.Print(parent);
        }
        newRepeat(parent) {
          return new repeat_1.Repeat(parent);
        }
        newSet(parent) {
          return new set_statement_1.SetStatement(parent);
        }
        newThrow(parent) {
          return new throw_1.Throw(parent);
        }
        newTryCatch(parent) {
          return new try_1.TryStatement(parent);
        }
        newVar(parent) {
          return new variable_statement_1.VariableStatement(parent);
        }
        newWhile(parent) {
          return new while_1.While(parent);
        }
        newComment(parent) {
          return new comment_statement_1.CommentStatement(parent);
        }
      };
      exports.StatementFactoryImpl = StatementFactoryImpl;
    }
  });

  // out/src/ide/frames/file-impl.js
  var require_file_impl = __commonJS({
    "out/src/ide/frames/file-impl.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FileImpl = exports.cannotLoadFile = exports.parseErrorPrefix = exports.fileErrorPrefix = exports.CodeSourceFromString = void 0;
      var root_ast_node_1 = require_root_ast_node();
      var std_lib_symbols_1 = require_std_lib_symbols();
      var test_status_1 = require_test_status();
      var environment_1 = require_environment();
      var elan_file_error_1 = require_elan_file_error();
      var code_source_from_string_1 = require_code_source_from_string();
      Object.defineProperty(exports, "CodeSourceFromString", { enumerable: true, get: function() {
        return code_source_from_string_1.CodeSourceFromString;
      } });
      var regexes_1 = require_regexes();
      var frame_helpers_1 = require_frame_helpers();
      var file_1 = require_file();
      var profile_1 = require_profile();
      var abstract_class_1 = require_abstract_class();
      var concrete_class_1 = require_concrete_class();
      var constant_1 = require_constant();
      var enum_1 = require_enum();
      var global_comment_1 = require_global_comment();
      var global_function_1 = require_global_function();
      var global_procedure_1 = require_global_procedure();
      var global_selector_1 = require_global_selector();
      var interface_frame_1 = require_interface_frame();
      var main_frame_1 = require_main_frame();
      var record_frame_1 = require_record_frame();
      var test_frame_1 = require_test_frame();
      var parent_helpers_1 = require_parent_helpers();
      var statement_factory_impl_1 = require_statement_factory_impl();
      var status_enums_1 = require_status_enums();
      exports.fileErrorPrefix = `Cannot load file:`;
      exports.parseErrorPrefix = `Parse error before:`;
      exports.cannotLoadFile = `${exports.fileErrorPrefix} it has been created or modified outside Elan IDE`;
      var FileImpl = class {
        hash;
        profile;
        userName;
        transform;
        currentHash = "";
        isParent = true;
        hasFields = true;
        isFile = true;
        parseError;
        defaultFileName = "code.elan";
        fileName = this.defaultFileName;
        _parseStatus = status_enums_1.ParseStatus.default;
        _compileStatus = status_enums_1.CompileStatus.default;
        _testStatus = test_status_1.TestStatus.default;
        _runStatus = status_enums_1.RunStatus.default;
        _fieldBeingEdited = false;
        _children = new Array();
        _map;
        _factory;
        allowAnyHeader = false;
        _stdLibSymbols;
        _nextId = 0;
        _testError;
        _frNo = 0;
        _showFrameNos = true;
        ast;
        copiedSource = [];
        constructor(hash, profile, userName, transform, stdLib, allowAnyHeader) {
          this.hash = hash;
          this.profile = profile;
          this.userName = userName;
          this.transform = transform;
          this._stdLibSymbols = new std_lib_symbols_1.StdLibSymbols(stdLib);
          this._map = /* @__PURE__ */ new Map();
          this._factory = new statement_factory_impl_1.StatementFactoryImpl();
          const selector = new global_selector_1.GlobalSelector(this);
          this.getChildren().push(selector);
          selector.select(true, false);
          if (allowAnyHeader) {
            this.allowAnyHeader = allowAnyHeader;
          }
        }
        addCopiedSource(source) {
          this.copiedSource.push(source);
        }
        getCopiedSource() {
          const ss = this.copiedSource;
          this.copiedSource = [];
          return ss;
        }
        version = environment_1.elanVersion;
        isProduction = environment_1.isElanProduction;
        getFile() {
          return this;
        }
        getFrNo() {
          const n = this._frNo++;
          return this._showFrameNos ? `<el-fr>${n}</el-fr>` : ``;
        }
        getFieldBeingEdited() {
          return this._fieldBeingEdited;
        }
        setFieldBeingEdited(value) {
          this._fieldBeingEdited = value;
        }
        getProfile() {
          return this.profile;
        }
        getChildren() {
          return this._children;
        }
        get hasTests() {
          return this._children.some((g) => g instanceof test_frame_1.TestFrame && !g.isGhosted() && !g.ignored);
        }
        deleteSelectedChildren() {
          (0, parent_helpers_1.parentHelper_deleteSelectedChildren)(this);
        }
        copySelectedChildren() {
          return (0, parent_helpers_1.parentHelper_copySelectedChildren)(this);
        }
        moveSelectedChildrenUpOne() {
          (0, parent_helpers_1.parentHelper_moveSelectedChildrenUpOne)(this);
        }
        moveSelectedChildrenDownOne() {
          (0, parent_helpers_1.parentHelper_moveSelectedChildrenDownOne)(this);
        }
        minimumNumberOfChildrenExceeded() {
          return this.getChildren().length > 1;
        }
        hasParent() {
          return false;
        }
        getParent() {
          throw new Error("getParent Should not have been called on a file; test for 'hasParent()' before calling.");
        }
        getById(id) {
          return this._map.get(id);
        }
        getIdPrefix() {
          return "file";
        }
        frNo = 1;
        async renderAsHtml(withHeader = true) {
          this._frNo = 1;
          const globals = (0, parent_helpers_1.parentHelper_renderChildrenAsHtml)(this);
          this.currentHash = await this.getHash();
          return withHeader ? `<el-header># ${this.getHashAsHtml()} ${this.getVersionAsHtml()} ${this.getUserNameAsHtml()} ${this.getProfileNameAsHtml()}</el-header>\r
${globals}` : globals;
        }
        indent() {
          return "";
        }
        async getHash(body) {
          body = (body || this.renderHashableContent()).trim().replaceAll("\r", "");
          return await this.hash(body);
        }
        getVersion() {
          return this.version;
        }
        getSemverString() {
          const v = this.getVersion();
          const suffix = v.preRelease === "" ? "" : `-${v.preRelease}`;
          return `${v.major}.${v.minor}.${v.patch}${suffix}`;
        }
        getVersionString() {
          return `Elan ${this.getSemverString()}`;
        }
        getVersionAsHtml() {
          const v = this.getVersionString();
          return `<el-version>${v}</el-version>`;
        }
        getHashAsHtml() {
          return `<el-hash>${this.currentHash}</el-hash>`;
        }
        // to allow header generation of new version
        setVersion(major, minor, patch, preRelease) {
          this.version = { major, minor, patch, preRelease };
        }
        // for testing
        setIsProduction(flag) {
          this.isProduction = flag;
        }
        getUserName() {
          return this.userName ? this.userName : profile_1.defaultUsername;
        }
        getUserNameAsHtml() {
          const cls = this.profile.show_user_and_profile ? "show" : "hide";
          const userName = this.getUserName();
          return `<el-user class="${cls}">${userName}</el-user>`;
        }
        getProfileName() {
          const pn = this.profile.name.replaceAll(" ", "_");
          return pn ? pn : "_";
        }
        getProfileNameAsHtml() {
          const cls = this.profile.show_user_and_profile ? "show" : "hide";
          const profileName = this.getProfileName();
          return `<el-profile class="${cls}">${profileName}</el-profile>`;
        }
        async renderAsSource() {
          const content = this.renderHashableContent();
          this.currentHash = await this.getHash(content);
          return `# ${this.currentHash} ${content}`;
        }
        getAst(invalidate) {
          if (!this.ast || invalidate) {
            this.ast = this.transform.transform(this, "", void 0);
          }
          return this.ast;
        }
        compile() {
          return this.getAst(true)?.compile() ?? "";
        }
        compileAsWorker(base, debugMode, standalone) {
          const ast = this.getAst(true);
          const mode = debugMode ? root_ast_node_1.CompileMode.debugWorker : standalone ? root_ast_node_1.CompileMode.standaloneWorker : root_ast_node_1.CompileMode.worker;
          ast?.setCompileOptions(mode, base);
          return ast?.compile() ?? "";
        }
        compileAsTestWorker(base) {
          const ast = this.getAst(true);
          ast?.setCompileOptions(root_ast_node_1.CompileMode.testWorker, base);
          return ast?.compile() ?? "";
        }
        renderHashableContent() {
          const globals = (0, parent_helpers_1.parentHelper_renderChildrenAsSource)(this);
          const code = `${this.getVersionString()} ${this.getUserName()} ${this.getProfileName()} ${this.getParseStatusLabel()}\r
\r
${globals}`;
          return code.endsWith("\r\n") ? code : code + "\r\n";
        }
        getFirstSelectorAsDirectChild() {
          return this.getChildren().filter((g) => (0, frame_helpers_1.isSelector)(g))[0];
        }
        getChildNumber(n) {
          return this.getChildren()[n];
        }
        getFirstChild() {
          return (0, parent_helpers_1.parentHelper_getFirstChild)(this);
        }
        getFirstNonImportedChild() {
          const globals = this.getChildren();
          const nonImported = globals.filter((g) => !g.isImported());
          return nonImported.length > 0 ? nonImported[0] : this.getLastChild();
        }
        getLastChild() {
          return (0, parent_helpers_1.parentHelper_getLastChild)(this);
        }
        getChildAfter(child) {
          return (0, parent_helpers_1.parentHelper_getChildAfter)(this, child);
        }
        getChildBefore(child) {
          return (0, parent_helpers_1.parentHelper_getChildBefore)(this, child);
        }
        getChildRange(first, last) {
          return (0, parent_helpers_1.parentHelper_getChildRange)(this, first, last);
        }
        addChildBefore(child, before) {
          (0, parent_helpers_1.parentHelper_addChildBefore)(this, child, before);
        }
        addChildAfter(child, before) {
          (0, parent_helpers_1.parentHelper_addChildAfter)(this, child, before);
        }
        removeChild(child) {
          (0, parent_helpers_1.parentHelper_removeChild)(this, child);
        }
        insertOrGotoChildSelector(after, child) {
          (0, parent_helpers_1.parentHelper_insertOrGotoChildSelector)(this, after, child);
        }
        defocusAll() {
          for (const f of this._map.values()) {
            if (f.isFocused()) {
              f.defocus();
            }
          }
        }
        expandCollapseAll() {
          (0, frame_helpers_1.expandCollapseAll)(this);
        }
        expand() {
        }
        collapse() {
        }
        readRunStatus() {
          return this._runStatus;
        }
        getRunStatusLabel() {
          const status = this.readRunStatus();
          return status === status_enums_1.RunStatus.default ? "" : status_enums_1.RunStatus[status];
        }
        getRunStatusColour() {
          return status_enums_1.RunStatus[this._runStatus];
        }
        setRunStatus(s) {
          this._runStatus = s;
        }
        readParseStatus() {
          this._parseStatus = status_enums_1.ParseStatus.default;
          this.updateAllParseStatus();
          return this._parseStatus;
        }
        getParseStatusLabel() {
          const status = this.readParseStatus();
          return status === status_enums_1.ParseStatus.default ? "" : status_enums_1.ParseStatus[status];
        }
        getParseStatusColour() {
          return status_enums_1.DisplayColour[(0, frame_helpers_1.helper_parseStatusAsDisplayStatus)(this._parseStatus)];
        }
        setTestStatus(s) {
          this._testStatus = s;
        }
        updateAllParseStatus() {
          this.getChildren().forEach((c) => c.updateParseStatus());
          this._parseStatus = (0, parent_helpers_1.worstParseStatus)(this._parseStatus, (0, parent_helpers_1.parentHelper_readWorstParseStatusOfChildren)(this));
        }
        refreshParseAndCompileStatuses(compileIfParsed) {
          try {
            this._parseStatus = status_enums_1.ParseStatus.default;
            this.parseError = void 0;
            this.updateAllParseStatus();
            this.resetAllCompileStatusAndErrors();
            this.resetAllTestStatus();
          } catch (e) {
            this._parseStatus = status_enums_1.ParseStatus.invalid;
            throw e;
          }
          try {
            if (this._parseStatus === status_enums_1.ParseStatus.valid && (!this._fieldBeingEdited || compileIfParsed)) {
              this.compile();
              this.updateAllCompileStatus();
            }
          } catch (e) {
            this._compileStatus = status_enums_1.CompileStatus.error;
            throw e;
          }
        }
        refreshTestStatuses(outcomes) {
          if (this._compileStatus === status_enums_1.CompileStatus.ok) {
            let errors = [];
            for (const outcome of outcomes) {
              const [tid, asserts] = outcome;
              const test = this.getById(tid);
              test.setAssertOutcomes(asserts);
              errors = errors.concat(asserts.map((a) => a.error).filter((e) => e));
            }
            this._testError = errors.length > 0 ? errors[0] : void 0;
            this.updateAllTestStatus();
          } else {
            this.resetAllTestStatus();
          }
        }
        //Compile status
        readCompileStatus() {
          return this._compileStatus;
        }
        getCompileStatusLabel() {
          const status = this.readCompileStatus();
          return status === status_enums_1.CompileStatus.default ? "" : status_enums_1.CompileStatus[status].replace("_", " ");
        }
        getCompileStatusColour() {
          let status = status_enums_1.DisplayColour.none;
          const parseStatus = (0, frame_helpers_1.helper_parseStatusAsDisplayStatus)(this.readParseStatus());
          if (parseStatus === status_enums_1.DisplayColour.ok) {
            status = (0, frame_helpers_1.helper_compileStatusAsDisplayStatus)(this._compileStatus);
          }
          return status_enums_1.DisplayColour[status];
        }
        updateAllCompileStatus() {
          this._compileStatus = (0, parent_helpers_1.parentHelper_readWorstCompileStatusOfChildren)(this);
        }
        resetAllCompileStatusAndErrors() {
          this.ast = void 0;
          this._compileStatus = status_enums_1.CompileStatus.default;
          this._testError = void 0;
        }
        readTestStatus() {
          return this.hasTests ? this._testStatus : test_status_1.TestStatus.default;
        }
        getTestError() {
          return this._testError;
        }
        getTestStatusLabel() {
          return this.getTestStatusColour() === "none" ? "" : test_status_1.TestStatus[this.readTestStatus()];
        }
        getTestStatusColour() {
          let status;
          if (this.readParseStatus() !== status_enums_1.ParseStatus.valid || this.readCompileStatus() !== status_enums_1.CompileStatus.ok) {
            status = status_enums_1.DisplayColour.none;
          } else {
            status = (0, frame_helpers_1.helper_testStatusAsDisplayStatus)(this.readTestStatus());
          }
          return status_enums_1.DisplayColour[status];
        }
        updateAllTestStatus() {
          const tests = this.getTestFrames();
          tests.forEach((t) => t.updateTestStatus());
          const worstOf = (a, b) => a < b ? a : b;
          const worst = tests.reduce((prev, t) => worstOf(t.readTestStatus(), prev), test_status_1.TestStatus.default);
          this._testStatus = worst;
        }
        resetAllTestStatus() {
          const tests = this.getTestFrames();
          tests.forEach((t) => t.resetTestStatus());
        }
        getTestFrames() {
          return this.getChildren().filter((c) => c instanceof test_frame_1.TestFrame && !c.isGhosted() && !c.ignored).map((c) => c);
        }
        getAllSelected() {
          const v = this.getMap().values();
          return [...v].filter((s) => s.isSelected());
        }
        deselectAll() {
          this.getAllSelected().forEach((s) => s.deselect());
        }
        getMap() {
          return this._map;
        }
        getNextId() {
          return this._nextId++;
        }
        getFactory() {
          return this._factory;
        }
        createMain() {
          return new main_frame_1.MainFrame(this);
        }
        createFunction() {
          return new global_function_1.GlobalFunction(this);
        }
        createProcedure() {
          return new global_procedure_1.GlobalProcedure(this);
        }
        createEnum() {
          return new enum_1.Enum(this);
        }
        createConcreteClass() {
          return new concrete_class_1.ConcreteClass(this);
        }
        createAbstractClass() {
          return new abstract_class_1.AbstractClass(this);
        }
        createInterface() {
          return new interface_frame_1.InterfaceFrame(this);
        }
        createRecord() {
          return new record_frame_1.RecordFrame(this);
        }
        createGlobalComment() {
          return new global_comment_1.GlobalComment(this);
        }
        createConstant() {
          return new constant_1.Constant(this);
        }
        createTest() {
          return new test_frame_1.TestFrame(this);
        }
        getNextSelector(mode) {
          let frame;
          if (mode === file_1.ParseMode.append) {
            frame = this.getLastChild();
            return (0, frame_helpers_1.isSelector)(frame) ? frame : (0, parent_helpers_1.parentHelper_insertOrGotoChildSelector)(this, true, frame);
          } else if (mode === file_1.ParseMode.import) {
            frame = this.getFirstNonImportedChild();
            return (0, frame_helpers_1.isSelector)(frame) ? frame : (0, parent_helpers_1.parentHelper_insertOrGotoChildSelector)(this, false, frame);
          } else {
            return this.getFirstSelectorAsDirectChild();
          }
        }
        parseBodyFrom(source) {
          try {
            while (source.hasMoreCode()) {
              if (source.isMatchRegEx(regexes_1.Regexes.newLine)) {
                source.removeNewLine();
              } else {
                this.getNextSelector(source.mode).parseFrom(source);
              }
            }
            this.removeAllSelectorsThatCanBe();
            this.deselectAll();
            this.getFirstChild().select(true, false);
            this.updateAllParseStatus();
          } catch (e) {
            if (e instanceof elan_file_error_1.ElanFileError) {
              this.parseError = e.message;
            } else {
              this.parseError = `Parse error before: ${source.getRemainingCode().substring(0, 100)}: ${e instanceof Error ? e.message : e}`;
            }
            this._parseStatus = status_enums_1.ParseStatus.invalid;
          }
        }
        async parseFrom(source) {
          if (!this._stdLibSymbols.isInitialised) {
            this.parseError = this._stdLibSymbols.error;
            this._parseStatus = status_enums_1.ParseStatus.invalid;
            return;
          }
          try {
            this.parseError = void 0;
            this._parseStatus = status_enums_1.ParseStatus.default;
            await this.validateHeader(source.getRemainingCode());
            if (source.isMatch("#")) {
              source.removeRegEx(regexes_1.Regexes.comment, false);
              source.removeRegEx(regexes_1.Regexes.newLine, false);
              source.removeRegEx(regexes_1.Regexes.newLine, false);
            }
            this.parseBodyFrom(source);
          } catch (e) {
            if (e instanceof elan_file_error_1.ElanFileError) {
              this.parseError = e.message;
            } else {
              this.parseError = `${exports.parseErrorPrefix} ${source.getRemainingCode().substring(0, 100)}: ${e instanceof Error ? e.message : e}`;
            }
            this._parseStatus = status_enums_1.ParseStatus.invalid;
          }
        }
        containsMain() {
          const mains = this.getChildren().filter((g) => (0, frame_helpers_1.isMain)(g));
          return mains.length > 0;
        }
        async validateHash(fileHash, code) {
          if (this.isProduction && !this.allowAnyHeader) {
            const toHash = code.substring(code.indexOf("Elan"));
            const newHash = await this.getHash(toHash);
            if (fileHash !== newHash) {
              throw new elan_file_error_1.ElanFileError(exports.cannotLoadFile);
            }
          }
        }
        getPatch(patch) {
          const tokens = patch.split("-");
          if (tokens.length === 1) {
            return [parseInt(tokens[0], 10), ""];
          }
          if (tokens.length === 2) {
            return [parseInt(tokens[0], 10), tokens[1]];
          }
          throw new elan_file_error_1.ElanFileError(exports.cannotLoadFile);
        }
        validateVersion(version) {
          if (this.isProduction && !this.allowAnyHeader) {
            const tokens = version.split(".");
            if (tokens.length !== 3) {
              throw new elan_file_error_1.ElanFileError(exports.cannotLoadFile);
            }
            const fileMajor = parseInt(tokens[0], 10);
            const fileMinor = parseInt(tokens[1], 10);
            const [filePatch] = this.getPatch(tokens[2]);
            if (isNaN(fileMajor) || isNaN(fileMinor) || isNaN(filePatch)) {
              throw new elan_file_error_1.ElanFileError(exports.cannotLoadFile);
            }
            if (fileMajor !== this.version.major) {
              throw new elan_file_error_1.ElanFileError(`${exports.fileErrorPrefix} it must be loaded into an Elan IDE version ${fileMajor}`);
            }
            if (fileMinor > this.version.minor) {
              throw new elan_file_error_1.ElanFileError(`${exports.fileErrorPrefix} it must be loaded into an Elan IDE version ${fileMajor}.${fileMinor}`);
            }
          }
        }
        async validateHeader(code) {
          if (!this.isEmpty(code)) {
            const eol = code.indexOf("\n");
            const header = code.substring(0, eol > 0 ? eol : void 0);
            const tokens = header.split(" ");
            if (tokens.length === 7 && tokens[0] === "#" && tokens[2] === "Elan") {
              await this.validateHash(tokens[1], code);
              this.validateVersion(tokens[3]);
              this.userName = tokens[4] ?? profile_1.defaultUsername;
            } else {
              throw new elan_file_error_1.ElanFileError(exports.cannotLoadFile);
            }
          }
        }
        isEmpty(code) {
          const matches = code.match(/^[\s\r\n]*$/);
          return matches !== null && matches.length > 0;
        }
        getFields() {
          return [];
        }
        controlKeys = ["O"];
        processKey(e) {
          if (e.modKey.control && !this.controlKeys.includes(e.key ?? "")) {
            return false;
          }
          const codeHasChanged = this._fieldBeingEdited;
          switch (e.key) {
            case "Home": {
              this.selectFirstGlobal();
              break;
            }
            case "End": {
              this.getLastChild().select(true, false);
              break;
            }
            case "Tab": {
              this.tab();
              break;
            }
            case "ArrowDown": {
              this.selectFirstGlobal();
              break;
            }
            case "ArrowRight": {
              this.selectFirstGlobal();
              break;
            }
            case "O": {
              if (e.modKey.control) {
                this.expandCollapseAll();
              }
              break;
            }
            case "t": {
              if (e.modKey.alt) {
                this.removeAllSelectorsThatCanBe();
              }
              break;
            }
          }
          this.setFieldBeingEdited(false);
          return codeHasChanged;
        }
        selectFirstGlobal() {
          this.getFirstChild().select(true, false);
        }
        tab() {
          this.getFirstChild().selectFirstField();
        }
        newChildSelector() {
          return new global_selector_1.GlobalSelector(this);
        }
        removeAllSelectorsThatCanBe() {
          for (const f of this.getMap().values()) {
            if ((0, frame_helpers_1.isSelector)(f)) {
              f.deleteIfPermissible();
            }
          }
        }
        // for testing only
        setSymbols(testSymbols) {
          this._stdLibSymbols = testSymbols;
        }
        get libraryScope() {
          return this._stdLibSymbols;
        }
        updateBreakpoints(event) {
          (0, parent_helpers_1.parentHelper_updateBreakpoints)(this, event);
        }
        isGhostedOrWithinAGhostedFrame() {
          return false;
        }
        isWithinAnImportedFrame() {
          return false;
        }
        isImported() {
          return false;
        }
        ghostSelectedChildren() {
          (0, parent_helpers_1.setGhostOnSelectedChildren)(this, true);
        }
        unghostSelectedChildren() {
          (0, parent_helpers_1.setGhostOnSelectedChildren)(this, false);
        }
      };
      exports.FileImpl = FileImpl;
    }
  });

  // out/src/ide/frames/frame-interfaces/editor-event.js
  var require_editor_event = __commonJS({
    "out/src/ide/frames/frame-interfaces/editor-event.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.modKeyString = modKeyString;
      exports.toDebugString = toDebugString;
      function modKeyString(mk) {
        return `control:${mk.control}, shift:${mk.shift}, alt:${mk.alt}`;
      }
      function toDebugString(ee) {
        return ee ? `editorEvent: {
type: ${ee.type},
target: ${ee.target},
key: ${ee?.key ?? "not set"},
modKey: ${modKeyString(ee.modKey)},
id: ${ee?.id ?? "not set"},
selection: ${ee.selection ? ee.selection : "not set"},
command: ${ee?.command ?? "not set"}
optionalData: ${ee?.optionalData ?? "not set"}
}` : "no editor event recorded";
      }
    }
  });

  // out/src/ide/stub-input-output.js
  var require_stub_input_output = __commonJS({
    "out/src/ide/stub-input-output.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.StubInputOutput = void 0;
      var StubInputOutput = class {
        constructor() {
        }
        readFile() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs(data.value);
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("readFile"));
          });
        }
        writeFile(fileName, data) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data2 = e.data;
              if (data2.type === "read") {
                rs();
              }
              if (data2.type === "status" && data2.status === "error") {
                rj(data2.error);
              }
            };
            postMessage(this.writeMsg("writeFile", [fileName, data]));
          });
        }
        writeMsg(func, parameters) {
          return { type: "write", function: func, parameters: parameters ?? [] };
        }
        drawBlockGraphics(html) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("drawBlockGraphics", [html]));
          });
        }
        clearBlockGraphics() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearBlockGraphics"));
          });
        }
        drawVectorGraphics(html) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("drawVectorGraphics", [html]));
          });
        }
        clearVectorGraphics() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearVectorGraphics"));
          });
        }
        clearDisplay() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearAllGraphics"));
          });
        }
        printLine(text) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("printLine", [text]));
          });
        }
        print(text) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("print", [text]));
          });
        }
        printTab(position, text) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("printTab", [position, text]));
          });
        }
        stopReading() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("stopReading"));
          });
        }
        readLine() {
          return new Promise((rs) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs(data.value);
              }
            };
            postMessage(this.writeMsg("readLine"));
          });
        }
        waitForAnyKey() {
          return new Promise((rs) => {
            onmessage = (_e) => {
              rs();
            };
            postMessage(this.writeMsg("waitForAnyKey"));
          });
        }
        waitForKey() {
          return new Promise((rs) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs(data.value);
              }
            };
            postMessage(this.writeMsg("waitForKey"));
          });
        }
        getKey() {
          return new Promise((rs) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs(data.value);
              }
            };
            postMessage(this.writeMsg("getKey"));
          });
        }
        getModKey(e) {
          return e.ctrlKey ? "Control" : e.shiftKey ? "Shift" : e.altKey ? "Alt" : "";
        }
        getKeyWithModifier() {
          return new Promise((rs) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs(data.value);
              }
            };
            postMessage(this.writeMsg("getKeyWithModifier"));
          });
        }
        clearKeyBuffer() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearKeyBuffer"));
          });
        }
        clearPrintedText() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearPrintedText"));
          });
        }
        clearSystemInfo() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearSystemInfo"));
          });
        }
        drawHtml(html) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("drawHtml", [html]));
          });
        }
        clearHtml() {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("clearHtml"));
          });
        }
        tone(duration, frequency, volume) {
          return new Promise((rs, rj) => {
            onmessage = (e) => {
              const data = e.data;
              if (data.type === "read") {
                rs();
              }
              if (data.type === "status" && data.status === "error") {
                rj(data.error);
              }
            };
            postMessage(this.writeMsg("tone", [duration, frequency, volume]));
          });
        }
        breakPoint(allScopedSymbols, id, singlestep) {
          let paused = true;
          let nextPause = false;
          addEventListener("message", async (e) => {
            if (e.data.type === "resume") {
              paused = false;
            }
            if (e.data.type === "pause") {
              nextPause = true;
            }
          });
          return new Promise((rs) => {
            postMessage({
              type: singlestep ? "singlestep" : "breakpoint",
              value: allScopedSymbols,
              pausedAt: id
            });
            const timeOut = setInterval(async () => {
              if (!paused) {
                clearInterval(timeOut);
                rs(nextPause);
              }
            }, 1);
          });
        }
      };
      exports.StubInputOutput = StubInputOutput;
    }
  });

  // out/src/ide/web/editorHandlers.js
  var require_editorHandlers = __commonJS({
    "out/src/ide/web/editorHandlers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.handleClick = handleClick;
      exports.handleDblClick = handleDblClick;
      exports.handleKey = handleKey;
      var frame_helpers_1 = require_frame_helpers();
      function getAllSelected(file) {
        const v = file.getMap().values();
        return [...v].filter((s) => s.isSelected());
      }
      function handleClick(e, file) {
        switch (e.target) {
          case "frame": {
            const s = file.getById(e.id);
            if (e.modKey.shift && (0, frame_helpers_1.isFrame)(s)) {
              const parent = s.getParent();
              const curSel = getAllSelected(file).filter((i) => (0, frame_helpers_1.isFrame)(i) && i.getParent() === parent);
              if (curSel.length > 0) {
                const toSelect = /* @__PURE__ */ new Set();
                for (const cs of curSel) {
                  const range = parent.getChildRange(cs, s);
                  const fr = range.filter((c) => c);
                  if (range.length !== fr.length) {
                    console.warn(`getChildRange returned undefined element - cs: ${cs?.constructor?.name}  s: ${s?.constructor?.name}`);
                  }
                  for (const r of fr) {
                    toSelect.add(r);
                  }
                }
                s?.select(true, false);
                for (const ts of toSelect) {
                  ts.select(false, true);
                }
                s?.select(true, true);
              } else {
                s?.select(true, false);
              }
            } else {
              s?.select(true, false, e.selection);
            }
            return true;
          }
        }
        return false;
      }
      function handleDblClick(e, file) {
        switch (e.target) {
          case "frame": {
            const s = file.getById(e.id);
            if ((0, frame_helpers_1.isCollapsible)(s)) {
              s.expandCollapse();
            }
            return true;
          }
        }
        return false;
      }
      function handleKey(e, file) {
        switch (e.key) {
          case "Shift":
            break;
          //Short circuit repeat from modifier held-down before other key
          case "Control":
            break;
          case "Alt":
            break;
          default: {
            if (e.target === "frame") {
              return file.getById(e.id).processKey(e);
            } else {
              return file.processKey(e);
            }
          }
        }
        return false;
      }
    }
  });

  // out/src/ide/web/ui-helpers.js
  var require_ui_helpers = __commonJS({
    "out/src/ide/web/ui-helpers.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.checkIsChrome = checkIsChrome;
      exports.confirmContinueOnNonChromeBrowser = confirmContinueOnNonChromeBrowser;
      exports.readMsg = readMsg;
      exports.errorMsg = errorMsg;
      function checkIsChrome() {
        const isChromium = window.chrome;
        const winNav = window.navigator;
        const vendorName = winNav.vendor;
        const isOpera = typeof window.opr !== "undefined";
        const _isFirefox = winNav.userAgent.indexOf("Firefox") > -1;
        const isIEedge = winNav.userAgent.indexOf("Edg") > -1;
        const isIOSChrome = winNav.userAgent.match("CriOS");
        const isGoogleChrome = typeof winNav.userAgentData !== "undefined" ? winNav.userAgentData.brands.some((b) => b.brand === "Google Chrome") : vendorName === "Google Inc.";
        const isChrome = isChromium !== null && typeof isChromium !== "undefined" && vendorName === "Google Inc." && isOpera === false && isIEedge === false && isGoogleChrome;
        if (isIOSChrome) {
          return true;
        } else if (isChrome || isIEedge) {
          return true;
        } else {
          return false;
        }
      }
      function confirmContinueOnNonChromeBrowser() {
        return confirm(`Elan is compatible with the Chrome or Edge browser. It does not work correctly in Firefox or Safari.`);
      }
      function readMsg(value) {
        return { type: "read", value };
      }
      function errorMsg(value) {
        return { type: "status", status: "error", error: value };
      }
    }
  });

  // out/src/compiler/syntax-nodes/binary-expr-asn.js
  var require_binary_expr_asn = __commonJS({
    "out/src/compiler/syntax-nodes/binary-expr-asn.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BinaryExprAsn = void 0;
      var boolean_type_1 = require_boolean_type();
      var float_type_1 = require_float_type();
      var int_type_1 = require_int_type();
      var string_type_1 = require_string_type();
      var symbol_helpers_1 = require_symbol_helpers();
      var compile_rules_1 = require_compile_rules();
      var abstract_ast_node_1 = require_abstract_ast_node();
      var ast_helpers_1 = require_ast_helpers();
      var operation_symbol_1 = require_operation_symbol();
      var BinaryExprAsn = class extends abstract_ast_node_1.AbstractAstNode {
        op;
        lhs;
        rhs;
        fieldId;
        scope;
        constructor(op, lhs, rhs, fieldId, scope) {
          super();
          this.op = op;
          this.lhs = lhs;
          this.rhs = rhs;
          this.fieldId = fieldId;
          this.scope = scope;
        }
        isEqualityOp(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Equals:
            case operation_symbol_1.OperationSymbol.NotEquals:
              return true;
          }
          return false;
        }
        isArithmeticOp(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Add:
            case operation_symbol_1.OperationSymbol.Minus:
            case operation_symbol_1.OperationSymbol.Multiply:
            case operation_symbol_1.OperationSymbol.Divide:
            case operation_symbol_1.OperationSymbol.Pow:
              return true;
          }
          return false;
        }
        isIntegerOnlyOp(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Div:
            case operation_symbol_1.OperationSymbol.Mod:
              return true;
          }
          return false;
        }
        isCompareOp(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.LT:
            case operation_symbol_1.OperationSymbol.GT:
            case operation_symbol_1.OperationSymbol.GTE:
            case operation_symbol_1.OperationSymbol.LTE:
              return true;
          }
          return false;
        }
        isLogicalOp(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.And:
            case operation_symbol_1.OperationSymbol.Or:
              return true;
          }
          return false;
        }
        opToJs(opSymbol) {
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Add:
              return "+";
            case operation_symbol_1.OperationSymbol.Minus:
              return "-";
            case operation_symbol_1.OperationSymbol.Multiply:
              return "*";
            case operation_symbol_1.OperationSymbol.And:
              return "&&";
            case operation_symbol_1.OperationSymbol.Or:
              return "||";
            case operation_symbol_1.OperationSymbol.Equals:
              return "===";
            case operation_symbol_1.OperationSymbol.NotEquals:
              return "!==";
            case operation_symbol_1.OperationSymbol.LT:
              return "<";
            case operation_symbol_1.OperationSymbol.GT:
              return ">";
            case operation_symbol_1.OperationSymbol.GTE:
              return ">=";
            case operation_symbol_1.OperationSymbol.LTE:
              return "<=";
            case operation_symbol_1.OperationSymbol.Div:
              return "/";
            case operation_symbol_1.OperationSymbol.Mod:
              return "%";
            case operation_symbol_1.OperationSymbol.Divide:
              return "/";
            case operation_symbol_1.OperationSymbol.Pow:
              return "**";
          }
          return " ";
        }
        isString(st) {
          return st instanceof string_type_1.StringType;
        }
        compile() {
          this.compileErrors = [];
          const lhsCode = this.lhs.compile();
          const rhsCode = this.rhs.compile();
          const lst = this.lhs.symbolType();
          const rst = this.rhs.symbolType();
          const opSymbol = (0, ast_helpers_1.mapOperation)(this.op);
          if (opSymbol === operation_symbol_1.OperationSymbol.Unknown) {
            (0, compile_rules_1.mustBeKnownOperation)(this.op, this.compileErrors, this.fieldId);
          }
          if (opSymbol === operation_symbol_1.OperationSymbol.Add && this.isString(lst) && this.isString(rst)) {
            return `${lhsCode} + ${rhsCode}`;
          }
          if (this.isEqualityOp(opSymbol)) {
            (0, compile_rules_1.mustBeCoercibleType)(lst, rst, this.compileErrors, this.fieldId);
          }
          if (this.isCompareOp(opSymbol) || this.isArithmeticOp(opSymbol)) {
            (0, compile_rules_1.mustBeNumberTypes)(lst, rst, this.compileErrors, this.fieldId);
          }
          if (this.isIntegerOnlyOp(opSymbol)) {
            (0, compile_rules_1.mustBeIntegerType)(lst, rst, this.compileErrors, this.fieldId);
          }
          if (this.isLogicalOp(opSymbol)) {
            (0, compile_rules_1.mustBeBooleanTypes)(lst, rst, this.compileErrors, this.fieldId);
          }
          (0, symbol_helpers_1.getGlobalScope)(this.scope).addCompileErrors(this.compileErrors);
          if (opSymbol === operation_symbol_1.OperationSymbol.Equals && ((0, symbol_helpers_1.isValueType)(lst) || (0, symbol_helpers_1.isValueType)(rst))) {
            return `${lhsCode} ${this.opToJs(opSymbol)} ${rhsCode}`;
          }
          if (opSymbol === operation_symbol_1.OperationSymbol.Equals) {
            return `system.objectEquals(${lhsCode}, ${rhsCode})`;
          }
          let code = `${lhsCode} ${this.opToJs(opSymbol)} ${rhsCode}`;
          if (opSymbol === operation_symbol_1.OperationSymbol.Div) {
            code = `Math.floor(${code})`;
          }
          return code;
        }
        symbolType() {
          const opSymbol = (0, ast_helpers_1.mapOperation)(this.op);
          switch (opSymbol) {
            case operation_symbol_1.OperationSymbol.Add:
              return (0, symbol_helpers_1.mostPreciseSymbol)(this.lhs.symbolType(), this.rhs.symbolType());
            case operation_symbol_1.OperationSymbol.Minus:
              return (0, symbol_helpers_1.mostPreciseSymbol)(this.lhs.symbolType(), this.rhs.symbolType());
            case operation_symbol_1.OperationSymbol.Multiply:
              return (0, symbol_helpers_1.mostPreciseSymbol)(this.lhs.symbolType(), this.rhs.symbolType());
            case operation_symbol_1.OperationSymbol.Pow:
              return (0, symbol_helpers_1.mostPreciseSymbol)(this.lhs.symbolType(), this.rhs.symbolType());
            case operation_symbol_1.OperationSymbol.Div:
              return int_type_1.IntType.Instance;
            case operation_symbol_1.OperationSymbol.Mod:
              return int_type_1.IntType.Instance;
            case operation_symbol_1.OperationSymbol.Divide:
              return float_type_1.FloatType.Instance;
            case operation_symbol_1.OperationSymbol.And:
              return boolean_type_1.BooleanType.Instance;
            case operation_symbol_1.OperationSymbol.Equals:
              return boolean_type_1.BooleanType.Instance;
            case operation_symbol_1.OperationSymbol.NotEquals:
              return boolean_type_1.BooleanType.Instance;
            case operation_symbol_1.OperationSymbol.LT:
              return boolean_type_1.BooleanType.Instance;
            case operation_symbol_1.OperationSymbol.GT:
              return boolean_type_1.BooleanType.Instance;
            case operation_symbol_1.OperationSymbol.LTE:
              return boolean_type_1.BooleanType.Instance;
            case operation_symbol_1.OperationSymbol.GTE:
              return boolean_type_1.BooleanType.Instance;
            default:
              return this.lhs.symbolType();
          }
        }
        toString() {
          return `${this.lhs} ${this.op} ${this.rhs}`;
        }
      };
      exports.BinaryExprAsn = BinaryExprAsn;
    }
  });

  // out/src/compiler/syntax-nodes/bracketed-asn.js
  var require_bracketed_asn = __commonJS({
    "out/src/compiler/syntax-nodes/bracketed-asn.js"(exports) {
    